/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.IO;

import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.IO.ReikaFileReader;
import Reika.DragonAPI.Libraries.MathSci.ReikaDateHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;

public class RemoteSourcedAsset {
    private static final File mcDir = DragonAPICore.getMinecraftDirectory();
    public final Class reference;
    public final String path;
    public final String remotePath;
    public final String localRemote;

    private RemoteSourcedAsset(Class ref, String s, String rem, String loc) {
        this.reference = ref;
        this.path = s;
        this.remotePath = rem;
        this.localRemote = loc;
    }

    public InputStream getData() throws IOException {
        InputStream main = this.getPrimary();
        if (main != null) {
            return main;
        }
        File f = new File(this.getLocalAssetPath());
        if (f.exists()) {
            return new FileInputStream(f);
        }
        String fall = this.getFallbackPath();
        f = new File(fall);
        if (f.exists()) {
            return new FileInputStream(f);
        }
        DragonAPICore.logError("Could not find main resource for asset " + this.reference + "/" + this.path + "!");
        InputStream in = this.reference.getResourceAsStream(fall);
        if (in != null) {
            return in;
        }
        DragonAPICore.logError("Could not find ANY resource for asset " + this.reference + "/" + this.path + "!");
        return null;
    }

    private InputStream getPrimary() {
        return this.reference.getResourceAsStream(this.path);
    }

    public void load() {
        try (InputStream main = this.getPrimary();){
            if (main != null) {
                return;
            }
            File f = new File(this.getLocalAssetPath());
            if (!f.exists()) {
                DragonAPICore.log("Downloading dynamic asset " + this.path + " from remote, as its local copy does not exist.");
                this.queueDownload();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void queueDownload() {
        DynamicAssetDownloader al = new DynamicAssetDownloader(this.getRemotePath(), this.getLocalAssetPath());
        new Thread((Runnable)al, "Dynamic Asset Download " + this.path).start();
    }

    private String getFileExt() {
        return this.path.substring(this.path.lastIndexOf(46));
    }

    private String getFilename() {
        return this.path.substring(this.path.lastIndexOf(47) + 1);
    }

    public String getRemotePath() {
        return this.remotePath + "/" + this.path;
    }

    private String getLocalAssetPath() {
        return mcDir + "/mods/" + this.localRemote + "/" + this.path;
    }

    private String getFallbackPath() {
        String ext = this.getFileExt();
        String main = this.path.substring(0, this.path.length() - ext.length());
        return main + "_fallback" + ext;
    }

    public static final class RemoteSourcedAssetRepository {
        public final Class rootClass;
        public final String rootPath;
        public final String rootRemote;
        public final String rootLocal;
        public final DragonAPIMod owner;

        public RemoteSourcedAssetRepository(DragonAPIMod mod, Class c, String r, String l) {
            this(mod, c, "", r, l);
        }

        public RemoteSourcedAssetRepository(DragonAPIMod mod, Class c, String p, String r, String l) {
            this.rootClass = c;
            this.rootLocal = l;
            this.rootRemote = r;
            this.rootPath = p;
            this.owner = mod;
        }

        public RemoteSourcedAsset createAsset(String file) {
            RemoteSourcedAsset rem = new RemoteSourcedAsset(this.rootClass, this.rootPath.isEmpty() ? file : this.rootPath + "/" + file, this.rootRemote, this.rootLocal);
            rem.load();
            return rem;
        }

        public void addToAssetLoader() {
        }
    }

    private static class DynamicAssetDownloader
    implements Runnable {
        private final String remotePath;
        private final String localPath;
        private final File targetFile;
        private boolean isComplete = false;

        private DynamicAssetDownloader(String rem, String loc) {
            this.remotePath = rem;
            this.localPath = loc;
            this.targetFile = new File(this.localPath);
        }

        @Override
        public void run() {
            long time = System.currentTimeMillis();
            DragonAPICore.log("Remote asset download thread starting...");
            this.tryDownload(5);
        }

        private void tryDownload(int max) {
            for (int i = 0; i < max; ++i) {
                try {
                    this.download();
                }
                catch (ReikaFileReader.FileReadException e) {
                    boolean end = i == max - 1;
                    String text = end ? "Skipping file." : "Retrying...";
                    DragonAPICore.logError("Could not read remote asset '" + this.remotePath + "'. " + text);
                    e.printStackTrace();
                    this.targetFile.delete();
                    if (!end) continue;
                }
                catch (ReikaFileReader.FileWriteException e) {
                    DragonAPICore.logError("Could not save asset '" + this.localPath + "'. Skipping file.");
                    e.printStackTrace();
                    this.targetFile.delete();
                }
                catch (IOException e) {
                    DragonAPICore.logError("Could not download remote asset '" + this.remotePath + "'. Skipping file.");
                    e.printStackTrace();
                    this.targetFile.delete();
                }
                break;
            }
        }

        private void download() throws IOException {
            if (!ReikaFileReader.isFileWithin(this.targetFile, DragonAPICore.getMinecraftDirectory())) {
                StringBuilder sb = new StringBuilder();
                sb.append("Dynamic Remote Asset " + this.remotePath + " attempted to download to " + this.targetFile.getCanonicalPath() + "!");
                sb.append(" This is not in the MC directory and very likely either malicious or poorly implemented, or the remote server has been compromised!");
                String s = sb.toString();
                DragonAPICore.logError(s);
                return;
            }
            this.targetFile.getParentFile().mkdirs();
            this.targetFile.delete();
            this.targetFile.createNewFile();
            URLConnection c = new URL(this.remotePath).openConnection();
            InputStream in = c.getInputStream();
            FileOutputStream out = new FileOutputStream(this.targetFile);
            long time = System.currentTimeMillis();
            ReikaFileReader.copyFile(in, out, 4096);
            long duration = System.currentTimeMillis() - time;
            String s = "Download of '" + this.remotePath + "' to '" + this.localPath + "' complete. Elapsed time: " + ReikaDateHelper.millisToHMSms(duration) + ". Filesize: " + this.targetFile.length();
            DragonAPICore.log(s);
            this.isComplete = true;
            in.close();
            ((OutputStream)out).close();
        }
    }
}

