/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable;

import Reika.DragonAPI.Instantiable.Data.Maps.ThresholdMapping;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;

public class Interpolation {
    private final ThresholdMapping<Double> data = new ThresholdMapping();
    private final boolean isColor;
    public boolean cosInterpolate = false;

    public Interpolation(boolean iscolor) {
        this.isColor = iscolor;
    }

    public Interpolation addPoint(double c, double val) {
        this.data.addMapping(c, val);
        return this;
    }

    public double getValue(double key) {
        Double x1 = this.data.getKeyForValue(key, false);
        Double x2 = this.data.getKeyForValue(key, true);
        Double d1 = this.data.getForValue(key, false);
        Double d2 = this.data.getForValue(key, true);
        if (x1 == x2) {
            return d1;
        }
        if (x1 == null) {
            return d2;
        }
        if (x2 == null) {
            return d1;
        }
        float f = (float)((key - x1) / (x2 - x1));
        return this.isColor ? (double)ReikaColorAPI.mixColors(d2.intValue(), d1.intValue(), f) : (this.cosInterpolate ? ReikaMathLibrary.cosInterpolation(key, x1, x2, d1, d2) : ReikaMathLibrary.linterpolate(key, x1, x2, d1, d2));
    }

    public String toString() {
        return this.data.toString();
    }

    public double getInitialValue() {
        return this.getValue(this.data.firstValue());
    }

    public double getFinalValue() {
        return this.getValue(this.data.lastValue());
    }

    public double getLowestKey() {
        return this.data.firstValue();
    }

    public double getHighestKey() {
        return this.data.lastValue();
    }
}

