/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Math;

import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import Reika.DragonAPI.Instantiable.Formula.MathExpression;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import java.util.Random;

public class NonUniformDistribution {
    private final WeightedRandom<Integer> data = new WeightedRandom();

    public void setRNG(Random rand) {
        this.data.setRNG(rand);
    }

    public void calculate(int from, int to, MathExpression formula) {
        this.data.clear();
        if (to < from) {
            int s = to;
            to = from;
            from = s;
        }
        for (int i = from; i <= to; ++i) {
            this.data.addEntry(i, formula.evaluate(i));
        }
    }

    public void calculate(Distribution exp) {
        this.calculate(exp.minX, exp.maxX, exp);
    }

    public int getRandomValue() {
        return this.data.getRandomEntry();
    }

    public double getProbability(int val) {
        return this.data.getProbability(val);
    }

    public static class TriangularDistribution
    extends Distribution {
        public final double baseValue;
        public final int peakX;
        public final double peakY;

        public TriangularDistribution(int x1, int x2, double base, int peakX, double peakY) {
            super(x1, x2);
            this.peakX = peakX;
            this.peakY = peakY;
            this.baseValue = base;
        }

        @Override
        public double evaluate(double arg) throws ArithmeticException {
            if (arg == (double)this.peakX) {
                return this.peakY;
            }
            if (arg > (double)this.peakX) {
                return ReikaMathLibrary.linterpolate(arg, this.peakX, this.maxX, this.peakY, this.baseValue);
            }
            if (arg < (double)this.peakX) {
                return ReikaMathLibrary.linterpolate(arg, this.minX, this.peakX, this.baseValue, this.peakY);
            }
            return 0.0;
        }

        @Override
        public double getBaseValue() {
            return this.baseValue;
        }

        @Override
        public String toString() {
            return "Pyramid distribution [" + this.minX + ", " + this.maxX + "] base " + this.baseValue + " peaking at " + this.peakX + "," + this.peakY;
        }
    }

    public static class CosineDistribution
    extends Distribution {
        public final double baseValue;
        public final int peakX;
        public final double peakY;

        public CosineDistribution(int x1, int x2, double base, int peakX, double peakY) {
            super(x1, x2);
            this.peakX = peakX;
            this.peakY = peakY;
            this.baseValue = base;
        }

        @Override
        public double evaluate(double arg) throws ArithmeticException {
            if (arg == (double)this.peakX) {
                return this.peakY;
            }
            if (arg > (double)this.peakX) {
                return ReikaMathLibrary.cosInterpolation2(this.peakX, this.maxX, arg, this.peakY, this.baseValue);
            }
            if (arg < (double)this.peakX) {
                return ReikaMathLibrary.cosInterpolation2(this.minX, this.peakX, arg, this.baseValue, this.peakY);
            }
            return 0.0;
        }

        @Override
        public double getBaseValue() {
            return this.baseValue;
        }

        @Override
        public String toString() {
            return "Cosine distribution [" + this.minX + ", " + this.maxX + "] base " + this.baseValue + " peaking at " + this.peakX + "," + this.peakY;
        }
    }

    public static abstract class Distribution
    extends MathExpression {
        public final int minX;
        public final int maxX;

        public Distribution(int x1, int x2) {
            this.minX = x1;
            this.maxX = x2;
        }
    }
}

