/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Math;

import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;

public class Spline {
    private final List<SplineAnchor> anchors = new ArrayList<SplineAnchor>();
    public final SplineType type;

    public Spline(SplineType t) {
        this.type = t;
    }

    public void update() {
        for (SplineAnchor a : this.anchors) {
            a.update();
        }
    }

    public void addPoint(SplineAnchor a) {
        this.anchors.add(a);
    }

    public DecimalPosition getLast() {
        return this.anchors.get(this.anchors.size() - 1).asPosition();
    }

    public List<DecimalPosition> get(int fineness, boolean closed) {
        if (fineness < 2) {
            throw new IllegalArgumentException("The fineness parameter must be greater than 2, since 2 points is just the linear segment.");
        }
        return this.interpolate(fineness, closed);
    }

    @SideOnly(value=Side.CLIENT)
    public void render(Tessellator v5, double x, double y, double z, int color, boolean glow, boolean closed, int fineness, float lineWidthFactor, ReikaGLHelper.BlendMode blend) {
        GL11.glPushAttrib((int)1048575);
        GL11.glDepthMask((boolean)false);
        List<DecimalPosition> li = this.get(fineness, closed);
        GL11.glEnable((int)3042);
        blend.apply();
        GL11.glDisable((int)3553);
        float w = GL11.glGetFloat((int)2849);
        v5.func_78371_b(3);
        int a = ReikaColorAPI.getAlpha(color);
        int clr = color & 0xFFFFFF;
        if (blend.isColorBlending() && a < 255) {
            clr = ReikaColorAPI.getColorWithBrightnessMultiplier(clr, (float)a / 255.0f / lineWidthFactor);
        }
        v5.func_78384_a(clr, a);
        this.renderPoints(v5, li, x, y, z, closed);
        v5.func_78381_a();
        if (glow) {
            v5.func_78371_b(3);
            v5.func_78384_a(clr, a / 4);
            GL11.glLineWidth((float)(5.0f * lineWidthFactor));
            this.renderPoints(v5, li, x, y, z, closed);
            v5.func_78381_a();
            v5.func_78371_b(3);
            if (blend.isColorBlending()) {
                clr = ReikaColorAPI.getColorWithBrightnessMultiplier(clr, (float)(a / 4) / 255.0f);
            }
            v5.func_78384_a(clr, a / 4);
            GL11.glLineWidth((float)(10.0f * lineWidthFactor));
            this.renderPoints(v5, li, x, y, z, closed);
            v5.func_78381_a();
        }
        GL11.glLineWidth((float)w);
        GL11.glPopAttrib();
    }

    private void renderPoints(Tessellator v5, List<DecimalPosition> li, double x, double y, double z, boolean closed) {
        for (DecimalPosition d : li) {
            v5.func_78377_a(x + d.xCoord, y + d.yCoord, z + d.zCoord);
        }
        if (closed) {
            DecimalPosition d = li.get(0);
            v5.func_78377_a(x + d.xCoord, y + d.yCoord, z + d.zCoord);
        }
    }

    private List<DecimalPosition> interpolate(int fine, boolean closed) {
        ArrayList<DecimalPosition> vertices = new ArrayList<DecimalPosition>();
        for (SplineAnchor a : this.anchors) {
            vertices.add(a.asPosition());
        }
        if (vertices.size() < 3) {
            return vertices;
        }
        if (closed) {
            vertices.add((DecimalPosition)vertices.get(0));
            DecimalPosition p2 = ((DecimalPosition)vertices.get(1)).copy();
            DecimalPosition pn1 = ((DecimalPosition)vertices.get(vertices.size() - 2)).copy();
            vertices.add(0, pn1);
            vertices.add(p2);
        } else {
            double dx = ((DecimalPosition)vertices.get((int)1)).xCoord - ((DecimalPosition)vertices.get((int)0)).xCoord;
            double dy = ((DecimalPosition)vertices.get((int)1)).yCoord - ((DecimalPosition)vertices.get((int)0)).yCoord;
            double dz = ((DecimalPosition)vertices.get((int)1)).zCoord - ((DecimalPosition)vertices.get((int)0)).zCoord;
            double x1 = ((DecimalPosition)vertices.get((int)0)).xCoord - dx;
            double y1 = ((DecimalPosition)vertices.get((int)0)).yCoord - dy;
            double z1 = ((DecimalPosition)vertices.get((int)0)).zCoord - dz;
            DecimalPosition start = new DecimalPosition(x1, y1, z1);
            int n = vertices.size() - 1;
            dx = ((DecimalPosition)vertices.get((int)n)).xCoord - ((DecimalPosition)vertices.get((int)(n - 1))).xCoord;
            dy = ((DecimalPosition)vertices.get((int)n)).yCoord - ((DecimalPosition)vertices.get((int)(n - 1))).yCoord;
            dz = ((DecimalPosition)vertices.get((int)n)).zCoord - ((DecimalPosition)vertices.get((int)(n - 1))).zCoord;
            double xn = ((DecimalPosition)vertices.get((int)n)).xCoord + dx;
            double yn = ((DecimalPosition)vertices.get((int)n)).yCoord + dy;
            double zn = ((DecimalPosition)vertices.get((int)n)).zCoord + dz;
            DecimalPosition end = new DecimalPosition(xn, yn, zn);
            vertices.add(0, start);
            vertices.add(end);
        }
        ArrayList<DecimalPosition> result = new ArrayList<DecimalPosition>();
        for (int i = 0; i < vertices.size() - 3; ++i) {
            List<DecimalPosition> points = this.interpolatePoints(vertices, i, fine);
            if (result.size() > 0) {
                points.remove(0);
            }
            result.addAll(points);
        }
        return result;
    }

    private List<DecimalPosition> interpolatePoints(List<DecimalPosition> points, int index, int pointsPerSegment) {
        ArrayList<DecimalPosition> result = new ArrayList<DecimalPosition>();
        double[] x = new double[4];
        double[] y = new double[4];
        double[] z = new double[4];
        double[] time = new double[4];
        for (int i = 0; i < 4; ++i) {
            x[i] = points.get((int)(index + i)).xCoord;
            y[i] = points.get((int)(index + i)).yCoord;
            z[i] = points.get((int)(index + i)).zCoord;
            time[i] = i;
        }
        double tstart = 1.0;
        double tend = 2.0;
        double power = this.type.power;
        if (power > 0.0) {
            double total = 0.0;
            for (int i = 1; i < 4; ++i) {
                double dx = x[i] - x[i - 1];
                double dy = y[i] - y[i - 1];
                double dz = z[i] - z[i - 1];
                time[i] = total += Math.pow(dx * dx + dy * dy + dz * dz, power);
            }
            tstart = time[1];
            tend = time[2];
        }
        int segments = pointsPerSegment - 1;
        result.add(points.get(index + 1));
        for (int i = 1; i < segments; ++i) {
            double xi = this.interpolate(x, time, tstart + (double)i * (tend - tstart) / (double)segments);
            double yi = this.interpolate(y, time, tstart + (double)i * (tend - tstart) / (double)segments);
            double zi = this.interpolate(z, time, tstart + (double)i * (tend - tstart) / (double)segments);
            result.add(new DecimalPosition(xi, yi, zi));
        }
        result.add(points.get(index + 2));
        return result;
    }

    private double interpolate(double[] p, double[] time, double t) {
        double L01 = p[0] * (time[1] - t) / (time[1] - time[0]) + p[1] * (t - time[0]) / (time[1] - time[0]);
        double L12 = p[1] * (time[2] - t) / (time[2] - time[1]) + p[2] * (t - time[1]) / (time[2] - time[1]);
        double L23 = p[2] * (time[3] - t) / (time[3] - time[2]) + p[3] * (t - time[2]) / (time[3] - time[2]);
        double L012 = L01 * (time[2] - t) / (time[2] - time[0]) + L12 * (t - time[0]) / (time[2] - time[0]);
        double L123 = L12 * (time[3] - t) / (time[3] - time[1]) + L23 * (t - time[1]) / (time[3] - time[1]);
        double C12 = L012 * (time[2] - t) / (time[2] - time[1]) + L123 * (t - time[1]) / (time[2] - time[1]);
        return C12;
    }

    public String toString() {
        return this.anchors.toString();
    }

    public int length() {
        return this.anchors.size();
    }

    public static enum SplineType {
        UNIFORM(0.0),
        CENTRIPETAL(0.25),
        CHORDAL(0.5);

        private final double power;

        private SplineType(double p) {
            this.power = p;
        }
    }

    public static class BasicVariablePoint
    extends BasicSplinePoint {
        private final double velocity;
        private final double variance;
        public double tolerance = 1.0;
        private double targetX;
        private double targetY;
        private double targetZ;
        private final DecimalPosition origin;

        public BasicVariablePoint(DecimalPosition pos, double var, double vel) {
            super(pos.xCoord, pos.yCoord, pos.zCoord);
            this.origin = pos;
            this.variance = var;
            this.velocity = vel;
            this.pickNewTarget();
        }

        @Override
        public void update() {
            double dx = this.targetX - this.posX;
            double dy = this.targetY - this.posY;
            double dz = this.targetZ - this.posZ;
            if (this.atTarget(dx, dy, dz)) {
                this.pickNewTarget();
            }
            this.move(dx, dy, dz);
        }

        private void move(double dx, double dy, double dz) {
            if (Math.abs(dx) >= this.tolerance) {
                this.posX += this.velocity * Math.signum(dx);
            }
            if (Math.abs(dy) >= this.tolerance) {
                this.posY += this.velocity * Math.signum(dy);
            }
            if (Math.abs(dz) >= this.tolerance) {
                this.posZ += this.velocity * Math.signum(dz);
            }
        }

        private boolean atTarget(double dx, double dy, double dz) {
            return Math.abs(dx) < this.tolerance && Math.abs(dy) < this.tolerance && Math.abs(dz) < this.tolerance;
        }

        private void pickNewTarget() {
            this.targetX = ReikaRandomHelper.getRandomPlusMinus(this.origin.xCoord, this.variance);
            this.targetY = ReikaRandomHelper.getRandomPlusMinus(this.origin.yCoord, this.variance);
            this.targetZ = ReikaRandomHelper.getRandomPlusMinus(this.origin.zCoord, this.variance);
        }

        @Override
        public String toString() {
            return super.toString() + " varies " + this.variance + "/" + this.velocity;
        }
    }

    public static class BasicSplinePoint
    implements SplineAnchor {
        protected double posX;
        protected double posY;
        protected double posZ;
        private DecimalPosition relative;

        public BasicSplinePoint(double x, double y, double z) {
            this.posX = x;
            this.posY = y;
            this.posZ = z;
        }

        public BasicSplinePoint(DecimalPosition p) {
            this(p.xCoord, p.yCoord, p.zCoord);
        }

        public BasicSplinePoint setRelativeTo(double x, double y, double z) {
            return this.setRelativeTo(new DecimalPosition(x, y, z));
        }

        public BasicSplinePoint setRelativeTo(DecimalPosition p) {
            this.relative = p;
            return this;
        }

        @Override
        public void update() {
        }

        @Override
        public final DecimalPosition asPosition() {
            return this.relative != null ? this.relative.offset(this.posX, this.posY, this.posZ) : new DecimalPosition(this.posX, this.posY, this.posZ);
        }

        @Override
        public String toString() {
            return this.asPosition().toString();
        }
    }

    public static interface SplineAnchor {
        public void update();

        public DecimalPosition asPosition();

        public String toString();
    }
}

