/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable;

import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMusicHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class MusicScore {
    private final ScoreTrack[] music;
    private final HashSet<Integer> activeTracks = new HashSet();
    private final int channelCount;
    private int length;
    private int noteCount;
    private ReikaMusicHelper.MusicKey lowest;
    private ReikaMusicHelper.MusicKey highest;
    private int firstNoteTime = Integer.MAX_VALUE;

    public MusicScore(int channels) {
        this.channelCount = channels;
        this.music = new ScoreTrack[channels];
    }

    public void addNote(int time, int channel, ReikaMusicHelper.MusicKey note, int voice, int vol, int len, boolean perc) {
        this.addNote(channel, time, new Note(note, voice, vol, len, perc));
    }

    private void addNote(int channel, int time, Note note) {
        NoteData c;
        if (this.music[channel] == null) {
            this.music[channel] = new ScoreTrack(channel);
        }
        if ((c = this.music[channel].getNoteAt(time)) == null) {
            c = new NoteData(time);
            this.music[channel].put(time, c);
        }
        this.activeTracks.add(channel);
        ++this.noteCount;
        c.add(note);
        this.length = Math.max(this.length, time);
        this.firstNoteTime = Math.min(this.firstNoteTime, time);
        if (note.key == null) {
            return;
        }
        if (this.lowest == null || this.lowest.ordinal() > note.key.ordinal()) {
            this.lowest = note.key;
        }
        if (this.highest == null || this.highest.ordinal() < note.key.ordinal()) {
            this.highest = note.key;
        }
    }

    public Collection<Note> getNotes(int time) {
        ArrayList<Note> li = new ArrayList<Note>();
        for (int i = 0; i < this.channelCount; ++i) {
            NoteData n;
            NoteData noteData = n = this.music[i] != null ? this.music[i].getNoteAt(time) : null;
            if (n == null) continue;
            li.addAll(n.notes.values());
        }
        return li;
    }

    public Collection<Note> getNotes(int channel, int time) {
        NoteData c = this.music[channel] != null ? this.music[channel].getNoteAt(time) : null;
        return c != null ? Collections.unmodifiableCollection(c.notes.values()) : null;
    }

    public void backspace(int channel) {
        if (this.music[channel] != null && !this.music[channel].isEmpty() && this.music[channel].remove(this.music[channel].lastNoteTime()) != null) {
            --this.noteCount;
            if (this.music[channel].isEmpty()) {
                this.activeTracks.remove(channel);
            }
        }
    }

    public ScoreTrack getTrack(int channel) {
        return this.music[channel] != null ? this.music[channel] : null;
    }

    public int getLatestPos(int channel) {
        return this.music[channel] != null && !this.music[channel].isEmpty() ? this.music[channel].lastNoteTime() : 0;
    }

    public int getLatestPos() {
        return this.length;
    }

    public int countTracks() {
        return this.music.length;
    }

    public MusicScore scaleSpeed(float factor, boolean alignToZero) {
        MusicScore mus = new MusicScore(this.channelCount);
        int shift = alignToZero ? (int)((float)(-this.firstNoteTime) / factor) : 0;
        for (int i = 0; i < this.channelCount; ++i) {
            if (this.music[i] == null) continue;
            for (Map.Entry e : this.music[i].entrySet()) {
                int time = (Integer)e.getKey();
                NoteData c = (NoteData)e.getValue();
                if (c == null) continue;
                for (Note n : c.notes.values()) {
                    mus.addNote(i, (int)((float)time / factor) + shift, n.scaleSpeed(factor));
                }
            }
        }
        return mus;
    }

    public MusicScore alignToZero() {
        MusicScore mus = new MusicScore(this.channelCount);
        for (int i = 0; i < this.channelCount; ++i) {
            if (this.music[i] == null) continue;
            for (Map.Entry e : this.music[i].entrySet()) {
                int time = (Integer)e.getKey();
                NoteData c = (NoteData)e.getValue();
                if (c == null) continue;
                for (Note n : c.notes.values()) {
                    mus.addNote(i, time - this.firstNoteTime, n);
                }
            }
        }
        return mus;
    }

    public void transpose(int semitones) {
        if (semitones == 0) {
            return;
        }
        for (int i = 0; i < this.channelCount; ++i) {
            if (this.music[i] == null) continue;
            for (Map.Entry e : this.music[i].entrySet()) {
                int time = (Integer)e.getKey();
                NoteData c = (NoteData)e.getValue();
                if (c == null) continue;
                e.setValue(c.transpose(semitones));
            }
        }
    }

    public ReikaMusicHelper.MusicKey getLowest() {
        return this.lowest;
    }

    public ReikaMusicHelper.MusicKey getHighest() {
        return this.highest;
    }

    public void normalizeToRange(ReikaMusicHelper.MusicKey min, ReikaMusicHelper.MusicKey max) {
        int under = min.ordinal() - this.lowest.ordinal();
        int over = this.highest.ordinal() - max.ordinal();
        int ounder = ReikaMathLibrary.roundToNearestX(12, under);
        int oover = ReikaMathLibrary.roundToNearestX(12, over);
        if (oover <= 0 && ounder <= 0 || oover == ounder) {
            return;
        }
        if (oover > ounder) {
            this.transpose(-12 * Math.round((float)(oover - ounder) / 24.0f));
        } else {
            this.transpose(12 * Math.round((float)(ounder - oover) / 24.0f));
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        for (int i = 0; i < this.channelCount; ++i) {
            NBTTagCompound nbt = new NBTTagCompound();
            if (this.music[i] != null) {
                for (Map.Entry e : this.music[i].entrySet()) {
                    NBTTagList li = ((NoteData)e.getValue()).writeToNBT();
                    nbt.func_74782_a(String.valueOf(e.getKey()), (NBTBase)li);
                }
            }
            tag.func_74782_a("Ch_" + i, (NBTBase)nbt);
        }
        tag.func_74768_a("numchan", this.channelCount);
        tag.func_74768_a("len", this.length);
        tag.func_74768_a("first", this.firstNoteTime);
        tag.func_74768_a("count", this.noteCount);
        tag.func_74768_a("lowest", this.lowest != null ? this.lowest.ordinal() : -1);
        tag.func_74768_a("highest", this.highest != null ? this.highest.ordinal() : -1);
    }

    public static MusicScore readFromNBT(NBTTagCompound tag) {
        MusicScore mus = new MusicScore(tag.func_74762_e("numchan"));
        for (int i = 0; i < mus.channelCount; ++i) {
            if (!tag.func_74764_b("Ch_" + i)) continue;
            mus.music[i] = new ScoreTrack(i);
            NBTTagCompound nbt = tag.func_74775_l("Ch_" + i);
            for (Object o : nbt.func_150296_c()) {
                String s = (String)o;
                int time = Integer.parseInt(s);
                NBTTagList li = nbt.func_150295_c(s, ReikaNBTHelper.NBTTypes.COMPOUND.ID);
                NoteData c = NoteData.readFromNBT(time, li);
                mus.music[i].put(time, c);
            }
            if (mus.music[i].isEmpty()) {
                mus.music[i] = null;
                continue;
            }
            mus.activeTracks.add(i);
        }
        mus.length = tag.func_74762_e("len");
        mus.firstNoteTime = tag.func_74762_e("first");
        mus.noteCount = tag.func_74762_e("count");
        int low = tag.func_74762_e("lowest");
        mus.lowest = low == -1 ? null : ReikaMusicHelper.MusicKey.getByIndex(low);
        int high = tag.func_74762_e("highest");
        mus.highest = high == -1 ? null : ReikaMusicHelper.MusicKey.getByIndex(high);
        return mus;
    }

    public String toString() {
        return Arrays.toString(this.music);
    }

    public int noteCount() {
        return this.noteCount;
    }

    public Set<Integer> getActiveTracks() {
        return Collections.unmodifiableSet(this.activeTracks);
    }

    public void clearChannel(int channel) {
        this.noteCount -= this.music[channel].noteCount();
        this.music[channel] = null;
        this.activeTracks.remove(channel);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderPianoRoll() {
    }

    public MusicScore copy() {
        MusicScore mus = new MusicScore(this.channelCount);
        for (int i = 0; i < this.channelCount; ++i) {
            if (this.music[i] == null) continue;
            mus.music[i] = this.music[i].copy();
        }
        mus.length = this.length;
        return mus;
    }

    public static class Note {
        public final ReikaMusicHelper.MusicKey key;
        public final int voice;
        public final int volume;
        public final int length;
        public final boolean percussion;

        private Note(ReikaMusicHelper.MusicKey note, int instru, int vol, int len, boolean perc) {
            this.key = note;
            this.voice = instru;
            this.volume = vol;
            this.length = len;
            this.percussion = perc;
        }

        public Note scaleSpeed(float speed) {
            return new Note(this.key, this.voice, this.volume, (int)((float)this.length / speed), this.percussion);
        }

        public Note transpose(int semitones) {
            return new Note(this.key.getInterval(semitones), this.voice, this.volume, this.length, this.percussion);
        }

        public void writeToNBT(NBTTagCompound nbt) {
            nbt.func_74768_a("key", this.key.ordinal());
            nbt.func_74768_a("volume", this.volume);
            nbt.func_74768_a("voice", this.voice);
            nbt.func_74768_a("length", this.length);
            nbt.func_74757_a("percussion", this.percussion);
        }

        public static Note readFromNBT(NBTTagCompound nbt) {
            return new Note(ReikaMusicHelper.MusicKey.getByIndex(nbt.func_74762_e("key")), nbt.func_74762_e("voice"), nbt.func_74762_e("volume"), nbt.func_74762_e("length"), nbt.func_74767_n("percussion"));
        }

        public String toString() {
            return this.key.name() + " / instr=" + this.voice + " / vol=" + this.volume + " / len=" + this.length;
        }

        public int hashCode() {
            return this.key.ordinal() << 16 | this.voice << 8 | this.volume;
        }

        public boolean equals(Object o) {
            if (o instanceof Note) {
                Note n = (Note)o;
                return n.key == this.key && n.voice == this.voice && n.volume == this.volume;
            }
            return false;
        }
    }

    public static class NoteData {
        private final HashMap<ReikaMusicHelper.MusicKey, Note> notes = new HashMap();
        public final int tick;
        private int longestNote = 0;

        private NoteData(int t) {
            this.tick = t;
        }

        public NoteData setTick(int newtick) {
            NoteData ret = new NoteData(newtick);
            ret.notes.putAll(this.notes);
            ret.longestNote = this.longestNote;
            return ret;
        }

        public int length() {
            return this.longestNote;
        }

        public NoteData transpose(int semitones) {
            NoteData ret = new NoteData(this.tick);
            for (Note n : this.notes.values()) {
                ret.add(n.transpose(semitones));
            }
            return ret;
        }

        private static NoteData readFromNBT(int t, NBTTagList li) {
            NoteData dat = new NoteData(t);
            for (Object o2 : li.field_74747_a) {
                NBTTagCompound val = (NBTTagCompound)o2;
                Note n = Note.readFromNBT(val);
                dat.add(n);
            }
            return dat;
        }

        private NBTTagList writeToNBT() {
            NBTTagList li = new NBTTagList();
            for (Note n : this.notes.values()) {
                NBTTagCompound val = new NBTTagCompound();
                n.writeToNBT(val);
                li.func_74742_a((NBTBase)val);
            }
            return li;
        }

        private void add(Note note) {
            this.notes.put(note.key, note);
            this.longestNote = Math.max(this.longestNote, note.length);
        }

        public Collection<Note> notes() {
            return Collections.unmodifiableCollection(this.notes.values());
        }

        public Set<ReikaMusicHelper.MusicKey> keys() {
            return Collections.unmodifiableSet(this.notes.keySet());
        }

        public String toString() {
            return this.notes.values().toString() + " @ " + this.tick;
        }
    }

    public static class ScoreTrack {
        private final TreeMap<Integer, NoteData> notes = new TreeMap();
        public final int channel;
        private ReikaMusicHelper.MusicKey lowest;
        private ReikaMusicHelper.MusicKey highest;
        private int firstNoteTime = Integer.MAX_VALUE;

        private ScoreTrack(int ch) {
            this.channel = ch;
        }

        public ScoreTrack copy() {
            ScoreTrack ret = new ScoreTrack(this.channel);
            ret.putAll(this);
            return ret;
        }

        public ScoreTrack alignToGrid(int step) {
            ScoreTrack ret = new ScoreTrack(this.channel);
            for (Map.Entry<Integer, NoteData> e : this.notes.entrySet()) {
                int tick = ReikaMathLibrary.roundDownToX(step, e.getKey());
                ret.put(tick, e.getValue().setTick(tick));
            }
            return ret;
        }

        public NoteData getNoteAt(int time) {
            return this.notes.get(time);
        }

        public int firstNoteTime() {
            return this.notes.isEmpty() ? -1 : this.notes.firstKey();
        }

        public int lastNoteTime() {
            return this.notes.isEmpty() ? -1 : this.notes.lastKey();
        }

        public ReikaMusicHelper.MusicKey getLowest() {
            return this.lowest;
        }

        public ReikaMusicHelper.MusicKey getHighest() {
            return this.highest;
        }

        public int getLengthInTicks() {
            if (this.isEmpty()) {
                return 0;
            }
            int last = this.lastNoteTime();
            NoteData note = this.getNoteAt(last);
            return last + note.length();
        }

        public boolean isEmpty() {
            return this.notes.isEmpty();
        }

        public int noteCount() {
            return this.notes.size();
        }

        private Collection<Map.Entry<Integer, NoteData>> entrySet() {
            return this.notes.entrySet();
        }

        public Collection<Map.Entry<Integer, NoteData>> entryView() {
            return Collections.unmodifiableMap(this.notes).entrySet();
        }

        private Collection<Integer> keySet() {
            return this.notes.keySet();
        }

        private void put(int time, NoteData data) {
            this.notes.put(time, data);
            for (Note n : data.notes()) {
                this.onAddNote(time, n);
            }
        }

        private void putAll(ScoreTrack s) {
            this.notes.putAll(s.notes);
            this.firstNoteTime = Math.min(this.firstNoteTime, s.firstNoteTime);
            if (this.lowest == null || this.lowest.ordinal() > s.lowest.ordinal()) {
                this.lowest = s.lowest;
            }
            if (this.highest == null || this.highest.ordinal() < s.highest.ordinal()) {
                this.highest = s.highest;
            }
        }

        private void onAddNote(int time, Note n) {
            this.firstNoteTime = Math.min(this.firstNoteTime, time);
            if (this.lowest == null || this.lowest.ordinal() > n.key.ordinal()) {
                this.lowest = n.key;
            }
            if (this.highest == null || this.highest.ordinal() < n.key.ordinal()) {
                this.highest = n.key;
            }
        }

        private NoteData remove(int time) {
            return this.notes.remove(time);
        }

        public Collection<NoteData> getNotes() {
            return Collections.unmodifiableCollection(this.notes.values());
        }

        public String toString() {
            return this.notes.toString();
        }

        public Collection<Note> getActiveNotesAt(int tick) {
            ArrayList<Note> ret = new ArrayList<Note>();
            Integer prev = this.notes.floorKey(tick);
            while (prev != null) {
                NoteData nd = this.notes.get(prev);
                for (Note n : nd.notes.values()) {
                    int end = nd.tick + n.length;
                    if (end <= tick) continue;
                    ret.add(n);
                }
                prev = this.notes.lowerKey(prev);
            }
            return ret;
        }
    }
}

