/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.ParticleController;

import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Interfaces.PositionController;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import net.minecraft.entity.Entity;

public class PulsingSpherePositionController
implements PositionController {
    public final int cycleLength;
    public final double innerRadius;
    public final double outerRadius;
    public final double theta;
    public final double phi;
    public final DecimalPosition center;
    private final double[] cartesian;
    private final double radiusDelta;
    private final double phase;
    private double currentRadius;

    public PulsingSpherePositionController(int l, double x, double y, double z, double r1, double r2, double theta, double phi) {
        this(l, x, y, z, r1, r2, theta, phi, PulsingSpherePositionController.calcPhase(theta, phi));
    }

    private static double calcPhase(double theta, double phi) {
        return phi / 4.0 + theta / 6.0;
    }

    public PulsingSpherePositionController(int l, double x, double y, double z, double r1, double r2, double theta, double phi, double phase) {
        this.cycleLength = l;
        this.center = new DecimalPosition(x, y, z);
        this.innerRadius = r1;
        this.outerRadius = r2;
        this.theta = theta;
        this.phi = phi;
        this.radiusDelta = (r2 - r1) / 2.0;
        this.cartesian = ReikaPhysicsHelper.polarToCartesian(1.0, theta, phi);
        this.phase = phase;
    }

    @Override
    public void update(Entity e) {
        this.currentRadius = this.innerRadius + this.radiusDelta + this.radiusDelta * Math.sin(this.phase + (double)(18 * e.field_70173_aa) / (double)this.cycleLength);
    }

    @Override
    public double getPositionX(Entity e) {
        return this.center.xCoord + this.currentRadius * this.cartesian[0];
    }

    @Override
    public double getPositionY(Entity e) {
        return this.center.yCoord + this.currentRadius * this.cartesian[1];
    }

    @Override
    public double getPositionZ(Entity e) {
        return this.center.zCoord + this.currentRadius * this.cartesian[2];
    }
}

