/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;

public class RadialTree {
    private final RadialNodeEntry topEntry;
    private final Collection<RadialNodeEntry> nodes = new ArrayList<RadialNodeEntry>();

    private RadialTree(RadialNodeEntry top, Collection<RadialNodeEntry> data) {
        this.topEntry = top;
        for (RadialNodeEntry v : data) {
            this.addObject(v);
        }
    }

    private void addObject(RadialNodeEntry v) {
        this.nodes.add(v);
    }

    @SideOnly(value=Side.CLIENT)
    public ClickableTree getClickable() {
        return new ClickableTree(this);
    }

    public static interface RadialNodeEntry {
        public RadialNodeEntry getParent();

        public Collection<RadialNodeEntry> getChildren();
    }

    private static class ClickableNode
    implements RadialNodeEntry {
        private final RadialNodeEntry reference;
        private double relativeX;
        private double relativeY;

        private ClickableNode(RadialNodeEntry e) {
            this.reference = e;
        }

        @Override
        public RadialNodeEntry getParent() {
            return this.reference.getParent();
        }

        @Override
        public Collection<RadialNodeEntry> getChildren() {
            return this.reference.getChildren();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class ClickableTree {
        private final RadialTree data;
        private ClickableNode selected;

        private ClickableTree(RadialTree tree) {
            ArrayList<ClickableNode> c = new ArrayList<ClickableNode>();
            for (RadialNodeEntry e : tree.nodes) {
                c.add(new ClickableNode(e));
            }
            this.data = new RadialTree(new ClickableNode(tree.topEntry), c);
        }

        public void render(int x, int y) {
            this.render((ClickableNode)this.data.topEntry, null);
        }

        private void render(ClickableNode e, ClickableNode parent) {
            this.doRender(e, parent);
            for (RadialNodeEntry radialNodeEntry : e.getChildren()) {
            }
        }

        private void doRender(ClickableNode e, ClickableNode parent) {
            if (parent != null) {
                // empty if block
            }
        }

        public void onClick(int x, int y, int b) {
        }
    }
}

