/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Recipe;

import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class FluidInputRecipe
extends ShapedOreRecipe {
    private static final MultiMap<String, ItemStack> fluidItems;

    public FluidInputRecipe(ItemStack result, Object ... recipe) {
        super(result, FluidInputRecipe.parseFluids(recipe));
    }

    private static Object[] parseFluids(Object[] recipe) {
        for (int i = 0; i < recipe.length; ++i) {
            if (!(recipe[i] instanceof Fluid)) continue;
            String s = FluidInputRecipe.registerItemsFor((Fluid)recipe[i]);
            recipe[i] = s;
        }
        return recipe;
    }

    private static String registerItemsFor(Fluid f) {
        if (!fluidItems.containsKey(f.getName())) {
            FluidInputRecipe.registerItems(f);
        }
        return "container_" + f.getName();
    }

    private static void registerItems(Fluid f) {
        String s2 = "container_" + f.getName();
        FluidContainerRegistry.FluidContainerData[] dat = FluidContainerRegistry.getRegisteredFluidContainerData();
        for (int i = 0; i < dat.length; ++i) {
            FluidContainerRegistry.FluidContainerData fcd = dat[i];
            if (fcd.fluid == null || fcd.fluid.getFluid() != f || fcd.filledContainer == null) continue;
            fluidItems.addValue(f.getName(), fcd.filledContainer);
            OreDictionary.registerOre((String)s2, (ItemStack)fcd.filledContainer);
        }
    }

    static {
        RecipeSorter.register((String)"dragonapi:shapedfluid", FluidInputRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped");
        RecipeSorter.register((String)"dragonapi:shapelessfluid", ShapelessFluidInputRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        fluidItems = new MultiMap().setNullEmpty();
    }

    public static class ShapelessFluidInputRecipe
    extends ShapelessOreRecipe {
        public ShapelessFluidInputRecipe(ItemStack result, Object ... recipe) {
            super(result, FluidInputRecipe.parseFluids(recipe));
        }
    }
}

