/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Rendering;

import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Libraries.Java.ReikaJVMParser;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class LODModelPart
extends ModelRenderer {
    private static final String JVM_FLAG = "-DragonAPI_CompileLODModels";
    public static boolean allowCompiling = ReikaJVMParser.isArgumentPresent("-DragonAPI_CompileLODModels");
    private double renderDistanceSqr = -1.0;
    private double lastDistance;
    private int lastTileX;
    private int lastTileY;
    private int lastTileZ;
    private double lastPlayerX;
    private double lastPlayerY;
    private double lastPlayerZ;
    private int textureX;
    private int textureZ;
    private int displayList = -1;
    private double renderDistanceScalar = 1.0;

    public LODModelPart(ModelBase baseModel, int textureX, int textureZ) {
        super(baseModel, textureX, textureZ);
    }

    public final ModelRenderer func_78784_a(int x, int z) {
        super.func_78784_a(x, z);
        this.textureX = x;
        this.textureZ = z;
        return this;
    }

    public final ModelRenderer func_78787_b(int w, int h) {
        super.func_78787_b(w, h);
        if (allowCompiling) {
            for (MovableBox b : this.field_78804_l) {
                b.textureWidth = w;
                b.textureHeight = h;
            }
        }
        return this;
    }

    public final void func_78793_a(float x, float y, float z) {
        super.func_78793_a(x, y, z);
        if (allowCompiling) {
            for (MovableBox b : this.field_78804_l) {
                b.offsetX = this.field_82906_o + x;
                b.offsetY = this.field_82908_p + y;
                b.offsetZ = this.field_82907_q + z;
            }
        }
    }

    public final ModelRenderer func_78789_a(float par1, float par2, float par3, int par4, int par5, int par6) {
        this.func_78790_a(par1, par2, par3, par4, par5, par6, 0.0f);
        return this;
    }

    public final void func_78790_a(float par1, float par2, float par3, int par4, int par5, int par6, float par7) {
        if (allowCompiling) {
            this.field_78804_l.add(new MovableBox(this, par1, par2, par3, par4, par5, par6));
        } else {
            if (this.field_78804_l.size() > 0) {
                throw new MisuseException("You cannot have multiple pieces per model unless model compiling is enabled (jvm arg '-DragonAPI_CompileLODModels')!");
            }
            super.func_78789_a(par1, par2, par3, par4, par5, par6);
        }
        this.renderDistanceSqr = -1.0;
    }

    public final void addBox(LODModelPart model) {
        if (!allowCompiling) {
            throw new MisuseException("You cannot have multiple pieces per model unless model compiling is enabled (jvm arg '-DragonAPI_CompileLODModels')!");
        }
        for (MovableBox b : model.field_78804_l) {
            MovableBox b2 = b.move(model, model.field_78800_c, model.field_78797_d, model.field_78798_e);
            this.field_78804_l.add(b2);
        }
        this.renderDistanceSqr = -1.0;
    }

    public final ModelRenderer func_78786_a(String s, float par1, float par2, float par3, int par4, int par5, int par6) {
        throw new MisuseException("Invalid box system for LODModelPart " + (Object)((Object)this) + "!");
    }

    public final void func_78792_a(ModelRenderer model) {
        throw new MisuseException("Children not permitted for LODModelPart " + (Object)((Object)this) + "!");
    }

    protected final ModelBox getBox(int idx) {
        return (ModelBox)this.field_78804_l.get(idx);
    }

    public final LODModelPart setRenderDistanceScalar(double d) {
        this.renderDistanceScalar = d;
        this.renderDistanceSqr = -1.0;
        return this;
    }

    private final float calculateVolume() {
        ModelBox box = this.getBox(this.field_78804_l.size() - 1);
        float x = box.field_78252_a - box.field_78248_d;
        float y = box.field_78250_b - box.field_78249_e;
        float z = box.field_78251_c - box.field_78246_f;
        return Math.abs(x * y * z);
    }

    private double calculateRenderDistance() {
        float size = this.calculateVolume();
        int d = 0;
        d = size > 1024.0f ? 16384 : (size > 512.0f ? 4096 : (size > 128.0f ? 2048 : (size > 32.0f ? 1024 : (size > 8.0f ? 256 : (size > 4.0f ? 128 : (size > 0.0f ? 96 : 0))))));
        return Math.max(this.renderDistanceSqr, (double)d) * this.renderDistanceScalar;
    }

    public final boolean shouldRender(double dist_squared) {
        if (this.renderDistanceSqr < 0.0) {
            this.renderDistanceSqr = this.calculateRenderDistance();
        }
        return GuiScreen.func_146271_m() || this.renderDistanceSqr * this.getDistanceMultiplier() >= dist_squared;
    }

    private double getDistanceMultiplier() {
        ReikaRenderHelper.RenderDistance r = ReikaRenderHelper.getRenderDistance();
        switch (r) {
            case FAR: {
                return 2.0;
            }
            case NORMAL: {
                return 1.0;
            }
            case SHORT: {
                return 0.75;
            }
            case TINY: {
                return 0.4;
            }
        }
        return 1.0;
    }

    public final void render(TileEntity te, float pixelSize) {
        if (te.func_145830_o()) {
            this.calcAndCacheRenderDistance(te);
        }
        if (!te.func_145830_o() || MinecraftForgeClient.getRenderPass() == -1 || this.shouldRender(this.lastDistance)) {
            super.func_78785_a(pixelSize);
        }
    }

    public final void func_78785_a(float pixelSize) {
        if (allowCompiling) {
            if (GuiScreen.func_146271_m()) {
                Tessellator v5 = Tessellator.field_78398_a;
                for (MovableBox b : this.field_78804_l) {
                    b.func_78245_a(v5, pixelSize);
                }
            } else {
                if (this.displayList == -1 || Keyboard.isKeyDown((int)41)) {
                    this.compileDisplayList(pixelSize);
                }
                GL11.glCallList((int)this.displayList);
            }
        } else {
            super.func_78785_a(pixelSize);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void compileDisplayList(float pixelSize) {
        if (!allowCompiling) {
            throw new MisuseException("You may not use GL lists with non-compilable models!");
        }
        this.displayList = GLAllocation.func_74526_a((int)1);
        GL11.glNewList((int)this.displayList, (int)4864);
        Tessellator v5 = Tessellator.field_78398_a;
        for (MovableBox b : this.field_78804_l) {
            b.func_78245_a(v5, pixelSize);
        }
        GL11.glEndList();
    }

    private void calcAndCacheRenderDistance(TileEntity te) {
        EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
        if (this.lastTileX != te.field_145851_c || this.lastTileY != te.field_145848_d || this.lastTileZ != te.field_145849_e || this.lastPlayerX != ep.field_70165_t || this.lastPlayerY != ep.field_70163_u || this.lastPlayerZ != ep.field_70161_v) {
            this.lastTileX = te.field_145851_c;
            this.lastTileY = te.field_145848_d;
            this.lastTileZ = te.field_145849_e;
            this.lastPlayerX = ep.field_70165_t;
            this.lastPlayerY = ep.field_70163_u;
            this.lastPlayerZ = ep.field_70161_v;
            this.lastDistance = ep.func_70092_e((double)this.lastTileX + 0.5, (double)this.lastTileY + 0.5, (double)this.lastTileZ + 0.5);
        }
    }

    private static class MovableBox
    extends ModelBox {
        private final int textureX;
        private final int textureZ;
        private float textureWidth;
        private float textureHeight;
        private final float originX;
        private final float originY;
        private final float originZ;
        private final int sizeX;
        private final int sizeY;
        private final int sizeZ;
        private final float rotationX;
        private final float rotationY;
        private final float rotationZ;
        private final float rotationOriginX;
        private final float rotationOriginY;
        private final float rotationOriginZ;
        private float offsetX;
        private float offsetY;
        private float offsetZ;

        private MovableBox(LODModelPart model, float pX, float pY, float pZ, int sX, int sY, int sZ) {
            this(model, model.textureX, model.textureZ, model.field_78801_a, model.field_78799_b, pX, pY, pZ, sX, sY, sZ);
        }

        private MovableBox(LODModelPart model, int tX, int tZ, float tW, float tH, float pX, float pY, float pZ, int sX, int sY, int sZ) {
            super((ModelRenderer)model, tX, tZ, pX, pY, pZ, sX, sY, sZ, 0.0f);
            if (!allowCompiling) {
                throw new MisuseException("You cannot have dynamic model boxes unless model compiling is enabled (jvm arg '-DragonAPI_CompileLODModels')!");
            }
            this.textureX = tX;
            this.textureZ = tZ;
            this.textureWidth = tW;
            this.textureHeight = tH;
            this.originX = pX;
            this.originY = pY;
            this.originZ = pZ;
            this.sizeX = sX;
            this.sizeY = sY;
            this.sizeZ = sZ;
            this.rotationX = model.field_78795_f;
            this.rotationY = model.field_78796_g;
            this.rotationZ = model.field_78808_h;
            this.rotationOriginX = model.field_78800_c;
            this.rotationOriginY = model.field_78797_d;
            this.rotationOriginZ = model.field_78798_e;
            this.offsetX = model.field_82906_o;
            this.offsetY = model.field_82908_p;
            this.offsetZ = model.field_82907_q;
        }

        private MovableBox move(LODModelPart p, float x, float y, float z) {
            return new MovableBox(p, this.textureX, this.textureZ, this.textureWidth, this.textureHeight, this.originX + x, this.originY + y, this.originZ + z, this.sizeX, this.sizeY, this.sizeZ);
        }

        public String toString() {
            return this.originX + ", " + this.originY + ", " + this.originZ + " > " + this.sizeX + "x" + this.sizeY + "x" + this.sizeZ + " tex " + this.textureX + "," + this.textureZ + " > " + this.textureWidth + "x" + this.textureHeight;
        }

        public void func_78245_a(Tessellator v5, float f5) {
            if (this.rotationX != 0.0f || this.rotationY != 0.0f || this.rotationZ != 0.0f) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)(this.rotationOriginX * f5), (float)(this.rotationOriginY * f5), (float)(this.rotationOriginZ * f5));
                if (this.rotationZ != 0.0f) {
                    GL11.glRotatef((float)(this.rotationZ * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
                }
                if (this.rotationY != 0.0f) {
                    GL11.glRotatef((float)(this.rotationY * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (this.rotationX != 0.0f) {
                    GL11.glRotatef((float)(this.rotationX * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
                }
                GL11.glTranslatef((float)(-this.rotationOriginX * f5), (float)(-this.rotationOriginY * f5), (float)(-this.rotationOriginZ * f5));
                super.func_78245_a(v5, f5);
                GL11.glPopMatrix();
            } else {
                super.func_78245_a(v5, f5);
            }
        }
    }
}

