/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Rendering;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Extras.ThrottleableEffectRenderer;
import Reika.DragonAPI.Instantiable.Data.Maps.PluralMap;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Instantiable.Effects.EntityFloatingSeedsFX;
import Reika.DragonAPI.Interfaces.Entity.CustomRenderFX;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class ParticleEngine
extends EffectRenderer
implements ThrottleableEffectRenderer.CustomEffectRenderer {
    private final HashMap<RenderKey, ParticleList> particles = new HashMap();
    private final PluralMap<RenderKey> keyMap = new PluralMap(2);
    private final Collection<EntityFX> queuedParticles = new ArrayList<EntityFX>();
    private Random rand = new Random();
    public static final int MAX_PARTICLES = ThrottleableEffectRenderer.getRegisteredInstance().limit;
    public static final TextureMode blockTex = new VanillaTextureMode(TextureMap.field_110575_b);
    public static final TextureMode itemTex = new VanillaTextureMode(TextureMap.field_110576_c);
    public static final TextureMode particleTex = new VanillaTextureMode(new ResourceLocation("textures/particle/particles.png"));
    private final RenderKey DEFAULT_RENDER = new RenderKey(particleTex, new RenderMode());
    private boolean isRendering;
    private boolean isTicking;
    public static final ParticleEngine defaultCustomEngine = new ParticleEngine(){

        @Override
        protected void registerClasses() {
            ThrottleableEffectRenderer.getRegisteredInstance().registerDelegateRenderer(EntityBlurFX.class, this);
            ThrottleableEffectRenderer.getRegisteredInstance().registerDelegateRenderer(EntityFloatingSeedsFX.class, this);
        }
    };

    protected ParticleEngine() {
        super(null, null);
    }

    public final void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
        this.registerClasses();
    }

    protected abstract void registerClasses();

    public final void registerAdditionalClass(Class<? extends EntityFX> c) {
        ThrottleableEffectRenderer.getRegisteredInstance().registerDelegateRenderer(c, this);
    }

    public final String func_78869_b() {
        return this.getParticleCount() + " Particles, " + this.keyMap.size() + " keys";
    }

    public final void func_78874_a(Entity entity, float frame) {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glAlphaFunc((int)516, (float)0.003921569f);
        this.isRendering = true;
        for (ParticleList parts : this.particles.values()) {
            parts.render(entity, frame);
        }
        this.isRendering = false;
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    public final void func_78873_a(EntityFX fx) {
        if (this.isRendering) {
            DragonAPICore.logError("Tried adding a particle mid-render!");
            Thread.dumpStack();
            return;
        }
        if (this.isTicking) {
            this.queuedParticles.add(fx);
            return;
        }
        RenderKey rm = this.DEFAULT_RENDER;
        if (fx instanceof CustomRenderFX) {
            rm = this.getOrCreateKey(((CustomRenderFX)fx).getTexture(), ((CustomRenderFX)fx).getRenderMode());
        }
        this.addParticle(rm, fx);
    }

    private final void addParticle(RenderKey rm, EntityFX fx) {
        ParticleList li = this.particles.get(rm);
        if (li == null) {
            li = new ParticleList(rm);
            this.particles.put(rm, li);
        }
        li.addParticle(fx);
    }

    private final RenderKey getOrCreateKey(TextureMode tex, RenderMode rm) {
        RenderKey rk = this.keyMap.get(tex, rm);
        if (rk == null) {
            rk = new RenderKey(tex, rm);
            this.keyMap.put(rk, tex, rm);
        }
        return rk;
    }

    public final void func_78868_a() {
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (mc.field_71441_e == null) {
            return;
        }
        this.isTicking = true;
        int dim = mc.field_71441_e.field_73011_w.field_76574_g;
        for (ParticleList li : this.particles.values()) {
            li.tick();
        }
        this.isTicking = false;
        if (!this.queuedParticles.isEmpty()) {
            for (EntityFX fx : this.queuedParticles) {
                this.func_78873_a(fx);
            }
            this.queuedParticles.clear();
        }
    }

    public final void func_78870_a(World world) {
        this.particles.clear();
    }

    @Override
    public final int getParticleCount() {
        int ret = 0;
        for (ParticleList li : this.particles.values()) {
            ret += li.particles.size();
        }
        return ret;
    }

    public static enum RenderModeFlags {
        ALPHA(true),
        LIGHT(true),
        ADDITIVE(false),
        DEPTH(true),
        ALPHACLIP(true);

        private final boolean defaultValue;
        private static final RenderModeFlags[] list;

        private RenderModeFlags(boolean f) {
            this.defaultValue = f;
        }

        private int getFlag() {
            return 1 << this.ordinal();
        }

        private void apply(boolean set) {
            switch (this) {
                case LIGHT: {
                    if (set) {
                        GL11.glEnable((int)2896);
                        ReikaRenderHelper.enableEntityLighting();
                        break;
                    }
                    GL11.glDisable((int)2896);
                    ReikaRenderHelper.disableEntityLighting();
                    break;
                }
                case ALPHA: {
                    if (set) {
                        GL11.glEnable((int)3042);
                        break;
                    }
                    GL11.glDisable((int)3042);
                    break;
                }
                case ADDITIVE: {
                    if (set) {
                        ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
                        break;
                    }
                    ReikaGLHelper.BlendMode.DEFAULT.apply();
                    break;
                }
                case DEPTH: {
                    if (set && !ThrottleableEffectRenderer.renderThroughWalls()) {
                        GL11.glEnable((int)2929);
                        break;
                    }
                    GL11.glDisable((int)2929);
                    break;
                }
                case ALPHACLIP: {
                    if (set) {
                        GL11.glEnable((int)3008);
                        break;
                    }
                    GL11.glDisable((int)3008);
                }
            }
        }

        static {
            list = RenderModeFlags.values();
        }
    }

    public static final class RenderMode {
        private final boolean[] flags = new boolean[RenderModeFlags.access$1400().length];

        public RenderMode() {
            for (int i = 0; i < this.flags.length; ++i) {
                this.flags[i] = RenderModeFlags.list[i].defaultValue;
            }
        }

        public RenderMode setFlag(RenderModeFlags f, boolean flag) {
            this.flags[f.ordinal()] = flag;
            return this;
        }

        public int hashCode() {
            return ReikaArrayHelper.booleanToBitflags(this.flags);
        }

        public boolean equals(Object o) {
            if (o instanceof RenderMode) {
                RenderMode r = (RenderMode)o;
                return Arrays.equals(this.flags, r.flags);
            }
            return false;
        }

        public String toString() {
            return Arrays.toString(this.flags);
        }

        private void apply() {
            for (int i = 0; i < this.flags.length; ++i) {
                RenderModeFlags.list[i].apply(this.flags[i]);
            }
        }
    }

    private static final class VanillaTextureMode
    extends TextureMode {
        private final ResourceLocation resource;

        private VanillaTextureMode(ResourceLocation loc) {
            this.resource = loc;
        }

        @Override
        protected void bind() {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.resource);
        }

        @Override
        protected boolean isTextureSame(TextureMode o) {
            return ((VanillaTextureMode)o).resource.equals((Object)this.resource);
        }

        @Override
        public int hashCode() {
            return this.resource.hashCode();
        }
    }

    public static final class CustomTextureMode
    extends TextureMode {
        private final Class reference;
        private final String texture;

        public CustomTextureMode(Class c, String t) {
            this.reference = c;
            this.texture = t;
        }

        @Override
        protected void bind() {
            ReikaTextureHelper.bindFinalTexture(this.reference, this.texture);
        }

        @Override
        protected boolean isTextureSame(TextureMode o) {
            CustomTextureMode cm = (CustomTextureMode)o;
            return cm.reference == this.reference && this.texture.equals(cm.texture);
        }

        @Override
        public int hashCode() {
            return this.reference.hashCode() ^ this.texture.hashCode();
        }
    }

    public static abstract class TextureMode {
        protected abstract void bind();

        public final boolean equals(Object o) {
            return o.getClass() == this.getClass() && this.isTextureSame((TextureMode)o);
        }

        protected abstract boolean isTextureSame(TextureMode var1);

        public abstract int hashCode();
    }

    private static class RenderKey {
        private final RenderMode mode;
        private final TextureMode texture;

        private RenderKey(TextureMode s, RenderMode rm) {
            this.texture = s;
            this.mode = rm;
        }

        private void apply() {
            this.mode.apply();
            this.texture.bind();
        }

        public int hashCode() {
            return this.texture.hashCode() ^ this.mode.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof RenderKey) {
                RenderKey r = (RenderKey)o;
                return this.texture.equals(r.texture) && this.mode.equals(r.mode);
            }
            return false;
        }
    }

    private static class ParticleEntry {
        private final EntityFX effect;
        private boolean countsToLimit;

        private ParticleEntry(EntityFX fx) {
            this.effect = fx;
            boolean flag = true;
            if (fx instanceof CustomRenderFX) {
                flag = !((CustomRenderFX)fx).rendersOverLimit();
            }
            this.countsToLimit = flag;
        }
    }

    private static class ParticleList {
        private final RenderKey key;
        private final ArrayList<ParticleEntry> particles = new ArrayList();
        private int effectiveCount = 0;

        private ParticleList(RenderKey rk) {
            this.key = rk;
        }

        private void render(Entity entity, float frame) {
            if (!this.particles.isEmpty()) {
                GL11.glPushMatrix();
                GL11.glPushAttrib((int)1048575);
                this.key.apply();
                float yaw = ActiveRenderInfo.field_74588_d;
                float pitch = ActiveRenderInfo.field_74586_f;
                float f3 = ActiveRenderInfo.field_74587_g;
                float f4 = ActiveRenderInfo.field_74596_h;
                float f5 = ActiveRenderInfo.field_74589_e;
                EntityFX.field_70556_an = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)frame;
                EntityFX.field_70554_ao = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)frame;
                EntityFX.field_70555_ap = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)frame;
                Tessellator v5 = Tessellator.field_78398_a;
                v5.func_78382_b();
                for (ParticleEntry p : this.particles) {
                    EntityFX fx = p.effect;
                    if (!ThrottleableEffectRenderer.isParticleVisible(fx)) continue;
                    if (this.key.mode.flags[RenderModeFlags.LIGHT.ordinal()]) {
                        v5.func_78380_c(fx.func_70070_b(frame));
                    } else {
                        v5.func_78380_c(240);
                    }
                    fx.func_70539_a(v5, frame, yaw, f5, pitch, f3, f4);
                }
                v5.func_78381_a();
                GL11.glPopAttrib();
                GL11.glPopMatrix();
            }
        }

        private boolean isEmpty() {
            return this.particles.isEmpty();
        }

        private void addParticle(EntityFX fx) {
            ParticleEntry e = new ParticleEntry(fx);
            this.particles.add(e);
            if (e.countsToLimit) {
                ++this.effectiveCount;
            }
            if (this.effectiveCount >= MAX_PARTICLES) {
                int i = 0;
                ParticleEntry rfx = this.particles.get(i);
                while (!rfx.countsToLimit && i < this.particles.size() - 1) {
                    rfx = this.particles.get(++i);
                }
                this.particles.remove(i);
                --this.effectiveCount;
            }
        }

        private void tick() {
            Iterator<ParticleEntry> it = this.particles.iterator();
            while (it.hasNext()) {
                try {
                    ParticleEntry fx = it.next();
                    if (fx != null) {
                        fx.effect.func_70071_h_();
                    }
                    if (fx.effect != null && !((ParticleEntry)fx).effect.field_70128_L) continue;
                    it.remove();
                    --this.effectiveCount;
                }
                catch (ConcurrentModificationException e) {
                    DragonAPICore.log("CME thrown updating particle type " + this.key + "!");
                }
            }
        }
    }
}

