/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Rendering;

import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import java.awt.Color;
import net.minecraft.client.renderer.Tessellator;

public class PixelRenderer {
    private boolean xy;
    private double x;
    private double y;
    private double z;
    private double pw;
    private double ph;
    private boolean flip;
    private boolean mirror;
    private int[] rgba = new int[4];

    public PixelRenderer(double px, double py, double pz, boolean plane, int wx, int wy, double w, double h, boolean f) {
        this.x = px;
        this.y = py;
        this.z = pz;
        this.xy = plane;
        this.pw = w / (double)wx;
        this.ph = -h / (double)wy;
        this.flip = f;
    }

    public void setPosition(double x0, double y0, double z0) {
        this.x = x0;
        this.y = y0;
        this.z = z0;
    }

    public void setFlip(boolean f) {
        this.flip = f;
    }

    public void setMirror(boolean m) {
        this.mirror = m;
    }

    public void setPlane(boolean plane) {
        this.xy = plane;
    }

    public void draw(int x1, int y1, int x2, int y2) {
        if (this.mirror) {
            // empty if block
        }
        ReikaRenderHelper.prepareGeoDraw(this.rgba[3] < 255);
        Tessellator v5 = Tessellator.field_78398_a;
        if (this.flip) {
            if (this.xy) {
                v5.func_78382_b();
                v5.func_78370_a(this.rgba[0], this.rgba[1], this.rgba[2], this.rgba[3]);
                v5.func_78377_a(this.x + (double)x1 * this.pw, this.y + this.ph + (double)y2 * this.ph, this.z);
                v5.func_78377_a(this.x + this.pw + (double)x2 * this.pw, this.y + this.ph + (double)y2 * this.ph, this.z);
                v5.func_78377_a(this.x + this.pw + (double)x2 * this.pw, this.y + (double)y1 * this.ph, this.z);
                v5.func_78377_a(this.x + (double)x1 * this.pw, this.y + (double)y1 * this.ph, this.z);
                v5.func_78381_a();
            } else {
                v5.func_78382_b();
                v5.func_78370_a(this.rgba[0], this.rgba[1], this.rgba[2], this.rgba[3]);
                v5.func_78377_a(this.x, this.y + this.ph + (double)y2 * this.ph, this.z + (double)x1 * this.pw);
                v5.func_78377_a(this.x, this.y + this.ph + (double)y2 * this.ph, this.z + this.pw + (double)x2 * this.pw);
                v5.func_78377_a(this.x, this.y + (double)y1 * this.ph, this.z + this.pw + (double)x2 * this.pw);
                v5.func_78377_a(this.x, this.y + (double)y1 * this.ph, this.z + (double)x1 * this.pw);
                v5.func_78381_a();
            }
        } else if (this.xy) {
            v5.func_78382_b();
            v5.func_78370_a(this.rgba[0], this.rgba[1], this.rgba[2], this.rgba[3]);
            v5.func_78377_a(this.x + (double)x1 * this.pw, this.y + (double)y1 * this.ph, this.z);
            v5.func_78377_a(this.x + this.pw + (double)x2 * this.pw, this.y + (double)y1 * this.ph, this.z);
            v5.func_78377_a(this.x + this.pw + (double)x2 * this.pw, this.y + this.ph + (double)y2 * this.ph, this.z);
            v5.func_78377_a(this.x + (double)x1 * this.pw, this.y + this.ph + (double)y2 * this.ph, this.z);
            v5.func_78381_a();
        } else {
            v5.func_78382_b();
            v5.func_78370_a(this.rgba[0], this.rgba[1], this.rgba[2], this.rgba[3]);
            v5.func_78377_a(this.x, this.y + (double)y1 * this.ph, this.z + (double)x1 * this.pw);
            v5.func_78377_a(this.x, this.y + (double)y1 * this.ph, this.z + this.pw + (double)x2 * this.pw);
            v5.func_78377_a(this.x, this.y + this.ph + (double)y2 * this.ph, this.z + this.pw + (double)x2 * this.pw);
            v5.func_78377_a(this.x, this.y + this.ph + (double)y2 * this.ph, this.z + (double)x1 * this.pw);
            v5.func_78381_a();
        }
        ReikaRenderHelper.exitGeoDraw();
    }

    public void setColor(int r, int g, int b, int a) {
        this.rgba[0] = r;
        this.rgba[1] = g;
        this.rgba[2] = b;
        this.rgba[3] = a;
    }

    public void setColor(Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int a = c.getAlpha();
        this.rgba[0] = r;
        this.rgba[1] = g;
        this.rgba[2] = b;
        this.rgba[3] = a;
    }
}

