/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Rendering;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Rendering.TextureSubImage;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import net.minecraft.nbt.NBTTagCompound;

public class TextureSlot
extends TextureSubImage {
    private final Class reference;
    private final String texture;

    public TextureSlot(Class c, String tex, double u, double du, double v, double dv) {
        super(u, du, v, dv);
        this.reference = c;
        this.texture = tex;
    }

    public void bindTexture() {
        ReikaTextureHelper.bindTexture(this.reference, this.texture);
    }

    public static TextureSlot fromSpritesheet(Class c, String tex, int x, int y, int gridLength) {
        double u = (double)x / (double)gridLength;
        double v = (double)y / (double)gridLength;
        double du = u + 1.0 / (double)gridLength;
        double dv = v + 1.0 / (double)gridLength;
        return new TextureSlot(c, tex, u, du, v, dv);
    }

    @Override
    public NBTTagCompound writeToNBT() {
        NBTTagCompound tag = super.writeToNBT();
        tag.func_74778_a("class", this.reference.getName());
        tag.func_74778_a("tex", this.texture);
        return tag;
    }

    public static TextureSlot readFromNBT(NBTTagCompound tag) {
        TextureSubImage base = TextureSubImage.readFromNBT(tag);
        return new TextureSlot(TextureSlot.getClass(tag.func_74779_i("class")), tag.func_74779_i("tex"), base.minU, base.maxU, base.minV, base.maxV);
    }

    private static Class getClass(String string) {
        try {
            return Class.forName(string);
        }
        catch (Exception e) {
            e.printStackTrace();
            return DragonAPICore.class;
        }
    }
}

