/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable;

import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;

public final class StepTimer {
    private int value;
    private int cap;

    public StepTimer(int top) {
        this.cap = top;
    }

    public StepTimer setCap(int val) {
        this.cap = val;
        return this;
    }

    public StepTimer stagger() {
        this.value = ReikaRandomHelper.getSafeRandomInt(this.cap);
        return this;
    }

    public void update() {
        ++this.value;
    }

    public void update(int time) {
        this.value += time;
    }

    public boolean isAtCap() {
        return this.value >= this.cap;
    }

    public boolean checkCap() {
        boolean cap = this.isAtCap();
        if (cap) {
            this.reset();
        }
        return cap;
    }

    public void reset() {
        this.value = 0;
    }

    public void setTick(int tick) {
        this.value = tick;
    }

    public void randomizeTick(Random r) {
        this.setTick(r.nextInt(this.cap));
    }

    public int getTick() {
        return this.value;
    }

    public int getCap() {
        return this.cap;
    }

    public float getFraction() {
        return (float)this.value / (float)this.cap;
    }

    public String toString() {
        return "Timer @ " + this.value + "/" + this.cap;
    }

    protected void writeSyncTag(NBTTagCompound NBT, String id) {
        NBT.func_74768_a(id + "cap", this.cap);
        NBT.func_74768_a(id + "tick", this.value);
    }

    protected void readSyncTag(NBTTagCompound NBT, String id) {
        this.cap = NBT.func_74762_e(id + "cap");
        this.value = NBT.func_74762_e(id + "tick");
    }
}

