/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Worldgen;

import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public abstract class TerrainShaper {
    protected static final BlockKey STONE = new BlockKey(Blocks.field_150348_b, 0);
    protected static final BlockKey DIRT = new BlockKey(Blocks.field_150346_d, 0);
    protected static final BlockKey GRASS = new BlockKey((Block)Blocks.field_150349_c, 0);
    private final Random rand = new Random();
    private Block[] blockColumn;
    private byte[] metaColumn;

    public final void generateColumn(World world, int x, int z, int chunkX, int chunkZ, Block[] blocks, byte[] metas, BiomeGenBase biome) {
        this.blockColumn = blocks;
        this.metaColumn = metas;
        long seed = (long)chunkX * 341873128712L + (long)chunkZ * 132897987541L;
        this.rand.setSeed(seed ^= (long)(x % 16) * 287238347L + (long)(z % 16) * 8258735447L);
        this.rand.nextBoolean();
        this.rand.nextBoolean();
        if (this.shouldClear()) {
            for (int i = 0; i < 256; ++i) {
                this.setBlock(x, i, z, Blocks.field_150350_a);
            }
        }
        this.generateColumn(world, x, z, this.rand, biome);
    }

    protected boolean shouldClear() {
        return true;
    }

    protected abstract void generateColumn(World var1, int var2, int var3, Random var4, BiomeGenBase var5);

    protected final void shiftVertical(int x, int z, int delta) {
        this.shiftVertical(x, z, delta, null, -1, false);
    }

    protected final void shiftVerticalWithinRange(int x, int z, int y1, int y2, int delta) {
        this.shiftVertical(x, z, delta, null, -1, false);
    }

    protected final void shiftVertical(int x, int z, int delta, Block fill, int fillm, boolean stopIfAir) {
        this.shiftVertical(x, z, 0, 255, delta, fill, fillm, stopIfAir);
    }

    protected final void shiftVertical(int x, int z, int y1, int y2, int delta, Block fill, int fillm, boolean stopIfAir) {
        block7: {
            int pos;
            block6: {
                int y;
                pos = this.calcPosIndex(x, z);
                if (delta <= 0) break block6;
                for (y = y2 - delta; y >= y1; --y) {
                    int put = y + delta;
                    Block b = this.blockColumn[pos + y];
                    byte meta = this.metaColumn[pos + y];
                    this.blockColumn[pos + put] = b;
                    this.metaColumn[pos + put] = meta;
                }
                if (fill == null) break block7;
                for (y = y1; y < y1 + delta; ++y) {
                    this.blockColumn[pos + y] = fill == Blocks.field_150350_a ? null : fill;
                    this.metaColumn[pos + y] = (byte)fillm;
                }
                break block7;
            }
            if (delta < 0) {
                int y;
                for (y = y1 - delta; y <= y2; ++y) {
                    int put = y + delta;
                    Block b = this.blockColumn[pos + y];
                    if (stopIfAir && (b == null || b == Blocks.field_150350_a)) break;
                    byte meta = this.metaColumn[pos + y];
                    this.blockColumn[pos + put] = b;
                    this.metaColumn[pos + put] = meta;
                }
                if (fill != null) {
                    for (y = y2 + delta; y <= y2; ++y) {
                        this.blockColumn[pos + y] = fill == Blocks.field_150350_a ? null : fill;
                        this.metaColumn[pos + y] = (byte)fillm;
                    }
                }
            }
        }
    }

    protected final int calcPosIndex(int x, int z) {
        int dx = x & 0xF;
        int dz = z & 0xF;
        int d = 256;
        return (dx * 16 + dz) * d;
    }

    protected final int getTopNonAir(int x, int z) {
        int pos = this.calcPosIndex(x, z);
        for (int y = 255; y >= 0; --y) {
            if (this.blockColumn[pos + y] == null || this.blockColumn[pos + y] == Blocks.field_150350_a) continue;
            return y;
        }
        return -1;
    }

    protected final int getLowestSurface(int x, int z) {
        int pos = this.calcPosIndex(x, z);
        for (int y = 0; y < 256; ++y) {
            if (this.blockColumn[pos + y] != null && this.blockColumn[pos + y] != Blocks.field_150350_a) continue;
            return y - 1;
        }
        return -1;
    }

    protected final void cleanColumn(World world, int x, int z, BiomeGenBase biome) {
        BlockKey stone = this.getStone(biome);
        BlockKey dirt = this.getDirt(biome);
        BlockKey grass = this.getGrass(biome);
        for (int i = 1; i < 256; ++i) {
            if (this.getBlock(x, i, z) == dirt.blockID) {
                if (this.getBlock(x, i - 1, z) != Blocks.field_150350_a && this.getBlock(x, i - 1, z) != null && !this.isPlant(this.getBlock(x, i - 1, z))) continue;
                this.setBlock(x, i, z, stone.blockID, stone.metadata);
                continue;
            }
            if (i < 255 && this.getBlock(x, i, z) == grass.blockID) {
                if (this.getBlock(x, i + 1, z) == Blocks.field_150350_a || this.getBlock(x, i + 1, z) == null || !this.isPlant(this.getBlock(x, i - 1, z))) continue;
                this.setBlock(x, i, z, dirt.blockID, dirt.metadata);
                continue;
            }
            if (this.getBlock(x, i, z) != dirt.blockID || i != 255 && this.getBlock(x, i + 1, z) != Blocks.field_150350_a && (this.getBlock(x, i + 1, z) == null || !this.isPlant(this.getBlock(x, i + 1, z)))) continue;
            this.setBlock(x, i, z, grass.blockID, grass.metadata);
        }
    }

    protected boolean isPlant(Block b) {
        return b.func_149688_o() == Material.field_151585_k;
    }

    protected BlockKey getStone(BiomeGenBase biome) {
        return STONE;
    }

    protected BlockKey getDirt(BiomeGenBase biome) {
        return DIRT;
    }

    protected BlockKey getGrass(BiomeGenBase biome) {
        return GRASS;
    }

    protected final Block getBlock(int x, int y, int z) {
        return this.blockColumn[this.calcPosIndex(x, z) + y];
    }

    protected final int getMetadata(int x, int y, int z) {
        return this.metaColumn[this.calcPosIndex(x, z) + y];
    }

    protected final void setBlock(int x, int y, int z, Block b) {
        this.setBlock(x, y, z, b, 0);
    }

    protected final void setBlock(int x, int y, int z, Block b, int meta) {
        if (meta < 0) {
            throw new IllegalArgumentException("Negative metadata @ " + x + ", " + y + ", " + z + "!");
        }
        int posIndex = this.calcPosIndex(x, z);
        if (b == Blocks.field_150350_a) {
            b = null;
        }
        this.blockColumn[posIndex + y] = b;
        this.metaColumn[posIndex + y] = (byte)meta;
    }
}

