/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Interfaces;

import Reika.DragonAPI.Auxiliary.Trackers.KeyWatcher;
import Reika.DragonAPI.Base.CoreContainer;
import Reika.DragonAPI.Interfaces.TileEntity.CraftingTile;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class CraftingContainer<V>
extends CoreContainer {
    private World world;
    private InventoryCrafting craftMatrix = new InventoryCrafting((Container)this, 3, 3);
    private IInventory craftResult = new InventoryCraftResult();
    private boolean noUpdate;
    private CraftingTile<V> crafter;
    public final boolean isGUI;

    public CraftingContainer(EntityPlayer player, CraftingTile<V> te, World worldObj, boolean gui) {
        super(player, (TileEntity)te);
        this.world = worldObj;
        this.crafter = te;
        this.isGUI = gui;
    }

    protected final void updateCraftMatrix() {
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.crafter.func_70301_a(i);
            this.noUpdate = true;
            this.craftMatrix.func_70299_a(i, stack);
        }
    }

    protected final void onCraftMatrixChanged() {
        this.func_75130_a((IInventory)this.craftMatrix);
    }

    public final void func_75130_a(IInventory par1IInventory) {
        if (!this.isGUI) {
            super.func_75130_a(par1IInventory);
            return;
        }
        if (this.noUpdate) {
            this.noUpdate = false;
            return;
        }
        V wr = this.getRecipe(this.craftMatrix, this.world);
        if (wr == null) {
            this.crafter.setToCraft(null);
            return;
        }
        ItemStack is = this.getOutput(wr);
        ItemStack slot13 = this.crafter.func_70301_a(this.crafter.getOutputSlot());
        if (slot13 != null) {
            if (is.func_77973_b() != slot13.func_77973_b()) {
                return;
            }
            if (is.func_77960_j() != slot13.func_77960_j()) {
                return;
            }
            if (slot13.field_77994_a >= slot13.func_77976_d()) {
                return;
            }
        }
        this.crafter.setToCraft(wr);
    }

    private void craft(V wr, EntityPlayer ep) {
        if (this.crafter.handleCrafting(wr, ep, KeyWatcher.instance.isKeyDown(ep, KeyWatcher.Key.LSHIFT))) {
            this.updateCraftMatrix();
        }
    }

    @Override
    public final ItemStack func_75144_a(int slot, int par2, int action, EntityPlayer ep) {
        ItemStack is = super.func_75144_a(slot, par2, action, ep);
        this.updateCraftMatrix();
        this.func_75130_a((IInventory)this.craftMatrix);
        InventoryPlayer ip = ep.field_71071_by;
        V wr = this.getRecipe(this.craftMatrix, this.world);
        if (wr != null && this.crafter.isReadyToCraft() && slot == 13) {
            ItemStack drop = ip.func_70445_o();
            ItemStack craft = this.getOutput(wr);
            if (!(drop == null || ReikaItemHelper.matchStacks(drop, craft) && drop.field_77994_a + craft.field_77994_a <= drop.func_77976_d())) {
                return is;
            }
            this.craft(wr, ep);
            craft.func_77980_a(this.world, ep, craft.field_77994_a);
            int outslot = this.crafter.getOutputSlot();
            if (drop == null) {
                ip.func_70437_b(this.crafter.func_70301_a(outslot));
            } else {
                drop.field_77994_a += this.crafter.func_70301_a((int)outslot).field_77994_a;
            }
            this.crafter.func_70299_a(outslot, null);
        }
        return is;
    }

    protected abstract ItemStack getOutput(V var1);

    protected abstract V getRecipe(InventoryCrafting var1, World var2);
}

