/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.IO;

import Reika.DragonAPI.APIPacketHandler;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Instantiable.IO.EnumSound;
import Reika.DragonAPI.Instantiable.IO.SingleSound;
import Reika.DragonAPI.Instantiable.IO.SoundVariant;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Interfaces.Registry.VariableSound;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import paulscode.sound.Library;
import paulscode.sound.SoundSystem;
import paulscode.sound.StreamThread;

public class ReikaSoundHelper {
    private static final MultiMap<SoundEnum, SoundPlay> plays = new MultiMap();
    private static final HashMap<Class, SoundEnumSet> soundSets = new HashMap();
    private static final HashMap<Integer, Class> soundSetIDs = new HashMap();
    private static Field soundLibraryField;
    private static Field streamThreadField;
    @SideOnly(value=Side.CLIENT)
    private static HashMap<ResourceLocation, MusicTicker.MusicType> musicTypes;

    public static void playBreakSound(World world, int x, int y, int z, Block b) {
        Block.SoundType s = b.field_149762_H;
        String f = s.func_150495_a();
        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, f, s.func_150497_c(), s.func_150494_d());
    }

    public static void playStepSound(World world, int x, int y, int z, Block b) {
        Block.SoundType s = b.field_149762_H;
        String f = s.func_150498_e();
        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, f, s.func_150497_c(), s.func_150494_d());
    }

    public static void playPlaceSound(World world, int x, int y, int z, Block b) {
        Block.SoundType s = b.field_149762_H;
        String f = s.func_150498_e();
        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, f, s.func_150497_c(), s.func_150494_d());
    }

    public static void playBreakSound(World world, int x, int y, int z, Block b, float vol, float pitch) {
        Block.SoundType s = b.field_149762_H;
        String f = s.func_150495_a();
        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, f, s.func_150497_c() * vol, s.func_150494_d() * pitch);
    }

    public static void playStepSound(World world, int x, int y, int z, Block b, float vol, float pitch) {
        Block.SoundType s = b.field_149762_H;
        String f = s.func_150498_e();
        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, f, s.func_150497_c() * vol, s.func_150494_d() * pitch);
    }

    public static void playPlaceSound(World world, int x, int y, int z, Block b, float vol, float pitch) {
        Block.SoundType s = b.field_149762_H;
        String f = s.func_150498_e();
        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, f, s.func_150497_c() * vol, s.func_150494_d() * pitch);
    }

    public static void playSoundAtBlock(World world, int x, int y, int z, String snd, float vol, float pit) {
        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, snd, vol, pit);
    }

    public static void playSoundAtBlock(World world, int x, int y, int z, String snd) {
        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, snd, 1.0f, 1.0f);
    }

    public static void playSound(SoundEnum s, World world, Entity e, float vol, float pitch) {
        ReikaSoundHelper.playSound(s, world, e.field_70165_t, e.field_70163_u, e.field_70161_v, vol, pitch);
    }

    public static void playSound(SoundEnum s, World world, double x, double y, double z, float vol, float pitch) {
        ReikaSoundHelper.playSound(s, world, x, y, z, vol, pitch, s.attenuate());
    }

    public static void playSound(SoundEnum s, World world, double x, double y, double z, float vol, float pitch, boolean atten) {
        long time = world.func_82737_E();
        if (!s.canOverlap()) {
            Collection<SoundPlay> c = plays.get(s);
            Iterator<SoundPlay> it = c.iterator();
            while (it.hasNext()) {
                SoundPlay p = it.next();
                if (time - p.time < 20L) {
                    if (!(p.loc.getDistanceTo(x, y, z) < 12.0) || p.loc.sharesBlock(x, y, z)) continue;
                    return;
                }
                it.remove();
            }
            plays.addValue(s, new SoundPlay(time, x, y, z));
        }
        ReikaSoundHelper.sendSound(s, world, x, y, z, vol, pitch, atten);
    }

    private static void sendSound(SoundEnum s, World world, double x, double y, double z, float vol, float pitch, boolean atten) {
        ReikaPacketHelper.sendSoundPacket(s, world, x, y, z, vol, pitch, atten);
    }

    @SideOnly(value=Side.CLIENT)
    public static ISound playClientSound(SoundEnum s, double x, double y, double z, float vol, float pitch) {
        return ReikaSoundHelper.playClientSound(s, x, y, z, vol, pitch, true);
    }

    @SideOnly(value=Side.CLIENT)
    public static ISound playClientSound(SoundEnum s, double x, double y, double z, float vol, float pitch, boolean att) {
        float v = vol * s.getModulatedVolume();
        if (v <= 0.0f) {
            return null;
        }
        EnumSound es = new EnumSound(s, x, y, z, v, pitch, att);
        try {
            FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)es);
        }
        catch (ConcurrentModificationException e) {
            e.printStackTrace();
        }
        return es;
    }

    @SideOnly(value=Side.CLIENT)
    public static void playClientSound(String snd, double x, double y, double z, float vol, float pitch, boolean atten) {
        Minecraft.func_71410_x().field_71441_e.func_72980_b(x, y, z, snd, vol, pitch, atten);
    }

    @SideOnly(value=Side.CLIENT)
    public static ISound playClientSound(SoundEnum s, Entity e, float vol, float pitch, boolean att) {
        return ReikaSoundHelper.playClientSound(s, e.field_70165_t, e.field_70163_u, e.field_70161_v, vol, pitch, att);
    }

    @SideOnly(value=Side.CLIENT)
    public static void playClientSound(SoundEnum s, Entity e, float vol, float pitch) {
        ReikaSoundHelper.playClientSound(s, e.field_70165_t, e.field_70163_u, e.field_70161_v, vol, pitch, true);
    }

    @SideOnly(value=Side.CLIENT)
    public static void playNormalClientSound(World world, double x, double y, double z, String name, float vol, float pitch, boolean flag) {
        world.func_72980_b(x, y, z, name, vol, pitch, flag);
    }

    public static void broadcastSound(SoundEnum s, float vol, float pitch) {
        WorldServer[] worlds;
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            throw new MisuseException("You cannot call this from the client!");
        }
        for (WorldServer world : worlds = DimensionManager.getWorlds()) {
            for (EntityPlayer ep : world.field_73010_i) {
                ReikaSoundHelper.playSound(s, (World)world, (Entity)ep, vol, pitch);
            }
        }
    }

    public static void playSoundAtEntity(World world, Entity e, String snd) {
        ReikaSoundHelper.playSoundAtEntity(world, e, snd, 1.0f, 1.0f);
    }

    public static void playSoundAtEntity(World world, Entity e, String snd, float vol, float p) {
        world.func_72908_a(e.field_70165_t, e.field_70163_u, e.field_70161_v, snd, vol, p);
    }

    public static void playSoundFromServer(World world, double x, double y, double z, String name, float vol, float pitch, boolean scale) {
        ReikaPacketHelper.writeDirectSound("DragonAPIData", APIPacketHandler.PacketIDs.SERVERSOUND.ordinal(), world, x, y, z, name, vol, pitch, scale);
    }

    public static void playSoundFromServerAtBlock(World world, int x, int y, int z, String name, float vol, float pitch, boolean scale) {
        ReikaSoundHelper.playSoundFromServer(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, name, vol, pitch, scale);
    }

    @SideOnly(value=Side.CLIENT)
    public static StreamThread getStreamingThread(SoundHandler sh) {
        try {
            SoundManager.SoundSystemStarterThread sys = sh.field_147694_f.field_148620_e;
            Library lib = (Library)soundLibraryField.get(sys);
            StreamThread s = (StreamThread)streamThreadField.get(lib);
            return s;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void restartStreamingSystem(SoundHandler sh) {
        DragonAPICore.log("Restarting sound streaming thread.");
        StreamThread thread = new StreamThread();
        try {
            SoundManager.SoundSystemStarterThread sys = sh.field_147694_f.field_148620_e;
            Library lib = (Library)soundLibraryField.get(sys);
            streamThreadField.set(lib, thread);
            thread.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void injectPaulscodeAccesses() {
        try {
            DragonAPICore.log("Injecting accesses into paulscode...");
            soundLibraryField = SoundSystem.class.getDeclaredField("soundLibrary");
            streamThreadField = Library.class.getDeclaredField("streamThread");
            soundLibraryField.setAccessible(true);
            streamThreadField.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static MusicTicker.MusicType getMusicTypeByResourceLocation(ResourceLocation loc) {
        return musicTypes.get(loc);
    }

    @SideOnly(value=Side.CLIENT)
    private static void doClientInit() {
        musicTypes = new HashMap();
        for (MusicTicker.MusicType type : MusicTicker.MusicType.values()) {
            musicTypes.put(type.func_148635_a(), type);
        }
    }

    public static SoundEnumSet getSoundLibrary(SoundEnum s) {
        SoundEnumSet set = soundSets.get(s.getClass());
        if (set == null) {
            DragonAPICore.logError("Tried to play an unregistered sound '" + s.getClass() + " " + s + "'!");
        }
        return set;
    }

    public static SoundEnum lookupSound(int lib, int idx) {
        Class type = soundSetIDs.get(lib);
        SoundEnumSet set = soundSets.get(type);
        if (type == null || set == null) {
            DragonAPICore.logError("Tried to play an unregistered sound!");
            return null;
        }
        return set.getSound(idx);
    }

    public static void registerSoundSet(Class<? extends SoundEnum> c) {
        if (c == SingleSound.class) {
            throw new IllegalArgumentException("You cannot register single sounds as a set!");
        }
        SoundEnumSet set = soundSets.get(c);
        if (set != null) {
            // empty if block
        }
        int idx = set != null ? set.index : soundSets.size();
        soundSetIDs.put(idx, c);
        if (set == null) {
            set = VariableSound.class.isAssignableFrom(c) ? new SoundEnumSetWithVariants(c, idx) : new SoundEnumSet(c, idx);
        }
        soundSets.put(c, set);
        if (set instanceof SoundEnumSetWithVariants) {
            for (Class c2 : ((SoundEnumSetWithVariants)set).variantClasses) {
                soundSets.put(c2, set);
            }
        }
        ReikaJavaLibrary.pConsole("Registered sound set of type " + c + " with values " + Arrays.toString(set.sounds));
    }

    public static void registerSingleSound(SingleSound s) {
        SingleSoundSet set = (SingleSoundSet)soundSets.get(SingleSound.class);
        set.addSound(s);
    }

    static {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            ReikaSoundHelper.doClientInit();
        }
        soundSetIDs.put(0, SingleSound.class);
        SingleSoundSet set = new SingleSoundSet();
        soundSets.put(SingleSound.class, set);
    }

    public static class SoundEnumSet {
        public final int index;
        public final Class<? extends SoundEnum> enumClass;
        protected final SoundEnum[] sounds;

        private SoundEnumSet(Class<? extends SoundEnum> c, int idx) {
            this.enumClass = c;
            this.sounds = c.getEnumConstants();
            this.index = idx;
        }

        protected SoundEnum getSound(int idx) {
            return this.sounds[idx];
        }

        public int getSoundIndex(SoundEnum s) {
            return s.ordinal();
        }
    }

    private static class SoundEnumSetWithVariants
    extends SoundEnumSet {
        private static final Comparator<SoundVariant> sorter = new Comparator<SoundVariant>(){

            @Override
            public int compare(SoundVariant o1, SoundVariant o2) {
                return String.CASE_INSENSITIVE_ORDER.compare(o1.getName(), o2.getName());
            }
        };
        private final HashMap<SoundEnum, SoundVariant[]> variants = new HashMap();
        private final HashSet<Class> variantClasses = new HashSet();

        private SoundEnumSetWithVariants(Class<? extends VariableSound> c, int idx) {
            super(c, idx);
            for (SoundEnum e : this.sounds) {
                VariableSound v = (VariableSound)e;
                Collection<SoundVariant> cv = v.getVariants();
                if (cv == null || cv.isEmpty()) continue;
                SoundVariant[] arr = cv.toArray(new SoundVariant[cv.size()]);
                Arrays.sort(arr, sorter);
                this.variants.put(e, arr);
                for (SoundVariant sv : arr) {
                    this.variantClasses.add(sv.getClass());
                }
            }
        }

        @Override
        protected SoundEnum getSound(int idx) {
            int base = idx & Short.MAX_VALUE;
            int variant = idx >> 16 & Short.MAX_VALUE;
            SoundEnum e = super.getSound(base);
            if (variant > 0) {
                SoundVariant[] arr = this.variants.get(e);
                e = arr[variant - 1];
            }
            return e;
        }

        @Override
        public int getSoundIndex(SoundEnum s) {
            SoundEnum parent = s;
            boolean var = s instanceof SoundVariant;
            if (var) {
                parent = ((SoundVariant)s).root;
            }
            int val = super.getSoundIndex(parent);
            if (var) {
                int offset;
                Object[] arr = this.variants.get(parent);
                int n = offset = arr == null ? 0 : 1 + ReikaArrayHelper.indexOf(arr, s);
                if (offset == 0) {
                    DragonAPICore.logError("Could not find variant index for " + s + " in " + Arrays.toString(arr) + " from " + parent);
                }
                val |= offset << 16;
            }
            return val;
        }
    }

    private static class SingleSoundSet
    extends SoundEnumSet {
        private final ArrayList<SingleSound> soundList = new ArrayList();

        private SingleSoundSet() {
            super(SingleSound.class, 0);
        }

        private void addSound(SingleSound s) {
            this.soundList.add(s);
        }

        @Override
        protected SoundEnum getSound(int idx) {
            return this.soundList.get(idx);
        }

        @Override
        public int getSoundIndex(SoundEnum s) {
            return this.soundList.indexOf(s);
        }
    }

    private static class SoundPlay {
        private final long time;
        private final DecimalPosition loc;

        private SoundPlay(long t, double x, double y, double z) {
            this.time = t;
            this.loc = new DecimalPosition(x, y, z);
        }
    }
}

