/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.Java;

import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.IDConflictException;
import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Exception.RegistrationException;
import Reika.DragonAPI.Instantiable.Data.Maps.PluralMap;
import Reika.DragonAPI.Instantiable.IO.ModLogger;
import Reika.DragonAPI.Interfaces.Registry.RegistrationList;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import com.google.common.base.Throwables;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;

public final class ReikaReflectionHelper
extends DragonAPICore {
    private static Field unmodifiableList;
    private static final PluralMap<Method> methodCache;

    public static Block createBlockInstance(DragonAPIMod mod, RegistrationList list) {
        try {
            Constructor c = list.getObjectClass().getConstructor(list.getConstructorParamTypes());
            Block instance = (Block)c.newInstance(list.getConstructorParams());
            return instance.func_149663_c(list.getUnlocalizedName());
        }
        catch (NoSuchMethodException e) {
            throw new RegistrationException(mod, list.getObjectClass().getSimpleName() + " does not have the specified constructor " + Arrays.toString(list.getConstructorParamTypes()) + "! Check visibility and material args!");
        }
        catch (SecurityException e) {
            throw new RegistrationException(mod, list.getObjectClass().getSimpleName() + " threw security exception!");
        }
        catch (InstantiationException e) {
            throw new RegistrationException(mod, list.getObjectClass().getSimpleName() + " did not allow instantiation!");
        }
        catch (IllegalAccessException e) {
            throw new RegistrationException(mod, list.getObjectClass().getSimpleName() + " threw illegal access exception! (Nonpublic constructor)");
        }
        catch (IllegalArgumentException e) {
            throw new RegistrationException(mod, list.getObjectClass().getSimpleName() + " was given invalid parameters!");
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof IllegalArgumentException) {
                throw new IDConflictException(mod, t.getMessage());
            }
            mod.getModLogger().logError("ITE on instantiating " + list);
            e.getCause().printStackTrace();
            throw new RegistrationException(mod, list + " (" + list.getObjectClass().getSimpleName() + ") threw invocation target exception: " + e + " with " + e.getCause() + " (" + e.getCause().getMessage() + ")");
        }
        catch (NoClassDefFoundError e) {
            e.printStackTrace();
            throw new RegistrationException(mod, "Failed to load " + list + " due to a missing class: ", e);
        }
    }

    public static Item createItemInstance(DragonAPIMod mod, RegistrationList list) {
        try {
            Constructor c = list.getObjectClass().getConstructor(list.getConstructorParamTypes());
            Item instance = (Item)c.newInstance(list.getConstructorParams());
            return instance.func_77655_b(list.getUnlocalizedName());
        }
        catch (NoSuchMethodException e) {
            throw new RegistrationException(mod, "Item Class " + list.getObjectClass().getSimpleName() + " does not have the specified constructor " + Arrays.toString(list.getConstructorParamTypes()) + "!");
        }
        catch (SecurityException e) {
            throw new RegistrationException(mod, "Item Class " + list.getObjectClass().getSimpleName() + " threw security exception!");
        }
        catch (InstantiationException e) {
            throw new RegistrationException(mod, list.getObjectClass().getSimpleName() + " did not allow instantiation!");
        }
        catch (IllegalAccessException e) {
            throw new RegistrationException(mod, list.getObjectClass().getSimpleName() + " threw illegal access exception! (Nonpublic constructor)");
        }
        catch (IllegalArgumentException e) {
            throw new RegistrationException(mod, list.getObjectClass().getSimpleName() + " was given invalid parameters!");
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof IllegalArgumentException) {
                throw new IDConflictException(mod, t.getMessage());
            }
            throw new RegistrationException(mod, list + " (" + list.getObjectClass().getSimpleName() + ") threw invocation target exception: " + e + " with " + e.getCause() + " (" + e.getCause().getMessage() + ")");
        }
        catch (NoClassDefFoundError e) {
            e.printStackTrace();
            throw new RegistrationException(mod, "Failed to load " + list + " due to a missing class: " + e);
        }
    }

    public static Item createBasicItemInstance(DragonAPIMod mod, Class<? extends Item> cl, int id, String unloc, boolean overwrite) {
        try {
            Constructor<? extends Item> c = cl.getConstructor(Integer.TYPE);
            Item instance = c.newInstance(id);
            return instance.func_77655_b(unloc);
        }
        catch (NoSuchMethodException e) {
            throw new MisuseException("Item Class " + cl.getSimpleName() + " does not have the specified constructor!");
        }
        catch (SecurityException e) {
            throw new MisuseException("Item Class " + cl.getSimpleName() + " threw security exception!");
        }
        catch (InstantiationException e) {
            throw new MisuseException(cl.getSimpleName() + " did not allow instantiation!");
        }
        catch (IllegalAccessException e) {
            throw new MisuseException(cl.getSimpleName() + " threw illegal access exception! (Nonpublic constructor)");
        }
        catch (IllegalArgumentException e) {
            throw new MisuseException(cl.getSimpleName() + " was given invalid parameters!");
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof IllegalArgumentException) {
                throw new IllegalArgumentException(t.getMessage());
            }
            throw new MisuseException(cl.getSimpleName() + " threw invocation target exception: " + e + " with " + e.getCause() + " (" + e.getCause().getMessage() + ")");
        }
        catch (NoClassDefFoundError e) {
            e.printStackTrace();
            throw new RegistrationException(mod, "Failed to load " + cl + " due to a missing class: " + e);
        }
    }

    public static Enchantment createEnchantmentInstance(DragonAPIMod mod, Class<? extends Enchantment> cl, int id, String unloc, boolean overwrite) {
        try {
            Constructor<? extends Enchantment> c = cl.getConstructor(Integer.TYPE);
            Enchantment instance = c.newInstance(id);
            return instance.func_77322_b(unloc);
        }
        catch (NoSuchMethodException e) {
            throw new MisuseException("Enchantment Class " + cl.getSimpleName() + " does not have the specified constructor!");
        }
        catch (SecurityException e) {
            throw new MisuseException("Enchantment Class " + cl.getSimpleName() + " threw security exception!");
        }
        catch (InstantiationException e) {
            throw new MisuseException(cl.getSimpleName() + " did not allow instantiation!");
        }
        catch (IllegalAccessException e) {
            throw new MisuseException(cl.getSimpleName() + " threw illegal access exception! (Nonpublic constructor)");
        }
        catch (IllegalArgumentException e) {
            throw new MisuseException(cl.getSimpleName() + " was given invalid parameters!");
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof IllegalArgumentException) {
                throw new IllegalArgumentException(t.getMessage());
            }
            throw new MisuseException(cl.getSimpleName() + " threw invocation target exception: " + e + " with " + e.getCause() + " (" + e.getCause().getMessage() + ")");
        }
        catch (NoClassDefFoundError e) {
            e.printStackTrace();
            throw new RegistrationException(mod, "Failed to load " + cl + " due to a missing class: " + e);
        }
    }

    public static int getPrivateInteger(Object obj, String field, ModLogger log) {
        try {
            Class<?> c = obj.getClass();
            AccessibleObject f = null;
            while (f == null && c != null) {
                try {
                    f = c.getDeclaredField(field);
                }
                catch (NoSuchFieldException e2) {
                    c = c.getSuperclass();
                }
            }
            if (f == null) {
                if (log.shouldDebug()) {
                    DragonAPICore.logError("Could not find field " + field + " in " + obj);
                    ReikaChatHelper.write("Could not find field " + field + " in " + obj);
                }
                throw new NoSuchFieldException();
            }
            int val = Integer.MIN_VALUE;
            if (!f.isAccessible()) {
                ((Field)f).setAccessible(true);
                val = ((Field)f).getInt(obj);
                ((Field)f).setAccessible(false);
            } else {
                val = ((Field)f).getInt(obj);
            }
            return val;
        }
        catch (NoSuchFieldException e) {
            if (log.shouldDebug()) {
                DragonAPICore.logError("Could not find field " + field + " in " + obj);
                ReikaChatHelper.write("Could not find field " + field + " in " + obj);
            }
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            if (log.shouldDebug()) {
                DragonAPICore.logError("Could not access field " + field + " in " + obj);
                ReikaChatHelper.write("Could not access field " + field + " in " + obj);
            }
            e.printStackTrace();
        }
        catch (SecurityException e) {
            if (log.shouldDebug()) {
                DragonAPICore.logError("Security Manager locked field " + field + " in " + obj);
                ReikaChatHelper.write("Security Manager locked field " + field + " in " + obj);
            }
            e.printStackTrace();
        }
        return Integer.MIN_VALUE;
    }

    public static boolean getPrivateBoolean(Object obj, String field, ModLogger log) {
        try {
            Class<?> c = obj.getClass();
            AccessibleObject f = null;
            while (f == null && c != null) {
                try {
                    f = c.getDeclaredField(field);
                }
                catch (NoSuchFieldException e2) {
                    c = c.getSuperclass();
                }
            }
            if (f == null) {
                if (log.shouldDebug()) {
                    DragonAPICore.logError("Could not find field " + field + " in " + obj);
                    ReikaChatHelper.write("Could not find field " + field + " in " + obj);
                }
                throw new NoSuchFieldException();
            }
            boolean val = false;
            if (!f.isAccessible()) {
                ((Field)f).setAccessible(true);
                val = ((Field)f).getBoolean(obj);
                ((Field)f).setAccessible(false);
            } else {
                val = ((Field)f).getBoolean(obj);
            }
            return val;
        }
        catch (NoSuchFieldException e) {
            if (log.shouldDebug()) {
                DragonAPICore.logError("Could not find field " + field + " in " + obj);
                ReikaChatHelper.write("Could not find field " + field + " in " + obj);
            }
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            if (log.shouldDebug()) {
                DragonAPICore.logError("Could not access field " + field + " in " + obj);
                ReikaChatHelper.write("Could not access field " + field + " in " + obj);
            }
            e.printStackTrace();
        }
        catch (SecurityException e) {
            if (log.shouldDebug()) {
                DragonAPICore.logError("Security Manager locked field " + field + " in " + obj);
                ReikaChatHelper.write("Security Manager locked field " + field + " in " + obj);
            }
            e.printStackTrace();
        }
        return false;
    }

    public static Field getProtectedInheritedField(Object o, String field) {
        return ReikaReflectionHelper.getProtectedInheritedField(o.getClass(), field);
    }

    public static Field getProtectedInheritedField(Class c, String field) {
        Field f = null;
        while (f == null && c != null) {
            try {
                f = c.getDeclaredField(field);
            }
            catch (NoSuchFieldException e2) {
                c = c.getSuperclass();
            }
        }
        return f;
    }

    public static Executable getProtectedInheritedMethod(Object o, String method, Class ... types) {
        return ReikaReflectionHelper.getProtectedInheritedMethod(o.getClass(), method, types);
    }

    public static Executable getProtectedInheritedMethod(Class c, String method, Class ... types) {
        Executable f = null;
        if (method.equals("<init>")) {
            while (f == null && c != null) {
                try {
                    f = c.getDeclaredConstructor(types);
                }
                catch (NoSuchMethodException e2) {
                    c = c.getSuperclass();
                }
            }
        } else {
            while (f == null && c != null) {
                try {
                    f = c.getDeclaredMethod(method, types);
                }
                catch (NoSuchMethodException e2) {
                    c = c.getSuperclass();
                }
            }
        }
        return f;
    }

    public static void setFinalField(Class c, String s, Object instance, Object o) throws Exception {
        ReikaReflectionHelper.setFinalField(ReikaReflectionHelper.getProtectedInheritedField(c, s), instance, o);
    }

    public static void setFinalField(Field f, Object instance, Object o) throws Exception {
        try {
            f.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(f, f.getModifiers() & 0xFFFFFFEF);
            f.set(instance, o);
        }
        catch (IllegalAccessException e) {
            if (e.toString().contains("Can not set final")) {
                throw new RuntimeException("You need to un-final a field BEFORE any accesses (ie f.get() calls)!", e);
            }
            throw e;
        }
    }

    public static Collection<Field> getFields(Class c, FieldSelector sel) {
        ArrayList<Field> li = new ArrayList<Field>();
        while (c != null) {
            Field[] fd = c.getDeclaredFields();
            for (int i = 0; i < fd.length; ++i) {
                Field f = fd[i];
                if (sel != null && !sel.isValid(f)) continue;
                li.add(f);
            }
            c = c.getSuperclass();
        }
        return li;
    }

    public static Collection<Method> getMethods(Class c, MethodSelector sel) {
        ArrayList<Method> li = new ArrayList<Method>();
        while (c != null) {
            Method[] fd = c.getDeclaredMethods();
            for (int i = 0; i < fd.length; ++i) {
                Method f = fd[i];
                if (sel != null && !sel.isValid(f)) continue;
                li.add(f);
            }
            c = c.getSuperclass();
        }
        return li;
    }

    public static boolean checkForField(Class c, String name, int ... modifiers) {
        try {
            Field f = c.getDeclaredField(name);
            for (int i = 0; i < modifiers.length; ++i) {
                int mod = modifiers[i];
                if ((f.getModifiers() & mod) != 0) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean checkForMethod(Class c, String name, Class[] args, int ... modifiers) {
        try {
            Method f = c.getDeclaredMethod(name, args);
            for (int i = 0; i < modifiers.length; ++i) {
                int mod = modifiers[i];
                if ((f.getModifiers() & mod) != 0) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Object cacheAndInvokeMethod(String cl, String name, Object ref, Object ... args) {
        try {
            Method m = methodCache.get(cl, name);
            if (m == null) {
                try {
                    Class<?> c = Class.forName(cl);
                    m = c.getDeclaredMethod(cl, ReikaReflectionHelper.getArgTypesFromArgs(args));
                    m.setAccessible(true);
                    methodCache.put(m, cl, name);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return m.invoke(ref, args);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Class[] getArgTypesFromArgs(Object[] args) {
        Class[] arr = new Class[args.length];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = args[i].getClass();
        }
        return arr;
    }

    public static <E> List<E> getUnmodifiableListInner(List<E> unmodifiable) {
        try {
            return (List)unmodifiableList.get(unmodifiable);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    static {
        try {
            Class<?> li = Class.forName("java.util.Collections$UnmodifiableList");
            unmodifiableList = li.getDeclaredField("list");
            unmodifiableList.setAccessible(true);
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
        methodCache = new PluralMap(2);
    }

    public static final class TypeSelector
    implements FieldSelector {
        public final Class type;

        public TypeSelector(Class c) {
            this.type = c;
        }

        @Override
        public boolean isValid(Field f) {
            return f.getType() == this.type;
        }
    }

    public static interface MethodSelector {
        public boolean isValid(Method var1);
    }

    public static interface FieldSelector {
        public boolean isValid(Field var1);
    }
}

