/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.MathSci;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import net.minecraft.util.MathHelper;

public final class ReikaEngLibrary
extends DragonAPICore {
    public static final double e = Math.E;
    public static final double pi = Math.PI;
    public static final double G = 6.67E-11;
    public static final double c = 2.998E8;
    public static final double k = 9.0E9;
    public static final double sigma = 5.67E-8;
    public static final double patm = 101300.0;
    public static final double rhogold = 19300.0;
    public static final double rhoiron = 7800.0;
    public static final double rhowater = 1000.0;
    public static final double rholava = 2700.0;
    public static final double rhowood = 800.0;
    public static final double rhorock = 3000.0;
    public static final double rhodiamond = 3500.0;
    public static final double rhographite = 2150.0;
    public static final double rhotungsten = 19300.0;
    public static final double rhouranium = 19050.0;
    public static final double Gsteel = 7.93E10;
    public static final double Giron = 8.2E10;
    public static final double Gglass = 2.62E10;
    public static final double Gdiamond = 4.78E11;
    public static final double Galuminum = 2.55E10;
    public static final double Grubber = 600000.0;
    public static final double Gwood = 6.2E8;
    public static final double Gconcrete = 7.93E10;
    public static final double Gstone = 8.0E9;
    public static final double Ggold = 2.7E10;
    public static final double Gtungsten = 1.61E11;
    public static final double Esteel = 2.1E11;
    public static final double Eiron = 2.11E11;
    public static final double Eglass = 7.0E10;
    public static final double Ediamond = 1.22E12;
    public static final double Ealuminum = 6.9E10;
    public static final double Erubber = 5.0E7;
    public static final double Ewood = 1.1E7;
    public static final double Econcrete = 3.0E10;
    public static final double Estone = 5.0E10;
    public static final double Egold = 7.9E10;
    public static final double Etungsten = 4.11E11;
    public static final double Tsteel = 4.0E8;
    public static final double Tiron = 2.0E8;
    public static final double Tglass = 3.3E7;
    public static final double Tdiamond = 5.0E9;
    public static final double Taluminum = 1.1E8;
    public static final double Trubber = 5000000.0;
    public static final double Twood = 2.0E7;
    public static final double Tconcrete_tensile = 3000000.0;
    public static final double Tconcrete_compressive = 9.0E7;
    public static final double Tstone = 1.0E8;
    public static final double Tgold = 1.08E8;
    public static final double Ttungsten = 9.8E8;
    public static final double Turanium = 6.25E8;
    public static final double Ssteel = 2.8E8;
    public static final double Siron = 1.16E8;
    public static final double Sglass = 1.91E7;
    public static final double Sdiamond = 2.9E9;
    public static final double Saluminum = 6.38E7;
    public static final double Srubber = 2900000.0;
    public static final double Swood = 1.16E7;
    public static final double Sconcrete_tensile = 1740000.0;
    public static final double Sconcrete_compressive = 5.1E7;
    public static final double Sstone = 4.0E7;
    public static final double Sgold = 6.26E7;
    public static final double Stungsten = 4.0E8;

    public static double decay(double rate, double ivp, double time) {
        double pow = -rate * time;
        return ivp * Math.pow(Math.E, pow);
    }

    public static double halflife(double init, double hlife, double time) {
        return init * Math.pow(2.0, time / hlife);
    }

    public static boolean mat_twistfailure(int torque, double radius, double taumax) {
        double J = 1.5707963267948966 * ReikaMathLibrary.intpow(radius, 4);
        return (double)torque * radius / J > taumax;
    }

    public static boolean mat_rot_tensfailure(double m, int rpm, double radius, double A, double sigmamax) {
        double omega = (double)(rpm * 120) * Math.PI;
        double Ftens = omega * m * radius / ReikaMathLibrary.intpow(radius, 2);
        return Ftens / A > sigmamax;
    }

    public static boolean mat_rotfailure(double rho, double radius, double omega, double sigmamax) {
        double sigma = rho * omega * omega * radius * radius / 2.0;
        return sigma > sigmamax;
    }

    public static double rotenergy(double rho, double t, double omega, double radius) {
        double V = Math.PI * radius * radius * t;
        double mass = rho * V;
        double I = mass * 0.7853981633974483 * ReikaMathLibrary.intpow(radius, 4);
        return 0.5 * I * ReikaMathLibrary.intpow(omega, 2);
    }

    public static double getHeatFromFriction(double Fnormal, double mu, double vSlip, double eta) {
        return Fnormal * mu * vSlip * eta;
    }

    public static String getSIPrefix(double val) {
        if (val == 0.0 || val < 10.0 && val >= 1.0) {
            return "";
        }
        int log = MathHelper.func_76128_c((double)ReikaMathLibrary.logbase(val, 1000.0));
        switch (log) {
            case 1: {
                return "k";
            }
            case 2: {
                return "M";
            }
            case 3: {
                return "G";
            }
            case 4: {
                return "T";
            }
            case 5: {
                return "P";
            }
            case 6: {
                return "E";
            }
            case -1: {
                return "m";
            }
            case -2: {
                return "micro";
            }
            case -3: {
                return "n";
            }
            case -4: {
                return "p";
            }
            case -5: {
                return "f";
            }
        }
        return "";
    }
}

