/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.MathSci;

import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.Isotopes;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaThermoHelper;

public class ReikaNuclearHelper {
    public static final double URANIUM_FISSION_ENERGY = 2.0E8;
    public static final double AVOGADRO = 6.02E23;
    public static final double NEUTRON_ESCAPE_SPEED = 2752.0;

    public static double getEnergyJ(double E) {
        return E * ReikaPhysicsHelper.ELECTRON_CHARGE;
    }

    public static double getUraniumFissionNeutronE() {
        return 3786752.0 * ReikaPhysicsHelper.NEUTRON_MASS * 6.02E23;
    }

    public static double getWasteDecayHeat() {
        return ReikaThermoHelper.getTemperatureIncrease(1.0, 15000.0, 6.02E23 * ReikaNuclearHelper.getEnergyJ(0.5));
    }

    public static double getDecayChanceFromHalflife(double halflife) {
        return Math.log(2.0) / halflife;
    }

    public static boolean shouldDecay(Isotopes iso) {
        return ReikaNuclearHelper.shouldDecay(iso, 1.0);
    }

    public static boolean shouldDecay(Isotopes iso, double multiplier) {
        double chance = multiplier * ReikaNuclearHelper.getDecayChanceFromHalflife(iso.getMCHalfLife());
        return ReikaRandomHelper.doWithChance(chance);
    }
}

