/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.Registry;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.ImmutableItemStack;
import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Instantiable.ItemFilter;
import Reika.DragonAPI.Instantiable.Recipe.FlexibleIngredient;
import Reika.DragonAPI.Instantiable.Recipe.ItemMatch;
import Reika.DragonAPI.Interfaces.Registry.OreType;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaOreHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.InterfaceCache;
import Reika.DragonAPI.ModRegistry.ModOreList;
import cofh.api.energy.IEnergyContainerItem;
import com.builtbroken.mc.api.items.energy.IEnergyItem;
import com.google.common.base.Strings;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mekanism.api.gas.IGasItem;
import net.machinemuse.api.electricity.MuseElectricItem;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public final class ReikaItemHelper
extends DragonAPICore {
    public static final ItemStack inksac = new ItemStack(Items.field_151100_aR, 1, 0);
    public static final ItemStack redDye = new ItemStack(Items.field_151100_aR, 1, 1);
    public static final ItemStack cactusDye = new ItemStack(Items.field_151100_aR, 1, 2);
    public static final ItemStack cocoaBeans = new ItemStack(Items.field_151100_aR, 1, 3);
    public static final ItemStack lapisDye = new ItemStack(Items.field_151100_aR, 1, 4);
    public static final ItemStack purpleDye = new ItemStack(Items.field_151100_aR, 1, 5);
    public static final ItemStack cyanDye = new ItemStack(Items.field_151100_aR, 1, 6);
    public static final ItemStack lgrayDye = new ItemStack(Items.field_151100_aR, 1, 7);
    public static final ItemStack grayDye = new ItemStack(Items.field_151100_aR, 1, 8);
    public static final ItemStack pinkDye = new ItemStack(Items.field_151100_aR, 1, 9);
    public static final ItemStack limeDye = new ItemStack(Items.field_151100_aR, 1, 10);
    public static final ItemStack yellowDye = new ItemStack(Items.field_151100_aR, 1, 11);
    public static final ItemStack lblueDye = new ItemStack(Items.field_151100_aR, 1, 12);
    public static final ItemStack magentaDye = new ItemStack(Items.field_151100_aR, 1, 13);
    public static final ItemStack orangeDye = new ItemStack(Items.field_151100_aR, 1, 14);
    public static final ItemStack bonemeal = new ItemStack(Items.field_151100_aR, 1, 15);
    public static final BlockKey blackWool = new BlockKey(Blocks.field_150325_L, 15);
    public static final BlockKey redWool = new BlockKey(Blocks.field_150325_L, 14);
    public static final BlockKey greenWool = new BlockKey(Blocks.field_150325_L, 13);
    public static final BlockKey brownWool = new BlockKey(Blocks.field_150325_L, 12);
    public static final BlockKey blueWool = new BlockKey(Blocks.field_150325_L, 11);
    public static final BlockKey purpleWool = new BlockKey(Blocks.field_150325_L, 10);
    public static final BlockKey cyanWool = new BlockKey(Blocks.field_150325_L, 9);
    public static final BlockKey lgrayWool = new BlockKey(Blocks.field_150325_L, 8);
    public static final BlockKey grayWool = new BlockKey(Blocks.field_150325_L, 7);
    public static final BlockKey pinkWool = new BlockKey(Blocks.field_150325_L, 6);
    public static final BlockKey limeWool = new BlockKey(Blocks.field_150325_L, 5);
    public static final BlockKey yellowWool = new BlockKey(Blocks.field_150325_L, 4);
    public static final BlockKey lblueWool = new BlockKey(Blocks.field_150325_L, 3);
    public static final BlockKey magentaWool = new BlockKey(Blocks.field_150325_L, 2);
    public static final BlockKey orangeWool = new BlockKey(Blocks.field_150325_L, 1);
    public static final BlockKey whiteWool = new BlockKey(Blocks.field_150325_L, 0);
    public static final BlockKey stoneBricks = new BlockKey(Blocks.field_150417_aV, 0);
    public static final BlockKey mossyBricks = new BlockKey(Blocks.field_150417_aV, 1);
    public static final BlockKey crackBricks = new BlockKey(Blocks.field_150417_aV, 2);
    public static final BlockKey circleBricks = new BlockKey(Blocks.field_150417_aV, 3);
    public static final BlockKey sandstone = new BlockKey(Blocks.field_150322_A, 0);
    public static final BlockKey carvedSandstone = new BlockKey(Blocks.field_150322_A, 1);
    public static final BlockKey smoothSandstone = new BlockKey(Blocks.field_150322_A, 2);
    public static final BlockKey quartz = new BlockKey(Blocks.field_150371_ca, 0);
    public static final BlockKey carvedQuartz = new BlockKey(Blocks.field_150371_ca, 1);
    public static final BlockKey columnQuartz = new BlockKey(Blocks.field_150371_ca, 2);
    public static final BlockKey oakWood = new BlockKey(Blocks.field_150344_f, 0);
    public static final BlockKey spruceWood = new BlockKey(Blocks.field_150344_f, 1);
    public static final BlockKey birchWood = new BlockKey(Blocks.field_150344_f, 2);
    public static final BlockKey jungleWood = new BlockKey(Blocks.field_150344_f, 3);
    public static final BlockKey acaciaWood = new BlockKey(Blocks.field_150344_f, 4);
    public static final BlockKey darkOakWood = new BlockKey(Blocks.field_150344_f, 5);
    public static final BlockKey stoneSlab = new BlockKey((Block)Blocks.field_150333_U, 0);
    public static final BlockKey sandstoneSlab = new BlockKey((Block)Blocks.field_150333_U, 1);
    public static final BlockKey cobbleSlab = new BlockKey((Block)Blocks.field_150333_U, 3);
    public static final BlockKey brickSlab = new BlockKey((Block)Blocks.field_150333_U, 4);
    public static final BlockKey stonebrickSlab = new BlockKey((Block)Blocks.field_150333_U, 5);
    public static final BlockKey netherSlab = new BlockKey((Block)Blocks.field_150333_U, 6);
    public static final BlockKey quartzSlab = new BlockKey((Block)Blocks.field_150333_U, 7);
    public static final BlockKey stoneDoubleSlab = new BlockKey((Block)Blocks.field_150334_T, 0);
    public static final BlockKey sandstoneDoubleSlab = new BlockKey((Block)Blocks.field_150334_T, 1);
    public static final BlockKey cobbleDoubleSlab = new BlockKey((Block)Blocks.field_150334_T, 3);
    public static final BlockKey brickDoubleSlab = new BlockKey((Block)Blocks.field_150334_T, 4);
    public static final BlockKey stonebrickDoubleSlab = new BlockKey((Block)Blocks.field_150334_T, 5);
    public static final BlockKey netherDoubleSlab = new BlockKey((Block)Blocks.field_150334_T, 6);
    public static final BlockKey quartzDoubleSlab = new BlockKey((Block)Blocks.field_150334_T, 7);
    public static final BlockKey oakSlab = new BlockKey((Block)Blocks.field_150376_bx, 0);
    public static final BlockKey spruceSlab = new BlockKey((Block)Blocks.field_150376_bx, 1);
    public static final BlockKey birchSlab = new BlockKey((Block)Blocks.field_150376_bx, 2);
    public static final BlockKey jungleSlab = new BlockKey((Block)Blocks.field_150376_bx, 3);
    public static final BlockKey oakDoubleSlab = new BlockKey((Block)Blocks.field_150373_bw, 0);
    public static final BlockKey spruceDoubleSlab = new BlockKey((Block)Blocks.field_150373_bw, 1);
    public static final BlockKey birchDoubleSlab = new BlockKey((Block)Blocks.field_150373_bw, 2);
    public static final BlockKey jungleDoubleSlab = new BlockKey((Block)Blocks.field_150373_bw, 3);
    public static final BlockKey tallgrass = new BlockKey((Block)Blocks.field_150329_H, 1);
    public static final BlockKey fern = new BlockKey((Block)Blocks.field_150329_H, 2);
    public static final BlockKey chiseledQuartz = new BlockKey(Blocks.field_150371_ca, 1);
    public static final BlockKey quartzPillar = new BlockKey(Blocks.field_150371_ca, 2);
    public static final ItemStack charcoal = new ItemStack(Items.field_151044_h, 1, 1);
    public static final Comparator<ItemStack> comparator = new ItemComparator();
    public static final Comparator<Object> itemListComparator = new ItemListComparator();
    private static final HashMap<Fluid, ItemStack> fluidContainerData = new HashMap();
    private static final HashMap<Item, Double> itemMass = new HashMap();
    public static final String PLAYER_DEATH_DROP_KEY = "PLAYER_DEATH_DROP";
    private static Field oreListField;
    private static final Pattern ORE_MATERIAL_PATTERN;
    private static final HashMap<Item, ArrayList<ItemStack>> permutations;

    public static boolean matchStacks(ImmutableItemStack a, ImmutableItemStack b) {
        return ReikaItemHelper.matchStacks(a.getItemStack(), b.getItemStack());
    }

    public static boolean matchStacks(ItemStack a, ImmutableItemStack b) {
        return ReikaItemHelper.matchStacks(a, b.getItemStack());
    }

    public static boolean matchStacks(ItemStack a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (b instanceof ItemStack) {
            return ReikaItemHelper.matchStacks(a, (ItemStack)b);
        }
        if (b instanceof BlockKey) {
            BlockKey bk = (BlockKey)b;
            return ReikaItemHelper.matchStackWithBlock(a, bk.blockID) && (!bk.hasMetadata() || a.func_77960_j() == bk.metadata);
        }
        if (b instanceof Collection) {
            return ReikaItemHelper.listContainsItemStack((Collection)b, a, false);
        }
        if (b instanceof String) {
            return ReikaItemHelper.listContainsItemStack(OreDictionary.getOres((String)((String)b)), a, false);
        }
        if (b instanceof ItemFilter) {
            return ((ItemFilter)b).matches(a);
        }
        if (b instanceof ItemMatch) {
            return ((ItemMatch)b).match(a);
        }
        if (b instanceof FlexibleIngredient) {
            return ((FlexibleIngredient)b).match(a);
        }
        return false;
    }

    public static boolean matchStacks(ItemStack a, ItemStack b) {
        return ReikaItemHelper.matchStacks(a, b, false);
    }

    public static boolean matchStacks(ItemStack a, ItemStack b, boolean checkDurability) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.func_77973_b() == null || b.func_77973_b() == null) {
            return false;
        }
        if (a.func_77973_b() != b.func_77973_b()) {
            return false;
        }
        return ReikaItemHelper.areMetasCombinable(a, b, checkDurability);
    }

    private static boolean areMetasCombinable(ItemStack a, ItemStack b, boolean checkDurability) {
        int d2;
        int d1 = a.func_77960_j();
        if (d1 == (d2 = b.func_77960_j()) || d1 == Short.MAX_VALUE || d2 == Short.MAX_VALUE) {
            return true;
        }
        if (a.func_77981_g()) {
            return false;
        }
        return !checkDurability || a.func_77958_k() <= 0;
    }

    public static boolean isFireworkIngredient(Item id) {
        if (id == Items.field_151045_i) {
            return true;
        }
        if (id == Items.field_151100_aR) {
            return true;
        }
        if (id == Items.field_151114_aO) {
            return true;
        }
        if (id == Items.field_151008_G) {
            return true;
        }
        if (id == Items.field_151074_bl) {
            return true;
        }
        if (id == Items.field_151059_bz) {
            return true;
        }
        if (id == Items.field_151045_i) {
            return true;
        }
        if (id == Items.field_151144_bL) {
            return true;
        }
        if (id == Items.field_151154_bQ) {
            return true;
        }
        if (id == Items.field_151121_aF) {
            return true;
        }
        return id == Items.field_151016_H;
    }

    public static ItemStack getSizedItemStack(ItemStack is, int num) {
        if (is == null || is.func_77973_b() == null || num <= 0) {
            return null;
        }
        ItemStack is2 = is.func_77946_l();
        is2.field_77994_a = num;
        return is2;
    }

    public static EntityItem dropItem(Entity e, ItemStack is) {
        return ReikaItemHelper.dropItem(e.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v, is);
    }

    public static EntityItem dropItem(World world, double x, double y, double z, ItemStack is) {
        return ReikaItemHelper.dropItem(world, x, y, z, is, 1.0);
    }

    public static EntityItem dropItem(World world, double x, double y, double z, ItemStack is, double vscale) {
        if (is == null) {
            return null;
        }
        EntityItem ei = new EntityItem(world, x, y, z, is.func_77946_l());
        ei.field_145804_b = 10;
        ei.field_70159_w = (-0.1 + 0.2 * rand.nextDouble()) * vscale;
        ei.field_70179_y = (-0.1 + 0.2 * rand.nextDouble()) * vscale;
        ei.field_70181_x = 0.2 * rand.nextDouble() * vscale;
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)ei);
        }
        return ei;
    }

    public static void dropItems(World world, double x, double y, double z, Collection<ItemStack> li) {
        for (ItemStack is : li) {
            ReikaItemHelper.dropItem(world, x, y, z, is);
        }
    }

    public static boolean isBlock(ItemStack is) {
        Block b = Block.func_149634_a((Item)is.func_77973_b());
        return b != null && b != Blocks.field_150350_a;
    }

    public static boolean collectionContainsItemStack(Collection<ItemStack> li, ItemStack is) {
        return ReikaItemHelper.listContainsItemStack(li, is, false);
    }

    public static boolean listContainsItemStack(Collection<ItemStack> li, ItemStack is, boolean NBT) {
        for (ItemStack is2 : li) {
            if (!ReikaItemHelper.matchStacks(is, is2) || NBT && !ItemStack.func_77970_a((ItemStack)is, (ItemStack)is2)) continue;
            return true;
        }
        return false;
    }

    public static void dropInventory(EntityPlayer ep) {
        InventoryPlayer ii = ep.field_71071_by;
        Random par5Random = new Random();
        if (ii != null) {
            for (int i = 0; i < ii.func_70302_i_(); ++i) {
                ItemStack itemstack = ii.func_70301_a(i);
                if (itemstack == null) continue;
                float f = par5Random.nextFloat() * 0.8f + 0.1f;
                float f1 = par5Random.nextFloat() * 0.8f + 0.1f;
                float f2 = par5Random.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int j = par5Random.nextInt(21) + 10;
                    if (j > itemstack.field_77994_a) {
                        j = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= j;
                    EntityItem ei = new EntityItem(ep.field_70170_p, ep.field_70165_t + (double)f, ep.field_70163_u + 0.25 + (double)f1, ep.field_70161_v + (double)f2, new ItemStack(itemstack.func_77973_b(), j, itemstack.func_77960_j()));
                    if (itemstack.func_77942_o()) {
                        ei.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    float f3 = 0.05f;
                    ei.field_70159_w = (float)par5Random.nextGaussian() * f3;
                    ei.field_70181_x = (float)par5Random.nextGaussian() * f3 + 0.2f;
                    ei.field_70179_y = (float)par5Random.nextGaussian() * f3;
                    ei.field_145804_b = 10;
                    ep.field_70170_p.func_72838_d((Entity)ei);
                }
            }
        }
    }

    public static void dropInventory(World world, int x, int y, int z) {
        IInventory ii = (IInventory)world.func_147438_o(x, y, z);
        Random par5Random = new Random();
        if (ii != null) {
            for (int i = 0; i < ii.func_70302_i_(); ++i) {
                ItemStack itemstack = ii.func_70301_a(i);
                if (itemstack == null) continue;
                float f = par5Random.nextFloat() * 0.8f + 0.1f;
                float f1 = par5Random.nextFloat() * 0.8f + 0.1f;
                float f2 = par5Random.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int j = par5Random.nextInt(21) + 10;
                    if (j > itemstack.field_77994_a) {
                        j = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= j;
                    EntityItem ei = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(itemstack.func_77973_b(), j, itemstack.func_77960_j()));
                    if (itemstack.func_77942_o()) {
                        ei.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    float f3 = 0.05f;
                    ei.field_70159_w = (float)par5Random.nextGaussian() * f3;
                    ei.field_70181_x = (float)par5Random.nextGaussian() * f3 + 0.2f;
                    ei.field_70179_y = (float)par5Random.nextGaussian() * f3;
                    ei.field_145804_b = 10;
                    world.func_72838_d((Entity)ei);
                }
            }
        }
    }

    public static BlockKey getWorldBlockFromItem(ItemStack is) {
        if (is == null) {
            return new BlockKey(Blocks.field_150350_a);
        }
        if (!(is.func_77973_b() instanceof ItemBlock)) {
            return new BlockKey(Blocks.field_150350_a);
        }
        int meta = is.func_77973_b().func_77647_b(is.func_77960_j());
        if (ReikaItemHelper.matchStackWithBlock(is, (Block)Blocks.field_150331_J) || ReikaItemHelper.matchStackWithBlock(is, (Block)Blocks.field_150320_F)) {
            meta = 0;
        }
        return new BlockKey(Block.func_149634_a((Item)is.func_77973_b()), meta);
    }

    public static boolean oreItemExists(String tag) {
        ArrayList li = OreDictionary.getOres((String)tag);
        return li != null && !li.isEmpty();
    }

    public static boolean oreItemsExist(String ... tags) {
        for (int i = 0; i < tags.length; ++i) {
            if (ReikaItemHelper.oreItemExists(tags[i])) continue;
            return false;
        }
        return true;
    }

    public static void addToList(ArrayList<ItemStack> items, ArrayList<ItemStack> toAdd) {
        for (int i = 0; i < toAdd.size(); ++i) {
            ItemStack is = toAdd.get(i);
            ReikaItemHelper.addItemToList(items, is);
        }
    }

    public static void addItemToList(ArrayList<ItemStack> items, ItemStack is) {
        for (int i = 0; i < items.size() && is.field_77994_a > 0; ++i) {
            ItemStack in = items.get(i);
            if (!ReikaItemHelper.matchStacks(is, in) || !ItemStack.func_77970_a((ItemStack)is, (ItemStack)in)) continue;
            int sum = in.field_77994_a + is.field_77994_a;
            if (sum <= in.func_77976_d()) {
                in.field_77994_a = sum;
                return;
            }
            int diff = in.func_77976_d() - in.field_77994_a;
            in.field_77994_a = in.func_77976_d();
            is.field_77994_a -= diff;
        }
        if (is.field_77994_a > 0) {
            items.add(is);
        }
    }

    public static boolean matchStackWithBlock(ItemStack is, Block b) {
        return is.func_77973_b() == Item.func_150898_a((Block)b);
    }

    public static ItemStack stripNBT(ItemStack is) {
        ItemStack is2 = is.func_77946_l();
        is2.field_77990_d = null;
        return is2;
    }

    @SideOnly(value=Side.CLIENT)
    public static List<ItemStack> getAllMetadataPermutations(Item item) {
        if (item == null) {
            throw new MisuseException("You cannot get the permutations of null!");
        }
        ArrayList<Object> li = permutations.get(item);
        if (li == null) {
            li = new ArrayList();
            CreativeTabs[] tabs = item.getCreativeTabs();
            for (int k = 0; k < tabs.length; ++k) {
                CreativeTabs tab = tabs[k];
                item.func_150895_a(item, tab, li);
            }
            permutations.put(item, li);
        }
        return Collections.unmodifiableList(li);
    }

    public static void sortItems(List<ItemStack> li) {
        Collections.sort(li, comparator);
    }

    public static boolean isItemAddedByMod(Item i, String modID) {
        GameRegistry.UniqueIdentifier id = GameRegistry.findUniqueIdentifierFor((Item)i);
        return id != null ? modID.equalsIgnoreCase(id.modId) : modID == null;
    }

    public static ItemStack getContainerForFluid(Fluid fluid) {
        if (fluidContainerData.containsKey(fluid)) {
            ItemStack ret = fluidContainerData.get(fluid);
            return ret != null ? ret.func_77946_l() : null;
        }
        ItemStack ret = ReikaItemHelper.calculateContainerForFluid(fluid);
        fluidContainerData.put(fluid, ret);
        return ret != null ? ret.func_77946_l() : null;
    }

    private static ItemStack calculateContainerForFluid(Fluid fluid) {
        ItemStack is = new ItemStack(Items.field_151133_ar);
        ItemStack fill = FluidContainerRegistry.fillFluidContainer((FluidStack)new FluidStack(fluid, Integer.MAX_VALUE), (ItemStack)is);
        if (fill != null) {
            return fill;
        }
        FluidContainerRegistry.FluidContainerData[] dat = FluidContainerRegistry.getRegisteredFluidContainerData();
        for (int i = 0; i < dat.length; ++i) {
            FluidContainerRegistry.FluidContainerData fcd = dat[i];
            if (fcd.fluid == null || fcd.fluid.getFluid() != fluid || fcd.filledContainer == null) continue;
            return fcd.filledContainer.func_77946_l();
        }
        return null;
    }

    public static boolean isVanillaBlock(Block b) {
        return ReikaItemHelper.isVanillaItem(Item.func_150898_a((Block)b)) || Block.func_149682_b((Block)b) <= Block.func_149682_b((Block)Blocks.field_150398_cm);
    }

    public static boolean isVanillaItem(ItemStack is) {
        return ReikaItemHelper.isVanillaItem(is.func_77973_b());
    }

    public static boolean isVanillaItem(Item i) {
        return "minecraft".equals(ReikaItemHelper.getNamespace(i));
    }

    public static String getNamespace(Block b) {
        if (b == null) {
            return null;
        }
        String s = Block.field_149771_c.func_148750_c((Object)b);
        return s.substring(0, s.indexOf(58));
    }

    public static String getNamespace(Item i) {
        if (i == null) {
            return null;
        }
        String s = Item.field_150901_e.func_148750_c((Object)i);
        if (s == null) {
            DragonAPICore.logError("Found null ID string for non-null item '" + i.getClass().getName() + "'!");
            return "ERROR";
        }
        return s.substring(0, s.indexOf(58));
    }

    public static String getRegistrantMod(ItemStack is) {
        return ReikaItemHelper.getRegistrantMod(is.func_77973_b());
    }

    public static String getRegistrantMod(Block b) {
        if (ReikaItemHelper.isVanillaBlock(b)) {
            return "Minecraft";
        }
        GameRegistry.UniqueIdentifier id = GameRegistry.findUniqueIdentifierFor((Block)b);
        return id != null ? id.modId : "[No Mod]";
    }

    public static String getRegistrantMod(Item i) {
        if (ReikaItemHelper.isVanillaItem(i)) {
            return "Minecraft";
        }
        GameRegistry.UniqueIdentifier id = GameRegistry.findUniqueIdentifierFor((Item)i);
        return id != null ? id.modId : "[No Mod]";
    }

    public static boolean checkOreDictOverlap(ItemStack is1, ItemStack is2) {
        for (String s : ReikaItemHelper.getOreNames(is1)) {
            if (!ReikaItemHelper.isInOreTag(is2, s)) continue;
            return true;
        }
        return false;
    }

    public static EntityPlayer getDropper(EntityItem ei) {
        if (ei.getEntityData().func_74764_b("dropper")) {
            try {
                return ei.field_70170_p.func_152378_a(UUID.fromString(ei.getEntityData().func_74779_i("dropper")));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    public static void setDropper(EntityItem ei, EntityPlayer ep) {
        String s = ep.func_110124_au().toString();
        ei.getEntityData().func_74778_a("dropper", s);
    }

    public static HashSet<String> getOreNames(ItemStack in) {
        HashSet<String> set = new HashSet<String>();
        int[] ids = OreDictionary.getOreIDs((ItemStack)in);
        for (int i = 0; i < ids.length; ++i) {
            set.add(OreDictionary.getOreName((int)ids[i]));
        }
        return set;
    }

    public static String[] getOreNamesArray(ItemStack is) {
        int[] ids = OreDictionary.getOreIDs((ItemStack)is);
        String[] ore = new String[ids.length];
        for (int i = 0; i < ore.length; ++i) {
            ore[i] = OreDictionary.getOreName((int)ids[i]);
        }
        return ore;
    }

    public static boolean isInOreTag(ItemStack is, String name) {
        return ReikaItemHelper.getOreNames(is).contains(name);
    }

    public static Collection<ItemStack> getAllOreItemsExcept(String tag, ItemStack excl) {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        for (ItemStack is : OreDictionary.getOres((String)tag)) {
            if (ReikaItemHelper.matchStacks(is, excl)) continue;
            li.add(is);
        }
        return li;
    }

    public static boolean verifyItemStack(ItemStack is, boolean fullCheck) {
        if (is == null) {
            return true;
        }
        if (is.func_77973_b() == null) {
            return false;
        }
        try {
            is.toString();
            if (fullCheck) {
                is.func_82833_r();
            }
        }
        catch (Exception e) {
            if (ReikaObfuscationHelper.isDeObfEnvironment()) {
                e.printStackTrace();
            }
            return false;
        }
        return true;
    }

    public static void removeOreDictEntry(String tag, ItemStack is) throws Exception {
        ArrayList ores = OreDictionary.getOres((String)tag);
        ArrayList li = (ArrayList)oreListField.get(ores);
        li.remove(is);
        DragonAPICore.log("Removed item " + is + " from OreDict tag '" + tag + "'");
    }

    public static void registerItemMass(Item i, double density, int ingots) {
        ReikaItemHelper.registerItemMass(i, density / 9.0 * (double)ingots * 0.125);
    }

    public static void registerItemMass(Item i, double mass) {
        itemMass.put(i, mass);
    }

    public static void toggleDamageBit(ItemStack is, int bit) {
        is.func_77964_b(ReikaMathLibrary.toggleBit(is.func_77960_j(), bit));
    }

    public static ArrayList<ItemStack> collateItemList(Collection<ItemStack> c) {
        if (c.size() <= 1) {
            return new ArrayList<ItemStack>(c);
        }
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        HashMap<KeyedItemStack, Integer> vals = new HashMap<KeyedItemStack, Integer>();
        for (ItemStack itemStack : c) {
            KeyedItemStack ks = new KeyedItemStack(itemStack).setSimpleHash(true).setIgnoreNBT(false);
            Integer get = (Integer)vals.get(ks);
            int val = get != null ? get : 0;
            vals.put(ks, val + itemStack.field_77994_a);
        }
        for (Map.Entry entry : vals.entrySet()) {
            KeyedItemStack is = (KeyedItemStack)entry.getKey();
            Integer val = (Integer)entry.getValue();
            if (val == null) {
                DragonAPICore.logError("Item " + is + " was mapped to null!");
                continue;
            }
            while (val > 0) {
                int amt = Math.min(val, is.getItemStack().func_77976_d());
                ItemStack copy = ReikaItemHelper.getSizedItemStack(is.getItemStack(), amt);
                li.add(copy);
                val = val - amt;
            }
        }
        return li;
    }

    public static boolean matchStackCollections(Collection<ItemStack> c1, Collection<ItemStack> c2) {
        if (c1.size() != c2.size()) {
            return false;
        }
        ArrayList<ItemStack> li = new ArrayList<ItemStack>(c1);
        ArrayList<ItemStack> li2 = new ArrayList<ItemStack>(c2);
        for (int i = 0; i < li.size(); ++i) {
            ItemStack o2;
            ItemStack o1 = li.get(i);
            if (ReikaItemHelper.matchStacks(o1, o2 = li2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static ItemStack lookupItem(String s) {
        if (Strings.isNullOrEmpty((String)s)) {
            throw new IllegalArgumentException("Invalid item string lookup os null or empty");
        }
        String[] parts = s.split(":");
        int m = 0;
        if (parts.length == 3) {
            try {
                m = parts[2].equalsIgnoreCase("*") ? Short.MAX_VALUE : Integer.parseInt(parts[2]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ReikaItemHelper.lookupItem(parts[0], parts[1], m);
    }

    public static ItemStack lookupItem(ModList mod, String s, int meta) {
        return ReikaItemHelper.lookupItem(mod.modLabel, s, meta);
    }

    public static ItemStack lookupItem(String mod, String item, int meta) {
        Item i = GameRegistry.findItem((String)mod, (String)item);
        return i != null ? new ItemStack(i, 1, meta) : null;
    }

    public static ItemStack lookupBlock(ModList mod, String s, int meta) {
        return ReikaItemHelper.lookupBlock(mod.modLabel, s, meta);
    }

    public static ItemStack lookupBlock(String mod, String s, int meta) {
        Block b = Block.func_149684_b((String)(mod + ":" + s));
        return b != null ? new ItemStack(b, 1, meta) : null;
    }

    public static boolean isOreDrop(ItemStack is) {
        Enum ore = ReikaOreHelper.getByDrop(is);
        if (ore != null) {
            return true;
        }
        ore = ModOreList.getByDrop(is);
        return ore != null;
    }

    public static double getItemMass(ItemStack is) {
        if (is == null) {
            return 0.0;
        }
        Double get = itemMass.get(is);
        return get != null ? get : 0.0;
    }

    public static ItemStack dechargeItem(ItemStack is) {
        if (is != null) {
            Item i = is.func_77973_b();
            if (InterfaceCache.GASITEM.instanceOf(i)) {
                ((IGasItem)i).removeGas(is, Integer.MAX_VALUE);
            } else if (InterfaceCache.ENERGYITEM.instanceOf(i)) {
                ((IEnergyItem)i).discharge(is, 2.147483647E9, true);
            } else if (InterfaceCache.RFENERGYITEM.instanceOf(i)) {
                ((IEnergyContainerItem)i).extractEnergy(is, Integer.MAX_VALUE, false);
            } else if (InterfaceCache.MUSEELECTRICITEM.instanceOf(i)) {
                ((MuseElectricItem)i).extractEnergy(is, Integer.MAX_VALUE, false);
            } else if (InterfaceCache.IELECTRICITEM.instanceOf(i)) {
                ElectricItem.manager.discharge(is, Double.POSITIVE_INFINITY, Integer.MAX_VALUE, true, false, false);
            }
        }
        return is;
    }

    public static ItemStack getAnyMetaStack(ItemStack is) {
        if (is == null) {
            return is;
        }
        ItemStack ret = is.func_77946_l();
        ret.func_77964_b(Short.MAX_VALUE);
        return ret;
    }

    public static boolean areStacksCombinable(ItemStack is1, ItemStack is2, int limit) {
        if (is1 != null && limit != Integer.MAX_VALUE) {
            limit = Math.min(limit, is1.func_77976_d());
        }
        return is1 != null && is2 != null && ReikaItemHelper.matchStacks(is1, is2, true) && ItemStack.func_77970_a((ItemStack)is1, (ItemStack)is2) && is1.field_77994_a + is2.field_77994_a <= limit;
    }

    public static ItemStack parseItem(Object o, boolean useWildcards) {
        if (o instanceof ItemStack) {
            return ((ItemStack)o).func_77946_l();
        }
        if (o instanceof Item) {
            return new ItemStack((Item)o, 1, useWildcards ? Short.MAX_VALUE : 0);
        }
        if (o instanceof Block) {
            return new ItemStack((Block)o, 1, useWildcards ? Short.MAX_VALUE : 0);
        }
        if (o instanceof String) {
            return ReikaItemHelper.lookupItem((String)o);
        }
        if (o instanceof BlockKey) {
            return ((BlockKey)o).asItemStack();
        }
        return null;
    }

    public static OreType parseOreTypeName(String name) {
        Matcher m = ORE_MATERIAL_PATTERN.matcher(name);
        return m.find() ? ReikaItemHelper.getOreType(m.group()) : null;
    }

    public static OreType getOreType(String name) {
        Enum ore = ReikaOreHelper.getByEnumName(name);
        if (ore == null) {
            ore = ModOreList.getByEnumName(name);
        }
        return ore;
    }

    public static Collection<ItemStack> parseMultiRangedMeta(ModList mod, String s) {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        String[] parts = s.split("/");
        String item = parts[0];
        if (parts.length > 1) {
            ArrayList<Integer> metas = new ArrayList<Integer>();
            String[] parts2 = parts[1].split(",");
            for (int i = 0; i < parts2.length; ++i) {
                String part = parts2[i];
                if (part.contains("-")) {
                    String[] parts3 = part.split("-");
                    int low = Integer.parseInt(parts3[0]);
                    int high = Integer.parseInt(parts3[1]);
                    for (int v = low; v <= high; ++v) {
                        metas.add(v);
                    }
                    continue;
                }
                metas.add(Integer.parseInt(part));
            }
            Iterator iterator = metas.iterator();
            while (iterator.hasNext()) {
                int meta = (Integer)iterator.next();
                li.add(ReikaItemHelper.lookupItem(mod, item, meta));
            }
        } else {
            li.add(ReikaItemHelper.lookupItem(mod, item, 0));
        }
        return li;
    }

    public static boolean isOreNugget(ItemStack is) {
        for (String s : ReikaItemHelper.getOreNames(is)) {
            if (!s.startsWith("nugget")) continue;
            return true;
        }
        return false;
    }

    public static boolean isToolOrArmor(Item i) {
        return i instanceof ItemTool || i instanceof ItemSword || i instanceof ItemShears || i instanceof ItemHoe || i instanceof ItemArmor;
    }

    public static int getIndexOf(List li, ItemStack is) {
        for (int i = 0; i < li.size(); ++i) {
            Object o = li.get(i);
            if (!(o instanceof ItemStack) || !ReikaItemHelper.matchStacks((ItemStack)o, is)) continue;
            return i;
        }
        return -1;
    }

    public static void setStackItem(ItemStack is, Item item, int meta) {
        is.func_150996_a(item);
        is.func_77964_b(meta);
    }

    public static boolean isOreIngot(ItemStack is) {
        for (int id : OreDictionary.getOreIDs((ItemStack)is)) {
            String s = OreDictionary.getOreName((int)id);
            if (!s.startsWith("ingot")) continue;
            return true;
        }
        return false;
    }

    public static boolean isOreDust(ItemStack is) {
        for (int id : OreDictionary.getOreIDs((ItemStack)is)) {
            String s = OreDictionary.getOreName((int)id);
            if (!s.startsWith("dust")) continue;
            return true;
        }
        return false;
    }

    public static ItemStack[] createStackArray(Item ... items) {
        ItemStack[] ret = new ItemStack[items.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new ItemStack(items[i]);
        }
        return ret;
    }

    public static Collection<ItemStack> makeListOf(Item ... in) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (Item i : in) {
            ret.add(new ItemStack(i));
        }
        return ret;
    }

    public static Collection<ItemStack> makeListOf(Block ... in) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (Block i : in) {
            ret.add(new ItemStack(i));
        }
        return ret;
    }

    public static boolean isDenseArmor(ItemStack is) {
        if (is.func_77973_b() instanceof ItemArmor) {
            ItemArmor.ArmorMaterial am = ((ItemArmor)is.func_77973_b()).func_82812_d();
            return am == ItemArmor.ArmorMaterial.GOLD || am.func_78044_b(1) >= 6;
        }
        return false;
    }

    public static ItemStack cookFood(ItemStack food) {
        ItemStack smelted = food.func_77973_b() instanceof ItemFood ? FurnaceRecipes.func_77602_a().func_151395_a(food) : null;
        return smelted != null ? smelted : food;
    }

    public static Collection<ItemStack> cloneItemCollection(Collection<ItemStack> c) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (ItemStack is : c) {
            ret.add(is != null ? is.func_77946_l() : null);
        }
        return ret;
    }

    static {
        ORE_MATERIAL_PATTERN = Pattern.compile("[A-Z].*$");
        permutations = new HashMap();
        try {
            Class<?> c = Class.forName("net.minecraftforge.oredict.OreDictionary$UnmodifiableArrayList");
            oreListField = c.getDeclaredField("list");
            oreListField.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        double ingotFactor = 0.0078125;
        double massIron = 866.6666666666666 * ingotFactor;
        double massGold = 2144.4444444444443 * ingotFactor;
        double massDiamond = 388.8888888888889 * ingotFactor;
        itemMass.put(Items.field_151042_j, massIron);
        itemMass.put(Items.field_151043_k, massGold);
        itemMass.put(Items.field_151045_i, massDiamond);
        itemMass.put((Item)Items.field_151028_Y, massIron * 5.0);
        itemMass.put((Item)Items.field_151030_Z, massIron * 8.0);
        itemMass.put((Item)Items.field_151165_aa, massIron * 7.0);
        itemMass.put((Item)Items.field_151167_ab, massIron * 4.0);
        itemMass.put((Item)Items.field_151169_ag, massGold * 5.0);
        itemMass.put((Item)Items.field_151171_ah, massGold * 8.0);
        itemMass.put((Item)Items.field_151149_ai, massGold * 7.0);
        itemMass.put((Item)Items.field_151151_aj, massGold * 4.0);
        itemMass.put((Item)Items.field_151161_ac, massDiamond * 5.0);
        itemMass.put((Item)Items.field_151163_ad, massDiamond * 8.0);
        itemMass.put((Item)Items.field_151173_ae, massDiamond * 7.0);
        itemMass.put((Item)Items.field_151175_af, massDiamond * 4.0);
    }

    private static class ItemListComparator
    implements Comparator<Object> {
        private ItemListComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof ItemStack) {
                if (o2 instanceof ItemStack) {
                    return comparator.compare((ItemStack)o1, (ItemStack)o2);
                }
                return Integer.MIN_VALUE;
            }
            if (o2 instanceof ItemStack) {
                return Integer.MAX_VALUE;
            }
            List l1 = (List)o1;
            List l2 = (List)o2;
            int fast = Integer.compare(l1.size(), l2.size());
            if (fast != 0) {
                return fast;
            }
            ArrayList li1 = new ArrayList(l1);
            ArrayList li2 = new ArrayList(l2);
            if (li1.size() > 1) {
                Collections.sort(li1, comparator);
                Collections.sort(li2, comparator);
            }
            for (int i = 0; i < li1.size(); ++i) {
                ItemStack is2;
                ItemStack is1 = (ItemStack)li1.get(i);
                int get = comparator.compare(is1, is2 = (ItemStack)li2.get(i));
                if (get == 0) continue;
                return get;
            }
            return 0;
        }
    }

    private static class ItemComparator
    implements Comparator<ItemStack> {
        private ItemComparator() {
        }

        @Override
        public int compare(ItemStack o1, ItemStack o2) {
            if (o1.func_77973_b() == o2.func_77973_b()) {
                if (o1.func_77960_j() == o2.func_77960_j()) {
                    if (o1.field_77994_a == o2.field_77994_a) {
                        if (o1.field_77990_d == o2.field_77990_d || o1.field_77990_d != null && o1.field_77990_d.equals((Object)o2.field_77990_d)) {
                            return 0;
                        }
                        if (o1.field_77990_d == null && o2.field_77990_d != null) {
                            return -1;
                        }
                        if (o2.field_77990_d == null && o1.field_77990_d != null) {
                            return 1;
                        }
                        return ReikaNBTHelper.compareNBTTags(o1.field_77990_d, o2.field_77990_d);
                    }
                    return Integer.compare(o2.field_77994_a, o1.field_77994_a);
                }
                return Integer.compare(o1.func_77960_j(), o2.func_77960_j());
            }
            return Integer.compare(Item.func_150891_b((Item)o1.func_77973_b()), Item.func_150891_b((Item)o2.func_77973_b()));
        }
    }
}

