/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.Registry;

import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Interfaces.Registry.OreType;
import Reika.DragonAPI.Libraries.Registry.ReikaDyeHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModInteract.RecipeHandlers.ModOreCompat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public enum ReikaOreHelper implements OreType
{
    COAL("Coal", Blocks.field_150365_q, Items.field_151044_h, 1, "oreCoal", "itemCoal", OreType.OreRarity.COMMON),
    IRON("Iron", Blocks.field_150366_p, "oreIron", 1, "ingotIron", OreType.OreRarity.AVERAGE),
    GOLD("Gold", Blocks.field_150352_o, "oreGold", 1, "ingotGold", OreType.OreRarity.SCATTERED),
    REDSTONE("Redstone", Blocks.field_150450_ax, Items.field_151137_ax, 1, "oreRedstone", "dustRedstone", OreType.OreRarity.COMMON),
    LAPIS("Lapis Lazuli", Blocks.field_150369_x, ReikaDyeHelper.BLUE.getStackOf(), 1, "oreLapis", "gemLapis", OreType.OreRarity.SCARCE),
    DIAMOND("Diamond", Blocks.field_150482_ag, Items.field_151045_i, 1, "oreDiamond", "gemDiamond", OreType.OreRarity.SCARCE),
    EMERALD("Emerald", Blocks.field_150412_bA, Items.field_151166_bC, 1, "oreEmerald", "gemEmerald", OreType.OreRarity.RARE),
    QUARTZ("Nether Quartz", Blocks.field_150449_bY, Items.field_151128_bU, 1, "oreQuartz", "itemQuartz", OreType.OreRarity.EVERYWHERE);

    private String name;
    private ItemStack drop;
    private Block ore;
    private String oreDict;
    private String dropOreDict;
    public final OreType.OreRarity rarity;
    public final int blockDrops;
    private final ArrayList<ItemStack> ores = new ArrayList();
    private static final HashMap<String, String> cases;
    private static final HashMap<Block, ReikaOreHelper> vanillaOres;
    private static final HashMap<String, ReikaOreHelper> oreNames;
    private static final HashMap<String, ReikaOreHelper> enumNames;
    private static final ItemHashMap<ReikaOreHelper> itemMap;
    public static final ReikaOreHelper[] oreList;
    private static final ArrayList<ItemStack> extraOres;

    private ReikaOreHelper(String n2, Block b, ItemStack is, int nd, String d, String d2, OreType.OreRarity r) {
        this.name = n2;
        this.ore = b;
        this.drop = is.func_77946_l();
        this.blockDrops = nd;
        this.oreDict = d;
        this.dropOreDict = d2;
        this.ores.addAll(OreDictionary.getOres((String)this.oreDict));
        this.rarity = r;
    }

    private ReikaOreHelper(String n2, Block b, Item i, int nd, String d, String d2, OreType.OreRarity r) {
        this(n2, b, new ItemStack(i), nd, d, d2, r);
    }

    private ReikaOreHelper(String n2, Block b, String d, int nd, String d2, OreType.OreRarity r) {
        this(n2, b, new ItemStack(b), nd, d, d2, r);
    }

    public String getName() {
        return this.name;
    }

    public ItemStack getDrop() {
        return this.drop.func_77946_l();
    }

    public ItemStack getOreBlock() {
        if (this.ore == null) {
            throw new IllegalStateException("Some mod deleted the vanilla ore block for " + this.getDisplayName() + "!");
        }
        return new ItemStack(this.ore);
    }

    public Block getOreBlockInstance() {
        return this.ore;
    }

    public boolean dropsSelf() {
        return this.drop.func_77973_b() == Item.func_150898_a((Block)this.ore);
    }

    public String getOreDictName() {
        return this.oreDict;
    }

    @Override
    public String[] getOreDictNames() {
        return new String[]{this.oreDict};
    }

    @Override
    public String getProductOreDictName() {
        return this.dropOreDict;
    }

    public String getDropOreDictName() {
        return this.dropOreDict;
    }

    public static boolean isVanillaOre(Block id) {
        return ReikaOreHelper.getFromVanillaOre(id) != null;
    }

    public static boolean isVanillaOre(Item id) {
        return ReikaOreHelper.isVanillaOre(Block.func_149634_a((Item)id));
    }

    public static ReikaOreHelper getFromVanillaOre(Item id) {
        return ReikaOreHelper.getFromVanillaOre(Block.func_149634_a((Item)id));
    }

    public static ReikaOreHelper getFromVanillaOre(Block id) {
        return vanillaOres.get(id);
    }

    public static boolean isVanillaOre(ItemStack id) {
        return ReikaOreHelper.getFromVanillaOre(id) != null;
    }

    public static ReikaOreHelper getFromVanillaOre(ItemStack id) {
        return vanillaOres.get(Block.func_149634_a((Item)id.func_77973_b()));
    }

    public ItemStack getResource() {
        if (!this.dropsSelf()) {
            return this.getDrop();
        }
        if (this == IRON) {
            return new ItemStack(Items.field_151042_j);
        }
        if (this == GOLD) {
            return new ItemStack(Items.field_151043_k);
        }
        return null;
    }

    @Override
    public Collection<ItemStack> getAllOreBlocks() {
        return Collections.unmodifiableCollection(OreDictionary.getOres((String)this.getOreDictName()));
    }

    public boolean contains(ItemStack is) {
        return ReikaItemHelper.collectionContainsItemStack(this.getAllOreBlocks(), is);
    }

    @Override
    public ItemStack getFirstOreBlock() {
        return new ItemStack(this.ore);
    }

    public static ReikaOreHelper getEntryByOreDict(ItemStack is) {
        return itemMap.get(is);
    }

    public static ReikaOreHelper getEntryFromOreName(String value) {
        return oreNames.get(value);
    }

    public Block getOreGenBlock() {
        return this.isEnd() ? Blocks.field_150377_bs : (this.isNether() ? Blocks.field_150424_aL : Blocks.field_150348_b);
    }

    public static void refreshAll() {
        for (int i = 0; i < oreList.length; ++i) {
            ReikaOreHelper ore = oreList[i];
            ore.refresh();
        }
    }

    private void refresh() {
        this.ores.clear();
        String tag = this.oreDict;
        ArrayList<ItemStack> li = new ArrayList<ItemStack>(OreDictionary.getOres((String)tag));
        li.addAll(ModOreCompat.instance.load(this));
        for (ItemStack is : li) {
            if (ReikaItemHelper.collectionContainsItemStack(this.ores, is)) continue;
            this.ores.add(is);
            itemMap.put(is, this);
        }
    }

    @Override
    public OreType.OreRarity getRarity() {
        return this.rarity;
    }

    public boolean isNether() {
        return this == QUARTZ;
    }

    public boolean isEnd() {
        return false;
    }

    @Override
    public EnumSet<OreType.OreLocation> getOreLocations() {
        return this.isEnd() ? EnumSet.of(OreType.OreLocation.END) : (this.isNether() ? EnumSet.of(OreType.OreLocation.NETHER) : EnumSet.of(OreType.OreLocation.OVERWORLD));
    }

    @Override
    public boolean canGenerateIn(Block b) {
        if (this.isNether()) {
            return b == Blocks.field_150424_aL;
        }
        if (this.isEnd()) {
            return b == Blocks.field_150377_bs;
        }
        return b == Blocks.field_150348_b;
    }

    @Override
    public boolean existsInGame() {
        return true;
    }

    public static boolean isVanillaOreType(String s) {
        return oreNames.containsKey(s);
    }

    public static ReikaOreHelper getByDrop(ItemStack is) {
        int[] ids = OreDictionary.getOreIDs((ItemStack)is);
        for (int i = 0; i < ids.length; ++i) {
            String s = OreDictionary.getOreName((int)ids[i]);
            ReikaOreHelper ore = oreNames.get(s);
            if (ore == null) continue;
            return ore;
        }
        return null;
    }

    public static ReikaOreHelper getByEnumName(String name) {
        return enumNames.get(name);
    }

    @Override
    public int getDisplayColor() {
        switch (this) {
            case COAL: {
                return 0x141414;
            }
            case DIAMOND: {
                return 65535;
            }
            case EMERALD: {
                return 65280;
            }
            case GOLD: {
                return 16764944;
            }
            case IRON: {
                return 13408655;
            }
            case LAPIS: {
                return 2117887;
            }
            case QUARTZ: {
                return 12628128;
            }
            case REDSTONE: {
                return 0xFF2020;
            }
        }
        return 0xFFFFFF;
    }

    @Override
    public int getDropCount() {
        switch (this) {
            case REDSTONE: {
                return 4;
            }
            case LAPIS: {
                return 6;
            }
        }
        return 1;
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    static {
        cases = new HashMap();
        vanillaOres = new HashMap();
        oreNames = new HashMap();
        enumNames = new HashMap();
        itemMap = new ItemHashMap();
        oreList = ReikaOreHelper.values();
        extraOres = new ArrayList();
        for (int i = 0; i < oreList.length; ++i) {
            vanillaOres.put(ReikaOreHelper.oreList[i].ore, oreList[i]);
            oreNames.put(ReikaOreHelper.oreList[i].oreDict, oreList[i]);
            enumNames.put(oreList[i].name(), oreList[i]);
        }
        vanillaOres.put(Blocks.field_150439_ay, REDSTONE);
    }
}

