/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries;

import Reika.DragonAPI.ASM.ASMCalls;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Auxiliary.Trackers.ReflectiveFailureTracker;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Instantiable.BasicModEntry;
import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Instantiable.Recipe.RecipePattern;
import Reika.DragonAPI.Interfaces.CustomToStringRecipe;
import Reika.DragonAPI.Interfaces.Registry.ModEntry;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModList;
import appeng.api.recipes.IIngredient;
import appeng.api.storage.data.IAEItemStack;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputOreDict;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeBookCloning;
import net.minecraft.item.crafting.RecipeFireworks;
import net.minecraft.item.crafting.RecipesArmor;
import net.minecraft.item.crafting.RecipesArmorDyes;
import net.minecraft.item.crafting.RecipesCrafting;
import net.minecraft.item.crafting.RecipesDyes;
import net.minecraft.item.crafting.RecipesFood;
import net.minecraft.item.crafting.RecipesIngots;
import net.minecraft.item.crafting.RecipesMapCloning;
import net.minecraft.item.crafting.RecipesMapExtending;
import net.minecraft.item.crafting.RecipesTools;
import net.minecraft.item.crafting.RecipesWeapons;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.commons.lang3.ArrayUtils;

public class ReikaRecipeHelper
extends DragonAPICore {
    private static final CraftingManager cr = CraftingManager.func_77594_a();
    private static final Random rand = new Random();
    private static final int[] permuOffsets = new int[9];
    private static final HashMap<IRecipe, RecipeCache> recipeCache = new HashMap();
    private static final HashMap<IRecipe, RecipeCache> recipeCacheClient = new HashMap();
    private static Field shapedOreHeight;
    private static Field shapedOreWidth;
    private static Field shapedOreInput;
    private static Class ic2ShapedClass;
    private static Class ic2ShapelessClass;
    private static Field shapedIc2Input;
    private static Field shapedIc2InputMirror;
    private static Field shapedIc2Height;
    private static Field shapedIc2Width;
    private static Field ic2MasksField;
    private static Field shapelessIc2Input;
    private static Class aeShapedClass;
    private static Class aeShapelessClass;
    private static Field shapedAEInput;
    private static Field shapelessAEInput;
    private static Field shapedAEHeight;
    private static Field shapedAEWidth;
    private static Class computerTurtleClass;
    private static Field computerTurtleInput;
    private static Class fairyComponentClass;
    private static Field fairyComponentInput;
    private static Field fairyComponentOutput;
    private static Field fairyComponentHeight;
    private static Field fairyComponentWidth;
    private static Class fairyStringClass;
    private static Field fairyStringInput;
    public static Field fairyStringOutput;
    private static Field fairyStringHeight;
    private static Field fairyStringWidth;
    private static Class teNEIClass;
    private static Field teNEIWrappedRecipe;

    public static Class fairyComponentClass() {
        return fairyComponentClass;
    }

    public static Class fairyStringClass() {
        return fairyStringClass;
    }

    public static ItemStack getFairyLightOutput(IRecipe ir) {
        try {
            return ir != null && ir.getClass() == fairyComponentClass ? (ItemStack)fairyComponentOutput.get(ir) : null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Class getIC2ShapedClass() {
        return ic2ShapedClass;
    }

    public static Class getIC2ShapelessClass() {
        return ic2ShapelessClass;
    }

    public static void overwriteShapedOreRecipeInput(ShapedOreRecipe s, Object[] in, int height, int width) {
        try {
            shapedOreInput.set(s, in);
            shapedOreHeight.set(s, height);
            shapedOreWidth.set(s, width);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getOreRecipeHeight(ShapedOreRecipe s) {
        try {
            return shapedOreHeight.getInt(s);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static int getOreRecipeWidth(ShapedOreRecipe s) {
        try {
            return shapedOreWidth.getInt(s);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static boolean isUniformInput(IRecipe ir) {
        HashSet<KeyedItemStack> set = new HashSet<KeyedItemStack>();
        for (ItemStack is : ReikaRecipeHelper.getAllItemsInRecipe(ir)) {
            KeyedItemStack ks = new KeyedItemStack(is).setSimpleHash(true);
            set.add(ks);
        }
        return set.size() == 1;
    }

    public static ItemStack getItemInRecipeAtXY(ShapedRecipes r, int x, int y) {
        int xy = x + r.field_77576_b * y;
        return r.field_77574_d[xy];
    }

    public static ArrayList<IRecipe> getAllRecipesByOutput(List<IRecipe> in, ItemStack out) {
        ArrayList<IRecipe> li = new ArrayList<IRecipe>();
        for (IRecipe ir : in) {
            if (!ReikaItemHelper.matchStacks(ir.func_77571_b(), out)) continue;
            li.add(ir);
        }
        return li;
    }

    public static boolean isCraftable(ItemStack is) {
        return ReikaRecipeHelper.isCraftable(CraftingManager.func_77594_a().func_77592_b(), is);
    }

    public static boolean isCraftable(List<IRecipe> in, ItemStack is) {
        return ReikaRecipeHelper.getAllRecipesByOutput(in, is).size() > 0;
    }

    public static List<ShapedOreRecipe> getShapedOreRecipesByOutput(List<IRecipe> in, ItemStack out) {
        ArrayList<ShapedOreRecipe> li = new ArrayList<ShapedOreRecipe>();
        for (IRecipe ir : in) {
            if (!(ir instanceof ShapedOreRecipe) || !ReikaItemHelper.matchStacks(ir.func_77571_b(), out)) continue;
            li.add((ShapedOreRecipe)ir);
        }
        return li;
    }

    public static List<ShapelessRecipes> getShapelessRecipesByOutput(List<IRecipe> in, ItemStack out) {
        ArrayList<ShapelessRecipes> li = new ArrayList<ShapelessRecipes>();
        for (IRecipe ir : in) {
            if (!(ir instanceof ShapelessRecipes) || !ReikaItemHelper.matchStacks(ir.func_77571_b(), out)) continue;
            li.add((ShapelessRecipes)ir);
        }
        return li;
    }

    public static List<ShapelessOreRecipe> getShapelessOreRecipesByOutput(List<IRecipe> in, ItemStack out) {
        ArrayList<ShapelessOreRecipe> li = new ArrayList<ShapelessOreRecipe>();
        for (IRecipe ir : in) {
            if (!(ir instanceof ShapelessOreRecipe) || !ReikaItemHelper.matchStacks(ir.func_77571_b(), out)) continue;
            li.add((ShapelessOreRecipe)ir);
        }
        return li;
    }

    private static List<ItemStack> getRecipeItemStack(ItemStack is, boolean client) {
        if (is == null) {
            return null;
        }
        if (is.func_77960_j() == Short.MAX_VALUE && client) {
            return ReikaItemHelper.getAllMetadataPermutations(is.func_77973_b());
        }
        return ReikaJavaLibrary.makeListFrom(is);
    }

    private static List<ItemStack> getRecipeItemStacks(Object[] c, boolean client) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (Object o : c) {
            if (o == null) continue;
            if (o instanceof ItemStack) {
                ItemStack is = (ItemStack)o;
                if (is.func_77960_j() == Short.MAX_VALUE && client) {
                    ret.addAll(ReikaItemHelper.getAllMetadataPermutations(is.func_77973_b()));
                    continue;
                }
                ret.add(is);
                continue;
            }
            if (!(o instanceof Collection)) continue;
            ret.addAll((Collection)o);
        }
        return ret;
    }

    private static List<ItemStack> getRecipeItemStacks(Collection c, boolean client) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (Object o : c) {
            if (o == null) continue;
            if (o instanceof ItemStack) {
                ItemStack is = (ItemStack)o;
                if (is.func_77960_j() == Short.MAX_VALUE && client) {
                    ret.addAll(ReikaItemHelper.getAllMetadataPermutations(is.func_77973_b()));
                } else {
                    ret.add(is);
                }
            }
            if (ModList.IC2.isLoaded()) {
                ReikaRecipeHelper.handleIC2Inputs(o, ret);
            }
            if (!ModList.APPENG.isLoaded()) continue;
            ReikaRecipeHelper.handleAEInputs(o, ret);
        }
        return ret;
    }

    @DependentMethodStripper.ModDependent(value={ModList.IC2})
    private static void handleIC2Inputs(Object o, ArrayList<ItemStack> ret) {
        if (o instanceof IRecipeInput) {
            ret.addAll(((IRecipeInput)o).getInputs());
        }
    }

    @DependentMethodStripper.ModDependent(value={ModList.APPENG})
    private static void handleAEInputs(Object o, ArrayList<ItemStack> ret) {
        if (o instanceof IAEItemStack) {
            ret.add(((IAEItemStack)o).getItemStack());
        }
    }

    private static RecipeCache getRecipeCacheObject(IRecipe ir, boolean client) {
        HashMap<IRecipe, RecipeCache> map = client ? recipeCacheClient : recipeCache;
        RecipeCache cache = map.get(ir);
        if (cache == null) {
            cache = ReikaRecipeHelper.calculateRecipeToItemStackArray(ir, client);
            if (!ReikaObfuscationHelper.isDeObfEnvironment()) {
                map.put(ir, cache);
            }
        }
        return cache;
    }

    public static List<ItemStack>[] getRecipeArray(IRecipe ir) {
        List[] lists = new List[9];
        RecipeCache c = ReikaRecipeHelper.getRecipeCacheObject(ir, false);
        if (c instanceof UnparsableRecipeCache) {
            return null;
        }
        for (int i = 0; i < 9; ++i) {
            List li = c.items[i];
            if (li == null || li.isEmpty()) continue;
            lists[i] = Collections.unmodifiableList(li);
        }
        return lists;
    }

    @SideOnly(value=Side.CLIENT)
    public static ItemStack[] getPermutedRecipeArray(IRecipe ir) {
        RecipeCache r = ReikaRecipeHelper.getRecipeCacheObject(ir, true);
        if (r instanceof UnparsableRecipeCache) {
            return null;
        }
        List[] isin = r.items;
        long ttick = System.currentTimeMillis();
        if (GuiScreen.func_146272_n()) {
            ttick *= 4L;
        }
        if (GuiScreen.func_146271_m()) {
            ttick /= 8L;
        }
        int time = 1000;
        for (int i = 0; i < isin.length; ++i) {
            if (isin[i] == null || isin[i].isEmpty() || ttick % (long)time != 0L) continue;
            ReikaRecipeHelper.permuOffsets[i] = rand.nextInt(isin[i].size());
        }
        int[] indices = new int[9];
        ItemStack[] add = new ItemStack[9];
        for (int i = 0; i < 9; ++i) {
            List li = isin[i];
            if (li == null || li.isEmpty()) continue;
            int tick = (int)((ttick / (long)time + (long)permuOffsets[i]) % (long)li.size());
            add[i] = (ItemStack)li.get(tick);
        }
        ItemStack[] in = new ItemStack[9];
        if (r.width == 3 && r.height == 3) {
            for (int i = 0; i < 9; ++i) {
                in[i] = add[i];
            }
        }
        if (r.width == 1 && r.height == 1) {
            in[4] = add[0];
        }
        if (r.width == 2 && r.height == 2) {
            in[0] = add[0];
            in[1] = add[1];
            in[3] = add[2];
            in[4] = add[3];
        }
        if (r.width == 1 && r.height == 2) {
            in[4] = add[0];
            in[7] = add[1];
        }
        if (r.width == 2 && r.height == 1) {
            in[0] = add[0];
            in[1] = add[1];
        }
        if (r.width == 3 && r.height == 1) {
            in[0] = add[0];
            in[1] = add[1];
            in[2] = add[2];
        }
        if (r.width == 1 && r.height == 3) {
            in[1] = add[0];
            in[4] = add[1];
            in[7] = add[2];
        }
        if (r.width == 2 && r.height == 3) {
            in[0] = add[0];
            in[1] = add[1];
            in[3] = add[2];
            in[4] = add[3];
            in[6] = add[4];
            in[7] = add[5];
        }
        if (r.width == 3 && r.height == 2) {
            in[3] = add[0];
            in[4] = add[1];
            in[5] = add[2];
            in[6] = add[3];
            in[7] = add[4];
            in[8] = add[5];
        }
        return in;
    }

    private static RecipeCache calculateRecipeToItemStackArray(IRecipe ire, boolean client) {
        List[] isin = new List[9];
        int w = 0;
        int h = 0;
        if (ire == null) {
            DragonAPICore.logError("Recipe is null!");
        }
        if (ire == null) {
            ReikaJavaLibrary.dumpStack();
            return null;
        }
        if ((ire = ReikaRecipeHelper.getTEWrappedRecipe(ire)) instanceof ShapedRecipes) {
            ShapedRecipes r = (ShapedRecipes)ire;
            int num = r.field_77574_d.length;
            w = r.field_77576_b;
            h = r.field_77577_c;
            for (int i = 0; i < r.field_77574_d.length; ++i) {
                ItemStack is = r.field_77574_d[i];
                isin[i] = ReikaRecipeHelper.getRecipeItemStack(is, client);
            }
        } else if (ire instanceof ShapedOreRecipe) {
            ShapedOreRecipe so = (ShapedOreRecipe)ire;
            Object[] objin = so.getInput();
            w = 3;
            h = 3;
            for (int i = 0; i < objin.length; ++i) {
                List li;
                if (objin[i] instanceof ItemStack) {
                    ItemStack is = (ItemStack)objin[i];
                    isin[i] = ReikaRecipeHelper.getRecipeItemStack(is, client);
                    continue;
                }
                if (!(objin[i] instanceof List) || (li = (List)objin[i]).isEmpty()) continue;
                isin[i] = ReikaRecipeHelper.getRecipeItemStacks(li, client);
            }
        } else if (ire instanceof ShapelessRecipes) {
            ShapelessRecipes sr = (ShapelessRecipes)ire;
            for (int i = 0; i < sr.func_77570_a(); ++i) {
                ItemStack is = (ItemStack)sr.field_77579_b.get(i);
                isin[i] = ReikaRecipeHelper.getRecipeItemStack(is, client);
            }
            w = sr.func_77570_a() >= 3 ? 3 : sr.func_77570_a();
            h = (sr.func_77570_a() + 2) / 3;
        } else if (ire instanceof ShapelessOreRecipe) {
            ShapelessOreRecipe so = (ShapelessOreRecipe)ire;
            for (int i = 0; i < so.func_77570_a(); ++i) {
                Object obj = so.getInput().get(i);
                if (obj instanceof ItemStack) {
                    ItemStack is = (ItemStack)obj;
                    isin[i] = ReikaRecipeHelper.getRecipeItemStack(is, client);
                    continue;
                }
                if (obj instanceof List) {
                    List li = (List)obj;
                    if (li.isEmpty()) continue;
                    isin[i] = ReikaRecipeHelper.getRecipeItemStacks(li, client);
                    continue;
                }
                DragonAPICore.log("Could not parse ingredient type " + obj.getClass() + " with value " + obj.toString());
                isin[i] = Arrays.asList(new ItemStack((Block)Blocks.field_150480_ab));
            }
            w = so.func_77570_a() >= 3 ? 3 : so.func_77570_a();
            h = (so.func_77570_a() + 2) / 3;
        } else if (ire.getClass() == ic2ShapedClass) {
            try {
                Object[] in = (Object[])shapedIc2Input.get(ire);
                in = ReikaRecipeHelper.padIC2CrushedArray(in, ire);
                w = Math.min(3, shapedIc2Width.getInt(ire));
                h = Math.min(3, shapedIc2Height.getInt(ire));
                for (int i = 0; i < in.length; ++i) {
                    Object o = in[i];
                    if (o == null) continue;
                    if (o instanceof ItemStack) {
                        isin[i] = ReikaRecipeHelper.getRecipeItemStack((ItemStack)o, client);
                        continue;
                    }
                    if (o instanceof List) {
                        isin[i] = ReikaRecipeHelper.getRecipeItemStacks((List)o, client);
                        continue;
                    }
                    if (o instanceof IRecipeInput) {
                        isin[i] = ReikaRecipeHelper.getRecipeItemStacks(((IRecipeInput)o).getInputs(), client);
                        continue;
                    }
                    DragonAPICore.log("Could not parse ingredient type " + o.getClass() + " with value " + o.toString());
                    isin[i] = Arrays.asList(new ItemStack((Block)Blocks.field_150480_ab));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (ire.getClass() == ic2ShapelessClass) {
            try {
                Object[] in = (Object[])shapelessIc2Input.get(ire);
                for (int i = 0; i < in.length; ++i) {
                    Object o = in[i];
                    if (o == null) continue;
                    if (o instanceof ItemStack) {
                        isin[i] = ReikaRecipeHelper.getRecipeItemStack((ItemStack)o, client);
                        continue;
                    }
                    if (o instanceof List) {
                        isin[i] = ReikaRecipeHelper.getRecipeItemStacks((List)o, client);
                        continue;
                    }
                    if (o instanceof IRecipeInput) {
                        isin[i] = ReikaRecipeHelper.getRecipeItemStacks(((IRecipeInput)o).getInputs(), client);
                        continue;
                    }
                    DragonAPICore.log("Could not parse ingredient type " + o.getClass() + " with value " + o.toString());
                    isin[i] = Arrays.asList(new ItemStack((Block)Blocks.field_150480_ab));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (ire.getClass() == aeShapedClass) {
            try {
                Object[] in = (Object[])shapedAEInput.get(ire);
                w = Math.min(3, shapedAEWidth.getInt(ire));
                h = Math.min(3, shapedAEHeight.getInt(ire));
                for (int i = 0; i < in.length; ++i) {
                    Object o = in[i];
                    if (o == null) continue;
                    if (o instanceof ItemStack) {
                        isin[i] = ReikaRecipeHelper.getRecipeItemStack((ItemStack)o, client);
                        continue;
                    }
                    if (o instanceof List) {
                        isin[i] = ReikaRecipeHelper.getRecipeItemStacks((List)o, client);
                        continue;
                    }
                    if (o instanceof IAEItemStack) {
                        isin[i] = ReikaRecipeHelper.getRecipeItemStack(((IAEItemStack)o).getItemStack(), client);
                        continue;
                    }
                    if (o instanceof IIngredient) {
                        isin[i] = ReikaRecipeHelper.getRecipeItemStacks(Arrays.asList(((IIngredient)o).getItemStackSet()), client);
                        continue;
                    }
                    DragonAPICore.log("Could not parse ingredient type " + o.getClass() + " with value " + o.toString());
                    isin[i] = Arrays.asList(new ItemStack((Block)Blocks.field_150480_ab));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (ire.getClass() == aeShapelessClass) {
            try {
                Object[] in = (Object[])shapelessAEInput.get(ire);
                for (int i = 0; i < in.length; ++i) {
                    Object o = in[i];
                    if (o == null) continue;
                    if (o instanceof ItemStack) {
                        isin[i] = ReikaRecipeHelper.getRecipeItemStack((ItemStack)o, client);
                        continue;
                    }
                    if (o instanceof List) {
                        isin[i] = ReikaRecipeHelper.getRecipeItemStacks((List)o, client);
                        continue;
                    }
                    if (o instanceof IAEItemStack) {
                        isin[i] = ReikaRecipeHelper.getRecipeItemStack(((IAEItemStack)o).getItemStack(), client);
                        continue;
                    }
                    if (o instanceof IIngredient) {
                        isin[i] = ReikaRecipeHelper.getRecipeItemStacks(Arrays.asList(((IIngredient)o).getItemStackSet()), client);
                        continue;
                    }
                    DragonAPICore.log("Could not parse ingredient type " + o.getClass() + " with value " + o.toString());
                    isin[i] = Arrays.asList(new ItemStack((Block)Blocks.field_150480_ab));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (ire.getClass() == computerTurtleClass) {
            try {
                Item[] in = (Item[])computerTurtleInput.get(ire);
                for (int i = 0; i < 3; ++i) {
                    for (int k = 0; k < 3; ++k) {
                        int idx = i * 3 + k;
                        isin[idx] = ReikaRecipeHelper.getRecipeItemStack(new ItemStack(in[idx]), client);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (ire.getClass() == fairyComponentClass) {
            try {
                Object[] in = (Object[])fairyComponentInput.get(ire);
                w = Math.min(3, fairyComponentWidth.getInt(ire));
                h = Math.min(3, fairyComponentHeight.getInt(ire));
                for (int i = 0; i < in.length; ++i) {
                    Object o = in[i];
                    if (o == null) continue;
                    if (o instanceof ItemStack) {
                        isin[i] = ReikaRecipeHelper.getRecipeItemStack((ItemStack)o, client);
                        continue;
                    }
                    if (o instanceof List) {
                        isin[i] = ReikaRecipeHelper.getRecipeItemStacks((List)o, client);
                        continue;
                    }
                    DragonAPICore.log("Could not parse ingredient type " + o.getClass() + " with value " + o.toString());
                    isin[i] = Arrays.asList(new ItemStack((Block)Blocks.field_150480_ab));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (ire.getClass() == fairyStringClass) {
            try {
                Object[] in = (Object[])fairyStringInput.get(ire);
                w = Math.min(3, fairyStringWidth.getInt(ire));
                h = Math.min(3, fairyStringHeight.getInt(ire));
                for (int i = 0; i < in.length; ++i) {
                    Object o = in[i];
                    if (o == null) continue;
                    if (o instanceof ItemStack) {
                        isin[i] = ReikaRecipeHelper.getRecipeItemStack((ItemStack)o, client);
                        continue;
                    }
                    if (o instanceof Object[]) {
                        isin[i] = ReikaRecipeHelper.getRecipeItemStacks((Object[])o, client);
                        continue;
                    }
                    if (o instanceof List) {
                        isin[i] = ReikaRecipeHelper.getRecipeItemStacks((List)o, client);
                        continue;
                    }
                    DragonAPICore.log("Could not parse ingredient type " + o.getClass() + " with value " + o.toString());
                    isin[i] = Arrays.asList(new ItemStack((Block)Blocks.field_150480_ab));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            DragonAPICore.logError("Recipe " + ReikaRecipeHelper.toString(ire) + " could not be parsed!");
            return new UnparsableRecipeCache();
        }
        return new RecipeCache(isin, w, h);
    }

    @DependentMethodStripper.ModDependent(value={ModList.IC2})
    private static Object[] padIC2CrushedArray(Object[] in, IRecipe ire) throws Exception {
        int[] masks = (int[])ic2MasksField.get(ire);
        int mask = masks[0];
        int w = Math.min(3, shapedIc2Width.getInt(ire));
        int h = Math.min(3, shapedIc2Height.getInt(ire));
        boolean[] flags = ReikaArrayHelper.booleanFromBitflags(mask, w * h);
        ArrayUtils.reverse((boolean[])flags);
        ArrayList li = ReikaJavaLibrary.makeListFromArray(in);
        for (int i = 0; i < flags.length; ++i) {
            if (flags[i]) continue;
            li.add(i, null);
        }
        return li.toArray(new Object[li.size()]);
    }

    public static IRecipe getTEWrappedRecipe(IRecipe ir) {
        if (ModList.THERMALEXPANSION.isLoaded() && ir.getClass() == teNEIClass) {
            try {
                ir = (IRecipe)teNEIWrappedRecipe.get(ir);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ir;
    }

    public static ItemStack getFurnaceInput(ItemStack out) {
        HashMap m = (HashMap)FurnaceRecipes.func_77602_a().func_77599_b();
        for (Object o : m.keySet()) {
            ItemStack in = (ItemStack)o;
            if (!ReikaItemHelper.matchStacks(FurnaceRecipes.func_77602_a().func_151395_a(in), out)) continue;
            return in;
        }
        return null;
    }

    public static void addSmelting(ItemStack in, ItemStack out, float xp) {
        FurnaceRecipes.func_77602_a().func_151394_a(in, out, xp);
    }

    public static boolean addOreRecipe(ItemStack out, Object ... in) {
        ShapedOreRecipe so = new ShapedOreRecipe(out, in);
        boolean allowed = true;
        ArrayList<String> missing = new ArrayList<String>();
        for (int i = 0; i < in.length; ++i) {
            if (!(in[i] instanceof String)) continue;
            String s = (String)in[i];
            if (i <= 0 || !(in[i - 1] instanceof Character) || ReikaItemHelper.oreItemExists(s)) continue;
            allowed = false;
            missing.add(s);
        }
        if (allowed) {
            GameRegistry.addRecipe((IRecipe)so);
        } else {
            DragonAPICore.log("Recipe for " + out.func_82833_r() + " requires missing Ore Dictionary items " + missing + ", and has not been loaded.");
        }
        return allowed;
    }

    public static boolean replaceIngredientInRecipe(ItemStack ingredient, Object replacement, IRecipe ir) {
        return ReikaRecipeHelper.replaceIngredientInRecipe(ingredient, replacement, ir, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean replaceIngredientInRecipe(ItemStack ingredient, Object replacement, IRecipe ir, ReplacementCallback rc) {
        if (ir == null) {
            return false;
        }
        boolean flag = false;
        if (ingredient == null) {
            throw new MisuseException("You cannot replace null in recipes!");
        }
        if (replacement instanceof String) {
            replacement = OreDictionary.getOres((String)((String)replacement));
        }
        if ((ir = ReikaRecipeHelper.getTEWrappedRecipe(ir)) instanceof ShapedRecipes) {
            if (!(replacement instanceof ItemStack)) {
                throw new MisuseException("You cannot put non-single-stack entries into a basic recipe type!");
            }
            if (ReikaItemHelper.matchStacks(ingredient, replacement)) {
                return false;
            }
            ShapedRecipes s = (ShapedRecipes)ir;
            for (int i = 0; i < s.field_77574_d.length; ++i) {
                if (!ReikaItemHelper.matchStacks(ingredient, s.field_77574_d[i])) continue;
                flag = true;
                if (rc != null) {
                    rc.onReplaced(ir, i, s.field_77574_d[i], replacement);
                }
                s.field_77574_d[i] = (ItemStack)replacement;
            }
            return flag;
        } else if (ir instanceof ShapelessRecipes) {
            if (!(replacement instanceof ItemStack)) {
                throw new MisuseException("You cannot put non-single-stack entries into a basic recipe type!");
            }
            if (ReikaItemHelper.matchStacks(ingredient, replacement)) {
                return false;
            }
            ShapelessRecipes s = (ShapelessRecipes)ir;
            List in = s.field_77579_b;
            for (int i = 0; i < in.size(); ++i) {
                if (!ReikaItemHelper.matchStacks(ingredient, (ItemStack)in.get(i))) continue;
                flag = true;
                if (rc != null) {
                    rc.onReplaced(ir, i, in.get(i), replacement);
                }
                in.set(i, (ItemStack)replacement);
            }
            return flag;
        } else if (ir instanceof ShapedOreRecipe) {
            ShapedOreRecipe s = (ShapedOreRecipe)ir;
            Object[] in = s.getInput();
            for (int i = 0; i < in.length; ++i) {
                if (in[i] instanceof ItemStack && ReikaItemHelper.matchStacks(ingredient, (ItemStack)in[i])) {
                    if (replacement instanceof ItemStack && ReikaItemHelper.matchStacks(ingredient, replacement)) continue;
                    flag = true;
                    if (rc != null) {
                        rc.onReplaced(ir, i, in[i], replacement);
                    }
                    in[i] = replacement;
                    continue;
                }
                if (!(in[i] instanceof List) || !ReikaItemHelper.collectionContainsItemStack((List)in[i], ingredient)) continue;
                boolean bl = flag = ((List)in[i]).size() != 1;
                if (rc != null) {
                    rc.onReplaced(ir, i, in[i], replacement);
                }
                in[i] = replacement;
            }
            return flag;
        } else if (ir instanceof ShapelessOreRecipe) {
            ShapelessOreRecipe s = (ShapelessOreRecipe)ir;
            ArrayList in = s.getInput();
            for (int i = 0; i < in.size(); ++i) {
                if (in.get(i) instanceof ItemStack && ReikaItemHelper.matchStacks(ingredient, (ItemStack)in.get(i))) {
                    if (replacement instanceof ItemStack && ReikaItemHelper.matchStacks(ingredient, replacement)) continue;
                    flag = true;
                    if (rc != null) {
                        rc.onReplaced(ir, i, in.get(i), replacement);
                    }
                    in.set(i, replacement);
                    continue;
                }
                if (!(in.get(i) instanceof List) || !ReikaItemHelper.collectionContainsItemStack((List)in.get(i), ingredient)) continue;
                boolean bl = flag = ((List)in.get(i)).size() != 1;
                if (rc != null) {
                    rc.onReplaced(ir, i, in.get(i), replacement);
                }
                in.set(i, replacement);
            }
            return flag;
        } else if (ir.getClass() == ic2ShapedClass) {
            try {
                Object[] in = (Object[])shapedIc2Input.get(ir);
                for (int i = 0; i < in.length; ++i) {
                    if (in[i] instanceof ItemStack && ReikaItemHelper.matchStacks(ingredient, (ItemStack)in[i])) {
                        flag = true;
                        if (rc != null) {
                            rc.onReplaced(ir, i, in[i], replacement);
                        }
                        in[i] = replacement;
                        continue;
                    }
                    if (in[i] instanceof IRecipeInput && ((IRecipeInput)in[i]).matches(ingredient)) {
                        flag = true;
                        if (rc != null) {
                            rc.onReplaced(ir, i, in[i], replacement);
                        }
                        in[i] = replacement;
                        continue;
                    }
                    if (!(in[i] instanceof Iterable)) continue;
                    boolean repl = false;
                    for (Object t : (Iterable)in[i]) {
                        if (t instanceof ItemStack && ReikaItemHelper.matchStacks(ingredient, (ItemStack)t)) {
                            repl = true;
                            break;
                        }
                        if (!(t instanceof IRecipeInput) || !((IRecipeInput)t).matches(ingredient)) continue;
                        repl = true;
                        break;
                    }
                    if (!repl) continue;
                    flag = true;
                    if (rc != null) {
                        rc.onReplaced(ir, i, in[i], replacement);
                    }
                    in[i] = replacement;
                }
                Object[] in2 = (Object[])shapedIc2InputMirror.get(ir);
                if (in2 == null) return flag;
                for (int i = 0; i < in2.length; ++i) {
                    if (in2[i] instanceof ItemStack && ReikaItemHelper.matchStacks(ingredient, (ItemStack)in2[i])) {
                        flag = true;
                        if (rc != null) {
                            rc.onReplaced(ir, i, in2[i], replacement);
                        }
                        in2[i] = replacement;
                        continue;
                    }
                    if (in2[i] instanceof IRecipeInput && ((IRecipeInput)in2[i]).matches(ingredient)) {
                        flag = true;
                        if (rc != null) {
                            rc.onReplaced(ir, i, in2[i], replacement);
                        }
                        in2[i] = replacement;
                        continue;
                    }
                    if (!(in2[i] instanceof Iterable)) continue;
                    boolean repl = false;
                    for (Object o : (Iterable)in2[i]) {
                        if (o instanceof ItemStack && ReikaItemHelper.matchStacks(ingredient, (ItemStack)o)) {
                            repl = true;
                            break;
                        }
                        if (!(o instanceof IRecipeInput) || !((IRecipeInput)o).matches(ingredient)) continue;
                        repl = true;
                        break;
                    }
                    if (!repl) continue;
                    flag = true;
                    if (rc != null) {
                        rc.onReplaced(ir, i, in2[i], replacement);
                    }
                    in2[i] = replacement;
                }
                return flag;
            }
            catch (Exception e) {
                e.printStackTrace();
                return flag;
            }
        } else if (ir.getClass() == ic2ShapelessClass) {
            try {
                Object[] in = (Object[])shapelessIc2Input.get(ir);
                for (int i = 0; i < in.length; ++i) {
                    if (in[i] instanceof ItemStack && ReikaItemHelper.matchStacks(ingredient, (ItemStack)in[i])) {
                        flag = true;
                        if (rc != null) {
                            rc.onReplaced(ir, i, in[i], replacement);
                        }
                        in[i] = replacement;
                        continue;
                    }
                    if (in[i] instanceof IRecipeInput && ((IRecipeInput)in[i]).matches(ingredient)) {
                        flag = true;
                        if (rc != null) {
                            rc.onReplaced(ir, i, in[i], replacement);
                        }
                        in[i] = replacement;
                        continue;
                    }
                    if (!(in[i] instanceof Iterable)) continue;
                    boolean repl = false;
                    for (Object t : (Iterable)in[i]) {
                        if (t instanceof ItemStack && ReikaItemHelper.matchStacks(ingredient, (ItemStack)t)) {
                            repl = true;
                            break;
                        }
                        if (!(t instanceof IRecipeInput) || !((IRecipeInput)t).matches(ingredient)) continue;
                        repl = true;
                        break;
                    }
                    if (!repl) continue;
                    flag = true;
                    if (rc != null) {
                        rc.onReplaced(ir, i, in[i], replacement);
                    }
                    in[i] = replacement;
                }
                return flag;
            }
            catch (Exception e) {
                e.printStackTrace();
                return flag;
            }
        } else if (ir.getClass() == aeShapedClass) {
            try {
                Object[] in = (Object[])shapedAEInput.get(ir);
                for (int i = 0; i < in.length; ++i) {
                    if (in[i] instanceof ItemStack && ReikaItemHelper.matchStacks(ingredient, (ItemStack)in[i])) {
                        if (replacement instanceof ItemStack && ReikaItemHelper.matchStacks(ingredient, replacement)) continue;
                        flag = true;
                        if (rc != null) {
                            rc.onReplaced(ir, i, in[i], replacement);
                        }
                        in[i] = replacement;
                        continue;
                    }
                    if (!(in[i] instanceof List) || !ReikaItemHelper.collectionContainsItemStack((List)in[i], ingredient)) continue;
                    boolean bl = flag = ((List)in[i]).size() != 1;
                    if (rc != null) {
                        rc.onReplaced(ir, i, in[i], replacement);
                    }
                    in[i] = replacement;
                }
                return flag;
            }
            catch (Exception e) {
                e.printStackTrace();
                return flag;
            }
        } else if (ir.getClass() == aeShapelessClass) {
            try {
                ArrayList in = (ArrayList)shapelessAEInput.get(ir);
                for (int i = 0; i < in.size(); ++i) {
                    if (in.get(i) instanceof ItemStack && ReikaItemHelper.matchStacks(ingredient, (ItemStack)in.get(i))) {
                        if (replacement instanceof ItemStack && ReikaItemHelper.matchStacks(ingredient, replacement)) continue;
                        flag = true;
                        if (rc != null) {
                            rc.onReplaced(ir, i, in.get(i), replacement);
                        }
                        in.set(i, replacement);
                        continue;
                    }
                    if (!(in.get(i) instanceof List) || !ReikaItemHelper.collectionContainsItemStack((List)in.get(i), ingredient)) continue;
                    boolean bl = flag = ((List)in.get(i)).size() != 1;
                    if (rc != null) {
                        rc.onReplaced(ir, i, in.get(i), replacement);
                    }
                    in.set(i, replacement);
                }
                return flag;
            }
            catch (Exception e) {
                e.printStackTrace();
                return flag;
            }
        } else {
            if (ir.getClass() != computerTurtleClass) return flag;
            try {
                Item[] in = (Item[])computerTurtleInput.get(ir);
                for (int i = 0; i < 3; ++i) {
                    for (int k = 0; k < 3; ++k) {
                        int idx = i * 3 + k;
                        if (in[idx] != ingredient.func_77973_b()) continue;
                        flag = true;
                        if (rc != null) {
                            rc.onReplaced(ir, i, in[i], replacement);
                        }
                        in[idx] = ((ItemStack)replacement).func_77973_b();
                    }
                }
                return flag;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return flag;
    }

    public static void replaceIngredientInAllRecipes(ItemStack ingredient, ItemStack replacement, boolean makeCopy) {
        if (ingredient == null) {
            throw new MisuseException("You cannot replace null in recipes!");
        }
        ArrayList<Object> copies = new ArrayList<Object>();
        List li = CraftingManager.func_77594_a().func_77592_b();
        for (IRecipe ir : li) {
            int i;
            boolean match;
            ShapedRecipes s;
            if (ir instanceof ShapedRecipes) {
                int i2;
                s = (ShapedRecipes)ir;
                match = false;
                for (i2 = 0; i2 < s.field_77574_d.length; ++i2) {
                    if (!ReikaItemHelper.matchStacks(ingredient, s.field_77574_d[i2])) continue;
                    match = true;
                }
                if (match && makeCopy) {
                    copies.add(new ShapedRecipes(s.field_77576_b, s.field_77577_c, s.field_77574_d, s.func_77571_b()));
                }
                if (!match) continue;
                for (i2 = 0; i2 < s.field_77574_d.length; ++i2) {
                    if (!ReikaItemHelper.matchStacks(ingredient, s.field_77574_d[i2])) continue;
                    s.field_77574_d[i2] = replacement;
                }
                continue;
            }
            if (ir instanceof ShapelessRecipes) {
                int i3;
                s = (ShapelessRecipes)ir;
                match = false;
                List in = s.field_77579_b;
                for (i3 = 0; i3 < in.size(); ++i3) {
                    if (!ReikaItemHelper.matchStacks(ingredient, (ItemStack)in.get(i3))) continue;
                    match = true;
                }
                if (match && makeCopy) {
                    ItemStack[] inarr = new ItemStack[in.size()];
                    for (i = 0; i < inarr.length; ++i) {
                        inarr[i] = (ItemStack)in.get(i);
                    }
                    copies.add(new ShapelessRecipes(s.func_77571_b(), new ArrayList(in)));
                }
                if (!match) continue;
                for (i3 = 0; i3 < in.size(); ++i3) {
                    if (!ReikaItemHelper.matchStacks(ingredient, (ItemStack)in.get(i3))) continue;
                    in.set(i3, replacement);
                }
                continue;
            }
            if (ir instanceof ShapedOreRecipe) {
                int i4;
                s = (ShapedOreRecipe)ir;
                match = false;
                Object[] in = s.getInput();
                for (i4 = 0; i4 < in.length; ++i4) {
                    if (!(in[i4] instanceof ItemStack) || !ReikaItemHelper.matchStacks(ingredient, (ItemStack)in[i4])) continue;
                    match = true;
                }
                if (match && makeCopy) {
                    int h = ReikaRecipeHelper.getOreRecipeHeight((ShapedOreRecipe)s);
                    int w = ReikaRecipeHelper.getOreRecipeWidth((ShapedOreRecipe)s);
                    if (h > 0 && w > 0) {
                        ShapedOreRecipe rec = new ShapedOreRecipe(s.func_77571_b(), new Object[]{Character.valueOf('B'), Blocks.field_150348_b});
                        Object[] items = new Object[in.length];
                        System.arraycopy(in, 0, items, 0, in.length);
                        ReikaRecipeHelper.overwriteShapedOreRecipeInput(rec, items, h, w);
                        copies.add(rec);
                    }
                }
                if (!match) continue;
                for (i4 = 0; i4 < in.length; ++i4) {
                    if (!(in[i4] instanceof ItemStack) || !ReikaItemHelper.matchStacks(ingredient, (ItemStack)in[i4])) continue;
                    in[i4] = replacement;
                }
                continue;
            }
            if (!(ir instanceof ShapelessOreRecipe)) continue;
            s = (ShapelessOreRecipe)ir;
            match = false;
            ArrayList in = s.getInput();
            for (int i5 = 0; i5 < in.size(); ++i5) {
                if (!(in.get(i5) instanceof ItemStack) || !ReikaItemHelper.matchStacks(ingredient, (ItemStack)in.get(i5))) continue;
                match = true;
            }
            if (match && makeCopy) {
                Object[] inarr = new Object[in.size()];
                for (i = 0; i < inarr.length; ++i) {
                    if (in.get(i) instanceof ArrayList) {
                        ItemStack is = (ItemStack)((ArrayList)in.get(i)).get(0);
                        String oreName = OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)is));
                        inarr[i] = oreName;
                        continue;
                    }
                    inarr[i] = in.get(i);
                }
                copies.add(new ShapelessOreRecipe(s.func_77571_b(), inarr));
            }
            if (!match) continue;
            for (int i6 = 0; i6 < in.size(); ++i6) {
                if (!(in.get(i6) instanceof ItemStack) || !ReikaItemHelper.matchStacks(ingredient, (ItemStack)in.get(i6))) continue;
                in.set(i6, replacement);
            }
        }
        CraftingManager.func_77594_a().func_77592_b().addAll(copies);
    }

    public static ShapedRecipes getShapedRecipeFor(ItemStack out, Object ... in) {
        String s = "";
        int i = 0;
        int j = 0;
        int k = 0;
        if (in[i] instanceof String[]) {
            String[] astring = (String[])in[i++];
            for (int l = 0; l < astring.length; ++l) {
                String s1 = astring[l];
                ++k;
                j = s1.length();
                s = s + s1;
            }
        } else {
            while (in[i] instanceof String) {
                String s2 = (String)in[i++];
                ++k;
                j = s2.length();
                s = s + s2;
            }
        }
        HashMap<Character, Object> hashmap = ASMCalls.parseItemMappings(i, false, in);
        ItemStack[] aitemstack = new ItemStack[j * k];
        for (int i1 = 0; i1 < j * k; ++i1) {
            char c0 = s.charAt(i1);
            aitemstack[i1] = hashmap.containsKey(Character.valueOf(c0)) ? ((ItemStack)hashmap.get(Character.valueOf(c0))).func_77946_l() : null;
        }
        ShapedRecipes shapedrecipes = new ShapedRecipes(j, k, aitemstack, out);
        return shapedrecipes;
    }

    public static ArrayList<ItemStack> getAllItemsInRecipe(IRecipe ire) {
        ArrayList<ItemStack> li;
        block6: {
            block8: {
                block7: {
                    block5: {
                        li = new ArrayList<ItemStack>();
                        if (!(ire instanceof ShapedRecipes)) break block5;
                        ShapedRecipes r = (ShapedRecipes)ire;
                        for (int i = 0; i < r.field_77574_d.length; ++i) {
                            li.add(r.field_77574_d[i]);
                        }
                        break block6;
                    }
                    if (!(ire instanceof ShapedOreRecipe)) break block7;
                    ShapedOreRecipe so = (ShapedOreRecipe)ire;
                    Object[] objin = so.getInput();
                    for (int i = 0; i < objin.length; ++i) {
                        if (objin[i] instanceof ItemStack) {
                            li.add((ItemStack)objin[i]);
                            continue;
                        }
                        if (!(objin[i] instanceof ArrayList)) continue;
                        li.addAll((ArrayList)objin[i]);
                    }
                    break block6;
                }
                if (!(ire instanceof ShapelessRecipes)) break block8;
                ShapelessRecipes sr = (ShapelessRecipes)ire;
                li.addAll(sr.field_77579_b);
                break block6;
            }
            if (!(ire instanceof ShapelessOreRecipe)) break block6;
            ShapelessOreRecipe so = (ShapelessOreRecipe)ire;
            for (int i = 0; i < so.func_77570_a(); ++i) {
                Object obj = so.getInput().get(i);
                if (obj instanceof ItemStack) {
                    li.add((ItemStack)obj);
                    continue;
                }
                if (!(obj instanceof ArrayList)) continue;
                li.addAll((ArrayList)obj);
            }
        }
        return li;
    }

    public static int getRecipeIngredientCount(IRecipe recipe) {
        if (recipe instanceof ShapedRecipes) {
            ShapedRecipes r = (ShapedRecipes)recipe;
            int ret = 0;
            for (int i = 0; i < r.field_77574_d.length; ++i) {
                if (r.field_77574_d[i] == null) continue;
                ++ret;
            }
            return ret;
        }
        if (recipe instanceof ShapedOreRecipe) {
            ShapedOreRecipe so = (ShapedOreRecipe)recipe;
            Object[] objin = so.getInput();
            int ret = 0;
            for (int i = 0; i < objin.length; ++i) {
                if (objin[i] == null) continue;
                ++ret;
            }
            return ret;
        }
        if (recipe instanceof ShapelessRecipes) {
            ShapelessRecipes sr = (ShapelessRecipes)recipe;
            return sr.field_77579_b.size();
        }
        if (recipe instanceof ShapelessOreRecipe) {
            ShapelessOreRecipe so = (ShapelessOreRecipe)recipe;
            return so.func_77570_a();
        }
        return -1;
    }

    public static Object[] getInputArrayCopy(IRecipe ire) {
        Object[] out;
        block31: {
            block38: {
                block37: {
                    block36: {
                        block35: {
                            block34: {
                                block33: {
                                    block32: {
                                        block30: {
                                            out = new Object[9];
                                            if (!((ire = ReikaRecipeHelper.getTEWrappedRecipe(ire)) instanceof ShapedRecipes)) break block30;
                                            ShapedRecipes r = (ShapedRecipes)ire;
                                            for (int i = 0; i < Math.min(3, r.field_77576_b); ++i) {
                                                for (int k = 0; k < Math.min(3, r.field_77577_c); ++k) {
                                                    int idx = i + k * r.field_77576_b;
                                                    int idx2 = i + k * 3;
                                                    if (r.field_77574_d[idx] == null) continue;
                                                    out[idx2] = r.field_77574_d[idx].func_77946_l();
                                                }
                                            }
                                            break block31;
                                        }
                                        if (!(ire instanceof ShapedOreRecipe)) break block32;
                                        ShapedOreRecipe so = (ShapedOreRecipe)ire;
                                        Object[] objin = so.getInput();
                                        int w = Math.min(3, ReikaRecipeHelper.getOreRecipeWidth(so));
                                        int h = Math.min(3, ReikaRecipeHelper.getOreRecipeHeight(so));
                                        for (int i = 0; i < w; ++i) {
                                            for (int k = 0; k < h; ++k) {
                                                int idx = i * w + k;
                                                int idx2 = i * 3 + k;
                                                Object o = objin[idx];
                                                if (o instanceof ItemStack) {
                                                    out[idx2] = ((ItemStack)o).func_77946_l();
                                                    continue;
                                                }
                                                if (!(o instanceof List)) continue;
                                                out[idx2] = new ArrayList((List)o);
                                            }
                                        }
                                        break block31;
                                    }
                                    if (!(ire instanceof ShapelessRecipes)) break block33;
                                    ShapelessRecipes sr = (ShapelessRecipes)ire;
                                    for (int i = 0; i < sr.field_77579_b.size(); ++i) {
                                        ItemStack is = (ItemStack)sr.field_77579_b.get(i);
                                        out[i] = is.func_77946_l();
                                    }
                                    break block31;
                                }
                                if (!(ire instanceof ShapelessOreRecipe)) break block34;
                                ShapelessOreRecipe so = (ShapelessOreRecipe)ire;
                                for (int i = 0; i < so.func_77570_a(); ++i) {
                                    Object o = so.getInput().get(i);
                                    if (o instanceof ItemStack) {
                                        out[i] = ((ItemStack)o).func_77946_l();
                                        continue;
                                    }
                                    if (!(o instanceof List)) continue;
                                    out[i] = new ArrayList((List)o);
                                }
                                break block31;
                            }
                            if (ire.getClass() != ic2ShapedClass) break block35;
                            try {
                                Object[] in = (Object[])shapedIc2Input.get(ire);
                                in = ReikaRecipeHelper.padIC2CrushedArray(in, ire);
                                int w = Math.min(3, shapedIc2Width.getInt(ire));
                                int h = Math.min(3, shapedIc2Height.getInt(ire));
                                for (int i = 0; i < w; ++i) {
                                    for (int k = 0; k < h; ++k) {
                                        int idx = i * w + k;
                                        int idx2 = i * 3 + k;
                                        Object o = in[idx];
                                        if (o instanceof ItemStack) {
                                            out[idx2] = ((ItemStack)o).func_77946_l();
                                            continue;
                                        }
                                        if (!(o instanceof List)) continue;
                                        out[idx2] = new ArrayList((List)o);
                                    }
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            break block31;
                        }
                        if (ire.getClass() != ic2ShapelessClass) break block36;
                        try {
                            Object[] in = (Object[])shapelessIc2Input.get(ire);
                            for (int i = 0; i < in.length; ++i) {
                                Object o = in[i];
                                if (o instanceof ItemStack) {
                                    out[i] = ((ItemStack)o).func_77946_l();
                                    continue;
                                }
                                if (!(o instanceof List)) continue;
                                out[i] = new ArrayList((List)o);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break block31;
                    }
                    if (ire.getClass() != aeShapedClass) break block37;
                    try {
                        Object[] in = (Object[])shapedAEInput.get(ire);
                        int w = Math.min(3, shapedAEWidth.getInt(ire));
                        int h = Math.min(3, shapedAEHeight.getInt(ire));
                        for (int i = 0; i < w; ++i) {
                            for (int k = 0; k < h; ++k) {
                                int idx = i * w + k;
                                int idx2 = i * 3 + k;
                                Object o = in[idx];
                                if (o instanceof ItemStack) {
                                    out[idx2] = ((ItemStack)o).func_77946_l();
                                    continue;
                                }
                                if (!(o instanceof List)) continue;
                                out[idx2] = new ArrayList((List)o);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block31;
                }
                if (ire.getClass() != aeShapelessClass) break block38;
                try {
                    List in = (List)shapelessAEInput.get(ire);
                    for (int i = 0; i < in.size(); ++i) {
                        Object o = in.get(i);
                        if (o instanceof ItemStack) {
                            out[i] = ((ItemStack)o).func_77946_l();
                            continue;
                        }
                        if (!(o instanceof List)) continue;
                        out[i] = new ArrayList((List)o);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break block31;
            }
            if (ire.getClass() != computerTurtleClass) break block31;
            try {
                Item[] in = (Item[])computerTurtleInput.get(ire);
                for (int i = 0; i < 3; ++i) {
                    for (int k = 0; k < 3; ++k) {
                        int idx = i * 3 + k;
                        out[idx] = new ItemStack(in[idx]);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return out;
    }

    public static ArrayList<Object> getAllInputsInRecipe(IRecipe ire) {
        ArrayList<Object> li;
        block4: {
            block6: {
                block5: {
                    block3: {
                        li = new ArrayList<Object>();
                        if (!(ire instanceof ShapedRecipes)) break block3;
                        ShapedRecipes r = (ShapedRecipes)ire;
                        for (int i = 0; i < r.field_77574_d.length; ++i) {
                            li.add(r.field_77574_d[i]);
                        }
                        break block4;
                    }
                    if (!(ire instanceof ShapedOreRecipe)) break block5;
                    ShapedOreRecipe so = (ShapedOreRecipe)ire;
                    Object[] objin = so.getInput();
                    for (int i = 0; i < objin.length; ++i) {
                        li.add(objin[i]);
                    }
                    break block4;
                }
                if (!(ire instanceof ShapelessRecipes)) break block6;
                ShapelessRecipes sr = (ShapelessRecipes)ire;
                li.addAll(sr.field_77579_b);
                break block4;
            }
            if (!(ire instanceof ShapelessOreRecipe)) break block4;
            ShapelessOreRecipe so = (ShapelessOreRecipe)ire;
            for (int i = 0; i < so.func_77570_a(); ++i) {
                Object obj = so.getInput().get(i);
                li.add(obj);
            }
        }
        return li;
    }

    public static ArrayList<ItemStack> getMutableOreDictList(String s) {
        ArrayList li = OreDictionary.getOres((String)s);
        ArrayList<ItemStack> clean = new ArrayList<ItemStack>();
        clean.addAll(li);
        return clean;
    }

    public static IRecipe getShapelessRecipeFor(ItemStack out, ItemStack ... in) {
        return new ShapelessRecipes(out.func_77946_l(), (List)ReikaJavaLibrary.makeListFrom(in));
    }

    public static boolean matchArrayToRecipe(ItemStack[] in, IRecipe ir) {
        RecipePattern r = new RecipePattern(in);
        return ir.func_77569_a((InventoryCrafting)r, null);
    }

    public static boolean recipeContains(IRecipe ir, ItemStack is) {
        return ReikaItemHelper.collectionContainsItemStack(ReikaRecipeHelper.getAllItemsInRecipe(ir), is);
    }

    public static Collection<Integer> getRecipeLocationIndices(IRecipe ir, ItemStack is) {
        ArrayList<Integer> c = new ArrayList<Integer>();
        RecipeCache r = ReikaRecipeHelper.getRecipeCacheObject(ir, false);
        if (r instanceof UnparsableRecipeCache) {
            return c;
        }
        for (int i = 0; i < 9; ++i) {
            List li = r.items[i];
            if (li == null || !ReikaItemHelper.collectionContainsItemStack(li, is)) continue;
            c.add(i);
        }
        return c;
    }

    @SideOnly(value=Side.CLIENT)
    public static ItemHashMap<Integer> getItemCountsForDisplay(IRecipe ir) {
        ItemHashMap<Integer> map = new ItemHashMap<Integer>();
        ItemStack[] items = ReikaRecipeHelper.getPermutedRecipeArray(ir);
        if (items == null) {
            return map;
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack is = items[i];
            if (is == null) continue;
            Integer num = map.get(is);
            int n = num != null ? num : 0;
            map.put(is, (Integer)(n + 1));
        }
        return map;
    }

    public static String toString(IRecipe r) {
        if (r == null) {
            return "<NULL>";
        }
        if ((r = ReikaRecipeHelper.getTEWrappedRecipe(r)) instanceof ShapedRecipes) {
            return "Shaped " + Arrays.toString(((ShapedRecipes)r).field_77574_d) + " > " + r.func_77571_b();
        }
        if (r instanceof ShapelessRecipes) {
            return "Shapeless " + ((ShapelessRecipes)r).field_77579_b.toString() + " > " + r.func_77571_b();
        }
        if (r instanceof ShapedOreRecipe) {
            return "Shaped Ore " + Arrays.toString(((ShapedOreRecipe)r).getInput()) + " > " + r.func_77571_b();
        }
        if (r instanceof ShapelessOreRecipe) {
            return "Shapeless Ore " + ((ShapelessOreRecipe)r).getInput().toString() + " > " + r.func_77571_b();
        }
        if (r.getClass() == ic2ShapedClass) {
            try {
                Object[] in = (Object[])shapedIc2Input.get(r);
                return "Shaped IC2 " + Arrays.deepToString(in) + " > " + r.func_77571_b();
            }
            catch (Exception e) {
                e.printStackTrace();
                return e.toString();
            }
        }
        if (r.getClass() == ic2ShapelessClass) {
            try {
                Object[] in = (Object[])shapelessIc2Input.get(r);
                return "Shapeless IC2 " + Arrays.deepToString(in) + " > " + r.func_77571_b();
            }
            catch (Exception e) {
                e.printStackTrace();
                return e.toString();
            }
        }
        if (r.getClass() == aeShapedClass) {
            try {
                Object[] in = (Object[])shapedAEInput.get(r);
                return "Shaped AE " + Arrays.deepToString(in) + " > " + r.func_77571_b();
            }
            catch (Exception e) {
                e.printStackTrace();
                return e.toString();
            }
        }
        if (r.getClass() == aeShapelessClass) {
            try {
                List in = (List)shapelessAEInput.get(r);
                return "Shapeless AE " + in.toString() + " > " + r.func_77571_b();
            }
            catch (Exception e) {
                e.printStackTrace();
                return e.toString();
            }
        }
        if (r.getClass() == computerTurtleClass) {
            try {
                Object[] in = (Item[])computerTurtleInput.get(r);
                return "CC Turtle " + Arrays.deepToString(in) + " > " + r.func_77571_b();
            }
            catch (Exception e) {
                e.printStackTrace();
                return e.toString();
            }
        }
        if (r instanceof CustomToStringRecipe) {
            return ((CustomToStringRecipe)r).toDisplayString();
        }
        return "Unknown '" + r.getClass().getName() + "' > " + r.func_77571_b();
    }

    public static String toDeterministicString(IRecipe r) {
        if (r instanceof ShapedRecipes) {
            Object[] arr = Arrays.copyOf(((ShapedRecipes)r).field_77574_d, ((ShapedRecipes)r).field_77574_d.length);
            return "Shaped " + Arrays.toString(arr) + " > " + r.func_77571_b();
        }
        if (r instanceof ShapelessRecipes) {
            ArrayList li = new ArrayList(((ShapelessRecipes)r).field_77579_b);
            Collections.sort(li, ReikaItemHelper.comparator);
            return "Shapeless " + li.toString() + " > " + r.func_77571_b();
        }
        if (r instanceof ShapedOreRecipe) {
            Object[] arr = Arrays.copyOf(((ShapedOreRecipe)r).getInput(), ((ShapedOreRecipe)r).getInput().length);
            for (int i = 0; i < arr.length; ++i) {
                ArrayList o = arr[i];
                if (!(o instanceof List)) continue;
                o = new ArrayList(o);
                Collections.sort(o, ReikaItemHelper.comparator);
                arr[i] = o;
            }
            return "Shaped Ore " + Arrays.toString(arr) + " > " + r.func_77571_b();
        }
        if (r instanceof ShapelessOreRecipe) {
            ArrayList li = new ArrayList(((ShapelessOreRecipe)r).getInput());
            Collections.sort(li, ReikaItemHelper.itemListComparator);
            for (int i = 0; i < li.size(); ++i) {
                Object o = li.get(i);
                if (!(o instanceof List)) continue;
                o = new ArrayList((List)o);
                Collections.sort((List)o, ReikaItemHelper.comparator);
                li.set(i, o);
            }
            return "Shapeless Ore " + li.toString() + " > " + r.func_77571_b();
        }
        if (r instanceof CustomToStringRecipe) {
            return ((CustomToStringRecipe)r).toDeterministicString();
        }
        return "Unknown '" + r.getClass().getName() + "' > " + r.func_77571_b();
    }

    public static boolean isNonVForgeRecipeClass(IRecipe r) {
        Class<?> c = r.getClass();
        if (c == ShapedRecipes.class || c == ShapelessRecipes.class) {
            return false;
        }
        if (c == RecipeBookCloning.class || c == RecipeFireworks.class || c == RecipesArmor.class || c == RecipesArmorDyes.class) {
            return false;
        }
        if (c == RecipesCrafting.class || c == RecipesDyes.class || c == RecipesFood.class || c == RecipesIngots.class) {
            return false;
        }
        if (c == RecipesMapCloning.class || c == RecipesMapExtending.class || c == RecipesTools.class || c == RecipesWeapons.class) {
            return false;
        }
        return c != ShapedOreRecipe.class && c != ShapelessOreRecipe.class;
    }

    public static boolean verifyRecipe(IRecipe r) {
        Object o;
        Object is;
        int i2;
        Object in;
        if (!ReikaItemHelper.verifyItemStack(r.func_77571_b(), true)) {
            return false;
        }
        if (r instanceof ShapedRecipes) {
            in = ((ShapedRecipes)r).field_77574_d;
            for (i2 = 0; i2 < ((ItemStack[])in).length; ++i2) {
                is = in[i2];
                if (ReikaItemHelper.verifyItemStack((ItemStack)is, false)) continue;
                return false;
            }
        }
        if (r instanceof ShapelessRecipes) {
            in = ((ShapelessRecipes)r).field_77579_b;
            Iterator i2 = in.iterator();
            while (i2.hasNext()) {
                is = (ItemStack)i2.next();
                if (ReikaItemHelper.verifyItemStack((ItemStack)is, false)) continue;
                return false;
            }
        }
        if (r instanceof ShapedOreRecipe) {
            in = ((ShapedOreRecipe)r).getInput();
            for (i2 = 0; i2 < ((Object)in).length; ++i2) {
                o = in[i2];
                if (o instanceof ItemStack) {
                    if (ReikaItemHelper.verifyItemStack((ItemStack)o, false)) continue;
                    return false;
                }
                if (!(o instanceof List)) continue;
                for (ItemStack is2 : (List)o) {
                    if (ReikaItemHelper.verifyItemStack(is2, false)) continue;
                    return false;
                }
            }
        }
        if (r instanceof ShapelessOreRecipe) {
            in = ((ShapelessOreRecipe)r).getInput();
            Iterator iterator = in.iterator();
            while (iterator.hasNext()) {
                o = iterator.next();
                if (o instanceof ItemStack) {
                    if (ReikaItemHelper.verifyItemStack((ItemStack)o, false)) continue;
                    return false;
                }
                if (!(o instanceof List)) continue;
                for (ItemStack is2 : (List)o) {
                    if (ReikaItemHelper.verifyItemStack(is2, false)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static Object[] decode1DArray(Object[] array, int w, int h) {
        if (array.length != w * h) {
            throw new IllegalArgumentException("Recipe size does not match array length!");
        }
        ArrayList<Object> li = new ArrayList<Object>();
        char[][] input = new char[h][w];
        for (int i = 0; i < w; ++i) {
            for (int k = 0; k < h; ++k) {
                char c;
                int idx = i + k * w;
                Object at = ReikaRecipeHelper.parseIngredient(array[idx]);
                input[k][i] = c = at == null ? (char)' ' : (char)(97 + idx);
                if (at == null) continue;
                li.add(Character.valueOf(c));
                li.add(at);
            }
        }
        ArrayList<String> shape = new ArrayList<String>();
        for (char[] line : input) {
            StringBuilder sb = new StringBuilder();
            for (char c : line) {
                sb.append(c);
            }
            shape.add(sb.toString());
        }
        li.addAll(0, shape);
        return li.toArray(new Object[li.size()]);
    }

    public static Object parseIngredient(Object o) {
        if (o instanceof Collection) {
            Collection c = (Collection)o;
            if (c.isEmpty()) {
                throw new IllegalArgumentException("Recipe had an empty collection ingredient?!");
            }
            return ReikaRecipeHelper.getOreNameForCollection(c);
        }
        if (ModList.IC2.isLoaded()) {
            o = ReikaRecipeHelper.parseIc2Ingredient(o);
        }
        if (ModList.APPENG.isLoaded()) {
            o = ReikaRecipeHelper.parseAEIngredient(o);
        }
        return o;
    }

    private static String getOreNameForCollection(Collection<ItemStack> c) {
        ItemStack is = c.iterator().next();
        HashSet<String> set = ReikaItemHelper.getOreNames(is);
        for (ItemStack is2 : c) {
            set.retainAll(ReikaItemHelper.getOreNames(is2));
        }
        if (set.isEmpty()) {
            throw new IllegalArgumentException("Recipe had a collection ingredient, with no shared ore tags?!");
        }
        return set.iterator().next();
    }

    @DependentMethodStripper.ModDependent(value={ModList.IC2})
    private static Object parseIc2Ingredient(Object o) {
        if (o instanceof IRecipeInput) {
            if (o instanceof RecipeInputOreDict) {
                return ((RecipeInputOreDict)o).input;
            }
            List li = ((IRecipeInput)o).getInputs();
            return li.size() == 1 ? li.get(0) : ReikaRecipeHelper.getOreNameForCollection(li);
        }
        return o;
    }

    @DependentMethodStripper.ModDependent(value={ModList.APPENG})
    private static Object parseAEIngredient(Object o) {
        if (o instanceof IAEItemStack) {
            return ((IAEItemStack)o).getItemStack();
        }
        if (o instanceof IIngredient) {
            ItemStack[] is;
            IIngredient ii = (IIngredient)o;
            try {
                is = ii.getItemStackSet();
            }
            catch (Exception e) {
                e.printStackTrace();
                return o;
            }
            if (is.length == 1) {
                return is[0];
            }
            List<ItemStack> li = Arrays.asList(is);
            return ReikaRecipeHelper.getOreNameForCollection(li);
        }
        return o;
    }

    public static Object[] decode2DArray(Object[][] array) {
        int i;
        String[] input = new String[array.length];
        ArrayList<String> objects = new ArrayList<String>();
        ArrayList<Object> entries = new ArrayList<Object>();
        for (i = 0; i < array.length; ++i) {
            StringBuilder sb = new StringBuilder();
            for (int k = 0; k < array[i].length; ++k) {
                Object o = array[i][k];
                char c = o == null ? (char)' ' : (char)(97 + (i * 3 + k));
                sb.append(String.valueOf(c));
                if (o == null) continue;
                entries.add(Character.valueOf(c));
                entries.add(o);
            }
            input[i] = sb.toString();
        }
        for (i = 0; i < input.length; ++i) {
            objects.add(input[i]);
        }
        objects.addAll(entries);
        return objects.toArray(new Object[objects.size()]);
    }

    public static ItemStack getShapelessCraftResult(ItemStack ... in) {
        if (in.length > 9) {
            throw new MisuseException("Too many input items!");
        }
        RecipePattern ic = new RecipePattern(in);
        return CraftingManager.func_77594_a().func_82787_a((InventoryCrafting)ic, ReikaWorldHelper.getBasicReferenceWorld());
    }

    public static IRecipe convertRecipeToOre(IRecipe ire) {
        if ((ire = ReikaRecipeHelper.getTEWrappedRecipe(ire)) instanceof ShapedRecipes) {
            ShapedRecipes r = (ShapedRecipes)ire;
            return new ShapedOreRecipe(ire.func_77571_b(), ReikaRecipeHelper.decode1DArray(r.field_77574_d, r.field_77576_b, r.field_77577_c));
        }
        if (ire instanceof ShapelessRecipes) {
            ShapelessRecipes sr = (ShapelessRecipes)ire;
            List in = sr.field_77579_b;
            Object[] ingredients = new Object[in.size()];
            for (int i = 0; i < in.size(); ++i) {
                ingredients[i] = ReikaRecipeHelper.parseIngredient(in.get(i));
            }
            return new ShapelessOreRecipe(ire.func_77571_b(), ingredients);
        }
        return ire;
    }

    @Deprecated
    public static IRecipe copyRecipe(IRecipe ire) {
        try {
            ire = ReikaRecipeHelper.getTEWrappedRecipe(ire);
            if (ire instanceof ShapedRecipes) {
                ShapedRecipes r = (ShapedRecipes)ire;
                return ReikaRecipeHelper.getShapedRecipeFor(ire.func_77571_b(), ReikaRecipeHelper.decode1DArray(r.field_77574_d, r.field_77576_b, r.field_77577_c));
            }
            if (ire instanceof ShapedOreRecipe) {
                ShapedOreRecipe so = (ShapedOreRecipe)ire;
                return new ShapedOreRecipe(ire.func_77571_b(), ReikaRecipeHelper.decode1DArray(so.getInput(), ReikaRecipeHelper.getOreRecipeWidth(so), ReikaRecipeHelper.getOreRecipeHeight(so)));
            }
            if (ire instanceof ShapelessRecipes) {
                ShapelessRecipes sr = (ShapelessRecipes)ire;
                return new ShapelessRecipes(ire.func_77571_b(), new ArrayList(sr.field_77579_b));
            }
            if (ire instanceof ShapelessOreRecipe) {
                ShapelessOreRecipe sr = (ShapelessOreRecipe)ire;
                ArrayList in = sr.getInput();
                Object[] ingredients = new Object[in.size()];
                for (int i = 0; i < in.size(); ++i) {
                    ingredients[i] = ReikaRecipeHelper.parseIngredient(in.get(i));
                }
                return new ShapelessOreRecipe(ire.func_77571_b(), ingredients);
            }
            if (ire.getClass() == ic2ShapedClass) {
                try {
                    Object[] in = (Object[])shapedIc2Input.get(ire);
                    in = ReikaRecipeHelper.padIC2CrushedArray(in, ire);
                    int w = shapedIc2Width.getInt(ire);
                    int h = shapedIc2Height.getInt(ire);
                    if (w * h != in.length) {
                        DragonAPICore.logError("Error parsing IC2 recipe: input array does not match reported height and width values!");
                    }
                    return new ShapedOreRecipe(ire.func_77571_b(), ReikaRecipeHelper.decode1DArray(in, w, h));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (ire.getClass() == ic2ShapelessClass) {
                try {
                    Object[] in = (Object[])shapelessIc2Input.get(ire);
                    Object[] ingredients = new Object[in.length];
                    for (int i = 0; i < in.length; ++i) {
                        ingredients[i] = ReikaRecipeHelper.parseIngredient(in[i]);
                    }
                    return new ShapelessOreRecipe(ire.func_77571_b(), ingredients);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (ire.getClass() == aeShapedClass) {
                try {
                    Object[] in = (Object[])shapedAEInput.get(ire);
                    int w = shapedAEWidth.getInt(ire);
                    int h = shapedAEHeight.getInt(ire);
                    return new ShapedOreRecipe(ire.func_77571_b(), ReikaRecipeHelper.decode1DArray(in, w, h));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (ire.getClass() == aeShapelessClass) {
                try {
                    ArrayList in = (ArrayList)shapelessAEInput.get(ire);
                    Object[] ingredients = new Object[in.size()];
                    for (int i = 0; i < in.size(); ++i) {
                        ingredients[i] = ReikaRecipeHelper.parseIngredient(in.get(i));
                    }
                    return new ShapelessOreRecipe(ire.func_77571_b(), ingredients);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (ire.getClass() == computerTurtleClass) {
                try {
                    Object[] in = (Item[])computerTurtleInput.get(ire);
                    return ReikaRecipeHelper.getShapedRecipeFor(ire.func_77571_b(), ReikaRecipeHelper.decode1DArray(in, 3, 3));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            DragonAPICore.logError("Could not copy recipe " + ReikaRecipeHelper.toString(ire));
            e.printStackTrace();
        }
        return null;
    }

    public static boolean matchRecipes(IRecipe r1, IRecipe r2) {
        if (r1 == null && r2 == null) {
            return true;
        }
        if (r1 == null || r2 == null) {
            return false;
        }
        if (r1.getClass() != r2.getClass()) {
            return false;
        }
        r1 = ReikaRecipeHelper.getTEWrappedRecipe(r1);
        r2 = ReikaRecipeHelper.getTEWrappedRecipe(r2);
        if (!ItemStack.func_77989_b((ItemStack)r1.func_77571_b(), (ItemStack)r2.func_77571_b())) {
            return false;
        }
        if (r1 instanceof ShapedRecipes) {
            ShapedRecipes sr1 = (ShapedRecipes)r1;
            ShapedRecipes sr2 = (ShapedRecipes)r2;
            return ReikaItemHelper.matchStackCollections(Arrays.asList(sr1.field_77574_d), Arrays.asList(sr2.field_77574_d));
        }
        if (r1 instanceof ShapedOreRecipe) {
            ShapedOreRecipe so1 = (ShapedOreRecipe)r1;
            ShapedOreRecipe so2 = (ShapedOreRecipe)r2;
            return ReikaRecipeHelper.matchIngredientCollections(Arrays.asList(so1.getInput()), Arrays.asList(so2.getInput()));
        }
        if (r1 instanceof ShapelessRecipes) {
            ShapelessRecipes sr1 = (ShapelessRecipes)r1;
            ShapelessRecipes sr2 = (ShapelessRecipes)r2;
            return ReikaItemHelper.matchStackCollections(sr1.field_77579_b, sr2.field_77579_b);
        }
        if (r1 instanceof ShapelessOreRecipe) {
            ShapelessOreRecipe sr1 = (ShapelessOreRecipe)r1;
            ShapelessOreRecipe sr2 = (ShapelessOreRecipe)r2;
            return ReikaRecipeHelper.matchIngredientCollections(sr1.getInput(), sr2.getInput());
        }
        if (r1.getClass() == ic2ShapedClass) {
            try {
                Object[] in1 = (Object[])shapedIc2Input.get(r1);
                Object[] in2 = (Object[])shapedIc2Input.get(r2);
                return ReikaRecipeHelper.matchIngredientCollections(Arrays.asList(in1), Arrays.asList(in2));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (r1.getClass() == ic2ShapelessClass) {
            try {
                Object[] in1 = (Object[])shapelessIc2Input.get(r1);
                Object[] in2 = (Object[])shapelessIc2Input.get(r2);
                return ReikaRecipeHelper.matchIngredientCollections(Arrays.asList(in1), Arrays.asList(in2));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (r1.getClass() == aeShapedClass) {
            try {
                Object[] in1 = (Object[])shapedAEInput.get(r1);
                Object[] in2 = (Object[])shapedAEInput.get(r2);
                return ReikaRecipeHelper.matchIngredientCollections(Arrays.asList(in1), Arrays.asList(in2));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (r1.getClass() == aeShapelessClass) {
            try {
                List in1 = (List)shapelessAEInput.get(r1);
                List in2 = (List)shapelessAEInput.get(r2);
                return ReikaRecipeHelper.matchIngredientCollections(in1, in2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (r1.getClass() == computerTurtleClass) {
            try {
                Item[] in1 = (Item[])computerTurtleInput.get(r1);
                Item[] in2 = (Item[])computerTurtleInput.get(r2);
                if (in1.length != in2.length) {
                    return false;
                }
                for (int i = 0; i < in1.length; ++i) {
                    if (in1[i] == in2[i]) continue;
                    return false;
                }
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private static boolean matchIngredientCollections(List<Object> input, List<Object> input2) {
        if (input.size() != input2.size()) {
            return false;
        }
        for (int i = 0; i < input.size(); ++i) {
            Object o1 = input.get(i);
            Object o2 = input2.get(i);
            if (o1 == null && o2 == null) continue;
            if (o1 == null || o2 == null) {
                return false;
            }
            if (o1.getClass() != o2.getClass()) {
                return false;
            }
            if (!(o1 instanceof ItemStack ? !ReikaItemHelper.matchStacks((ItemStack)o1, (ItemStack)o2) : !o1.equals(o2))) continue;
            return false;
        }
        return true;
    }

    public static double getRecipeSimilarityValue(IRecipe r1, IRecipe r2) {
        if (r1.getClass() != r2.getClass()) {
            return 0.0;
        }
        double score = 0.0;
        if (r1 instanceof ShapedRecipes) {
            ShapedRecipes sr1 = (ShapedRecipes)r1;
            ShapedRecipes sr2 = (ShapedRecipes)r2;
            if (sr1.field_77577_c != sr2.field_77577_c || sr1.field_77576_b != sr2.field_77576_b) {
                return 0.0;
            }
            for (int i = 0; i < sr1.field_77576_b; ++i) {
                for (int k = 0; k < sr1.field_77577_c; ++k) {
                    ItemStack is1 = sr1.field_77574_d[i + k * sr1.field_77576_b];
                    ItemStack is2 = sr2.field_77574_d[i + k * sr2.field_77576_b];
                    if (!ReikaItemHelper.matchStacks(is1, is2)) continue;
                    score += 5.0;
                }
            }
            return score / (double)(sr1.field_77577_c * sr1.field_77576_b);
        }
        if (r1 instanceof ShapedOreRecipe) {
            ShapedOreRecipe so1 = (ShapedOreRecipe)r1;
            ShapedOreRecipe so2 = (ShapedOreRecipe)r2;
            int h1 = ReikaRecipeHelper.getOreRecipeHeight(so1);
            int w1 = ReikaRecipeHelper.getOreRecipeWidth(so1);
            if (h1 != ReikaRecipeHelper.getOreRecipeHeight(so2) || w1 != ReikaRecipeHelper.getOreRecipeWidth(so2)) {
                return 0.0;
            }
            for (int i = 0; i < w1; ++i) {
                for (int k = 0; k < h1; ++k) {
                    Object is2;
                    Object is1 = so1.getInput()[i + k * w1];
                    if (is1 == (is2 = so2.getInput()[i + k * w1])) {
                        score += 5.0;
                    }
                    if (is1 == null || is2 == null || is1.getClass() != is2.getClass()) continue;
                    if (is1 instanceof ItemStack) {
                        if (!ReikaItemHelper.matchStacks((ItemStack)is1, (ItemStack)is2)) continue;
                        score += 5.0;
                        continue;
                    }
                    if (!(is1 instanceof Collection)) continue;
                    Collection c1 = (Collection)is1;
                    Collection c2 = (Collection)is2;
                    HashSet<KeyedItemStack> s1 = new HashSet<KeyedItemStack>();
                    HashSet<KeyedItemStack> s2 = new HashSet<KeyedItemStack>();
                    for (ItemStack is : c1) {
                        s1.add(new KeyedItemStack(is).setIgnoreNBT(true).setSized(false).setIgnoreMetadata(false).setSimpleHash(true));
                    }
                    for (ItemStack is : c2) {
                        s2.add(new KeyedItemStack(is).setIgnoreNBT(true).setSized(false).setIgnoreMetadata(false).setSimpleHash(true));
                    }
                    if (!s1.equals(s2)) continue;
                    score += 5.0;
                }
            }
            return score / (double)(h1 * w1);
        }
        if (r1 instanceof ShapelessRecipes) {
            ShapelessRecipes sr1 = (ShapelessRecipes)r1;
            ShapelessRecipes sr2 = (ShapelessRecipes)r2;
            ArrayList c1 = new ArrayList(sr1.field_77579_b);
            ArrayList c2 = new ArrayList(sr2.field_77579_b);
            ArrayList lg = c1.size() > c2.size() ? c1 : c2;
            ArrayList sm = c1.size() > c2.size() ? c2 : c1;
            for (ItemStack is : lg) {
                int idx = ReikaItemHelper.getIndexOf(sm, is);
                if (idx < 0) continue;
                score += 5.0;
                sm.remove(idx);
            }
            return score / (double)lg.size();
        }
        if (r1 instanceof ShapelessOreRecipe) {
            ShapelessOreRecipe sr1 = (ShapelessOreRecipe)r1;
            ShapelessOreRecipe sr2 = (ShapelessOreRecipe)r2;
            ArrayList c1 = new ArrayList(sr1.getInput());
            ArrayList c2 = new ArrayList(sr2.getInput());
            ArrayList lg = c1.size() > c2.size() ? c1 : c2;
            ArrayList sm = c1.size() > c2.size() ? c2 : c1;
            for (Object o : lg) {
                int idx = -1;
                idx = o instanceof ItemStack ? ReikaItemHelper.getIndexOf(sm, (ItemStack)o) : sm.indexOf(o);
                if (idx < 0) continue;
                score += 5.0;
                sm.remove(idx);
            }
            return score / (double)lg.size();
        }
        return 0.0;
    }

    public static Object[] parseMinetweakerInput(String rec) {
        rec = rec.replace(" ", "").replace("<", "").replace(">", "");
        String[] parts = rec.split("[\\\\[,\\\\]]");
        ArrayList<String> li = new ArrayList<String>();
        for (String s : parts) {
            if ((s = s.replace("[", "").replace("]", "")).isEmpty()) continue;
            li.add(s);
        }
        parts = li.toArray(new String[li.size()]);
        Object[] ret = new Object[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            String s = parts[i];
            if (s.equals("null")) continue;
            ret[i] = s.startsWith("ore:") ? s.substring(4) : ReikaItemHelper.lookupItem(s);
        }
        return ret;
    }

    public static Object[] createRecipeArgsFromShapeAndMats(Object[] mats, String ... shape) {
        ArrayList li = ReikaJavaLibrary.makeListFrom(shape);
        for (Object o : mats) {
            li.add(o);
        }
        return li.toArray(new Object[li.size()]);
    }

    static {
        try {
            shapedOreHeight = ShapedOreRecipe.class.getDeclaredField("height");
            shapedOreWidth = ShapedOreRecipe.class.getDeclaredField("width");
            shapedOreInput = ShapedOreRecipe.class.getDeclaredField("input");
            shapedOreHeight.setAccessible(true);
            shapedOreWidth.setAccessible(true);
            shapedOreInput.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (ModList.IC2.isLoaded()) {
            try {
                ic2ShapedClass = Class.forName("ic2.core.AdvRecipe");
                ic2ShapelessClass = Class.forName("ic2.core.AdvShapelessRecipe");
                shapedIc2Input = ic2ShapedClass.getDeclaredField("input");
                shapedIc2Input.setAccessible(true);
                shapedIc2Width = ic2ShapedClass.getDeclaredField("inputWidth");
                shapedIc2Width.setAccessible(true);
                shapedIc2Height = ic2ShapedClass.getDeclaredField("inputHeight");
                shapedIc2Height.setAccessible(true);
                shapedIc2InputMirror = ic2ShapedClass.getDeclaredField("inputMirrored");
                shapedIc2InputMirror.setAccessible(true);
                ic2MasksField = ic2ShapedClass.getDeclaredField("masks");
                ic2MasksField.setAccessible(true);
                shapelessIc2Input = ic2ShapelessClass.getDeclaredField("input");
                shapelessIc2Input.setAccessible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
                DragonAPICore.logError("Could not load IC2 recipe handling!");
                ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)ModList.IC2, e);
            }
        }
        if (ModList.THERMALEXPANSION.isLoaded()) {
            try {
                teNEIClass = Class.forName("cofh.thermalexpansion.plugins.nei.handlers.NEIRecipeWrapper");
                teNEIWrappedRecipe = teNEIClass.getDeclaredField("recipe");
                teNEIWrappedRecipe.setAccessible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
                DragonAPICore.logError("Could not load TE recipe handling!");
                ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)ModList.THERMALEXPANSION, e);
            }
        }
        if (ModList.COMPUTERCRAFT.isLoaded()) {
            try {
                computerTurtleClass = Class.forName("dan200.computercraft.shared.turtle.recipes.TurtleRecipe");
                computerTurtleInput = computerTurtleClass.getDeclaredField("m_recipe");
                computerTurtleInput.setAccessible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
                DragonAPICore.logError("Could not load ComputerCraft recipe handling!");
                ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)ModList.COMPUTERCRAFT, e);
            }
        }
        if (ModList.APPENG.isLoaded()) {
            try {
                aeShapedClass = Class.forName("appeng.recipes.game.ShapedRecipe");
                aeShapelessClass = Class.forName("appeng.recipes.game.ShapelessRecipe");
                shapedAEInput = aeShapedClass.getDeclaredField("input");
                shapedAEInput.setAccessible(true);
                shapedAEWidth = aeShapedClass.getDeclaredField("width");
                shapedAEWidth.setAccessible(true);
                shapedAEHeight = aeShapedClass.getDeclaredField("height");
                shapedAEHeight.setAccessible(true);
                shapelessAEInput = aeShapelessClass.getDeclaredField("input");
                shapelessAEInput.setAccessible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
                DragonAPICore.logError("Could not load AE recipe handling!");
                ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)ModList.APPENG, e);
            }
        }
        if (Loader.isModLoaded((String)"fairylights")) {
            try {
                fairyComponentClass = Class.forName("com.pau101.fairylights.item.crafting.RecipeDyeColorNBT");
                fairyComponentInput = fairyComponentClass.getDeclaredField("recipeItems");
                fairyComponentInput.setAccessible(true);
                fairyComponentOutput = fairyComponentClass.getDeclaredField("recipeOutput");
                fairyComponentOutput.setAccessible(true);
                fairyComponentHeight = fairyComponentClass.getDeclaredField("recipeHeight");
                fairyComponentHeight.setAccessible(true);
                fairyComponentWidth = fairyComponentClass.getDeclaredField("recipeWidth");
                fairyComponentWidth.setAccessible(true);
                fairyStringClass = Class.forName("com.pau101.fairylights.item.crafting.RecipeFairyLights");
                fairyStringInput = fairyStringClass.getDeclaredField("recipeItems");
                fairyStringInput.setAccessible(true);
                fairyStringOutput = fairyStringClass.getDeclaredField("recipeOutput");
                fairyStringOutput.setAccessible(true);
                fairyStringHeight = fairyStringClass.getDeclaredField("recipeHeight");
                fairyStringHeight.setAccessible(true);
                fairyStringWidth = fairyStringClass.getDeclaredField("recipeWidth");
                fairyStringWidth.setAccessible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
                DragonAPICore.logError("Could not load FairyLights recipe handling!");
                ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)new BasicModEntry("fairylights"), e);
            }
        }
    }

    public static interface ReplacementCallback {
        public void onReplaced(IRecipe var1, int var2, Object var3, Object var4);
    }

    private static class UnparsableRecipeCache
    extends RecipeCache {
        private UnparsableRecipeCache() {
            super(new List[0], 0, 0);
        }
    }

    private static class RecipeCache {
        private final List<ItemStack>[] items;
        private final int width;
        private final int height;

        private RecipeCache(List<ItemStack>[] items, int w, int h) {
            this.items = items;
            this.width = w;
            this.height = h;
        }
    }
}

