/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.Rendering;

import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.TexturedQuad;
import net.minecraftforge.common.util.ForgeDirection;

public class ReikaModelHelper {
    public static void flipUVs(ModelRenderer part, boolean x, boolean y, boolean z) {
        for (Object o : part.field_78804_l) {
            ReikaModelHelper.flipUVs((ModelBox)o, x, y, z);
        }
        if (part.field_78805_m != null) {
            for (Object o : part.field_78805_m) {
                ReikaModelHelper.flipUVs((ModelRenderer)o, x, y, z);
            }
        }
    }

    public static void flipUVs(ModelBox box, boolean x, boolean y, boolean z) {
        boolean[] doFlip = new boolean[]{y || z, y || z, x || z, x || z, x || y, x || y};
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            if (!(dir.offsetX == 0 && x || dir.offsetY == 0 && y) && (dir.offsetZ != 0 || !z)) continue;
            ReikaModelHelper.flipFace(ReikaModelHelper.getFace(box, dir), dir, x, y, z);
        }
    }

    private static TexturedQuad getFace(ModelBox box, ForgeDirection face) {
        int idx = -1;
        switch (face) {
            case EAST: {
                idx = 0;
                break;
            }
            case WEST: {
                idx = 1;
                break;
            }
            case DOWN: {
                idx = 2;
                break;
            }
            case UP: {
                idx = 3;
                break;
            }
            case NORTH: {
                idx = 4;
                break;
            }
            case SOUTH: {
                idx = 5;
                break;
            }
        }
        return idx >= 0 ? box.field_78254_i[idx] : null;
    }

    private static void flipFace(TexturedQuad quad, ForgeDirection face, boolean x, boolean y, boolean z) {
        switch (face) {
            case DOWN: 
            case UP: {
                float temp;
                if (x) {
                    temp = quad.field_78239_a[0].field_78241_b;
                    quad.field_78239_a[0].field_78241_b = quad.field_78239_a[2].field_78241_b;
                    quad.field_78239_a[2].field_78241_b = temp;
                }
                if (!z) break;
                temp = quad.field_78239_a[0].field_78242_c;
                quad.field_78239_a[0].field_78242_c = quad.field_78239_a[2].field_78242_c;
                quad.field_78239_a[2].field_78242_c = temp;
                break;
            }
            case EAST: 
            case WEST: {
                float temp;
                if (z) {
                    temp = quad.field_78239_a[0].field_78241_b;
                    quad.field_78239_a[0].field_78241_b = quad.field_78239_a[2].field_78241_b;
                    quad.field_78239_a[2].field_78241_b = temp;
                }
                if (!y) break;
                temp = quad.field_78239_a[1].field_78242_c;
                quad.field_78239_a[1].field_78242_c = quad.field_78239_a[3].field_78242_c;
                quad.field_78239_a[3].field_78242_c = temp;
                break;
            }
            case NORTH: 
            case SOUTH: {
                float temp;
                if (x) {
                    temp = quad.field_78239_a[0].field_78241_b;
                    quad.field_78239_a[0].field_78241_b = quad.field_78239_a[2].field_78241_b;
                    quad.field_78239_a[2].field_78241_b = temp;
                }
                if (!y) break;
                temp = quad.field_78239_a[1].field_78242_c;
                quad.field_78239_a[1].field_78242_c = quad.field_78239_a[3].field_78242_c;
                quad.field_78239_a[3].field_78242_c = temp;
            }
        }
        quad.field_78239_a[1].field_78241_b = quad.field_78239_a[2].field_78241_b;
        quad.field_78239_a[3].field_78241_b = quad.field_78239_a[0].field_78241_b;
        quad.field_78239_a[1].field_78242_c = quad.field_78239_a[0].field_78242_c;
        quad.field_78239_a[3].field_78242_c = quad.field_78239_a[2].field_78242_c;
    }
}

