/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.DeepInteract;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Extras.ReplacementSmeltingHandler;
import Reika.DragonAPI.IO.ReikaFileReader;
import Reika.DragonAPI.Instantiable.Data.Collections.OneWayCollections;
import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Instantiable.Event.MTReloadEvent;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.Registry.ReikaDyeHelper;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import minetweaker.util.IEventHandler;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import org.apache.commons.codec.Charsets;

public final class MTInteractionManager {
    public static final MTInteractionManager instance = new MTInteractionManager();
    private final OneWayCollections.OneWayMap<Prevention, OneWayCollections.OneWayMap<KeyedItemStack, String>> data = new OneWayCollections.OneWayMap();
    private final Method reloadMethod;

    private MTInteractionManager() {
        if (!MTInteractionManager.isMTLoaded()) {
            this.reloadMethod = null;
            return;
        }
        Method rl = null;
        Method rlw = null;
        try {
            Class<?> api = Class.forName("minetweaker.MineTweakerImplementationAPI");
            rl = MTInteractionManager.getReloadMethod(api);
            rlw = api.getDeclaredMethod("onReloadEvent", IEventHandler.class);
            rlw.setAccessible(true);
            rlw.invoke(null, new PreReloadHandler());
            rlw = api.getDeclaredMethod("onPostReload", IEventHandler.class);
            rlw.setAccessible(true);
            rlw.invoke(null, new PostReloadHandler());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.reloadMethod = rl;
    }

    private static Method getReloadMethod(Class api) {
        String[] names = new String[]{"reload", "reloadScripts", "reloadAllScripts", "rebuild", "rebuildScripts", "rebuildAllScripts"};
        for (int i = 0; i < names.length; ++i) {
            try {
                Method m = api.getDeclaredMethod(names[i], new Class[0]);
                m.setAccessible(true);
                return m;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        return null;
    }

    public void scanAndRevert() {
        this.scanAndRemove();
        this.reloadMT();
    }

    private void scanAndRemove() {
        if (!DragonAPICore.isSinglePlayer()) {
            ArrayList<File> files = this.getFiles();
            for (File f : files) {
                this.parseFile(f);
            }
        }
    }

    private void parseFile(File f) {
        for (Prevention p : this.data.keySet()) {
            MTScriptScanner scan = new MTScriptScanner(p, f);
            scan.performChanges(f, Charsets.UTF_8);
            if (scan.extraComments.isEmpty()) continue;
            scan.setPhase2();
            scan.performChanges(f, Charsets.UTF_8);
        }
    }

    public void reloadMT() {
        if (this.reloadMethod == null) {
            return;
        }
        try {
            this.reloadMethod.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ArrayList<File> getFiles() {
        String main = System.getProperty("user.dir").replaceAll("\\\\", "/");
        File folder = new File(main + "/scripts");
        return ReikaFileReader.getAllFilesInFolder(folder, ".zs");
    }

    public void blacklistNewRecipesFor(ItemStack is) {
        this.addEntry(Prevention.NEWRECIPE, is, false, true);
    }

    public void blacklistNewRecipesFor(Block i) {
        this.addEntry(Prevention.NEWRECIPE, new ItemStack(i), true, true);
    }

    public void blacklistNewRecipesFor(Item i) {
        this.addEntry(Prevention.NEWRECIPE, new ItemStack(i), true, true);
    }

    public void blacklistNewRecipesFor(ItemStack is, boolean ignoreMetadata, boolean ignoreNBT) {
        this.addEntry(Prevention.NEWRECIPE, is, ignoreMetadata, ignoreNBT);
    }

    public void blacklistRecipeRemovalFor(ItemStack is) {
        this.addEntry(Prevention.REMOVERECIPE, is, false, true);
    }

    public void blacklistRecipeRemovalFor(Block i) {
        this.addEntry(Prevention.REMOVERECIPE, new ItemStack(i), true, true);
    }

    public void blacklistRecipeRemovalFor(Item i) {
        this.addEntry(Prevention.REMOVERECIPE, new ItemStack(i), true, true);
    }

    public void blacklistRecipeRemovalFor(ItemStack is, boolean ignoreMetadata, boolean ignoreNBT) {
        this.addEntry(Prevention.REMOVERECIPE, is, ignoreMetadata, ignoreNBT);
    }

    public void blacklistOreDictTagsFor(ItemStack is) {
        this.addEntry(Prevention.OREDICT, is, false, true);
    }

    public void blacklistOreDictTagsFor(Block i) {
        this.addEntry(Prevention.OREDICT, new ItemStack(i), true, true);
    }

    public void blacklistOreDictTagsFor(Item i) {
        this.addEntry(Prevention.OREDICT, new ItemStack(i), true, true);
    }

    public void blacklistOreDictTagsFor(ItemStack is, boolean ignoreMetadata, boolean ignoreNBT) {
        this.addEntry(Prevention.OREDICT, is, ignoreMetadata, ignoreNBT);
    }

    private void addEntry(Prevention p, ItemStack is, boolean ignoreMetadata, boolean ignoreNBT) {
        if (is == null || is.func_77973_b() == null) {
            throw new MisuseException("Cannot block MT scripts on null items!");
        }
        ModContainer mc = Loader.instance().activeModContainer();
        if (mc == null) {
            throw new MisuseException("Cannot block MT scripts from outside a mod!");
        }
        GameRegistry.UniqueIdentifier id = GameRegistry.findUniqueIdentifierFor((Item)is.func_77973_b());
        if (id == null) {
            throw new MisuseException("Cannot block MT scripts for non-mod items!");
        }
        if (!mc.getModId().equalsIgnoreCase(id.modId)) {
            throw new MisuseException("Cannot block MT scripts on items from another mod!");
        }
        OneWayCollections.OneWayMap<KeyedItemStack, String> li = (OneWayCollections.OneWayMap<KeyedItemStack, String>)this.data.get((Object)p);
        if (li == null) {
            li = new OneWayCollections.OneWayMap<KeyedItemStack, String>();
            this.data.put(p, li);
        }
        KeyedItemStack ks = new KeyedItemStack(is);
        ks.setIgnoreMetadata(ignoreMetadata);
        ks.setIgnoreNBT(ignoreNBT);
        ks.setSimpleHash(true);
        ks.lock();
        if (li.containsKey(ks)) {
            for (Map.Entry e : li.entrySet()) {
                KeyedItemStack key = (KeyedItemStack)e.getKey();
                if (!key.equals(ks) || !key.contains(ks)) continue;
                DragonAPICore.log("Note: This item, '" + is.func_82833_r() + "' (" + ks + "), is already listed, but under the wider tag " + key + ".");
                return;
            }
        }
        li.put(ks, mc.getModId());
    }

    public static boolean isMTLoaded() {
        try {
            return Class.forName("minetweaker.MineTweakerImplementationAPI") != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private class PostReloadHandler
    implements IEventHandler {
        private PostReloadHandler() {
        }

        public void handle(Object r) {
            ReplacementSmeltingHandler.applyMinetweakerChanges();
            ReikaDyeHelper.buildItemCache();
            MinecraftForge.EVENT_BUS.post((Event)new MTReloadEvent(TickEvent.Phase.END));
        }
    }

    private class PreReloadHandler
    implements IEventHandler {
        private PreReloadHandler() {
        }

        public void handle(Object r) {
            instance.scanAndRemove();
            ReplacementSmeltingHandler.prepareForMinetweakerChanges();
            MinecraftForge.EVENT_BUS.post((Event)new MTReloadEvent(TickEvent.Phase.START));
        }
    }

    private static final class MTScriptScanner
    extends ReikaFileReader.LineEditor {
        private final OneWayCollections.OneWayMap<KeyedItemStack, String> set;
        private final OneWayCollections.OneWayMap<String, OneWayCollections.OneWaySet<MTItemEntry>> variables = new OneWayCollections.OneWayMap();
        private String lastItemMod;
        private final File script;
        private final Prevention protectionType;
        private int commentBlockStart;
        private String partialLine;
        private final HashSet<String> extraComments = new HashSet();
        private boolean phase2;

        private MTScriptScanner(Prevention p, File f) {
            this.set = (OneWayCollections.OneWayMap)instance.data.get((Object)p);
            this.script = f;
            this.protectionType = p;
        }

        private void setPhase2() {
            this.phase2 = true;
        }

        @Override
        protected String getReplacementLine(String s, String newline, int idx) {
            if (this.phase2) {
                return "//" + s;
            }
            return "//" + s + newline + "//The above line(s) was/were commented out because the mod registering the item for which a recipeis being added or removed (" + this.lastItemMod + ") has requested not to allow changes of that form. See your logs for moreinformation, including on who to go to if you have further questions.";
        }

        @Override
        public boolean editLine(String s, int idx) {
            if (this.phase2) {
                return this.extraComments.contains(s);
            }
            s = ReikaStringParser.stripSpaces(s);
            boolean flag = false;
            if (!(s = this.parseOutCommentedSections(s, idx)).isEmpty()) {
                try {
                    flag = this.parseLine(s);
                }
                catch (Exception e) {
                    DragonAPICore.logError("Error parsing line '" + this.getOriginalLine(idx) + "' in '" + this.script.getName() + "':");
                    e.printStackTrace();
                    return false;
                }
                if (flag) {
                    DragonAPICore.log("The line '" + s + "' has been commented out of the Minetweaker script, as " + this.lastItemMod + " has requested to disallow such actions. This is NOT a bug in either that mod or Minetweaker; do not botherStanHebben with it. You may ask the developer of " + this.lastItemMod + " for further questions or to request aremoval. Be civil.");
                }
            }
            return flag;
        }

        private String parseOutCommentedSections(String s, int lineNum) {
            int idx;
            while (s.contains("/*") && s.contains("*/")) {
                if (s.indexOf("/*") < s.indexOf("*/")) {
                    int idx1 = s.indexOf("/*");
                    int idx2 = s.indexOf("*/") + 2;
                    String p1 = s.substring(0, idx1);
                    String p2 = s.substring(idx2);
                    s = p1 + p2;
                    continue;
                }
                if (this.partialLine == null) {
                    this.partialLine = "";
                }
                this.partialLine = this.partialLine + s.substring(s.indexOf("*/") + 2, s.indexOf("/*"));
                if (this.commentBlockStart == 0) {
                    this.commentBlockStart = lineNum;
                }
                s = "";
            }
            if (s.contains("/*")) {
                idx = s.indexOf("/*");
                this.partialLine = s.substring(0, idx);
                this.commentBlockStart = lineNum;
                return "";
            }
            if (s.contains("*/")) {
                idx = s.indexOf("*/") + 2;
                String ret = this.partialLine + s.substring(idx);
                if (this.commentBlockStart != 0) {
                    for (int i = this.commentBlockStart; i < lineNum; ++i) {
                        this.extraComments.add(this.getOriginalLine(i));
                    }
                }
                this.commentBlockStart = 0;
                this.partialLine = null;
                return ret;
            }
            return this.partialLine != null ? "" : s;
        }

        private boolean parseLine(String s) {
            if (s.startsWith("//") || s.startsWith("##")) {
                return false;
            }
            if (s.startsWith("val") || s.startsWith("var")) {
                int eq = s.indexOf("=");
                if (eq >= 0) {
                    String name = s.substring(3, eq);
                    int lb = s.indexOf(60);
                    int rb = s.indexOf(62);
                    if (lb >= 0 && rb >= 0) {
                        MTItemEntry val = new MTItemEntry(s.substring(lb + 1, rb));
                        OneWayCollections.OneWaySet<MTItemEntry> set = (OneWayCollections.OneWaySet<MTItemEntry>)this.variables.get(name);
                        if (set == null) {
                            set = new OneWayCollections.OneWaySet<MTItemEntry>();
                            this.variables.put(name, set);
                        }
                        set.add(val);
                    }
                }
                return false;
            }
            int period = s.indexOf(46);
            if (period >= 0) {
                return this.parseTruncLine(s.substring(0, period - 1), s.substring(period + 1));
            }
            return false;
        }

        private void logError(String s, String desc) {
            DragonAPICore.logError("Note that an invalid line has been found in your MT script '" + this.script.getName() + "':");
            DragonAPICore.logError("The line '" + s + "' " + desc + " Consider fixing this.");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean parseTruncLine(String pre, String s) {
            if (s.toLowerCase().startsWith("add")) {
                if (!s.toLowerCase().contains("ore:")) return this.parse(s, Prevention.NEWRECIPE);
                this.parse(s, Prevention.OREDICT);
                return false;
            } else {
                if (!s.toLowerCase().startsWith("remove")) return false;
                return this.parse(s, Prevention.REMOVERECIPE);
            }
        }

        private boolean parse(String s, Prevention p) {
            if (p != this.protectionType) {
                return false;
            }
            int lb = s.indexOf(60);
            int rb = s.indexOf(62);
            OneWayCollections.OneWaySet<MTItemEntry> items = new OneWayCollections.OneWaySet<MTItemEntry>();
            if (lb >= 0 && rb >= 0) {
                items.add(new MTItemEntry(s.substring(lb + 1, rb)));
            } else {
                int lp = s.indexOf(40);
                int lc = s.indexOf(44);
                if (lp < 0 || lc < 0) {
                    return false;
                }
                String tag = s.substring(lp + 1, lc);
                OneWayCollections.OneWaySet var = (OneWayCollections.OneWaySet)this.variables.get(tag);
                if (var != null) {
                    items.addAll(var);
                }
            }
            for (MTItemEntry item : items) {
                KeyedItemStack ks = item.asKeyStack();
                if (ks == null) continue;
                ks.setSimpleHash(true).lock();
                String mod = (String)this.set.get(ks);
                if (mod == null) continue;
                this.lastItemMod = mod;
                return true;
            }
            this.lastItemMod = "[null]";
            return false;
        }
    }

    private static final class MTItemEntry {
        private final String id;
        private final int meta;

        public MTItemEntry(String item) {
            String[] parts = item.split(":");
            int m = 0;
            boolean metapar = false;
            try {
                m = Integer.parseInt(parts[parts.length - 1]);
                metapar = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.meta = m;
            this.id = metapar ? item.substring(0, item.lastIndexOf(58)) : item;
        }

        public int hashCode() {
            return this.id.hashCode() ^ this.meta;
        }

        public boolean equals(Object o) {
            if (o instanceof MTItemEntry) {
                MTItemEntry mt = (MTItemEntry)o;
                return this.id.equals(mt.id) && mt.meta == this.meta;
            }
            return false;
        }

        private KeyedItemStack asKeyStack() {
            Item item = (Item)Item.field_150901_e.func_82594_a(this.id);
            if (item == null) {
                return null;
            }
            KeyedItemStack ks = new KeyedItemStack(new ItemStack(item, 1, this.meta)).setSimpleHash(true).lock();
            return ks;
        }

        public String toString() {
            return this.id + "%" + this.meta;
        }
    }

    private static enum Prevention {
        NEWRECIPE,
        REMOVERECIPE,
        OREDICT;

    }
}

