/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.DeepInteract;

import Reika.DragonAPI.Auxiliary.Trackers.ReflectiveFailureTracker;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Maps.TierMap;
import Reika.DragonAPI.Instantiable.Formula.MathExpression;
import Reika.DragonAPI.Instantiable.IO.XMLInterface;
import Reika.DragonAPI.Interfaces.ObjectToNBTSerializer;
import Reika.DragonAPI.Interfaces.Registry.ModEntry;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.ReikaRecipeHelper;
import Reika.DragonAPI.ModInteract.CustomThaumResearch;
import Reika.DragonAPI.ModInteract.ItemHandlers.ThaumIDHandler;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.crafting.ShapedArcaneRecipe;
import thaumcraft.api.crafting.ShapelessArcaneRecipe;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.api.research.ResearchPage;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.api.wands.WandCap;
import thaumcraft.api.wands.WandRod;
import thaumcraft.common.entities.monster.EntityWisp;

public class ReikaThaumHelper {
    private static Map<String, ArrayList<String>> research;
    private static Map<String, AspectList> aspects;
    private static Map<String, ArrayList<String>> scannedObjects;
    private static Map<String, ArrayList<String>> scannedEntities;
    private static Map<String, ArrayList<String>> scannedPhenomena;
    private static Map<String, Integer> playerWarp;
    private static Map<String, Integer> playerStickyWarp;
    private static Map<String, Integer> playerTempWarp;
    private static Method addWandVis;
    private static Method getWandVis;
    private static Method maxWandVis;
    private static Method setWandInUse;
    private static Method clearWandInUse;
    private static Method researchComplete;
    private static Method completeResearch;
    private static Method getData;
    private static Method createNote;
    private static Method getMix;
    private static Field dataKey;
    private static Field dataComplete;
    private static SimpleNetworkWrapper packetHandlerInstance;
    private static Constructor<IMessage> aspectPacketConstructor;
    private static Field wispTarget;
    private static Class alchemicalFurnaceClass;
    private static Field furnaceBurn;
    private static Field itemBurn;
    private static Object proxy;
    private static Field researchManager;
    private static final TierMap<Aspect> aspectTiers;
    private static final HashSet<String> nativeCategories;
    public static final ObjectToNBTSerializer<Aspect> aspectSerializer;

    public static void addAspects(ItemStack is, AspectList aspects) {
        AspectList has = (AspectList)ThaumcraftApi.objectTags.get(Arrays.asList(is.func_77973_b(), is.func_77960_j()));
        if (has != null) {
            for (Aspect as : has.aspects.keySet()) {
                aspects.merge(as, has.getAmount(as));
            }
        }
        ReikaThaumHelper.clearNullAspects(aspects);
        ThaumcraftApi.registerObjectTag((ItemStack)is, (int[])new int[]{is.func_77960_j()}, (AspectList)aspects);
        DragonAPICore.log("Registering " + is + " aspects " + ReikaThaumHelper.aspectsToString(aspects));
    }

    public static void addAspectsToBlock(Block b, AspectList aspects) {
        ReikaThaumHelper.addAspects(new ItemStack(b), aspects);
    }

    public static void addAspectsToBlockMeta(Block b, int meta, AspectList aspects) {
        ReikaThaumHelper.addAspects(new ItemStack(b, 1, meta), aspects);
    }

    public static void addAspectsToItem(Item i, AspectList aspects) {
        ReikaThaumHelper.addAspects(new ItemStack(i), aspects);
    }

    public static void addAspectsToItemMeta(Item id, int meta, AspectList aspects) {
        ReikaThaumHelper.addAspects(new ItemStack(id, 1, meta), aspects);
    }

    public static void addAspects(ItemStack is, Object ... aspects) {
        if (aspects.length % 2 != 0) {
            DragonAPICore.logError("Could not add aspects to " + is + ": You must specify a level for every aspect!");
            ReikaJavaLibrary.dumpStack();
            return;
        }
        AspectList has = (AspectList)ThaumcraftApi.objectTags.get(Arrays.asList(is.func_77973_b(), is.func_77960_j()));
        AspectList ot = ReikaThaumHelper.getAspectList(aspects);
        if (has != null) {
            for (Aspect as : has.aspects.keySet()) {
                ot.merge(as, has.getAmount(as));
            }
        }
        ReikaThaumHelper.clearNullAspects(ot);
        ThaumcraftApi.registerObjectTag((ItemStack)is, (AspectList)ot);
        DragonAPICore.log("Registering " + is + " aspects " + ReikaThaumHelper.aspectsToString(ot));
    }

    public static void addAspectsToBlock(Block b, Object ... aspects) {
        ReikaThaumHelper.addAspects(new ItemStack(b), aspects);
    }

    public static void addAspectsToBlockMeta(Block b, int meta, Object ... aspects) {
        ReikaThaumHelper.addAspects(new ItemStack(b, 1, meta), aspects);
    }

    public static void addAspectsToItem(Item i, Object ... aspects) {
        ReikaThaumHelper.addAspects(new ItemStack(i), aspects);
    }

    public static void addAspectsToItemMeta(Item id, int meta, Object ... aspects) {
        ReikaThaumHelper.addAspects(new ItemStack(id, 1, meta), aspects);
    }

    public static void clearAspects(ItemStack is) {
        AspectList ot = new AspectList();
        ThaumcraftApi.registerObjectTag((ItemStack)is, (int[])new int[]{is.func_77960_j()}, (AspectList)ot);
    }

    public static void addAspects(Class<? extends Entity> entity, Object ... aspects) {
        AspectList ot = ReikaThaumHelper.getAspectList(aspects);
        String name = (String)EntityList.field_75626_c.get(entity);
        ThaumcraftApi.registerEntityTag((String)name, (AspectList)ot, (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
    }

    private static AspectList getAspectList(Object ... aspects) {
        AspectList ot = new AspectList();
        try {
            for (int i = 0; i < aspects.length; i += 2) {
                Aspect a = null;
                Object seek = aspects[i];
                if (seek instanceof Aspect) {
                    a = (Aspect)seek;
                } else if (seek instanceof String) {
                    a = Aspect.getAspect((String)((String)seek));
                }
                if (a != null) {
                    ot.add(a, ((Integer)aspects[i + 1]).intValue());
                    continue;
                }
                DragonAPICore.logError("Cannot generate aspect from input '" + seek + "'!");
            }
        }
        catch (ClassCastException e) {
            DragonAPICore.logError("Invalid parameters! Could not generate aspect list from " + Arrays.toString(aspects) + "!");
            e.printStackTrace();
        }
        return ot;
    }

    public static void clearNullAspects(AspectList al) {
        al.aspects.remove(null);
    }

    public static String aspectsToString(AspectList al) {
        if (al == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (Aspect a : al.aspects.keySet()) {
            if (a == null) {
                sb.append("<NULL>");
            } else {
                int amt = al.getAmount(a);
                sb.append(a.getTag() + "=" + amt);
            }
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public static boolean hasPlayerDiscoveredAspect(EntityPlayer ep, Aspect a) {
        if (!ModList.THAUMCRAFT.isLoaded()) {
            return false;
        }
        if (a.isPrimal()) {
            return true;
        }
        AspectList al = aspects.get(ep.func_70005_c_());
        return al != null && al.aspects.containsKey(a);
    }

    public static Collection<Aspect> getAllDiscoveredAspects(EntityPlayer ep) {
        ArrayList<Aspect> li = new ArrayList<Aspect>();
        if (!ModList.THAUMCRAFT.isLoaded()) {
            return li;
        }
        AspectList al = aspects.get(ep.func_70005_c_());
        if (al != null) {
            li.addAll(al.aspects.keySet());
        }
        return li;
    }

    public static Collection<? extends Aspect> getAllAspects() {
        return Aspect.aspects.values();
    }

    public static void sortAspectList(ArrayList<Aspect> list) {
        Collections.sort(list, new AspectSorter());
    }

    public static void clearScannedObjects(EntityPlayer ep) {
        if (!ModList.THAUMCRAFT.isLoaded()) {
            return;
        }
        String s = ep.func_70005_c_();
        scannedObjects.remove(s);
        scannedEntities.remove(s);
        scannedPhenomena.remove(s);
    }

    public static void clearResearch(EntityPlayer ep) {
        if (!ModList.THAUMCRAFT.isLoaded()) {
            return;
        }
        research.remove(ep.func_70005_c_());
    }

    public static void clearDiscoveredAspects(EntityPlayer ep) {
        if (!ModList.THAUMCRAFT.isLoaded()) {
            return;
        }
        aspects.remove(ep.func_70005_c_());
    }

    public static int getResearchPoolCount(EntityPlayer ep, Aspect a) {
        if (!ModList.THAUMCRAFT.isLoaded()) {
            return 0;
        }
        AspectList al = aspects.get(ep.func_70005_c_());
        return al.getAmount(a);
    }

    public static void giveResearchPoint(Aspect a, short amt, EntityPlayer ep) {
        if (!ModList.THAUMCRAFT.isLoaded()) {
            return;
        }
        AspectList get = aspects.get(ep.func_70005_c_());
        if (get == null) {
            get = new AspectList();
            aspects.put(ep.func_70005_c_(), get);
        }
        get.add(a, (int)amt);
        if (ep instanceof EntityPlayerMP) {
            ReikaThaumHelper.sendAspectGetPacket((EntityPlayerMP)ep, a, amt);
        }
    }

    private static void sendAspectGetPacket(EntityPlayerMP ep, Aspect a, short amt) {
        try {
            short total = (short)ReikaThaumHelper.getResearchPoolCount((EntityPlayer)ep, a);
            IMessage pkt = aspectPacketConstructor.newInstance(a.getTag(), amt, total);
            packetHandlerInstance.sendTo(pkt, ep);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void giveWarpProtection(EntityPlayer ep, int time) {
        if (!ModList.THAUMCRAFT.isLoaded()) {
            return;
        }
        ep.func_70690_d(new PotionEffect(ThaumIDHandler.Potions.WARPWARD.getID(), time, 0));
    }

    public static void removeWarp(EntityPlayer ep) {
        playerWarp.remove(ep.func_70005_c_());
        playerTempWarp.remove(ep.func_70005_c_());
    }

    public static void removeWarp(EntityPlayer ep, int amt) {
        int left;
        if (!ModList.THAUMCRAFT.isLoaded()) {
            return;
        }
        String s = ep.func_70005_c_();
        int temphas = ReikaThaumHelper.getPlayerTempWarp(ep);
        int rem = 0;
        if (temphas > 0) {
            rem = Math.min(temphas, amt);
            if (temphas - rem > 0) {
                playerTempWarp.put(s, temphas - rem);
            } else {
                playerTempWarp.remove(s);
            }
        }
        if ((left = amt - rem) > 0) {
            int has;
            int stickhas = ReikaThaumHelper.getPlayerStickyWarp(ep);
            if (stickhas > 0) {
                int rem2 = Math.min(stickhas, left);
                if (stickhas - rem2 > 0) {
                    playerStickyWarp.put(s, stickhas - rem2);
                } else {
                    playerStickyWarp.remove(s);
                }
                left -= rem2;
            }
            if (left > 0 && (has = ReikaThaumHelper.getPlayerWarp(ep)) > 0) {
                int rem2 = Math.min(has, left);
                if (has - rem2 > 0) {
                    playerWarp.put(s, has - rem2);
                } else {
                    playerWarp.remove(s);
                }
            }
        }
    }

    public static int getPlayerWarp(EntityPlayer ep) {
        Integer has = playerWarp.get(ep.func_70005_c_());
        return has != null ? has : 0;
    }

    public static int getPlayerStickyWarp(EntityPlayer ep) {
        Integer has = playerStickyWarp.get(ep.func_70005_c_());
        return has != null ? has : 0;
    }

    public static int getPlayerTempWarp(EntityPlayer ep) {
        Integer has = playerTempWarp.get(ep.func_70005_c_());
        return has != null ? has : 0;
    }

    public static void addPlayerWarp(EntityPlayer ep, int amt) {
        Integer has = playerWarp.get(ep.func_70005_c_());
        int val = has != null ? has : 0;
        playerWarp.put(ep.func_70005_c_(), val + amt);
    }

    public static void addPlayerStickyWarp(EntityPlayer ep, int amt) {
        Integer has = playerStickyWarp.get(ep.func_70005_c_());
        int val = has != null ? has : 0;
        playerStickyWarp.put(ep.func_70005_c_(), val + amt);
    }

    public static void addPlayerTempWarp(EntityPlayer ep, int amt) {
        Integer has = playerTempWarp.get(ep.func_70005_c_());
        int val = has != null ? has : 0;
        playerTempWarp.put(ep.func_70005_c_(), val + amt);
    }

    public static int getWandSpaceFor(ItemStack wand, Aspect a) {
        if (!ModList.THAUMCRAFT.isLoaded()) {
            return 0;
        }
        return ReikaThaumHelper.getVisCapacityForWand(wand) - ReikaThaumHelper.getVisInWand(wand).getAmount(a);
    }

    public static int getVisCapacityForWand(ItemStack wand) {
        if (!ModList.THAUMCRAFT.isLoaded()) {
            return 0;
        }
        try {
            return (Integer)maxWandVis.invoke((Object)wand.func_77973_b(), wand);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static AspectList getVisInWand(ItemStack wand) {
        if (!ModList.THAUMCRAFT.isLoaded()) {
            return null;
        }
        try {
            return (AspectList)getWandVis.invoke((Object)wand.func_77973_b(), wand);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int addVisToWand(ItemStack wand, Aspect a, int amt) {
        if (!ModList.THAUMCRAFT.isLoaded()) {
            return 0;
        }
        try {
            return (Integer)addWandVis.invoke((Object)wand.func_77973_b(), wand, a, amt, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static void setWandInUse(ItemStack wand, TileEntity te) {
        if (!ModList.THAUMCRAFT.isLoaded()) {
            return;
        }
        try {
            setWandInUse.invoke((Object)wand.func_77973_b(), wand, te.field_145851_c, te.field_145848_d, te.field_145849_e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void clearWandInUse(ItemStack wand) {
        if (!ModList.THAUMCRAFT.isLoaded()) {
            return;
        }
        try {
            clearWandInUse.invoke((Object)wand.func_77973_b(), wand);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static AspectList decompose(Aspect a) {
        AspectList al = new AspectList();
        if (a.isPrimal()) {
            al.add(a, 1);
        } else {
            HashMap<Aspect, Integer> map = ReikaThaumHelper.getAspectDecomposition(a);
            for (Aspect a2 : map.keySet()) {
                al.add(a2, map.get(a2).intValue());
            }
        }
        return al;
    }

    public static AspectList decompose(AspectList complex) {
        AspectList al = new AspectList();
        for (Aspect a : complex.aspects.keySet()) {
            int amt = complex.getAmount(a);
            if (a.isPrimal()) {
                al.add(a, amt);
                continue;
            }
            HashMap<Aspect, Integer> map = ReikaThaumHelper.getAspectDecomposition(a);
            for (Aspect a2 : map.keySet()) {
                al.add(a2, amt * map.get(a2));
            }
        }
        return al;
    }

    public static HashMap<Aspect, Integer> getAspectDecomposition(Aspect a) {
        HashMap<Aspect, Integer> map = new HashMap<Aspect, Integer>();
        ReikaThaumHelper.addAspectDecomposition(a, map);
        return map;
    }

    private static void addAspectDecomposition(Aspect a, HashMap<Aspect, Integer> map) {
        Integer get = map.get(a);
        if (get == null) {
            get = 0;
        }
        if (a.isPrimal()) {
            map.put(a, get + 1);
        } else {
            Aspect[] parents = a.getComponents();
            for (int i = 0; i < parents.length; ++i) {
                ReikaThaumHelper.addAspectDecomposition(parents[i], map);
            }
        }
    }

    public static String getResearchForItem(ItemStack is) {
        try {
            Object data = getData.invoke(null, is);
            return (String)dataKey.get(data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isResearchComplete(EntityPlayer ep, String research) {
        return ThaumcraftApiHelper.isResearchComplete((String)ep.func_70005_c_(), (String)research);
    }

    public static boolean hasResearchPrereqs(EntityPlayer ep, String research) {
        for (String p : ResearchCategories.getResearch((String)research).parents) {
            if (ThaumcraftApiHelper.isResearchComplete((String)ep.func_70005_c_(), (String)p)) continue;
            return false;
        }
        return true;
    }

    public static void completeResearch(EntityPlayer ep, String research) {
        try {
            completeResearch.invoke(ReikaThaumHelper.getResearchManager(), ep, research);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isNativeThaumResearch(ResearchItem ri) {
        return nativeCategories.contains(ri.category);
    }

    private static Object getResearchManager() throws Exception {
        return researchManager.get(proxy);
    }

    public static void addBookCategory(ResourceLocation icon, String name) {
        ResourceLocation rl2 = new ResourceLocation("thaumcraft", "textures/gui/gui_researchback.png");
        ResearchCategories.registerCategory((String)name, (ResourceLocation)icon, (ResourceLocation)rl2);
    }

    public static void addBookCategory(ResourceLocation icon, String name, String tex) {
        ResourceLocation rl2 = DragonAPICore.getDirectResource(tex);
        ResearchCategories.registerCategory((String)name, (ResourceLocation)icon, (ResourceLocation)rl2);
    }

    public static ResearchItem addBasicBookEntryViaXML(DragonAPIMod mod, String id, String name, String desc, String category, AspectList aspects, int row, int col, Class root, String path, ResourceLocation ico) {
        CustomThaumResearch res = new CustomThaumResearch(id, category, aspects, col, row, 0, ico).setName(name);
        res.setDescription(desc);
        XMLResearch xml = new XMLResearch(mod, id.toLowerCase(Locale.ENGLISH), root, path);
        res.setPages(xml.getPages());
        return res.registerResearchItem();
    }

    public static ResearchItem addInfusionRecipeBookEntryViaXML(DragonAPIMod mod, String id, String desc, String category, InfusionRecipe ir, MathExpression cost, int row, int col, Class root, String path) {
        ItemStack out = (ItemStack)ir.getRecipeOutput();
        AspectList aspects = new AspectList();
        for (Aspect a : ir.getAspects().aspects.keySet()) {
            int amt = cost != null ? (int)cost.evaluate(ir.getAspects().getAmount(a)) : ir.getAspects().getAmount(a);
            aspects.add(a, Math.max(1, amt));
        }
        String name = out.func_82833_r();
        CustomThaumResearch res = new CustomThaumResearch(id, category, aspects, col, row, 0, out).setName(name);
        res.setDescription(desc);
        XMLResearch xml = new XMLResearch(mod, id.toLowerCase(Locale.ENGLISH), root, path, ir);
        res.setPages(xml.getPages());
        return res.registerResearchItem();
    }

    public static ResearchItem addCrucibleRecipeBookEntryViaXML(DragonAPIMod mod, String id, String desc, String category, CrucibleRecipe ir, MathExpression cost, int row, int col, Class root, String path) {
        ItemStack out = ir.getRecipeOutput();
        AspectList aspects = new AspectList();
        for (Aspect a : ir.aspects.aspects.keySet()) {
            aspects.add(a, Math.max(1, (int)cost.evaluate(ir.aspects.getAmount(a))));
        }
        String name = out.func_82833_r();
        CustomThaumResearch res = new CustomThaumResearch(id, category, aspects, col, row, 0, out).setName(name);
        res.setDescription(desc);
        XMLResearch xml = new XMLResearch(mod, id.toLowerCase(Locale.ENGLISH), root, path, ir);
        res.setPages(xml.getPages());
        return res.registerResearchItem();
    }

    public static ResearchItem addArcaneRecipeBookEntryViaXML(DragonAPIMod mod, String id, String desc, String category, IArcaneRecipe ir, MathExpression cost, int row, int col, Class root, String path) {
        ItemStack out = ir.getRecipeOutput();
        AspectList aspects = new AspectList();
        for (Aspect a : ir.getAspects().aspects.keySet()) {
            aspects.add(a, Math.max(1, (int)cost.evaluate(ir.getAspects().getAmount(a))));
        }
        String name = out.func_82833_r();
        CustomThaumResearch res = new CustomThaumResearch(id, category, aspects, col, row, 0, out).setName(name);
        res.setDescription(desc);
        XMLResearch xml = new XMLResearch(mod, id.toLowerCase(Locale.ENGLISH), root, path, ir);
        res.setPages(xml.getPages());
        return res.registerResearchItem();
    }

    public static ResearchItem addResearchForMultipleRecipesViaXML(DragonAPIMod mod, String name, ItemStack icon, String id, String desc, String category, Class root, String path, int row, int col, Object[] recipes, AspectList al) {
        XMLResearch xml = ReikaThaumHelper.getResearchForMultipleRecipes(mod, id.toLowerCase(Locale.ENGLISH), root, path, recipes);
        CustomThaumResearch res = new CustomThaumResearch(id, category, al, col, row, 0, icon).setName(name);
        res.setDescription(desc);
        res.setPages(xml.getPages());
        return res.registerResearchItem();
    }

    private static XMLResearch getResearchForMultipleRecipes(DragonAPIMod mod, String name, Class root, String path, Object[] recipes) {
        XMLResearch res = new XMLResearch(mod, name, root, path);
        for (Object r : recipes) {
            res.addRecipePage(r);
        }
        return res;
    }

    public static void setWispHostility(EntityWisp e, EntityLivingBase tg) {
        try {
            wispTarget.set(e, tg);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static Entity getWispHostility(EntityWisp e) {
        try {
            return (Entity)wispTarget.get(e);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void triggerEffect(EffectType type, Object ... data) {
        try {
            type.call.invoke(proxy, data);
        }
        catch (Exception e) {
            DragonAPICore.logError("Error Triggering ThaumCraft Effect: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static int getAspectTier(Aspect a) {
        if (aspectTiers.isEmpty()) {
            ReikaThaumHelper.buildAspectTiers();
        }
        return aspectTiers.getTier(a);
    }

    public static Set<Aspect> getAspectsByTier(int t) {
        if (aspectTiers.isEmpty()) {
            ReikaThaumHelper.buildAspectTiers();
        }
        return aspectTiers.getByTier(t);
    }

    public static int getMaxAspectTier() {
        if (aspectTiers.isEmpty()) {
            ReikaThaumHelper.buildAspectTiers();
        }
        return aspectTiers.getMaxTier();
    }

    private static void buildAspectTiers() {
        for (Aspect aspect : ReikaThaumHelper.getAllAspects()) {
            if (aspectTiers.containsKey(aspect)) continue;
            aspectTiers.addObject(aspect, ReikaThaumHelper.calculateAspectTier(aspect));
        }
    }

    private static int calculateAspectTier(Aspect a) {
        if (a.isPrimal()) {
            return 0;
        }
        Aspect[] parents = a.getComponents();
        int maxt = 0;
        for (Aspect a2 : parents) {
            int t2 = aspectTiers.getTier(a2);
            if (t2 == -1) {
                t2 = ReikaThaumHelper.calculateAspectTier(a2);
                aspectTiers.addObject(a2, t2);
            }
            maxt = Math.max(maxt, t2);
        }
        return maxt + 1;
    }

    public static void programResearchNote(ItemStack is, String key, World world) {
        try {
            createNote.invoke(null, is, key, world);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Aspect getAspectCombinationResult(Aspect a1, Aspect a2) {
        try {
            return (Aspect)getMix.invoke(null, a1, a2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ShapelessOreRecipe getShapelessArcaneAsShapelessRecipe(ShapelessArcaneRecipe r) {
        return new ShapelessOreRecipe(r.getRecipeOutput(), new Object[]{r.getInput()});
    }

    public static ShapedOreRecipe getShapedArcaneAsShapedRecipe(ShapedArcaneRecipe r) {
        return new ShapedOreRecipe(r.getRecipeOutput(), ReikaRecipeHelper.decode1DArray(r.input, r.width, r.height));
    }

    public static boolean isAlchemicalFurnace(TileEntity te) {
        return te != null && te.getClass() == alchemicalFurnaceClass;
    }

    public static void setAlchemicalBurnTime(TileEntity te, int ticks) {
        try {
            furnaceBurn.setInt(te, ticks);
            itemBurn.setInt(te, ticks);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addSmeltingBonusWithStackSize(ItemStack in, ItemStack out) {
        try {
            Field f = ThaumcraftApi.class.getDeclaredField("smeltingBonus");
            f.setAccessible(true);
            HashMap map = (HashMap)f.get(null);
            List<Object> key = Arrays.asList(in.func_77973_b(), in.func_77960_j());
            map.put(key, out.func_77946_l());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean aspectListContains(AspectList list, AspectList has) {
        for (Aspect a : has.aspects.keySet()) {
            if (list.getAmount(a) >= has.getAmount(a)) continue;
            return false;
        }
        return true;
    }

    public static ItemFocusBasic getWandFocus(ItemStack is) {
        if (is.field_77990_d == null || !is.field_77990_d.func_74764_b("focus")) {
            return null;
        }
        ItemStack stored = ItemStack.func_77949_a((NBTTagCompound)is.field_77990_d.func_74775_l("focus"));
        return stored != null && stored.func_77973_b() instanceof ItemFocusBasic ? (ItemFocusBasic)stored.func_77973_b() : null;
    }

    public static ItemStack getWandFocusStack(ItemStack is) {
        if (is.field_77990_d == null || !is.field_77990_d.func_74764_b("focus")) {
            return null;
        }
        return ItemStack.func_77949_a((NBTTagCompound)is.field_77990_d.func_74775_l("focus"));
    }

    public static WandRod getWandRod(ItemStack is) {
        String key = is != null && is.field_77990_d != null && is.field_77990_d.func_74764_b("rod") ? is.field_77990_d.func_74779_i("rod") : "wood";
        return (WandRod)WandRod.rods.get(key);
    }

    public static WandCap getWandCap(ItemStack is) {
        String key = is != null && is.field_77990_d != null && is.field_77990_d.func_74764_b("cap") ? is.field_77990_d.func_74779_i("cap") : "iron";
        return (WandCap)WandCap.caps.get(key);
    }

    static {
        aspectTiers = new TierMap();
        nativeCategories = new HashSet();
        aspectSerializer = new ObjectToNBTSerializer<Aspect>(){

            @Override
            public NBTTagCompound save(Aspect obj) {
                NBTTagCompound ret = new NBTTagCompound();
                ret.func_74778_a("aspect", obj.getTag());
                return ret;
            }

            @Override
            public Aspect construct(NBTTagCompound tag) {
                return Aspect.getAspect((String)tag.func_74779_i("aspect"));
            }
        };
        if (ModList.THAUMCRAFT.isLoaded()) {
            Field f;
            Class<?> c;
            nativeCategories.add("BASICS");
            nativeCategories.add("THAUMATURGY");
            nativeCategories.add("ALCHEMY");
            nativeCategories.add("ARTIFICE");
            nativeCategories.add("GOLEMANCY");
            nativeCategories.add("ELDRITCH");
            try {
                c = Class.forName("thaumcraft.common.Thaumcraft");
                f = c.getField("proxy");
                proxy = f.get(null);
                Class<?> cp = Class.forName("thaumcraft.common.CommonProxy");
                Field kn = cp.getField("playerKnowledge");
                researchManager = cp.getField("researchManager");
                Object knowledge = kn.get(proxy);
                Class<?> ck = Class.forName("thaumcraft.common.lib.research.PlayerKnowledge");
                Field res = ck.getField("researchCompleted");
                Field objs = ck.getField("objectsScanned");
                Field ents = ck.getField("entitiesScanned");
                Field phen = ck.getField("phenomenaScanned");
                Field asp = ck.getField("aspectsDiscovered");
                Field warp = ck.getField("warp");
                Field warpsticky = ck.getField("warpSticky");
                Field warptemp = ck.getField("warpTemp");
                aspects = (Map)asp.get(knowledge);
                research = (Map)res.get(knowledge);
                scannedObjects = (Map)objs.get(knowledge);
                scannedEntities = (Map)ents.get(knowledge);
                scannedPhenomena = (Map)phen.get(knowledge);
                playerWarp = (Map)warp.get(knowledge);
                playerStickyWarp = (Map)warpsticky.get(knowledge);
                playerTempWarp = (Map)warptemp.get(knowledge);
            }
            catch (Exception e) {
                DragonAPICore.logError("Could not load ThaumCraft PlayerKnowledge Handler!");
                e.printStackTrace();
                ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)ModList.THAUMCRAFT, e);
            }
            try {
                c = Class.forName("thaumcraft.common.lib.network.PacketHandler");
                f = c.getField("INSTANCE");
                packetHandlerInstance = (SimpleNetworkWrapper)f.get(null);
                Class<?> pkt = Class.forName("thaumcraft.common.lib.network.playerdata.PacketAspectPool");
                aspectPacketConstructor = pkt.getConstructor(String.class, Short.class, Short.class);
            }
            catch (Exception e) {
                DragonAPICore.logError("Could not load ThaumCraft Packet Handler!");
                e.printStackTrace();
                ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)ModList.THAUMCRAFT, e);
            }
            try {
                Class<?> wand = Class.forName("thaumcraft.common.items.wands.ItemWandCasting");
                addWandVis = wand.getMethod("addVis", ItemStack.class, Aspect.class, Integer.TYPE, Boolean.TYPE);
                getWandVis = wand.getMethod("getAllVis", ItemStack.class);
                maxWandVis = wand.getMethod("getMaxVis", ItemStack.class);
                setWandInUse = wand.getMethod("setObjectInUse", ItemStack.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                clearWandInUse = wand.getMethod("clearObjectInUse", ItemStack.class);
            }
            catch (Exception e) {
                DragonAPICore.logError("Could not load ThaumCraft Wand Handler!");
                e.printStackTrace();
                ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)ModList.THAUMCRAFT, e);
            }
            try {
                Class<?> mgr = Class.forName("thaumcraft.common.lib.research.ResearchManager");
                researchComplete = mgr.getMethod("isResearchComplete", String.class, String.class);
                completeResearch = mgr.getMethod("completeResearch", EntityPlayer.class, String.class);
                getData = mgr.getMethod("getData", ItemStack.class);
                createNote = mgr.getMethod("createNote", ItemStack.class, String.class, World.class);
                getMix = mgr.getMethod("getCombinationResult", Aspect.class, Aspect.class);
                Class<?> data = Class.forName("thaumcraft.common.lib.research.ResearchNoteData");
                dataKey = data.getField("key");
                dataComplete = data.getField("complete");
            }
            catch (Exception e) {
                DragonAPICore.logError("Could not load ThaumCraft Research Handler!");
                e.printStackTrace();
                ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)ModList.THAUMCRAFT, e);
            }
            try {
                Class<?> wisp = Class.forName("thaumcraft.common.entities.monster.EntityWisp");
                wispTarget = wisp.getDeclaredField("targetedEntity");
                wispTarget.setAccessible(true);
            }
            catch (Exception e) {
                DragonAPICore.logError("Could not load ThaumCraft Mob Handler!");
                e.printStackTrace();
                ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)ModList.THAUMCRAFT, e);
            }
            try {
                alchemicalFurnaceClass = Class.forName("thaumcraft.common.tiles.TileAlchemyFurnace");
                furnaceBurn = alchemicalFurnaceClass.getDeclaredField("furnaceBurnTime");
                furnaceBurn.setAccessible(true);
                itemBurn = alchemicalFurnaceClass.getDeclaredField("currentItemBurnTime");
                itemBurn.setAccessible(true);
            }
            catch (Exception e) {
                DragonAPICore.logError("Could not load ThaumCraft Alchemical Furnace Handler!");
                e.printStackTrace();
                ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)ModList.THAUMCRAFT, e);
            }
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                try {
                    Class<?> clip = Class.forName("thaumcraft.client.ClientProxy");
                    for (int i = 0; i < EffectType.list.length; ++i) {
                        EffectType type = EffectType.list[i];
                        type.call = clip.getMethod(type.name, type.arguments);
                    }
                }
                catch (Exception e) {
                    DragonAPICore.logError("Could not load ThaumCraft Effect Handler!");
                    e.printStackTrace();
                    ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)ModList.THAUMCRAFT, e);
                }
            }
        }
    }

    public static enum EffectType {
        NODEBURST("burst", World.class, Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE),
        WISP("wispFX", World.class, Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE),
        WISP2("wispFX2", World.class, Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, Float.TYPE),
        WISP3("wispFX3", World.class, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Boolean.TYPE, Float.TYPE),
        WISP4("wispFX4", World.class, Double.TYPE, Double.TYPE, Double.TYPE, Entity.class, Integer.TYPE, Boolean.TYPE, Float.TYPE),
        BOLT("bolt", World.class, Entity.class, Entity.class),
        SOURCESTREAM("sourceStreamFX", World.class, Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE),
        RUNES("blockRunes", World.class, Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE, Float.TYPE),
        NODEBOLT("nodeBolt", World.class, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE),
        NODEBOLT_ENTITY("nodeBolt", World.class, Float.TYPE, Float.TYPE, Float.TYPE, Entity.class);

        private static final EffectType[] list;
        private final String name;
        private final Class[] arguments;
        private Method call;

        private EffectType(String s, Class ... args) {
            this.name = s;
            this.arguments = args;
        }

        static {
            list = EffectType.values();
        }
    }

    private static class XMLPage
    extends ResearchPage
    implements Comparable<XMLPage> {
        private final XMLResearch research;
        private final int page;

        private XMLPage(XMLResearch res, InfusionRecipe recipe, int id) {
            super(recipe);
            this.research = res;
            this.page = id;
        }

        private XMLPage(XMLResearch res, IArcaneRecipe recipe, int id) {
            super(recipe);
            this.research = res;
            this.page = id;
        }

        private XMLPage(XMLResearch res, CrucibleRecipe recipe, int id) {
            super(recipe);
            this.research = res;
            this.page = id;
        }

        private XMLPage(XMLResearch res, int id) {
            super("");
            this.research = res;
            this.page = id;
        }

        public String getTranslatedText() {
            return this.research.info.getValueAtNode("researches:" + this.research.name.toLowerCase(Locale.ENGLISH) + ":page" + this.page);
        }

        public String toString() {
            return this.research.name + ": " + this.getTranslatedText();
        }

        private static XMLPage getPageForObject(XMLResearch r, Object o, int id) {
            if (o instanceof InfusionRecipe) {
                return new XMLPage(r, (InfusionRecipe)o, id);
            }
            if (o instanceof IArcaneRecipe) {
                return new XMLPage(r, (IArcaneRecipe)o, id);
            }
            if (o instanceof CrucibleRecipe) {
                return new XMLPage(r, (CrucibleRecipe)o, id);
            }
            return new XMLPage(r, id);
        }

        @Override
        public int compareTo(XMLPage o) {
            return Integer.compare(this.page, o.page);
        }
    }

    public static class XMLResearch {
        private final DragonAPIMod mod;
        private final XMLInterface info;
        private final ArrayList<XMLPage> pages = new ArrayList();
        public final String name;
        private int maxPage = -1;
        private final HashSet<Integer> textPages = new HashSet();
        private final ArrayList<Integer> recipePages = new ArrayList();

        private static XMLInterface loadData(Class root, String path) {
            XMLInterface xml = new XMLInterface(root, path, !ReikaObfuscationHelper.isDeObfEnvironment());
            xml.init();
            return xml;
        }

        private XMLResearch(DragonAPIMod mod, String name, Class root, String path) {
            this.mod = mod;
            this.info = XMLResearch.loadData(root, path);
            this.name = name;
            for (String key : this.info.getNodesWithin("researches:" + name)) {
                int id = Integer.parseInt(key.substring(key.lastIndexOf("page") + "page".length()));
                this.maxPage = Math.max(this.maxPage, id);
                this.pages.add(new XMLPage(this, id));
                this.textPages.add(id);
            }
            for (int i = 0; i <= this.maxPage; ++i) {
                if (this.textPages.contains(i)) continue;
                this.recipePages.add(i);
            }
        }

        private void addRecipePage(Object recipe) {
            int idx = -1;
            if (this.recipePages.isEmpty()) {
                ++this.maxPage;
                idx = this.maxPage;
            } else {
                idx = this.recipePages.remove(0);
            }
            this.pages.add(XMLPage.getPageForObject(this, recipe, idx));
            Collections.sort(this.pages);
        }

        private XMLResearch(DragonAPIMod mod, String name, Class root, String path, InfusionRecipe recipe) {
            this(mod, name, root, path);
            this.addRecipePage(recipe);
        }

        private XMLResearch(DragonAPIMod mod, String name, Class root, String path, IArcaneRecipe recipe) {
            this(mod, name, root, path);
            this.addRecipePage(recipe);
        }

        private XMLResearch(DragonAPIMod mod, String name, Class root, String path, CrucibleRecipe recipe) {
            this(mod, name, root, path);
            this.addRecipePage(recipe);
        }

        public ResearchPage[] getPages() {
            ResearchPage[] arr = new ResearchPage[this.pages.size()];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = this.pages.get(i);
            }
            return arr;
        }
    }

    private static final class AspectSorter
    implements Comparator<Aspect> {
        private static final HashMap<Aspect, Integer> map = new HashMap();

        private AspectSorter() {
        }

        @Override
        public int compare(Aspect o1, Aspect o2) {
            if (o1.isPrimal() && o2.isPrimal()) {
                return map.get(o1) - map.get(o2);
            }
            if (o1.isPrimal()) {
                return Integer.MIN_VALUE;
            }
            if (o2.isPrimal()) {
                return Integer.MAX_VALUE;
            }
            return String.CASE_INSENSITIVE_ORDER.compare(o1.getName(), o2.getName());
        }

        static {
            map.put(Aspect.AIR, 0);
            map.put(Aspect.EARTH, 1);
            map.put(Aspect.FIRE, 2);
            map.put(Aspect.WATER, 3);
            map.put(Aspect.ORDER, 4);
            map.put(Aspect.ENTROPY, 5);
        }
    }
}

