/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.DeepInteract;

import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Instantiable.Data.Collections.OneWayCollections;
import Reika.DragonAPI.Instantiable.Data.Immutable.ImmutableArray;
import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Instantiable.Event.AddRecipeEvent;
import Reika.DragonAPI.ModInteract.DeepInteract.CraftingManagerBlacklisting;
import Reika.DragonAPI.ModInteract.DeepInteract.MTInteractionManager;
import Reika.DragonAPI.ModInteract.DeepInteract.MatterOverdriveHandler;
import Reika.DragonAPI.ModInteract.ReikaEEHelper;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.HashSet;
import moze_intel.projecte.api.event.EMCRemapEvent;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;

public final class SensitiveItemRegistry {
    public static final SensitiveItemRegistry instance = new SensitiveItemRegistry();
    private final OneWayCollections.OneWaySet<KeyedItemStack> keys = new OneWayCollections.OneWaySet();
    private final OneWayCollections.OneWaySet<KeyedItemStack> recipeDisallowed = new OneWayCollections.OneWaySet();
    private final OneWayCollections.OneWayMap<DragonAPIMod, OneWayCollections.OneWaySet<KeyedItemStack>> byMod = new OneWayCollections.OneWayMap();

    private SensitiveItemRegistry() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void registerItem(DragonAPIMod mod, Block item, boolean allowRecipes) {
        for (int i = 0; i < Interactions.list.length; ++i) {
            Interactions it = (Interactions)((Object)Interactions.list.get(i));
            if (!it.isLoaded) continue;
            it.blacklist(item);
        }
        this.onRegisterItem(mod, new KeyedItemStack(item), allowRecipes);
    }

    public void registerItem(DragonAPIMod mod, Item item, boolean allowRecipes) {
        for (int i = 0; i < Interactions.list.length; ++i) {
            Interactions it = (Interactions)((Object)Interactions.list.get(i));
            if (!it.isLoaded) continue;
            it.blacklist(item);
        }
        this.onRegisterItem(mod, new KeyedItemStack(item), allowRecipes);
    }

    public void registerItem(DragonAPIMod mod, ItemStack item, boolean allowRecipes) {
        for (int i = 0; i < Interactions.list.length; ++i) {
            Interactions it = (Interactions)((Object)Interactions.list.get(i));
            if (!it.isLoaded) continue;
            it.blacklist(item);
        }
        this.onRegisterItem(mod, new KeyedItemStack(item), allowRecipes);
    }

    private void onRegisterItem(DragonAPIMod mod, KeyedItemStack item, boolean allowRecipes) {
        this.keys.add(item.setSimpleHash(true).lock());
        if (!allowRecipes) {
            this.recipeDisallowed.add(item.setSimpleHash(true).lock());
        }
        this.byMod.get(mod);
    }

    public HashSet<KeyedItemStack> getItemsForMod(DragonAPIMod mod) {
        return (HashSet)this.byMod.get(mod);
    }

    public boolean contains(ItemStack is) {
        return this.keys.contains(new KeyedItemStack(is).setSimpleHash(true));
    }

    public boolean contains(KeyedItemStack ks) {
        return this.keys.contains(ks.copy().setSimpleHash(true));
    }

    @SubscribeEvent
    @DependentMethodStripper.ModDependent(value={ModList.PROJECTE})
    public void watchProjectE(EMCRemapEvent evt) {
        for (KeyedItemStack ks : this.keys) {
            ItemStack is = ks.getItemStack();
            ReikaEEHelper.blacklistItemStack(is);
        }
    }

    @SubscribeEvent
    public void preventDisallowedRecipes(AddRecipeEvent evt) {
        if (!AddRecipeEvent.isVanillaPass) {
            this.removeDisallowedRecipe(evt);
        }
    }

    private void removeDisallowedRecipe(AddRecipeEvent evt) {
        ItemStack out = evt.recipe.func_77571_b();
        if (out != null && out.func_77973_b() != null && this.recipeDisallowed.contains(new KeyedItemStack(out).setSimpleHash(true))) {
            evt.setCanceled(true);
        }
    }

    private static enum Interactions {
        MINETWEAKER(MTInteractionManager.isMTLoaded()),
        CRAFTMANAGER(ModList.CRAFTMANAGER.isLoaded()),
        MATTEROVERDRIVE(Loader.isModLoaded((String)"mo")),
        EE(true);

        private final boolean isLoaded;
        private static final ImmutableArray<Interactions> list;

        private Interactions(boolean b) {
            this.isLoaded = b;
        }

        private void blacklist(Block item) {
            switch (this) {
                case MINETWEAKER: {
                    MTInteractionManager.instance.blacklistNewRecipesFor(item);
                    break;
                }
                case CRAFTMANAGER: {
                    CraftingManagerBlacklisting.registerItem(item);
                    break;
                }
                case MATTEROVERDRIVE: {
                    MatterOverdriveHandler.blacklist(item);
                    break;
                }
                case EE: {
                    ReikaEEHelper.blacklistBlock(item);
                }
            }
        }

        private void blacklist(Item item) {
            switch (this) {
                case MINETWEAKER: {
                    MTInteractionManager.instance.blacklistNewRecipesFor(item);
                    break;
                }
                case CRAFTMANAGER: {
                    CraftingManagerBlacklisting.registerItem(item);
                    break;
                }
                case MATTEROVERDRIVE: {
                    MatterOverdriveHandler.blacklist(item);
                    break;
                }
                case EE: {
                    ReikaEEHelper.blacklistItem(item);
                }
            }
        }

        private void blacklist(ItemStack item) {
            switch (this) {
                case MINETWEAKER: {
                    MTInteractionManager.instance.blacklistNewRecipesFor(item);
                    break;
                }
                case CRAFTMANAGER: {
                    CraftingManagerBlacklisting.registerItem(item);
                    break;
                }
                case MATTEROVERDRIVE: {
                    MatterOverdriveHandler.blacklist(item);
                    break;
                }
                case EE: {
                    ReikaEEHelper.blacklistItemStack(item);
                }
            }
        }

        static {
            list = new ImmutableArray<Interactions>(Interactions.values());
        }
    }
}

