/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.Lua;

import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Libraries.Java.ReikaASMHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.ModList;
import dan200.computercraft.api.lua.LuaException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import net.minecraft.tileentity.TileEntity;

public abstract class LuaMethod {
    public final String displayName;
    private final Class requiredClass;
    private static final HashMap<MethodKey, LuaMethod> methods = new HashMap();

    public LuaMethod(String name, Class requiredParent) {
        this.displayName = name;
        this.requiredClass = requiredParent;
        MethodKey mk = this.getKey();
        if (methods.containsKey(mk)) {
            throw new IllegalArgumentException("This method is a duplicate of one that already exists!");
        }
        methods.put(mk, this);
    }

    public static final Collection<LuaMethod> getMethods() {
        return Collections.unmodifiableCollection(methods.values());
    }

    public static final LuaMethod getMethod(String name, Class c) {
        return methods.get(new MethodKey(name, c));
    }

    public static final int getNumberMethods() {
        return methods.size();
    }

    @DependentMethodStripper.ModDependent(value={ModList.COMPUTERCRAFT})
    public static Object[] invokeCC(LuaMethod m, TileEntity te, Object[] args) throws LuaException, InterruptedException {
        try {
            return m.invoke(te, args);
        }
        catch (LuaMethodException e) {
            throw new LuaException(e.getMessage());
        }
    }

    @DependentMethodStripper.ModDependent(value={ModList.OPENCOMPUTERS})
    public static Object[] invokeOC(LuaMethod m, TileEntity te, Object[] args) throws RuntimeException {
        try {
            return m.invoke(te, args);
        }
        catch (LuaMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract Object[] invoke(TileEntity var1, Object[] var2) throws LuaMethodException, InterruptedException;

    public abstract String getDocumentation();

    public boolean isDocumented() {
        return true;
    }

    public final boolean isClassInstanceOf(Class<? extends TileEntity> te) {
        return this.requiredClass != null ? this.requiredClass.isAssignableFrom(te) : true;
    }

    public final boolean isValidFor(TileEntity te) {
        return this.requiredClass != null ? this.requiredClass.isAssignableFrom(te.getClass()) : true;
    }

    public final boolean equals(Object o) {
        if (o instanceof LuaMethod) {
            return ((LuaMethod)o).displayName.equals(this.displayName) && this.requiredClass == ((LuaMethod)o).requiredClass;
        }
        return false;
    }

    public final int hashCode() {
        return this.displayName.hashCode() ^ this.requiredClass.hashCode();
    }

    public final String toString() {
        String name = this.requiredClass != null ? this.requiredClass.getSimpleName() : "Any TileEntity";
        return this.displayName + "() for " + name;
    }

    private final MethodKey getKey() {
        return new MethodKey(this);
    }

    public static void registerMethods(String folder) {
        try {
            for (Class c : ReikaJavaLibrary.getAllClassesFromPackage(folder, LuaMethod.class, true, true)) {
                ModList mod;
                if (c.isAnnotationPresent(ModTileDependent.class)) {
                    String[] vals;
                    for (String s : vals = c.getAnnotation(ModTileDependent.class).value()) {
                        if (ReikaASMHelper.checkForClass(s)) continue;
                    }
                }
                if (c.isAnnotationPresent(ModDependentMethod.class) && !(mod = c.getAnnotation(ModDependentMethod.class).value()).isLoaded()) continue;
                c.newInstance();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load LuaMethods!", e);
        }
    }

    public abstract String getArgsAsString();

    public abstract ReturnType getReturnType();

    static {
        LuaMethod.registerMethods("Reika.DragonAPI.ModInteract.Lua");
    }

    public final class LuaMethodException
    extends Exception {
        public LuaMethodException(Exception e) {
            super(e);
        }

        public LuaMethodException(String s, Exception e) {
            super(s, e);
        }

        public LuaMethodException(String s) {
            super(s);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface ModDependentMethod {
        public ModList value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface ModTileDependent {
        public String[] value();
    }

    private static class MethodKey {
        private final String name;
        private final Class parent;

        private MethodKey(LuaMethod m) {
            this(m.displayName, m.requiredClass);
        }

        private MethodKey(String s, Class c) {
            this.name = s;
            this.parent = c;
        }
    }

    public static enum ReturnType {
        VOID("void"),
        INTEGER("int"),
        LONG("long"),
        ARRAY("Object[]"),
        STRING("String"),
        BOOLEAN("boolean"),
        FLOAT("float");

        public final String displayName;

        private ReturnType(String name) {
            this.displayName = name;
        }
    }
}

