/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModRegistry;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.DragonAPIInit;
import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockBox;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Maps.BlockMap;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Interfaces.Registry.TreeType;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public enum ModWoodList implements TreeType
{
    CANOPY(ModList.TWILIGHT, 2434327, 3343460, 18, 30, "log", "leaves", "sapling", new int[]{1, 13}, new int[]{1, 9}, 1, VarType.INSTANCE),
    DARKWOOD(ModList.TWILIGHT, 3483674, 3759937, 60, 20, "log", "darkleaves", "sapling", new int[]{3, 15}, 0, 3, VarType.INSTANCE),
    MANGROVE(ModList.TWILIGHT, 9275776, 4396101, 10, 18, "log", "leaves", "sapling", new int[]{2, 14}, new int[]{2, 10}, 2, VarType.INSTANCE),
    TWILIGHTOAK(ModList.TWILIGHT, 8414804, 7752018, 30, 180, "log", "leaves", "sapling", new int[]{0, 12}, new int[]{0, 8}, 0, VarType.INSTANCE),
    GREATWOOD(ModList.THAUMCRAFT, 5193271, 7443020, 10, 30, "blockMagicalLog", "blockMagicalLeaves", "blockCustomPlant", new int[]{0, 4, 8}, new int[]{0, 8}, 0, VarType.INSTANCE),
    SILVERWOOD(ModList.THAUMCRAFT, 13222828, 5735111, 8, 24, "blockMagicalLog", "blockMagicalLeaves", "blockCustomPlant", new int[]{1, 5, 9}, new int[]{1, 9}, 1, VarType.INSTANCE),
    EUCALYPTUS(ModList.NATURA, 14864049, 3969305, 10, 14, "tree", "floraLeaves", "floraSapling", 0, new int[]{1, 9}, 1, VarType.INSTANCE),
    SEQUOIA(ModList.NATURA, 9204066, 3969305, 50, 250, "redwood", "floraLeaves", "floraSapling", new int[]{0, 1, 2}, new int[]{0, 8}, 0, VarType.INSTANCE),
    SAKURA(ModList.NATURA, 7355394, 15433624, 16, 30, "tree", "floraLeavesNoColor", "floraSapling", new int[]{1, 5, 9}, new int[]{0, 8}, 3, VarType.INSTANCE),
    GHOSTWOOD(ModList.NATURA, 0xB3B3B3, 15656657, 7, 12, "tree", "floraLeavesNoColor", "floraSapling", new int[]{2, 6, 10}, new int[]{1, 9}, 4, VarType.INSTANCE),
    HOPSEED(ModList.NATURA, 10454625, 3969305, 10, 7, "tree", "floraLeaves", "floraSapling", 3, new int[]{2, 10}, 2, VarType.INSTANCE),
    NATURADARKWOOD(ModList.NATURA, 2313605, 400972, 7, 12, "darkTree", "darkLeaves", "floraSapling", 0, new int[]{0, 1, 2, 8, 9, 10}, 6, VarType.INSTANCE),
    BLOODWOOD(ModList.NATURA, 9260805, 0xB10000, 14, 16, "bloodwood", "floraLeavesNoColor", "floraSapling", new int[]{0, 1, 2, 3, 4, 5, 15}, new int[]{2, 10}, 5, VarType.INSTANCE),
    FUSEWOOD(ModList.NATURA, 2899512, 2654605, 7, 12, "darkTree", "darkLeaves", "floraSapling", 1, new int[]{3, 11}, 7, VarType.INSTANCE),
    TIGERWOOD(ModList.NATURA, 5523766, 5974272, 7, 12, "rareTree", "rareLeaves", "rareSapling", 3, new int[]{3, 11}, 3, VarType.INSTANCE),
    SILVERBELL(ModList.NATURA, 9673861, 7583817, 7, 12, "rareTree", "rareLeaves", "rareSapling", 1, new int[]{1, 9}, 1, VarType.INSTANCE),
    MAPLE(ModList.NATURA, 5257763, 10040338, 7, 12, "rareTree", "rareLeaves", "rareSapling", 0, new int[]{0, 8}, 0, VarType.INSTANCE),
    WILLOW(ModList.NATURA, 5786672, 5540161, 9, 14, "willow", "floraLeavesNoColor", "rareSapling", 0, new int[]{3, 11}, 4, VarType.INSTANCE),
    AMARANTH(ModList.NATURA, 10259286, 3969305, 6, 20, "rareTree", "rareLeaves", "rareSapling", 2, new int[]{2, 10}, 2, VarType.INSTANCE),
    BAMBOO(ModList.BOP, 12309100, 11524155, 5, 20, "bamboo", "leaves1", "saplings", 0, new int[]{1, 5, 9, 13}, 2, VarType.INSTANCE),
    MAGIC(ModList.BOP, 7898014, 5670846, 7, 12, "logs2", "leaves1", "saplings", new int[]{1, 5, 9, 13}, new int[]{2, 6, 10, 14}, 3, VarType.INSTANCE),
    DARK(ModList.BOP, 0x664848, 3223362, 7, 12, "logs1", "leaves1", "saplings", new int[]{2, 6, 10, 14}, new int[]{3, 7, 11, 15}, 4, VarType.INSTANCE),
    FIR(ModList.BOP, 6772806, 5344863, 12, 60, "logs1", "leaves2", "saplings", new int[]{3, 7, 11, 15}, new int[]{1, 5, 9, 13}, 6, VarType.INSTANCE),
    LOFTWOOD(ModList.BOP, 8484453, 4184468, 8, 16, "logs2", "leaves2", "saplings", new int[]{0, 4, 8, 12}, new int[]{2, 6, 10, 14}, 7, VarType.INSTANCE),
    CHERRY(ModList.BOP, 9851969, 16756704, 15, 20, "logs1", "leaves3", "saplings", new int[]{1, 5, 9, 13}, new int[]{1, 3, 5, 7, 9, 11, 13, 15}, 10, VarType.INSTANCE),
    HELLBARK(ModList.BOP, 11759427, 8085023, 2, 5, "logs4", "leaves4", "saplings", new int[]{1, 5, 9, 13}, new int[]{0, 4, 8, 12}, 13, VarType.INSTANCE),
    JACARANDA(ModList.BOP, 10060151, 6573956, 7, 12, "logs4", "leaves4", "saplings", new int[]{2, 6, 10, 14}, new int[]{1, 5, 9, 13}, 14, VarType.INSTANCE),
    SACRED(ModList.BOP, 9005903, 4102170, 30, 160, "logs1", "colorizedLeaves1", "colorizedSaplings", new int[]{0, 4, 8, 12}, new int[]{0, 4, 8, 12}, 0, VarType.INSTANCE),
    BOPMANGROVE(ModList.BOP, 14602677, 4102170, 5, 15, "logs2", "colorizedLeaves1", "colorizedSaplings", new int[]{2, 6, 10, 14}, new int[]{1, 5, 9, 13}, 1, VarType.INSTANCE),
    PALM(ModList.BOP, 9661248, 4102170, 6, 14, "logs2", "colorizedLeaves1", "colorizedSaplings", new int[]{3, 7, 11, 15}, new int[]{2, 6, 10, 14}, 2, VarType.INSTANCE),
    REDWOOD(ModList.BOP, 7483149, 4102170, 6, 50, "logs3", "colorizedLeaves1", "colorizedSaplings", new int[]{0, 4, 8, 12}, new int[]{3, 7, 11, 15}, 3, VarType.INSTANCE),
    BOPWILLOW(ModList.BOP, 7764551, 4102170, 8, 15, "logs3", "colorizedLeaves2", "colorizedSaplings", new int[]{1, 5, 9, 13}, new int[]{0, 4, 8, 12}, 4, VarType.INSTANCE),
    PINE(ModList.BOP, 9005903, 4102170, 8, 25, "logs4", "colorizedLeaves2", "colorizedSaplings", new int[]{0, 4, 8, 12}, new int[]{1, 5, 9, 13}, 5, VarType.INSTANCE),
    MAHOGANY(ModList.BOP, 9005903, 4102170, 9, 16, "logs4", "colorizedLeaves2", "colorizedSaplings", new int[]{3, 7, 11, 15}, new int[]{2, 6, 10, 14}, 6, VarType.INSTANCE),
    BXLREDWOOD(ModList.BXL, 0, 0, -1, -1, null, null, null, 0, VarType.INSTANCE),
    IC2RUBBER(ModList.IC2, 3943712, 6521155, 6, 15, "rubberWood", "rubberLeaves", "rubberSapling", new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, new int[]{0, 8}, 0, VarType.ITEMSTACK),
    MFRRUBBER(ModList.MINEFACTORY, 8281125, 6144291, 30, 90, "rubberWoodBlock", "rubberLeavesBlock", "rubberSaplingBlock", new int[]{0, 1, 2, 3, 4, 5, 13}, new int[]{0, 8}, 0, VarType.INSTANCE),
    TIMEWOOD(ModList.TWILIGHT, 5189661, 6986775, 10, 20, "magicLog", "magicLeaves", "sapling", new int[]{0, 12}, new int[]{1, 8}, 5, VarType.INSTANCE),
    TRANSFORMATION(ModList.TWILIGHT, 6713983, 7130346, 12, 20, "magicLog", "magicLeaves", "sapling", new int[]{1, 13}, new int[]{1, 9}, 6, VarType.INSTANCE),
    MINEWOOD(ModList.TWILIGHT, 12953986, 16576836, 15, 20, "magicLog", "magicLeaves", "sapling", new int[]{2, 14}, new int[]{2, 10}, 7, VarType.INSTANCE),
    SORTING(ModList.TWILIGHT, 7362613, 3558403, 12, 20, "magicLog", "magicLeaves", "sapling", new int[]{3, 15}, new int[]{3, 11}, 8, VarType.INSTANCE),
    GLOW(ModList.TRANSITIONAL, 14858363, 16759902, 7, 12, "GlowWood", "GlowLeaf", "GlowSapling", 0, 0, 0, VarType.INSTANCE),
    FORCE(ModList.DARTCRAFT, 14726985, 14266924, 7, 12, "forceLog", "forceLeaves", "forceSapling", 0, new int[]{0, 8}, 0, VarType.INSTANCE),
    HIGHFIR(ModList.HIGHLANDS, 0x77EE77, 0x88DD88, 10, 30, "firWood", "firLeaves", "firSapling", VarType.INSTANCE),
    HIGHACACIA(ModList.HIGHLANDS, 0x77EE77, 0x88DD88, 12, 10, "acaciaWood", "acaciaLeaves", "acaciaSapling", VarType.INSTANCE),
    HIGHREDWOOD(ModList.HIGHLANDS, 0x77EE77, 0x88DD88, 12, 45, "redwoodWood", "redwoodLeaves", "redwoodSapling", VarType.INSTANCE),
    POPLAR(ModList.HIGHLANDS, 0x77EE77, 0x88DD88, 8, 12, "poplarWood", "poplarLeaves", "poplarSapling", VarType.INSTANCE),
    HIGHCANOPY(ModList.HIGHLANDS, 0x77EE77, 0x88DD88, 12, 30, "canopyWood", "canopyLeaves", "canopySapling", VarType.INSTANCE),
    HIGHPALM(ModList.HIGHLANDS, 0x77EE77, 0x88DD88, 4, 12, "palmWood", "palmLeaves", "palmSapling", VarType.INSTANCE),
    IRONWOOD(ModList.HIGHLANDS, 0x77EE77, 0x88DD88, 20, 50, "ironWood", "ironwoodLeaves", "ironwoodSapling", VarType.INSTANCE),
    HIGHMANGROVE(ModList.HIGHLANDS, 0x77EE77, 0x88DD88, 6, 10, "mangroveWood", "mangroveLeaves", "mangroveSapling", VarType.INSTANCE),
    ASH(ModList.HIGHLANDS, 0x77EE77, 0x88DD88, 12, 25, "ashWood", "ashLeaves", "ashSapling", VarType.INSTANCE),
    WITCHWOOD(ModList.ARSMAGICA, 5786930, 2049817, 10, 20, "witchwoodLog", "witchwoodLeaves", "witchwoodSapling", VarType.INSTANCE),
    ROWAN(ModList.WITCHERY, 3622451, 10385229, 7, 12, "LOG", "LEAVES", "SAPLING", new int[]{0, 4, 8}, new int[]{0, 8}, 0, VarType.INSTANCE),
    HAWTHORNE(ModList.WITCHERY, 0x656566, 0xC3EEC3, 10, 16, "LOG", "LEAVES", "SAPLING", new int[]{2, 6, 10}, new int[]{2, 10}, 2, VarType.INSTANCE),
    ALDER(ModList.WITCHERY, 5395532, 12834146, 6, 10, "LOG", "LEAVES", "SAPLING", new int[]{1, 5, 9}, new int[]{1, 9}, 1, VarType.INSTANCE),
    LIGHTED(ModList.CHROMATICRAFT, 10510134, 16766867, 10, 14, "GLOWLOG", "GLOWLEAF", "GLOWSAPLING", 0, new int[]{0, 1, 2, 3, 4}, 0, VarType.INSTANCE),
    SLIME(ModList.TINKERER, 6881146, 9371617, 12, 15, "slimeGel", "slimeLeaves", "slimeSapling", 1, 0, 0, VarType.INSTANCE),
    TAINTED(ModList.FORBIDDENMAGIC, 4208459, 5442939, 7, 12, "taintLog", "taintLeaves", "taintSapling", new int[]{0, 4, 8}, 0, 0, VarType.INSTANCE),
    PINKBIRCH(ModList.SATISFORESTRY, 15066331, 16225717, 6, 20, "LOG", "LEAVES", "SAPLING", new int[]{0, 4, 8, 12}, new int[]{0, 4, 8, 12}, 0, VarType.INSTANCE),
    GIANTPINKTREE(ModList.SATISFORESTRY, 15066331, 16019099, 48, 192, "LOG", "LEAVES", "SAPLING", new int[]{1, 5, 9, 13}, new int[]{1, 5, 9, 13}, 1, VarType.INSTANCE),
    REDJUNGLE(ModList.SATISFORESTRY, 15066331, 13390173, 15, 20, "LOG", "LEAVES", "SAPLING", new int[]{2, 6, 10, 14}, new int[]{2, 6, 10, 14}, 2, VarType.INSTANCE),
    WEEDWOOD(ModList.BETWEENLANDS, 7043632, 9742403, 8, 14, "weedwoodLog", "weedwoodLeaves", "saplingWeedwood", VarType.INSTANCE),
    SAPTREE(ModList.BETWEENLANDS, 7043632, 9742403, 8, 14, "sapTreeLog", "sapTreeLeaves", "saplingSapTree", VarType.INSTANCE),
    BETWEENRUBBER(ModList.BETWEENLANDS, 7043632, 9742403, 8, 14, "weedwoodLog", "rubberTreeLeaves", "saplingRubberTree", VarType.INSTANCE),
    TROPIPALM(ModList.TROPICRAFT, 9853491, 0x20C020, 6, 12, "logs", "palmLeaves", "saplings", new int[]{0, 2, 4, 6, 8, 10, 12, 14}, new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, 0, VarType.INSTANCE),
    TROPIMAHOGANY(ModList.TROPICRAFT, 8140337, 0x20C020, 9, 20, "logs", "rainforestLeaves", "saplings", new int[]{1, 3, 5, 7, 9, 11, 13, 15}, new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, 1, VarType.INSTANCE),
    NETHERPAM(ModList.NETHERPAM, 0xA02020, 13582400, 4, 4, "netherLog", "netherLeaves", "netherSapling", VarType.INSTANCE),
    GOLDOAK(ModList.AETHER, 14994276, 14994276, 8, 14, "AetherLog", "GoldenOakLeaves", "GoldenOakSapling", new int[]{2, 3}, new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, 0, VarType.INSTANCE),
    BAOBAB(ModList.EREBUS, 0, 0, 12, 14, "Baobab_Log", "Baobab_Leaves", "Baobab_Sapling", VarType.INSTANCE),
    EREBEUCALYPTUS(ModList.EREBUS, 0, 0, 20, 60, "Eucalyptus_Log", "Eucalyptus_Leaves", "Eucalyptus_Sapling", VarType.INSTANCE),
    EREBMAHOGANY(ModList.EREBUS, 0, 0, 12, 18, "Mahogany_Log", "Mahogany_Leaves", "Mahogany_Sapling", VarType.INSTANCE),
    MOSSBARK(ModList.EREBUS, 0, 0, 12, 14, "Mossbark_Log", "Mossbark_Leaves", "Mossbark_Sapling", VarType.INSTANCE),
    ASPER(ModList.EREBUS, 0, 0, 12, 14, "Asper_Log", "Asper_Leaves", "Asper_Sapling", VarType.INSTANCE),
    CYPRESS(ModList.EREBUS, 0, 0, 8, 16, "Cypress_Log", "Cypress_Leaves", "Cypress_Sapling", VarType.INSTANCE),
    SAP(ModList.EREBUS, 0, 0, 12, 14, "Sap_Log", "Sap_Leaves", "Sap_Sapling", VarType.INSTANCE),
    MARSHWOOD(ModList.EREBUS, 0, 0, 12, 14, "Marshwood_Log", "Marshwood_Leaves", "Marshwood_Sapling", VarType.INSTANCE);

    private ModList mod;
    private Block blockID = null;
    private Block leafID = null;
    private int[] blockMeta;
    private int[] leafMeta;
    private boolean hasPlanks;
    private Block saplingID;
    private int saplingMeta;
    public final int logColor;
    public final int leafColor;
    public final BlockBox bounds;
    private String varName;
    private Class containerClass;
    private boolean exists = false;
    public static final ModWoodList[] woodList;
    private static final BlockMap<ModWoodList> logMappings;
    private static final BlockMap<ModWoodList> leafMappings;
    private static final BlockMap<ModWoodList> saplingMappings;
    private static final MultiMap<ModList, ModWoodList> modMappings;

    private ModWoodList(ModList req, int color, int leaf, int w, int h, String blockVar, String leafVar, String saplingVar, VarType type) {
        this(req, color, leaf, w, h, blockVar, leafVar, saplingVar, new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, 0, type);
    }

    private ModWoodList(ModList req, int color, int leaf, int w, int h, String blockVar, String leafVar, String saplingVar, int meta, int metaleaf, int metasapling, VarType type) {
        this(req, color, leaf, w, h, blockVar, leafVar, saplingVar, new int[]{meta}, new int[]{metaleaf}, metasapling, type);
    }

    private ModWoodList(ModList req, int color, int leaf, int w, int h, String blockVar, String leafVar, String saplingVar, int meta, VarType type) {
        this(req, color, leaf, w, h, blockVar, leafVar, saplingVar, new int[]{meta}, new int[]{meta}, meta, type);
    }

    private ModWoodList(ModList req, int color, int leaf, int w, int h, String blockVar, String leafVar, String saplingVar, int[] meta, int metaleaf, int metasapling, VarType type) {
        this(req, color, leaf, w, h, blockVar, leafVar, saplingVar, meta, new int[]{metaleaf}, metasapling, type);
    }

    private ModWoodList(ModList req, int color, int leaf, int w, int h, String blockVar, String leafVar, String saplingVar, int meta, int[] metaleaf, int metasapling, VarType type) {
        this(req, color, leaf, w, h, blockVar, leafVar, saplingVar, new int[]{meta}, metaleaf, metasapling, type);
    }

    private ModWoodList(ModList req, int color, int leafcolor, int w, int h, String blockVar, String leafVar, String saplingVar, int[] meta, int[] metaleaf, int metasapling, VarType type) {
        if (!DragonAPIInit.canLoadHandlers()) {
            throw new MisuseException("Accessed registry enum too early! Wait until postInit!");
        }
        this.mod = req;
        this.leafColor = leafcolor;
        this.logColor = color;
        this.bounds = BlockBox.origin().expand(w, h, w);
        if (!this.mod.isLoaded()) {
            DragonAPICore.log("DRAGONAPI: Not loading " + this.getLabel() + ": Mod not present.");
            this.blockMeta = new int[]{0};
            this.leafMeta = new int[]{0};
            return;
        }
        Class cl = req.getBlockClass();
        if (cl == null) {
            DragonAPICore.logError("Error loading wood " + this.getLabel() + ": Empty block class");
            return;
        }
        if (blockVar == null || blockVar.isEmpty()) {
            DragonAPICore.logError("Error loading wood " + this.getLabel() + ": Empty variable name");
            return;
        }
        if (leafVar == null || leafVar.isEmpty()) {
            DragonAPICore.logError("Error loading leaves for wood " + this.getLabel() + ": Empty variable name");
            return;
        }
        try {
            Block idsapling;
            Block idleaf;
            Block id;
            switch (type) {
                case ITEMSTACK: {
                    ItemStack sapling;
                    ItemStack wood = this.loadItemStack(cl, blockVar);
                    ItemStack leaf = this.loadItemStack(cl, leafVar);
                    ItemStack itemStack = sapling = saplingVar == null ? null : this.loadItemStack(cl, saplingVar);
                    if (wood == null || leaf == null || saplingVar != null && sapling == null) {
                        DragonAPICore.logError("Error loading " + this.getLabel() + ": Block not instantiated!");
                        return;
                    }
                    id = Block.func_149634_a((Item)wood.func_77973_b());
                    idleaf = Block.func_149634_a((Item)leaf.func_77973_b());
                    idsapling = Block.func_149634_a((Item)sapling.func_77973_b());
                    break;
                }
                case INSTANCE: {
                    Block sapling_b;
                    Block wood_b = this.loadBlock(cl, blockVar);
                    Block leaf_b = this.loadBlock(cl, leafVar);
                    Block block = sapling_b = saplingVar == null ? null : this.loadBlock(cl, saplingVar);
                    if (wood_b == null || leaf_b == null || saplingVar != null && sapling_b == null) {
                        DragonAPICore.logError("Error loading " + this.getLabel() + ": Block not instantiated!");
                        return;
                    }
                    id = wood_b;
                    idleaf = leaf_b;
                    idsapling = sapling_b;
                    break;
                }
                case REGISTRY: {
                    Block sapling_b;
                    Block wood_b = GameRegistry.findBlock((String)this.mod.modLabel, (String)blockVar);
                    Block leaf_b = GameRegistry.findBlock((String)this.mod.modLabel, (String)leafVar);
                    Block block = sapling_b = saplingVar == null ? null : GameRegistry.findBlock((String)this.mod.modLabel, (String)saplingVar);
                    if (wood_b == null || leaf_b == null || saplingVar != null && sapling_b == null) {
                        DragonAPICore.logError("Error loading " + this.getLabel() + ": Block not instantiated!");
                        return;
                    }
                    id = wood_b;
                    idleaf = leaf_b;
                    idsapling = sapling_b;
                    break;
                }
                default: {
                    DragonAPICore.logError("Error loading wood " + this.getLabel());
                    DragonAPICore.logError("Invalid variable type " + (Object)((Object)type));
                    return;
                }
            }
            this.blockID = id;
            this.blockMeta = new int[meta.length];
            System.arraycopy(meta, 0, this.blockMeta, 0, meta.length);
            this.leafID = idleaf;
            this.leafMeta = new int[metaleaf.length];
            System.arraycopy(metaleaf, 0, this.leafMeta, 0, metaleaf.length);
            this.saplingID = idsapling;
            this.saplingMeta = metasapling;
            DragonAPICore.log("Successfully loaded wood " + this.getLabel());
            this.exists = true;
        }
        catch (NoSuchFieldException e) {
            DragonAPICore.logError("Error loading wood " + this.getLabel());
            e.printStackTrace();
        }
        catch (SecurityException e) {
            DragonAPICore.logError("Error loading wood " + this.getLabel());
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            DragonAPICore.logError("Error loading wood " + this.getLabel());
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            DragonAPICore.logError("Error loading wood " + this.getLabel());
            e.printStackTrace();
        }
        catch (ReflectiveOperationException e) {
            DragonAPICore.logError("Error loading wood " + this.getLabel());
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            DragonAPICore.logError("Error loading wood " + this.getLabel());
            e.printStackTrace();
        }
    }

    private ItemStack loadItemStack(Class cl, String field) throws ReflectiveOperationException {
        switch (this.mod) {
            default: 
        }
        Object ins = this.getFieldInstance();
        Field f = cl.getField(field);
        return (ItemStack)f.get(ins);
    }

    private Block loadBlock(Class cl, String field) throws ReflectiveOperationException {
        switch (this.mod) {
            case CHROMATICRAFT: 
            case SATISFORESTRY: {
                Field f = cl.getField(field);
                Method block = cl.getMethod("getBlockInstance", new Class[0]);
                Object entry = f.get(null);
                return (Block)block.invoke(entry, new Object[0]);
            }
            case EREBUS: {
                cl = Class.forName("erebus.lib.EnumWood");
                int idx = field.indexOf(95);
                String type = field.substring(idx + 1);
                Field f = cl.getField(field.substring(0, idx));
                Method block = cl.getMethod("get" + type, new Class[0]);
                Object entry = f.get(null);
                return (Block)block.invoke(entry, new Object[0]);
            }
        }
        Object ins = this.getFieldInstance();
        Field f = cl.getField(field);
        return (Block)f.get(ins);
    }

    private Object getFieldInstance() throws ReflectiveOperationException {
        switch (this.mod) {
            case WITCHERY: {
                Class<?> c = Class.forName("com.emoniph.witchery.Witchery");
                Field f = c.getField("Blocks");
                return f.get(null);
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append(" from ");
        sb.append(this.mod);
        if (this.exists) {
            sb.append(" (LOG " + this.blockID + ":" + Arrays.toString(this.blockMeta) + ";");
            sb.append(" ");
            sb.append("LEAF " + this.leafID + ":" + Arrays.toString(this.leafMeta) + ";");
            if (this.saplingID != null) {
                sb.append(" ");
                sb.append("SAPLING " + this.saplingID + ":" + this.saplingMeta);
            }
            sb.append(")");
        } else {
            sb.append(" (Not loaded)");
        }
        return sb.toString();
    }

    public String getBasicInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append(" from ");
        sb.append(this.mod);
        return sb.toString();
    }

    public String getLabel() {
        return this.name() + " from " + this.getParentMod();
    }

    @Override
    public boolean exists() {
        return this.exists && this.getParentMod().isLoaded();
    }

    @Override
    public BlockKey getItem() {
        return new BlockKey(this.blockID, this.blockMeta[0]);
    }

    public BlockKey getLogItemWithOffset(int i) {
        return new BlockKey(this.blockID, this.blockMeta[i]);
    }

    public boolean isLogBlock(ItemStack block) {
        if (this.blockMeta == null) {
            return false;
        }
        if (this == SEQUOIA) {
            return Block.func_149634_a((Item)block.func_77973_b()) == this.blockID;
        }
        for (int i = 0; i < this.blockMeta.length; ++i) {
            if (!ReikaItemHelper.matchStacks(block, this.getLogItemWithOffset(i))) continue;
            return true;
        }
        return false;
    }

    public Block getBlock() {
        return this.blockID;
    }

    public String getName() {
        return ReikaStringParser.capFirstChar(this.name());
    }

    @Override
    public Block getLogID() {
        return this.blockID;
    }

    @Override
    public Block getLeafID() {
        return this.leafID;
    }

    @Override
    public Block getSaplingID() {
        return this.saplingID;
    }

    @Override
    public List<Integer> getLogMetadatas() {
        ArrayList<Integer> li = new ArrayList<Integer>();
        for (int i = 0; i < this.blockMeta.length; ++i) {
            li.add(this.blockMeta[i]);
        }
        return li;
    }

    @Override
    public List<Integer> getLeafMetadatas() {
        ArrayList<Integer> li = new ArrayList<Integer>();
        for (int i = 0; i < this.leafMeta.length; ++i) {
            li.add(this.leafMeta[i]);
        }
        return li;
    }

    public static ModWoodList getModWood(Block id, int meta) {
        return logMappings.get(id, meta);
    }

    public static ModWoodList getModWood(ItemStack block) {
        return ModWoodList.getModWood(Block.func_149634_a((Item)block.func_77973_b()), block.func_77960_j());
    }

    public static ModWoodList getModWoodFromSapling(Block id, int meta) {
        return saplingMappings.get(id, meta);
    }

    public static ModWoodList getModWoodFromSapling(ItemStack block) {
        return ModWoodList.getModWoodFromSapling(Block.func_149634_a((Item)block.func_77973_b()), block.func_77960_j());
    }

    public static ModWoodList getModWoodFromLeaf(ItemStack block) {
        return ModWoodList.getModWoodFromLeaf(Block.func_149634_a((Item)block.func_77973_b()), block.func_77960_j());
    }

    public static ModWoodList getModWoodFromLeaf(Block id, int meta) {
        return leafMappings.get(id, meta);
    }

    public static boolean isModWood(ItemStack block) {
        return ModWoodList.getModWood(block) != null;
    }

    public static boolean isModWood(Block id, int meta) {
        return ModWoodList.getModWood(id, meta) != null;
    }

    public static boolean isModLeaf(Block id, int meta) {
        return ModWoodList.getModWoodFromLeaf(id, meta) != null;
    }

    public static boolean isModLeaf(ItemStack block) {
        return ModWoodList.getModWoodFromLeaf(block) != null;
    }

    public static boolean isModSapling(ItemStack block) {
        return ModWoodList.getModWoodFromSapling(block) != null;
    }

    public static boolean isModSapling(Block id, int meta) {
        return ModWoodList.getModWoodFromSapling(id, meta) != null;
    }

    public IIcon getWoodIcon(IBlockAccess iba, int x, int y, int z, int s) {
        return this.getBlock().func_149673_e(iba, x, y, z, s);
    }

    public IIcon getSideIcon() {
        return this.getBlock().func_149733_h(2);
    }

    public EntityFallingBlock getFallingBlock(World world, int x, int y, int z) {
        EntityFallingBlock e = new EntityFallingBlock(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, this.blockID, this.blockMeta[0]);
        return e;
    }

    @Override
    public BlockKey getBasicLeaf() {
        return new BlockKey(this.leafID, this.leafMeta[0]);
    }

    public ArrayList<ItemStack> getAllLeaves() {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        for (int i = 0; i < this.leafMeta.length; ++i) {
            li.add(new ItemStack(this.leafID, 1, this.leafMeta[i]));
        }
        return li;
    }

    public ItemStack getCorrespondingSapling() {
        return this.saplingID == null ? null : new ItemStack(this.saplingID, 1, this.saplingMeta);
    }

    @Override
    public int getSaplingMeta() {
        return this.saplingMeta;
    }

    public ModList getParentMod() {
        return this.mod;
    }

    public static ModWoodList getRandomWood(Random rand) {
        ModWoodList wood = woodList[rand.nextInt(woodList.length)];
        while (!wood.exists) {
            wood = woodList[rand.nextInt(woodList.length)];
        }
        return wood;
    }

    public boolean isRareTree() {
        if (this.isMagicTFTree()) {
            return true;
        }
        return this == SILVERWOOD;
    }

    public boolean isMagicTFTree() {
        if (this == TIMEWOOD) {
            return true;
        }
        if (this == SORTING) {
            return true;
        }
        if (this == MINEWOOD) {
            return true;
        }
        return this == TRANSFORMATION;
    }

    @Override
    public boolean canBePlacedSideways() {
        return this.getLogMetadatas().size() == 3;
    }

    public boolean isNaturalLeaf(World world, int x, int y, int z) {
        if (this.getParentMod() == ModList.BOP || this.getParentMod() == ModList.THAUMCRAFT || this.getParentMod() == ModList.NATURA || this.getParentMod() == ModList.TWILIGHT) {
            return (world.func_72805_g(x, y, z) & 4) == 0;
        }
        return true;
    }

    @Override
    public BlockBox getTypicalMaximumSize() {
        return this.bounds;
    }

    public static Collection<ModWoodList> getAllWoodsByMod(ModList mod) {
        return modMappings.get(mod);
    }

    static {
        woodList = ModWoodList.values();
        logMappings = new BlockMap();
        leafMappings = new BlockMap();
        saplingMappings = new BlockMap();
        modMappings = new MultiMap(MultiMap.CollectionType.HASHSET);
        for (int i = 0; i < woodList.length; ++i) {
            int k;
            ModWoodList w = woodList[i];
            if (!w.exists()) continue;
            Block id = w.blockID;
            Block leaf = w.leafID;
            int[] metas = w.blockMeta;
            int[] leafmetas = w.leafMeta;
            Block sapling = w.saplingID;
            int saplingMeta = w.saplingMeta;
            for (k = 0; k < metas.length; ++k) {
                logMappings.put(id, metas[k], w);
            }
            for (k = 0; k < leafmetas.length; ++k) {
                leafMappings.put(leaf, leafmetas[k], w);
            }
            if (sapling != null) {
                saplingMappings.put(sapling, saplingMeta, w);
            }
            modMappings.addValue(w.mod, w);
        }
    }

    public static enum VarType {
        ITEMSTACK,
        INSTANCE,
        REGISTRY;


        public String toString() {
            return "Variable Type " + ReikaStringParser.capFirstChar(this.name());
        }
    }
}

