/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Auxiliary;

import Reika.DragonAPI.Auxiliary.Trackers.ReflectiveFailureTracker;
import Reika.DragonAPI.Instantiable.BasicModEntry;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Event.CreeperExplodeEvent;
import Reika.DragonAPI.Instantiable.RayTracer;
import Reika.DragonAPI.Interfaces.Registry.ModEntry;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.MESystemReader;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModWoodList;
import Reika.ReactorCraft.API.RadiationHandler;
import Reika.ReactorCraft.Entities.EntityNeutron;
import Reika.ReactorCraft.Entities.EntityRadiation;
import Reika.ReactorCraft.ReactorCraft;
import Reika.ReactorCraft.Registry.RadiationShield;
import Reika.ReactorCraft.Registry.ReactorBlocks;
import Reika.ReactorCraft.Registry.ReactorItems;
import Reika.RotaryCraft.Items.Tools.Bedrock.ItemBedrockArmor;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridNode;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IReadOnlyCollection;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.nodes.INode;
import thaumcraft.api.nodes.NodeModifier;
import thaumcraft.api.nodes.NodeType;

public class RadiationEffects {
    private static final Random rand = new Random();
    private static Class electricalAgeBlock;
    public static final RadiationEffects instance;
    private final RayTracer tracer = new RayTracer(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    private RadiationEffects() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void dirtyBombs(CreeperExplodeEvent evt) {
        if (evt.creeper.getEntityData().func_74767_n("radioactive")) {
            World world = evt.creeper.field_70170_p;
            int x = MathHelper.func_76128_c((double)evt.creeper.field_70165_t);
            int y = MathHelper.func_76128_c((double)evt.creeper.field_70163_u);
            int z = MathHelper.func_76128_c((double)evt.creeper.field_70161_v);
            this.contaminateArea(world, x, y, z, 4, 3.0f, 1.5, true, RadiationIntensity.MODERATE);
        }
    }

    public boolean applyEffects(EntityLivingBase e, RadiationIntensity ri) {
        if (ri.causesHarm()) {
            if (!(e.func_70644_a((Potion)ReactorCraft.radiation) || this.isEntityImmuneToAll(e) || ri.hasSufficientShielding(e))) {
                e.func_70690_d(this.getRadiationEffect(ri));
                return true;
            }
            if (ReikaEntityHelper.isEntityWearingPoweredArmor((EntityLivingBase)e)) {
                for (int i = 1; i <= 4; ++i) {
                    ReikaItemHelper.dechargeItem((ItemStack)e.func_71124_b(i));
                }
            }
            if (e instanceof EntityCreeper) {
                EntityCreeper ec = (EntityCreeper)e;
                ec.getEntityData().func_74757_a("radioactive", true);
            }
        }
        return false;
    }

    public void applyPulseEffects(EntityLivingBase e, RadiationIntensity ri) {
        if (!(e.func_70644_a((Potion)ReactorCraft.radiation) || this.isEntityImmuneToAll(e) || ri.hasSufficientShielding(e))) {
            e.func_70690_d(this.getRadiationEffect(20, ri));
        }
    }

    public boolean isEntityImmuneToAll(EntityLivingBase e) {
        return e instanceof EntityPlayer && ((EntityPlayer)e).field_71075_bZ.field_75098_d;
    }

    public boolean hasHazmatSuit(EntityLivingBase e) {
        return ReikaEntityHelper.isEntityWearingFullSuitOf((EntityLivingBase)e, is -> this.isValidHazmatItem((ItemStack)is));
    }

    private boolean isValidHazmatItem(ItemStack is) {
        ReactorItems ri = ReactorItems.getEntry(is);
        return ri != null && ri.isHazmat();
    }

    public double contaminateArea(World world, int x, int y, int z, int range, float density, double force, boolean los, RadiationIntensity ri) {
        double frac = 1.0;
        int num = Math.max(1, (int)(Math.sqrt(range) * (double)density));
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)x, (double)y, (double)z).func_72314_b((double)range, (double)range, (double)range);
        for (int i = 0; i < num; ++i) {
            int dx = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)range);
            int dy = ReikaRandomHelper.getRandomPlusMinus((int)y, (int)range);
            int dz = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)range);
            while (los && !this.isValidRadiationPosition(world, x, y, z, dx, dy, dz, 2.0)) {
                dx = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)range);
                dy = ReikaRandomHelper.getRandomPlusMinus((int)y, (int)range);
                dz = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)range);
            }
            if (ReikaMathLibrary.py3d((double)(dx - x), (double)(dy - y), (double)(dz - z)) <= force) {
                frac -= 1.0 / (double)num;
            }
            EntityRadiation rad = new EntityRadiation(world, range, ri);
            rad.func_70012_b((double)dx + 0.5, (double)dy + 0.5, (double)dz + 0.5, 0.0f, 0.0f);
            if (world.field_72995_K) continue;
            world.func_72838_d((Entity)rad);
        }
        return frac;
    }

    private boolean isValidRadiationPosition(World world, int x, int y, int z, int dx, int dy, int dz, double forceDist) {
        if (ReikaMathLibrary.py3d((double)(dx - x), (double)(dy - y), (double)(dz - z)) <= forceDist) {
            return true;
        }
        ArrayList li = ReikaWorldHelper.getBlocksAlongVector((World)world, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (double)((double)dx + 0.5), (double)((double)dy + 0.5), (double)((double)dz + 0.5));
        double chance = 1.0;
        for (BlockKey bk : li) {
            RadiationShield rs = RadiationShield.getFrom(bk.blockID, bk.metadata);
            if (rs == null) continue;
            chance *= 1.0 - rs.radiationDeflectChance / 100.0;
        }
        boolean flag = chance > 0.0 && ReikaRandomHelper.doWithChance((double)chance);
        return flag;
    }

    public void transformBlock(World world, int x, int y, int z, RadiationIntensity ri) {
        if (world.field_72995_K) {
            return;
        }
        Block id = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (id == Blocks.field_150350_a) {
            return;
        }
        if (id == Blocks.field_150330_I) {
            return;
        }
        if (electricalAgeBlock == id.getClass()) {
            return;
        }
        if (ri.isAtLeast(RadiationIntensity.HIGHLEVEL)) {
            if (id == Blocks.field_150362_t || id == Blocks.field_150361_u || id.func_149688_o() == Material.field_151584_j || ModWoodList.isModLeaf((Block)id, (int)meta)) {
                world.func_147468_f(x, y, z);
            }
            if (id == Blocks.field_150436_aH) {
                id.func_149697_b(world, x, y, z, meta, 0);
                world.func_147468_f(x, y, z);
            }
            if (id == Blocks.field_150329_H) {
                world.func_147449_b(x, y, z, (Block)Blocks.field_150330_I);
            }
            if (id == Blocks.field_150395_bd) {
                id.func_149697_b(world, x, y, z, meta, 0);
                world.func_147468_f(x, y, z);
            }
            if (id == Blocks.field_150392_bi) {
                id.func_149697_b(world, x, y, z, meta, 0);
                world.func_147468_f(x, y, z);
            }
            if (id == Blocks.field_150328_O) {
                id.func_149697_b(world, x, y, z, meta, 0);
                world.func_147468_f(x, y, z);
            }
            if (id == Blocks.field_150327_N) {
                id.func_149697_b(world, x, y, z, meta, 0);
                world.func_147468_f(x, y, z);
            }
            if (id == Blocks.field_150464_aj) {
                id.func_149697_b(world, x, y, z, meta, 0);
                world.func_147468_f(x, y, z);
            }
            if (id == Blocks.field_150459_bM) {
                id.func_149697_b(world, x, y, z, meta, 0);
                world.func_147468_f(x, y, z);
            }
            if (id == Blocks.field_150469_bN) {
                id.func_149697_b(world, x, y, z, meta, 0);
                world.func_147468_f(x, y, z);
            }
            if (id == Blocks.field_150434_aF || id.func_149688_o() == Material.field_151570_A) {
                id.func_149697_b(world, x, y, z, meta, 0);
                world.func_147468_f(x, y, z);
            }
            if (id == Blocks.field_150423_aK) {
                id.func_149697_b(world, x, y, z, meta, 0);
                world.func_147468_f(x, y, z);
            }
            if (id == Blocks.field_150393_bb) {
                id.func_149697_b(world, x, y, z, meta, 0);
                world.func_147468_f(x, y, z);
            }
            if (id == Blocks.field_150440_ba) {
                id.func_149697_b(world, x, y, z, meta, 0);
                world.func_147468_f(x, y, z);
            }
            if (id == Blocks.field_150394_bc) {
                id.func_149697_b(world, x, y, z, meta, 0);
                world.func_147468_f(x, y, z);
            }
            if (id == Blocks.field_150345_g || id.func_149688_o() == Material.field_151585_k) {
                world.func_147449_b(x, y, z, (Block)Blocks.field_150330_I);
            }
            if (id == Blocks.field_150375_by) {
                id.func_149697_b(world, x, y, z, meta, 0);
                world.func_147468_f(x, y, z);
            }
            if (id == Blocks.field_150341_Y) {
                world.func_147449_b(x, y, z, Blocks.field_150347_e);
            }
            if (id == Blocks.field_150349_c || id.func_149688_o() == Material.field_151577_b) {
                world.func_147449_b(x, y, z, Blocks.field_150346_d);
            }
            if (id == Blocks.field_150418_aU) {
                world.func_147465_d(x, y, z, ReikaBlockHelper.getSilverfishImitatedBlock((int)meta), 0, 3);
            }
        }
        if (id == ReactorBlocks.FLUORITE.getBlockInstance() || id == ReactorBlocks.FLUORITEORE.getBlockInstance()) {
            world.func_147465_d(x, y, z, id, meta + 8, 3);
            world.func_147479_m(x, y, z);
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (ri.isAtLeast(RadiationIntensity.MODERATE) && ModList.THAUMCRAFT.isLoaded() && te instanceof INode) {
            INode n = (INode)te;
            n.addToContainer(Aspect.POISON, 10);
            n.addToContainer(Aspect.DEATH, 5);
            n.addToContainer(Aspect.ENTROPY, 10);
            n.addToContainer(Aspect.AURA, 5);
            n.addToContainer(Aspect.TAINT, 5);
            n.addToContainer(Aspect.ENERGY, 2);
            if (rand.nextInt(4) == 0) {
                if (n.getNodeType() == NodeType.NORMAL) {
                    n.setNodeType(NodeType.UNSTABLE);
                } else if (n.getNodeType() == NodeType.UNSTABLE) {
                    n.setNodeType(NodeType.TAINTED);
                }
            }
            if (rand.nextInt(8) == 0) {
                n.setNodeModifier(NodeModifier.BRIGHT);
            }
        }
    }

    public PotionEffect getRadiationEffect(RadiationIntensity ri) {
        return this.getRadiationEffect(ri.potionDuration, ri);
    }

    private PotionEffect getRadiationEffect(int duration, RadiationIntensity ri) {
        PotionEffect pot = new PotionEffect(ReactorCraft.radiation.field_76415_H, duration, ri.ordinal());
        pot.setCurativeItems(new ArrayList());
        return pot;
    }

    public void doOreIrradiation(World world, int x, int y, int z, EntityPlayer ep) {
        int r = 9;
        double dd = ep.func_70092_e((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        if (dd <= (double)(r * r)) {
            for (double dx = 0.0; dx <= 1.0; dx += 1.0) {
                for (double dy = 0.0; dy <= 1.0; dy += 1.0) {
                    for (double dz = 0.0; dz <= 1.0; dz += 1.0) {
                        for (double dh = 0.0; dh <= (double)ep.field_70131_O; dh += (double)(ep.field_70131_O / 2.0f)) {
                            this.tracer.setOrigins((double)x + dx, (double)y + dy, (double)z + dz, ep.field_70165_t, ep.field_70163_u + dh, ep.field_70161_v);
                            if (!this.tracer.isClearLineOfSight(world)) continue;
                            int dur = (int)(200.0 / Math.max(1.0, Math.sqrt(dd)));
                            PotionEffect e = this.getRadiationEffect(dur, RadiationIntensity.LOWLEVEL);
                            ep.func_70690_d(e);
                            return;
                        }
                    }
                }
            }
        }
    }

    public MESystemReader.MESystemEffect createMESystemEffect() {
        return new MESystemReader.ItemInSystemEffect(ReactorItems.WASTE.getStackOfMetadata(Short.MAX_VALUE)){

            public int getTickFrequency() {
                return 2400;
            }

            protected void doEffect(IGrid grid, long amt) {
                IReadOnlyCollection c = grid.getNodes();
                HashSet<WorldLocation> locations = new HashSet<WorldLocation>();
                for (IGridNode ign : c) {
                    IGridBlock igb = ign.getGridBlock();
                    if (igb == null || !igb.isWorldAccessible()) continue;
                    DimensionalCoord loc = igb.getLocation();
                    locations.add(new WorldLocation(loc.getWorld(), loc.x, loc.y, loc.z));
                }
                WorldLocation loc = (WorldLocation)ReikaJavaLibrary.getRandomCollectionEntry((Random)rand, locations);
                this.leakRadiation(loc.getWorld(), loc.xCoord, loc.yCoord, loc.zCoord);
            }

            protected void leakRadiation(World world, int x, int y, int z) {
                ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[rand.nextInt(6)];
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)new EntityNeutron(world, x, y, z, dir, EntityNeutron.NeutronType.WASTE));
                }
            }
        };
    }

    static {
        instance = new RadiationEffects();
        String modid = "Eln";
        if (Loader.isModLoaded((String)modid)) {
            try {
                electricalAgeBlock = Class.forName("mods.eln.node.six.SixNode");
            }
            catch (Exception e) {
                ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)new BasicModEntry(modid), e);
                e.printStackTrace();
            }
        }
    }

    public static enum RadiationIntensity implements RadiationHandler.RadiationLevel
    {
        BACKGROUND(0),
        LOWLEVEL(100),
        MODERATE(1200),
        HIGHLEVEL(6000),
        LETHAL(36000);

        public static final RadiationIntensity[] radiationList;
        private final int potionDuration;

        private RadiationIntensity(int t) {
            this.potionDuration = t;
        }

        @Override
        public boolean causesHarm() {
            return this != BACKGROUND;
        }

        public boolean isAtLeast(RadiationIntensity ri) {
            return this.ordinal() >= ri.ordinal();
        }

        @Override
        public boolean hasSufficientShielding(EntityLivingBase e) {
            switch (this) {
                case BACKGROUND: {
                    return true;
                }
                case LETHAL: {
                    return false;
                }
                case HIGHLEVEL: {
                    return instance.hasHazmatSuit(e);
                }
                case MODERATE: {
                    Function<ItemStack, Boolean> func = is -> instance.isValidHazmatItem(is) || ItemBedrockArmor.isValidBedrockArmorItem((ItemStack)is);
                    return ReikaEntityHelper.isEntityWearingFullSuitOf((EntityLivingBase)e, func);
                }
                case LOWLEVEL: {
                    Function<ItemStack, Boolean> func = is -> instance.isValidHazmatItem(is) || ItemBedrockArmor.isValidBedrockArmorItem((ItemStack)is) || ReikaItemHelper.isDenseArmor((ItemStack)is);
                    return ReikaEntityHelper.isEntityWearingFullSuitOf((EntityLivingBase)e, func);
                }
            }
            return false;
        }

        static {
            radiationList = RadiationIntensity.values();
        }
    }
}

