/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Base;

import Reika.ChromatiCraft.API.ChromatiAPI;
import Reika.ChromatiCraft.API.CrystalElementAccessor;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.Isotopes;
import Reika.DragonAPI.Libraries.MathSci.ReikaNuclearHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaTimeHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.ModList;
import Reika.ReactorCraft.Auxiliary.WasteManager;
import Reika.ReactorCraft.Base.TileEntityInventoriedReactorBase;
import Reika.ReactorCraft.Entities.EntityNeutron;
import Reika.ReactorCraft.Registry.ReactorItems;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityWasteUnit
extends TileEntityInventoriedReactorBase {
    private long lastTickTime = -1L;

    protected void fill() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) != null) continue;
            ItemStack is = WasteManager.getFullyRandomWasteItem();
            this.func_70299_a(i, is);
        }
    }

    public abstract boolean leaksRadiation();

    public abstract boolean isValidIsotope(Isotopes var1);

    protected abstract boolean canBeAccelerated();

    protected abstract double getBaseDecayRate();

    private final double getAccelerationFactor() {
        double base = this.getBaseDecayRate();
        if (this.canBeAccelerated()) {
            base = Math.pow(base, this.getAcceleratorBoost());
        }
        return base * 192.0;
    }

    private final double getAcceleratorBoost() {
        if (!ModList.CHROMATICRAFT.isLoaded()) {
            return 1.0;
        }
        CrystalElementAccessor.CrystalElementProxy e = CrystalElementAccessor.getByEnum((String)"LIGHTBLUE");
        int tier = ChromatiAPI.getAPI().adjacency().getAdjacentUpgradeTier(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, e);
        if (tier <= 0) {
            return 1.0;
        }
        return Math.sqrt(ChromatiAPI.getAPI().adjacency().getFactor(e, tier));
    }

    protected final void decayWaste() {
        double mult = this.getAccelerationFactor();
        if (this.accountForOutGameTime()) {
            mult *= (double)(1L + this.getSkippedTicks());
        }
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.inv[i] == null || this.inv[i].func_77973_b() != ReactorItems.WASTE.getItemInstance()) continue;
            Isotopes atom = Isotopes.getIsotope((int)this.inv[i].func_77960_j());
            if (ReikaRandomHelper.doWithChance((double)(mult / this.getBaseDecayRate() * 0.5 * ReikaNuclearHelper.getDecayChanceFromHalflife((double)Math.log(atom.getMCHalfLife())))) && this.leaksRadiation() && rand.nextBoolean()) {
                this.leakRadiation(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            if (!ReikaNuclearHelper.shouldDecay((Isotopes)atom, (double)mult)) continue;
            ReikaInventoryHelper.decrStack((int)i, (IInventory)this, (int)Math.max(1, this.inv[i].field_77994_a / 2));
            this.onDecayWaste(i);
        }
    }

    protected abstract boolean accountForOutGameTime();

    private long getSkippedTicks() {
        long time = System.currentTimeMillis();
        long dur = time - this.lastTickTime;
        long ticks = 0L;
        if (dur > 50L) {
            ticks = dur / 50L - 1L;
        }
        this.lastTickTime = time;
        return ticks;
    }

    protected void onDecayWaste(int i) {
    }

    protected void leakRadiation(World world, int x, int y, int z) {
        ForgeDirection dir = this.dirs[rand.nextInt(this.dirs.length)];
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)new EntityNeutron(world, x, y, z, dir, EntityNeutron.NeutronType.WASTE));
        }
    }

    public final boolean func_94041_b(int i, ItemStack is) {
        return is.func_77973_b() == ReactorItems.WASTE.getItemInstance() && is.func_77960_j() < 1000 && this.isValidIsotope(Isotopes.getIsotope((int)is.func_77960_j())) && this.isValidSlot(i, is);
    }

    protected boolean isValidSlot(int i, ItemStack is) {
        return true;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public final boolean canItemEnterFromSide(ForgeDirection dir) {
        return true;
    }

    @Override
    public final boolean canItemExitToSide(ForgeDirection dir) {
        return true;
    }

    public final int countWaste() {
        int count = 0;
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.inv[i] == null || this.inv[i].func_77973_b() != ReactorItems.WASTE.getItemInstance()) continue;
            count += this.inv[i].field_77994_a;
        }
        return count;
    }

    public final boolean hasWaste() {
        return this.countWaste() > 0;
    }

    public final double getHalfLife(ItemStack is) {
        if (is.func_77973_b() != ReactorItems.WASTE.getItemInstance()) {
            return 0.0;
        }
        return WasteManager.getWasteList().get(is.func_77960_j()).getMCHalfLife();
    }

    protected final boolean isLongLivedWaste(ItemStack is) {
        return is.func_77973_b() == ReactorItems.WASTE.getItemInstance() && this.getHalfLife(is) > (double)(6 * ReikaTimeHelper.YEAR.getMinecraftDuration());
    }

    protected final boolean isLongLivedWaste(Isotopes i) {
        return i.getMCHalfLife() > (double)(6 * ReikaTimeHelper.YEAR.getMinecraftDuration());
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.lastTickTime = NBT.func_74763_f("lasttime");
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        NBT.func_74772_a("lasttime", this.lastTickTime);
    }
}

