/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft;

import Reika.DragonAPI.Auxiliary.Trackers.DonatorController;
import Reika.DragonAPI.Auxiliary.Trackers.PatreonController;
import Reika.DragonAPI.Auxiliary.Trackers.PlayerSpecificRenderer;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.DragonOptions;
import Reika.DragonAPI.Instantiable.Rendering.ItemSpriteSheetRenderer;
import Reika.DragonAPI.Interfaces.PlayerRenderObj;
import Reika.ReactorCraft.Auxiliary.DonatorToroidRender;
import Reika.ReactorCraft.Auxiliary.ReactorRenderList;
import Reika.ReactorCraft.CommonProxy;
import Reika.ReactorCraft.Entities.EntityFusion;
import Reika.ReactorCraft.Entities.EntityNeutron;
import Reika.ReactorCraft.Entities.EntityPlasma;
import Reika.ReactorCraft.Entities.EntityRadiation;
import Reika.ReactorCraft.Entities.RenderFusion;
import Reika.ReactorCraft.Entities.RenderNeutron;
import Reika.ReactorCraft.Entities.RenderPlasma;
import Reika.ReactorCraft.Entities.RenderRadiation;
import Reika.ReactorCraft.ReactorCraft;
import Reika.ReactorCraft.ReactorItemRenderer;
import Reika.ReactorCraft.Registry.ReactorItems;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.ReactorCraft.SteamLineRenderer;
import Reika.ReactorCraft.TritiumLampRenderer;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;

public class ClientProxy
extends CommonProxy {
    public static final ItemSpriteSheetRenderer[] items = new ItemSpriteSheetRenderer[]{new ItemSpriteSheetRenderer((DragonAPIMod)ReactorCraft.instance, ReactorCraft.class, "Textures/Items/items1.png")};
    private static final ReactorItemRenderer reactor = new ReactorItemRenderer();
    public static SteamLineRenderer line;
    public static TritiumLampRenderer lamp;
    private static final HashMap<ReactorItems, String> armorAssets;

    @Override
    public void addArmorRenders() {
        hazmat = RenderingRegistry.addNewArmourRendererPrefix((String)"hazmat");
        ClientProxy.addArmorTexture(ReactorItems.HAZBOOTS, "/Reika/ReactorCraft/Textures/Misc/haz_1.png");
        ClientProxy.addArmorTexture(ReactorItems.HAZHELMET, "/Reika/ReactorCraft/Textures/Misc/haz_1.png");
        ClientProxy.addArmorTexture(ReactorItems.HAZCHEST, "/Reika/ReactorCraft/Textures/Misc/haz_1.png");
        ClientProxy.addArmorTexture(ReactorItems.HAZLEGS, "/Reika/ReactorCraft/Textures/Misc/haz_2.png");
    }

    private static void addArmorTexture(ReactorItems item, String tex) {
        ReactorCraft.logger.log((Object)("Adding armor texture for " + (Object)((Object)item) + ": " + tex));
        String[] s = tex.split("/");
        String file = s[s.length - 1];
        String defaultTex = "reactorcraft:textures/models/armor/" + file;
        armorAssets.put(item, defaultTex);
    }

    public static String getArmorTextureAsset(ReactorItems item) {
        return armorAssets.get((Object)item);
    }

    @Override
    public void registerSounds() {
        this.sounds.register();
    }

    @Override
    public void registerRenderers() {
        if (DragonOptions.NORENDERS.getState()) {
            ReactorCraft.logger.log((Object)"Disabling all machine renders for FPS and lag profiling.");
        } else {
            this.loadModels();
        }
        this.addArmorRenders();
        lineRender = RenderingRegistry.getNextAvailableRenderId();
        line = new SteamLineRenderer(lineRender);
        RenderingRegistry.registerBlockHandler((int)lineRender, (ISimpleBlockRenderingHandler)line);
        lampRender = RenderingRegistry.getNextAvailableRenderId();
        lamp = new TritiumLampRenderer(lampRender);
        RenderingRegistry.registerBlockHandler((int)lampRender, (ISimpleBlockRenderingHandler)lamp);
        this.registerSpriteSheets();
        RenderingRegistry.registerEntityRenderingHandler(EntityNeutron.class, (Render)new RenderNeutron());
        RenderingRegistry.registerEntityRenderingHandler(EntityRadiation.class, (Render)new RenderRadiation());
        RenderingRegistry.registerEntityRenderingHandler(EntityPlasma.class, (Render)new RenderPlasma());
        RenderingRegistry.registerEntityRenderingHandler(EntityFusion.class, (Render)new RenderFusion());
    }

    private void registerSpriteSheets() {
        for (int i = 0; i < ReactorItems.itemList.length; ++i) {
            if (ReactorItems.itemList[i].getSpriteIndex() <= -1) continue;
            MinecraftForgeClient.registerItemRenderer((Item)ReactorItems.itemList[i].getItemInstance(), (IItemRenderer)items[ReactorItems.itemList[i].getSpriteSheet()]);
        }
    }

    public void loadModels() {
        for (int i = 0; i < ReactorTiles.TEList.length; ++i) {
            ReactorTiles m = ReactorTiles.TEList[i];
            if (!m.hasRender() || m.isPipe()) continue;
            ClientRegistry.bindTileEntitySpecialRenderer((Class)m.getTEClass(), (TileEntitySpecialRenderer)ReactorRenderList.instantiateRenderer(m));
        }
        MinecraftForgeClient.registerItemRenderer((Item)ReactorItems.PLACER.getItemInstance(), (IItemRenderer)reactor);
    }

    @Override
    public World getClientWorld() {
        return FMLClientHandler.instance().getClient().field_71441_e;
    }

    @Override
    public void loadDonatorRender() {
        ArrayList donators = new ArrayList();
        donators.addAll(DonatorController.instance.getReikasDonators());
        donators.addAll(PatreonController.instance.getModPatrons("Reika"));
        for (DonatorController.Donator s : donators) {
            if (s.ingameName != null) {
                PlayerSpecificRenderer.instance.registerRenderer(s.ingameName, (PlayerRenderObj)DonatorToroidRender.instance);
                continue;
            }
            ReactorCraft.logger.logError((Object)("Donator " + s.displayName + " UUID could not be found! Cannot give special render!"));
        }
    }

    static {
        armorAssets = new HashMap();
    }
}

