/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.GUIs;

import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Instantiable.Rendering.StructureRenderer;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaGuiAPI;
import Reika.ReactorCraft.Auxiliary.ReactorDescriptions;
import Reika.ReactorCraft.Auxiliary.ReactorStacks;
import Reika.ReactorCraft.ReactorCraft;
import Reika.ReactorCraft.Registry.CraftingItems;
import Reika.ReactorCraft.Registry.ReactorBlocks;
import Reika.ReactorCraft.Registry.ReactorBook;
import Reika.ReactorCraft.Registry.ReactorItems;
import Reika.ReactorCraft.Registry.ReactorStructures;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.RotaryCraft.Auxiliary.HandbookAuxData;
import Reika.RotaryCraft.Auxiliary.Interfaces.HandbookEntry;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.MachineRecipeRenderer;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesBlastFurnace;
import Reika.RotaryCraft.GUIs.GuiHandbook;
import Reika.RotaryCraft.Registry.BlockRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiReactorBook
extends GuiHandbook {
    private int structureMode;

    public GuiReactorBook(EntityPlayer p5ep, World world, int s, int p) {
        super(p5ep, world, s, p);
    }

    protected void reloadXMLData() {
        ReactorDescriptions.reload();
    }

    protected void addTabButtons(int j, int k) {
        ReactorBook.addRelevantButtons(j, k, this.screen, this.field_146292_n);
    }

    public int getMaxScreen() {
        return ReactorBook.RESOURCEDESC.getScreen() + ReactorBook.RESOURCEDESC.getNumberChildren() / 8;
    }

    protected void onInitGui(int j, int k, HandbookEntry h) {
        for (int i = 0; i < ReactorStructures.structureList.length; ++i) {
            StructureRenderer s = ReactorStructures.structureList[i].getRenderer();
            s.resetRotation();
            if (h == ReactorBook.STRUCTURES) continue;
            s.reset();
        }
        if (h == ReactorBook.STRUCTURES && this.subpage > 0) {
            this.field_146292_n.add(new GuiButton(20, j + 256 - 77, k + 6, 20, 20, "3D"));
            this.field_146292_n.add(new GuiButton(21, j + 256 - 57, k + 6, 20, 20, "2D"));
            this.field_146292_n.add(new GuiButton(22, j + 256 - 97, k + 6, 20, 20, "N#"));
            if (this.structureMode == 1) {
                this.field_146292_n.add(new GuiButton(23, j + 256 - 77, k + 40, 20, 20, "+"));
                this.field_146292_n.add(new GuiButton(24, j + 256 - 57, k + 40, 20, 20, "-"));
            }
        }
    }

    protected void func_146284_a(GuiButton b) {
        if (b.field_146127_k == 20) {
            this.structureMode = 0;
            this.func_73866_w_();
            ReactorStructures.structureList[this.subpage - 1].getRenderer().resetStepY();
            return;
        }
        if (b.field_146127_k == 21) {
            this.structureMode = 1;
            this.func_73866_w_();
            ReactorStructures.structureList[this.subpage - 1].getRenderer().resetStepY();
            return;
        }
        if (b.field_146127_k == 22) {
            this.structureMode = 2;
            this.func_73866_w_();
            ReactorStructures.structureList[this.subpage - 1].getRenderer().resetStepY();
            return;
        }
        if (b.field_146127_k == 23) {
            ReactorStructures.structureList[this.subpage - 1].getRenderer().incrementStepY();
            this.func_73866_w_();
            return;
        }
        if (b.field_146127_k == 24) {
            ReactorStructures.structureList[this.subpage - 1].getRenderer().decrementStepY();
            this.func_73866_w_();
            return;
        }
        super.func_146284_a(b);
    }

    public int getMaxSubpage() {
        ReactorBook h = ReactorBook.getFromScreenAndPage(this.screen, this.page);
        if (h == ReactorBook.STRUCTURES) {
            return ReactorStructures.structureList.length;
        }
        if (h == ReactorBook.SHIELDING) {
            return 1;
        }
        return h.isMachine() ? 1 : 0;
    }

    protected int getNewScreenByTOCButton(int id) {
        switch (id) {
            case 1: {
                return ReactorBook.INTRO.getScreen();
            }
            case 2: {
                return ReactorBook.PROCDESC.getScreen();
            }
            case 3: {
                return ReactorBook.GENDESC.getScreen();
            }
            case 4: {
                return ReactorBook.HTGRDESC.getScreen();
            }
            case 5: {
                return ReactorBook.FISSIONDESC.getScreen();
            }
            case 6: {
                return ReactorBook.BREEDERDESC.getScreen();
            }
            case 7: {
                return ReactorBook.THORIUMDESC.getScreen();
            }
            case 8: {
                return ReactorBook.FUSIONDESC.getScreen();
            }
            case 9: {
                return ReactorBook.ACCDESC.getScreen();
            }
            case 10: {
                return ReactorBook.TOOLDESC.getScreen();
            }
            case 11: {
                return ReactorBook.RESOURCEDESC.getScreen();
            }
        }
        return 0;
    }

    protected boolean isOnTOC() {
        return this.getEntry() == ReactorBook.TOC;
    }

    protected void drawAuxData(int posX, int posY) {
        ItemStack in;
        ArrayList out;
        ReactorBook h = (ReactorBook)this.getEntry();
        if (h.isMachine()) {
            out = ReikaJavaLibrary.makeListFrom((Object)h.getMachine().getCraftedProduct());
            if (out == null || out.size() <= 0) {
                return;
            }
            ReikaGuiAPI.instance.drawCustomRecipes(ri, this.field_146289_q, (List)out, HandbookAuxData.getWorktable(), posX + 72 - 18, posY + 18, posX - 1620, posY + 32);
        }
        if (this.getGuiLayout() == GuiHandbook.PageType.CRAFTING) {
            out = ReikaJavaLibrary.makeListFrom((Object)h.getItem().getStackOf());
            if (out == null || out.size() <= 0) {
                return;
            }
            ReikaGuiAPI.instance.drawCustomRecipes(ri, this.field_146289_q, (List)out, CraftingManager.func_77594_a().func_77592_b(), posX + 72, posY + 18, posX + 162, posY + 32);
        }
        if (h == ReactorBook.MAGNET) {
            in = ReactorStacks.lodestone;
            ItemStack out2 = ReactorItems.MAGNET.getStackOf();
            int k = (int)(System.nanoTime() / 2000000000L % (long)ReactorItems.MAGNET.getNumberMetadatas());
            if (k != 0) {
                in = ReactorItems.MAGNET.getStackOfMetadata(k - 1);
                out2 = ReactorItems.MAGNET.getStackOfMetadata(k);
            }
            MachineRecipeRenderer.instance.drawCompressor(posX + 66, posY + 14, in, posX + 120, posY + 41, out2);
        } else if (h == ReactorBook.PELLET) {
            in = CraftingItems.GRAPHITE.getItem();
            ItemStack in2 = CraftingItems.UDUST.getItem();
            ItemStack out3 = ReactorItems.PELLET.getStackOf();
            RecipesBlastFurnace.BlastCrafting r = (RecipesBlastFurnace.BlastCrafting)RecipesBlastFurnace.getRecipes().getAllCraftingMaking(out3).get(0);
            MachineRecipeRenderer.instance.drawBlastFurnaceCrafting(posX + 99, posY + 18, posX + 180, posY + 32, r);
            ReikaGuiAPI.instance.drawCenteredStringNoShadow(this.field_146289_q, r.temperature + "C", posX + 56, posY + 66, 0);
        }
    }

    protected void doRenderMachine(double x, double y, HandbookEntry he) {
        ReactorBook h = (ReactorBook)he;
        ReactorTiles rt = h.getMachine();
        if (rt != null) {
            TileEntity te = rt.createTEInstanceForRender();
            double sc = 48.0;
            int r = (int)(System.nanoTime() / 20000000L) % 360;
            double a = 0.0;
            double b = 0.0;
            double c = 0.0;
            if (rt == ReactorTiles.STEAMLINE) {
                a = 0.33;
                b = 0.25;
                c = 0.33;
            }
            if (rt == ReactorTiles.CONTROL) {
                b = -0.1875;
            }
            if (rt.hasRender() && !rt.isPipe()) {
                double dx = -x;
                double dy = -y - 21.0;
                double dz = 0.0;
                GL11.glTranslated((double)(-dx), (double)(-dy), (double)(-dz));
                GL11.glScaled((double)sc, (double)(-sc), (double)sc);
                GL11.glRotatef((float)this.renderq, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)r, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslated((double)a, (double)b, (double)c);
                TileEntityRendererDispatcher.field_147556_a.func_147549_a(te, -0.5, 0.0, -0.5, 0.0f);
                GL11.glTranslated((double)(-a), (double)(-b), (double)(-c));
                GL11.glRotatef((float)(-r), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)(-this.renderq), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslated((double)(-dx), (double)(-dy), (double)(-dz));
                GL11.glScaled((double)(1.0 / sc), (double)(-1.0 / sc), (double)(1.0 / sc));
            } else {
                double dx = x;
                double dy = y;
                double dz = 0.0;
                GL11.glTranslated((double)dx, (double)dy, (double)dz);
                GL11.glScaled((double)sc, (double)(-sc), (double)sc);
                GL11.glRotatef((float)this.renderq, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)r, (float)0.0f, (float)1.0f, (float)0.0f);
                ReikaTextureHelper.bindTerrainTexture();
                GL11.glTranslated((double)a, (double)b, (double)c);
                rb.func_147800_a(rt.getBlockInstance(), rt.getBlockMetadata(), 1.0f);
                GL11.glTranslated((double)(-a), (double)(-b), (double)(-c));
                GL11.glRotatef((float)(-r), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)(-this.renderq), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glScaled((double)(1.0 / sc), (double)(-1.0 / sc), (double)(1.0 / sc));
                GL11.glTranslated((double)(-dx), (double)(-dy), (double)(-dz));
            }
        }
    }

    protected void drawAuxGraphics(int posX, int posY, float ptick) {
        ReactorBook h = (ReactorBook)this.getEntry();
        ReikaGuiAPI api = ReikaGuiAPI.instance;
        if (h == ReactorBook.STRUCTURES && this.subpage != 0) {
            ReactorStructures s = ReactorStructures.structureList[this.subpage - 1];
            StructureRenderer r = s.getRenderer();
            this.field_146289_q.func_78276_b(s.getName(), posX + 8, posY + 16, 0);
            if (this.structureMode == 0) {
                if (Mouse.isButtonDown((int)0) && this.getGuiTick() > 2) {
                    r.rotate(0.25 * (double)Mouse.getDY(), 0.25 * (double)Mouse.getDX(), 0.0);
                } else if (Mouse.isButtonDown((int)1)) {
                    r.resetRotation();
                }
                if (Keyboard.isKeyDown((int)30)) {
                    r.rotate(0.0, 0.75, 0.0);
                } else if (Keyboard.isKeyDown((int)32)) {
                    r.rotate(0.0, -0.75, 0.0);
                } else if (Keyboard.isKeyDown((int)17)) {
                    r.rotate(-0.75, 0.0, 0.0);
                } else if (Keyboard.isKeyDown((int)31)) {
                    r.rotate(0.75, 0.0, 0.0);
                }
                r.draw3D(posX, posY, ptick, true);
            } else if (this.structureMode == 1) {
                r.drawSlice(posX, posY, this.field_146289_q);
            } else if (this.structureMode == 2) {
                this.drawTally(s, posX, posY);
            }
        }
    }

    private void drawTally(ReactorStructures s, int j, int k) {
        ItemHashMap map = s.getStructure(this.worldObj, 0, 0, 0, ForgeDirection.EAST).tally();
        int i = 0;
        int n = 8;
        ArrayList c = new ArrayList(map.keySet());
        Collections.sort(c, ReikaItemHelper.comparator);
        for (ItemStack is : c) {
            BlockRegistry b2;
            int dx = j + 10 + i / n * 50;
            int dy = k + 30 + i % n * 22;
            ItemStack is2 = is.func_77946_l();
            ReactorBlocks b = ReactorBlocks.getFromItem(is2);
            if (b != null && b.isMachine()) {
                is2 = ReactorTiles.getMachineFromIDandMetadata(b.getBlockInstance(), is2.func_77960_j()).getCraftedProduct();
            }
            if ((b2 = BlockRegistry.getFromItem((ItemStack)is2)) != null && b2.isMachine()) {
                is2 = MachineRegistry.getMachineFromIDandMetadata((Block)b2.getBlockInstance(), (int)is2.func_77960_j()).getCraftedProduct();
            }
            ReikaGuiAPI.instance.drawItemStackWithTooltip(field_146296_j, this.field_146289_q, is2, dx, dy);
            this.field_146289_q.func_78276_b(String.valueOf(map.get(is)), dx + 20, dy + 5, 0);
            ++i;
        }
    }

    protected HandbookEntry getEntry() {
        return ReactorBook.getFromScreenAndPage(this.screen, this.page);
    }

    public boolean isLimitedView() {
        return false;
    }

    protected GuiHandbook.PageType getGuiLayout() {
        ReactorBook h = (ReactorBook)this.getEntry();
        if (this.isOnTOC()) {
            return GuiHandbook.PageType.TOC;
        }
        if (h.isParent()) {
            return GuiHandbook.PageType.PLAIN;
        }
        if (h == ReactorBook.STRUCTURES && this.subpage > 0) {
            return GuiHandbook.PageType.SOLID;
        }
        if (this.subpage >= 1) {
            return GuiHandbook.PageType.PLAIN;
        }
        if (h.isMachine()) {
            return GuiHandbook.PageType.MACHINERENDER;
        }
        if (h.getParent() == ReactorBook.TOOLDESC) {
            return GuiHandbook.PageType.CRAFTING;
        }
        if (h == ReactorBook.FUEL) {
            return GuiHandbook.PageType.CRAFTING;
        }
        if (h == ReactorBook.BREEDERFUEL) {
            return GuiHandbook.PageType.CRAFTING;
        }
        if (h == ReactorBook.MAGNET) {
            return GuiHandbook.PageType.COMPACTOR;
        }
        if (h == ReactorBook.PELLET) {
            return GuiHandbook.PageType.BLASTFURNACE;
        }
        return GuiHandbook.PageType.PLAIN;
    }

    protected void bindTexture() {
        ReactorBook h = (ReactorBook)this.getEntry();
        if (h == ReactorBook.FUSIONINFO) {
            ReikaTextureHelper.bindTexture(ReactorCraft.class, (String)"Textures/GUI/Handbook/fusion.png");
        } else if (h == ReactorBook.FISSIONINFO) {
            ReikaTextureHelper.bindTexture(ReactorCraft.class, (String)"Textures/GUI/Handbook/fission.png");
        } else {
            super.bindTexture();
        }
    }

    public List<HandbookEntry> getAllTabsOnScreen() {
        List<ReactorBook> li = ReactorBook.getEntriesForScreen(this.screen);
        return new ArrayList<HandbookEntry>(li);
    }
}

