/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Items;

import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Maps.PlayerMap;
import Reika.DragonAPI.Interfaces.Registry.OreType;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaOreHelper;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModOreList;
import Reika.ReactorCraft.API.MagneticOreOverride;
import Reika.ReactorCraft.Base.ReactorItemBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class ItemIronFinder
extends ReactorItemBase {
    private static final PlayerMap<OreCollection> cache = new PlayerMap();
    private static final HashSet<OreType> ores = new HashSet(ReikaJavaLibrary.makeListFrom((Object[])new Enum[]{ReikaOreHelper.IRON, ReikaOreHelper.REDSTONE, ModOreList.NICKEL, ModOreList.COBALT, ModOreList.CERTUSQUARTZ, ModOreList.NIKOLITE, ModOreList.MAGNETITE, ModOreList.NETHERIRON, ModOreList.NETHERREDSTONE, ModOreList.NETHERNICKEL, ModOreList.NETHERNIKOLITE, ModOreList.TESLATITE, ModOreList.SILICON, ModOreList.DILITHIUM, ModOreList.MIMICHITE}));

    public ItemIronFinder(int tex) {
        super(tex);
    }

    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer ep) {
        return is;
    }

    public void func_77663_a(ItemStack is, World world, Entity e, int slot, boolean selected) {
        if (ModList.CHROMATICRAFT.isLoaded()) {
            this.tickAuraPouch(is, world, e, slot, selected);
        }
    }

    @DependentMethodStripper.ModDependent(value={ModList.CHROMATICRAFT})
    private void tickAuraPouch(ItemStack is, World world, Entity e, int slot, boolean selected) {
        if (e instanceof EntityPlayer && ChromaItems.AURAPOUCH.matchWith(((EntityPlayer)e).field_71071_by.field_70462_a[slot]) && world.func_82737_E() % 8L == 0L) {
            e.getEntityData().func_74772_a("ironfinder", world.func_82737_E());
        }
    }

    public static Set<Coordinate> getOreNearby(EntityPlayer ep, int range) {
        OreCollection c = (OreCollection)cache.get(ep);
        if (c == null || System.currentTimeMillis() - c.time >= 500L) {
            c = new OreCollection(ep, ItemIronFinder.findOreNearby(ep, range));
            cache.put(ep, (Object)c);
        }
        return Collections.unmodifiableSet(c.locations);
    }

    private static HashSet<Coordinate> findOreNearby(EntityPlayer ep, int range) {
        HashSet<Coordinate> m = new HashSet<Coordinate>();
        World world = ep.field_70170_p;
        int x = MathHelper.func_76128_c((double)ep.field_70165_t);
        int y = MathHelper.func_76128_c((double)(ep.field_70163_u + (double)ep.func_70047_e()));
        int z = MathHelper.func_76128_c((double)ep.field_70161_v);
        ArrayList c = new ArrayList();
        for (int i = -range; i <= range; ++i) {
            for (int j = -range; j <= range; ++j) {
                for (int k = -range; k <= range; ++k) {
                    ReikaOreHelper ore;
                    int dx = x + i;
                    int dy = y + j;
                    int dz = z + k;
                    Block b = world.func_147439_a(dx, dy, dz);
                    if (b instanceof MagneticOreOverride && ((MagneticOreOverride)b).showOnHUD(world, dx, dy, dz, ep)) {
                        m.add(new Coordinate(dx, dy, dz));
                    }
                    if ((ore = ReikaOreHelper.getFromVanillaOre((Block)b)) == null) {
                        ore = ModOreList.getModOreFromOre((Block)b, (int)world.func_72805_g(dx, dy, dz));
                    }
                    if (!ores.contains(ore)) continue;
                    m.add(new Coordinate(dx, dy, dz));
                }
            }
        }
        return m;
    }

    private static class OreCollection {
        public final long time;
        public final HashSet<Coordinate> locations;
        public final String player;

        private OreCollection(EntityPlayer ep, HashSet<Coordinate> c) {
            this.locations = c;
            this.player = ep.func_70005_c_();
            this.time = System.currentTimeMillis();
        }
    }
}

