/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Models;

import Reika.DragonAPI.Instantiable.Rendering.LODModelPart;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import Reika.RotaryCraft.Auxiliary.OldTextureLoader;
import Reika.RotaryCraft.Base.RotaryModelBase;
import java.util.ArrayList;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;

public class ModelTurbine
extends RotaryModelBase {
    private final LODModelPart shaft1;
    private final LODModelPart shaft1a;
    private final LODModelPart blade;
    protected final int stage;
    private int compiledList = -1;
    private EntityVillager villagerRender;

    public ModelTurbine(int stage) {
        this.field_78090_t = 128;
        this.field_78089_u = 128;
        this.stage = stage;
        this.shaft1 = new LODModelPart((ModelBase)this, 0, 106);
        this.shaft1a = new LODModelPart((ModelBase)this, 0, 106);
        this.blade = new LODModelPart((ModelBase)this, 0, 0);
        this.init();
        this.setCompilable(false);
    }

    private void init() {
        this.shaft1.func_78789_a(-2.0f, -2.0f, 0.0f, 4, 4, 16);
        this.shaft1.func_78793_a(0.0f, 15.0f, -8.0f);
        this.shaft1.func_78787_b(128, 128);
        this.shaft1.field_78809_i = true;
        this.setRotation(this.shaft1, 0.0f, 0.0f, 0.7853982f);
        this.shaft1a.func_78789_a(-2.0f, -2.0f, 0.0f, 4, 4, 16);
        this.shaft1a.func_78793_a(0.0f, 15.0f, -8.0f);
        this.shaft1a.func_78787_b(128, 128);
        this.shaft1a.field_78809_i = true;
        this.setRotation(this.shaft1a, 0.0f, 0.0f, 0.0f);
        this.blade.func_78789_a(-0.5f, (float)(-this.getBladeLength()), (float)(-this.getBladeWidth()) / 2.0f, 1, this.getBladeLength(), this.getBladeWidth());
        this.blade.func_78793_a(0.0f, 15.0f, 0.0f);
        this.blade.func_78787_b(128, 128);
        this.blade.field_78809_i = true;
        this.setRotation(this.blade, 0.0f, 0.0f, 0.0f);
    }

    private void clear() {
        this.shaft1.field_78804_l.clear();
        this.shaft1a.field_78804_l.clear();
        this.blade.field_78804_l.clear();
    }

    protected final void reset() {
        this.clear();
        this.init();
    }

    public void renderAll(TileEntity te, ArrayList li, float phi, float theta) {
        double vo = 0.9375;
        int damage = li != null ? (Integer)li.get(0) : 0;
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)vo, (double)0.0);
        GL11.glRotatef((float)phi, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslated((double)0.0, (double)(-vo), (double)0.0);
        this.renderModelDirect(te, damage, vo);
        GL11.glPopMatrix();
    }

    private void renderModelDirect(TileEntity te, int damage, double vo) {
        double dd = 0.25;
        double sc = this.getScaleFactor();
        this.shaft1.render(te, 0.0625f);
        this.shaft1a.render(te, 0.0625f);
        if (this.renderTwoStages()) {
            GL11.glTranslated((double)0.0, (double)0.0, (double)dd);
        }
        this.renderBlades(te, damage, vo, 0.0f);
        if (this.renderTwoStages()) {
            GL11.glTranslated((double)0.0, (double)0.0, (double)(-dd * 2.0));
            GL11.glTranslated((double)0.0, (double)vo, (double)0.0);
            GL11.glScaled((double)sc, (double)sc, (double)1.0);
            GL11.glTranslated((double)0.0, (double)(-vo), (double)0.0);
            this.renderBlades(te, damage, vo, 0.0f);
            GL11.glTranslated((double)0.0, (double)vo, (double)0.0);
            GL11.glScaled((double)(1.0 / sc), (double)(1.0 / sc), (double)1.0);
            GL11.glTranslated((double)0.0, (double)(-vo), (double)0.0);
            GL11.glTranslated((double)0.0, (double)0.0, (double)dd);
        }
    }

    protected boolean renderTwoStages() {
        return true;
    }

    private void renderBlades(TileEntity te, int damage, double vo, float phi) {
        double da = this.getAngularSeparation() * (damage + 1);
        int i = 0;
        while (i < 360) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)vo, (double)0.0);
            GL11.glRotatef((float)((float)i + phi), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslated((double)0.0, (double)(-vo), (double)0.0);
            GL11.glRotatef((float)(-this.getBladeTwist()), (float)0.0f, (float)1.0f, (float)0.0f);
            if (te.func_145830_o() && OldTextureLoader.instance.loadOldTextures()) {
                if (this.villagerRender == null) {
                    this.villagerRender = new EntityVillager(te.field_145850_b);
                }
                int n = 2;
                switch (this.stage) {
                    case 0: {
                        n = 5;
                        break;
                    }
                    case 1: {
                        n = 4;
                        break;
                    }
                    case 2: {
                        n = 3;
                    }
                }
                if ((double)i / da % (double)n == 0.0) {
                    double s = (float)this.getBladeLength() / 20.0f;
                    if (this.stage <= 1) {
                        s *= -0.75;
                        GL11.glTranslated((double)0.0, (double)1.375, (double)0.0);
                    }
                    GL11.glScaled((double)1.0, (double)s, (double)1.0);
                    RenderManager.field_78727_a.func_147940_a((Entity)this.villagerRender, 0.0, 0.0, 0.0, 0.0f, ReikaRenderHelper.getPartialTickTime());
                }
            } else {
                this.blade.render(te, 0.0625f);
            }
            GL11.glPopMatrix();
            i = (int)((double)i + da);
        }
    }

    public int getBladeLength() {
        switch (this.stage) {
            case 0: {
                return 16;
            }
            case 1: {
                return 24;
            }
            case 2: {
                return 28;
            }
            case 3: {
                return 33;
            }
            case 4: {
                return 40;
            }
        }
        return 4;
    }

    public int getAngularSeparation() {
        switch (this.stage) {
            case 0: {
                return 8;
            }
            case 1: {
                return 5;
            }
            case 2: {
                return 8;
            }
            case 3: {
                return 8;
            }
            case 4: {
                return 8;
            }
            case 5: {
                return 9;
            }
            case 6: {
                return 10;
            }
        }
        return 10;
    }

    public int getBladeTwist() {
        switch (this.stage) {
            case 0: {
                return 10;
            }
            case 1: {
                return 15;
            }
            case 2: {
                return 20;
            }
            case 3: {
                return 30;
            }
            case 4: {
                return 45;
            }
            case 5: {
                return 45;
            }
            case 6: {
                return 50;
            }
        }
        return 10;
    }

    public int getBladeWidth() {
        switch (this.stage) {
            case 0: {
                return 2;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 6;
            }
            case 6: {
                return 8;
            }
        }
        return 2;
    }

    public double getScaleFactor() {
        if (this.stage < 1) {
            return 1.3;
        }
        return 1.1;
    }
}

