/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Registry;

import Reika.DragonAPI.Base.StructureBase;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FilledBlockArray;
import Reika.DragonAPI.Instantiable.Rendering.StructureRenderer;
import Reika.DragonAPI.Interfaces.Registry.StructureEnum;
import Reika.ReactorCraft.Auxiliary.Structure.FlywheelStructure;
import Reika.ReactorCraft.Auxiliary.Structure.GeneratorStructure;
import Reika.ReactorCraft.Auxiliary.Structure.InjectorStructure;
import Reika.ReactorCraft.Auxiliary.Structure.PreheaterStructure;
import Reika.ReactorCraft.Auxiliary.Structure.SolenoidStructure;
import Reika.ReactorCraft.Auxiliary.Structure.TurbineStructure;
import Reika.ReactorCraft.Base.ReactorStructureBase;
import Reika.ReactorCraft.Registry.ReactorTiles;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Keyboard;

public enum ReactorStructures implements StructureEnum
{
    HEATER(ReactorTiles.HEATER, new PreheaterStructure()),
    GENERATOR(ReactorTiles.GENERATOR, new GeneratorStructure()),
    INJECTOR(ReactorTiles.INJECTOR, new InjectorStructure()),
    SOLENOID(ReactorTiles.SOLENOID, new SolenoidStructure()),
    HPTURBINE(ReactorTiles.BIGTURBINE, new TurbineStructure()),
    FLYWHEEL(ReactorTiles.FLYWHEEL, new FlywheelStructure());

    public static ReactorStructures[] structureList;
    private StructureRenderer render;
    private final ReactorTiles tile;
    public final ReactorStructureBase structure;

    private ReactorStructures(ReactorTiles r, ReactorStructureBase struct) {
        this.tile = r;
        this.structure = struct;
    }

    @SideOnly(value=Side.CLIENT)
    public StructureRenderer getRenderer() {
        if (this.render == null || Keyboard.isKeyDown((int)29)) {
            FilledBlockArray f = this.getStructure((World)Minecraft.func_71410_x().field_71441_e, 0, 0, 0, ForgeDirection.EAST);
            this.render = new StructureRenderer(f);
            this.addOverrides();
        }
        return this.render;
    }

    private void addOverrides() {
        this.render.addOverride(new ItemStack(this.tile.getBlock(), 1, this.tile.getBlockMetadata()), this.tile.getCraftedProduct());
        this.render.addOverride(new ItemStack(ReactorTiles.STEAMLINE.getBlock(), 1, ReactorTiles.STEAMLINE.getBlockMetadata()), ReactorTiles.STEAMLINE.getCraftedProduct());
    }

    public FilledBlockArray getStructure(World world, int x, int y, int z, ForgeDirection dir) {
        this.structure.dir = dir;
        return this.structure.getArray(world, x, y, z);
    }

    public String getName() {
        return StatCollector.func_74838_a((String)("reactorstruct." + this.name().toLowerCase(Locale.ENGLISH)));
    }

    public StructureBase getStructure() {
        return this.structure;
    }

    public boolean isNatural() {
        return false;
    }

    static {
        structureList = ReactorStructures.values();
    }
}

