/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Registry;

import Reika.ReactorCraft.Entities.EntityNeutron;

public enum ReactorType {
    FISSION,
    BREEDER,
    HTGR,
    THORIUM,
    FUSION,
    SOLAR,
    NULL;


    public double getHPTurbineMultiplier() {
        switch (this) {
            case FUSION: {
                return 1.5;
            }
            case HTGR: {
                return 0.25;
            }
            case SOLAR: {
                return 0.4f;
            }
            case NULL: {
                return 0.0;
            }
        }
        return 1.0;
    }

    public float getControlCPUHeatEfficiency() {
        switch (this) {
            case FUSION: 
            case HTGR: 
            case SOLAR: {
                return this.getTypeMismatchHeatEfficiency();
            }
        }
        return 1.0f;
    }

    public float getTypeMismatchHeatEfficiency() {
        switch (this) {
            case FISSION: {
                return 1.0f;
            }
            case HTGR: {
                return 0.0625f;
            }
            case FUSION: 
            case SOLAR: {
                return 0.0f;
            }
            case THORIUM: {
                return 0.25f;
            }
            case NULL: {
                return 0.0f;
            }
        }
        return 0.5f;
    }

    public EntityNeutron.NeutronType getNeutronType() {
        switch (this) {
            case BREEDER: {
                return EntityNeutron.NeutronType.BREEDER;
            }
            case FISSION: {
                return EntityNeutron.NeutronType.FISSION;
            }
            case FUSION: {
                return EntityNeutron.NeutronType.FUSION;
            }
            case THORIUM: {
                return EntityNeutron.NeutronType.THORIUM;
            }
        }
        return null;
    }
}

