/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities.Fission;

import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.ReactorCraft.Auxiliary.LinkableReactorCore;
import Reika.ReactorCraft.Base.TileEntityReactorBase;
import Reika.ReactorCraft.Entities.EntityNeutron;
import Reika.ReactorCraft.Registry.ReactorSounds;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.ReactorCraft.Registry.ReactorType;
import Reika.ReactorCraft.TileEntities.Fission.TileEntityCPU;
import Reika.ReactorCraft.TileEntities.Fission.TileEntityWaterCell;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityControlRod
extends TileEntityReactorBase
implements LinkableReactorCore {
    private boolean lowered = true;
    private Motions motion;
    private static final int MINOFFSET = -5;
    private static final int MAXOFFSET = 20;
    private int rodOffset = -5;
    private Coordinate CPU;

    @Override
    public void link(TileEntityCPU te) {
        this.CPU = new Coordinate((TileEntity)te);
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        this.moveRods();
        this.thermalTicker.update();
        if (this.thermalTicker.checkCap()) {
            this.updateTemperature(world, x, y, z);
        }
    }

    private void moveRods() {
        if (this.motion != null) {
            this.rodOffset += this.motion.stepHeight;
        }
        if (this.rodOffset <= -5 || this.rodOffset >= 20) {
            this.motion = null;
            this.rodOffset = Math.max(-5, this.rodOffset);
            this.rodOffset = Math.min(20, this.rodOffset);
            this.lowered = this.rodOffset == -5;
        }
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public int getIndex() {
        return ReactorTiles.CONTROL.ordinal();
    }

    public void toggle(boolean sound, boolean spread) {
        this.motion = this.lowered ? Motions.RAISING : Motions.LOWERING;
        if (spread) {
            TileEntityControlRod tc;
            TileEntity te = this.getAdjacentTileEntity(ForgeDirection.UP);
            while (te instanceof TileEntityControlRod) {
                tc = (TileEntityControlRod)te;
                tc.toggle(false, false);
                te = tc.getAdjacentTileEntity(ForgeDirection.UP);
            }
            te = this.getAdjacentTileEntity(ForgeDirection.DOWN);
            while (te instanceof TileEntityControlRod) {
                tc = (TileEntityControlRod)te;
                tc.toggle(false, false);
                te = tc.getAdjacentTileEntity(ForgeDirection.DOWN);
            }
        }
        if (sound) {
            ReactorSounds.CONTROL.playSoundAtBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 1.0f, 1.3f);
        }
    }

    public void setActive(boolean active, boolean sound) {
        Motions motions = this.motion = active ? Motions.LOWERING : Motions.RAISING;
        if (sound) {
            ReactorSounds.CONTROL.playSoundAtBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 1.0f, 1.3f);
        }
    }

    public void drop(boolean sound) {
        if (sound && this.rodOffset > -5 && this.motion != Motions.SCRAM) {
            ReactorSounds.SCRAM.playSoundAtBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 1.0f, 1.0f);
        }
        this.motion = Motions.SCRAM;
    }

    public boolean isActive() {
        return this.lowered && this.rodOffset == -5;
    }

    @Override
    public boolean onNeutron(EntityNeutron e, World world, int x, int y, int z) {
        return this.isActive() ? ReikaRandomHelper.doWithChance((double)60.0) : false;
    }

    @Override
    public int getTemperature() {
        return this.temperature;
    }

    @Override
    public void setTemperature(int T) {
        this.temperature = T;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("down", this.lowered);
        if (this.motion != null) {
            NBT.func_74768_a("motion", this.motion.ordinal());
        }
        NBT.func_74768_a("rodoffset", this.rodOffset);
        if (this.CPU != null) {
            this.CPU.writeToNBT("cpu", NBT);
        }
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.lowered = NBT.func_74767_n("down");
        if (NBT.func_74764_b("motion")) {
            this.motion = Motions.values()[NBT.func_74762_e("motion")];
        }
        this.rodOffset = NBT.func_74762_e("rodoffset");
        this.CPU = Coordinate.readFromNBT((String)"cpu", (NBTTagCompound)NBT);
    }

    @Override
    public int getMaxTemperature() {
        return 0;
    }

    private void onMeltdown(World world, int x, int y, int z) {
    }

    @Override
    public boolean canDumpHeatInto(TileEntityWaterCell.LiquidStates liq) {
        return liq.isWater();
    }

    @Override
    public int getTextureState(ForgeDirection side) {
        return this.isActive() ? 1 : 0;
    }

    public int getRodPosition() {
        return this.rodOffset;
    }

    public void breakBlock() {
        TileEntity te;
        if (this.CPU != null && (te = this.CPU.getTileEntity((IBlockAccess)this.field_145850_b)) instanceof TileEntityCPU) {
            ((TileEntityCPU)te).getLayout().removeControlRod(this);
            ((TileEntityCPU)te).removeTemperatureCheck(this);
        }
    }

    @Override
    public ReactorType getReactorType() {
        return ReactorType.FISSION;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return ReikaAABBHelper.getBlockAABB((TileEntity)this).func_72321_a(0.0, 2.0, 0.0);
    }

    private static enum Motions {
        RAISING(1),
        LOWERING(-1),
        SCRAM(-7);

        public final int stepHeight;

        private Motions(int dh) {
            this.stepHeight = dh;
        }
    }
}

