/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities.Fusion;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Instantiable.Rendering.StructureRenderer;
import Reika.DragonAPI.Interfaces.TileEntity.ToggleTile;
import Reika.ReactorCraft.Auxiliary.FusionReactorToroidPart;
import Reika.ReactorCraft.Auxiliary.MultiBlockTile;
import Reika.ReactorCraft.Auxiliary.NeutronTile;
import Reika.ReactorCraft.Base.BlockReCMultiBlock;
import Reika.ReactorCraft.Base.TileEntityReactorBase;
import Reika.ReactorCraft.Entities.EntityNeutron;
import Reika.ReactorCraft.Entities.EntityPlasma;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.ReactorCraft.TileEntities.TileEntityMagneticPipe;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeConnector;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Registry.MachineRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityFusionInjector
extends TileEntityReactorBase
implements IFluidHandler,
PipeConnector,
MultiBlockTile,
FusionReactorToroidPart,
ToggleTile,
NeutronTile {
    private final HybridTank tank = new HybridTank("injector", 8000);
    private ForgeDirection facing;
    private boolean hasMultiBlock;
    private boolean enabled = true;

    @Override
    public boolean hasMultiBlock() {
        return this.hasMultiBlock;
    }

    @Override
    public void setHasMultiBlock(boolean has) {
        this.hasMultiBlock = has;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (DragonAPICore.debugtest) {
            this.tank.addLiquid(1000, FluidRegistry.getFluid((String)"rc fusion plasma"));
            this.hasMultiBlock = true;
        }
        if (this.canMake()) {
            this.make(world, x, y, z);
        }
    }

    public void setFacing(ForgeDirection dir) {
        this.facing = dir;
    }

    private boolean canMake() {
        if (!this.hasMultiBlock) {
            return false;
        }
        if (this.tank.isEmpty()) {
            return false;
        }
        if (!this.enabled) {
            return false;
        }
        return !this.hasRedstoneSignal();
    }

    private void make(World world, int x, int y, int z) {
        this.createPlasma(world, x, y, z);
        this.tank.removeLiquid(2);
    }

    private void createPlasma(World world, int x, int y, int z) {
        EntityPlasma e = new EntityPlasma(world, x, y, z, this.placer);
        e.setTarget(x + this.getFacing().offsetX, z + this.getFacing().offsetZ);
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)e);
        }
    }

    public int[] getTarget() {
        int dx = this.field_145851_c + this.getFacing().offsetX;
        int dz = this.field_145849_e + this.getFacing().offsetZ;
        return new int[]{dx, this.field_145848_d, dz};
    }

    @Override
    public FusionReactorToroidPart getNextPart(World world, int x, int y, int z) {
        int dx = this.field_145851_c + this.getFacing().offsetX * 2;
        int dz = this.field_145849_e + this.getFacing().offsetZ * 2;
        TileEntity te = world.func_147438_o(dx, y, dz);
        return te instanceof FusionReactorToroidPart ? (FusionReactorToroidPart)te : null;
    }

    public ForgeDirection getFacing() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && this.shouldFlip()) {
            return System.currentTimeMillis() % 4000L >= 2000L ? ForgeDirection.NORTH : ForgeDirection.SOUTH;
        }
        return this.facing != null ? this.facing : ForgeDirection.EAST;
    }

    @SideOnly(value=Side.CLIENT)
    private boolean shouldFlip() {
        return StructureRenderer.isRenderingTiles();
    }

    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe();
    }

    public boolean canConnectToPipeOnSide(MachineRegistry p, ForgeDirection side) {
        return true;
    }

    public TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        return TileEntityPiping.Flow.INPUT;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.canFill(from, resource.getFluid()) ? this.tank.fill(resource, doFill) : 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int amount, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid.equals(FluidRegistry.getFluid((String)"rc fusion plasma")) && this.getAdjacentTileEntity(from) instanceof TileEntityMagneticPipe;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public int getIndex() {
        return ReactorTiles.INJECTOR.ordinal();
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        this.tank.writeToNBT(NBT);
        NBT.func_74768_a("face", this.getFacing().ordinal());
        NBT.func_74757_a("multi", this.hasMultiBlock);
        NBT.func_74757_a("t_enable", this.enabled);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.tank.readFromNBT(NBT);
        this.facing = this.dirs[NBT.func_74762_e("face")];
        this.hasMultiBlock = NBT.func_74767_n("multi");
        if (NBT.func_74764_b("t_enable")) {
            this.enabled = NBT.func_74767_n("t_enable");
        }
    }

    @Override
    public int getTextureState(ForgeDirection side) {
        return side == this.getFacing() ? 0 : (side.offsetY != 0 ? 2 : 2);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
        this.syncAllData(false);
    }

    public void breakBlock() {
        if (!this.field_145850_b.field_72995_K) {
            for (int i = 0; i < 6; ++i) {
                ForgeDirection dir = this.dirs[i];
                int dx = this.field_145851_c + dir.offsetX;
                int dy = this.field_145848_d + dir.offsetY;
                int dz = this.field_145849_e + dir.offsetZ;
                Block b = this.field_145850_b.func_147439_a(dx, dy, dz);
                if (!(b instanceof BlockReCMultiBlock)) continue;
                ((BlockReCMultiBlock)b).breakMultiBlock(this.field_145850_b, dx, dy, dz);
            }
        }
    }

    @Override
    public boolean onNeutron(EntityNeutron e, World world, int x, int y, int z) {
        return false;
    }
}

