/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities.PowerGen;

import Reika.ChromatiCraft.API.Interfaces.WorldRift;
import Reika.DragonAPI.Instantiable.Data.Proportionality;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.ReactorCraft.Auxiliary.SteamTile;
import Reika.ReactorCraft.Base.TileEntityLine;
import Reika.ReactorCraft.ReactorCraft;
import Reika.ReactorCraft.Registry.ReactorOptions;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.ReactorCraft.Registry.ReactorType;
import Reika.ReactorCraft.Registry.WorkingFluid;
import Reika.ReactorCraft.TileEntities.Fission.TileEntityReactorBoiler;
import Reika.ReactorCraft.TileEntities.TileEntitySteamDiffuser;
import Reika.RotaryCraft.API.Interfaces.PressureTile;
import Reika.RotaryCraft.Auxiliary.Interfaces.PumpablePipe;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.TileEntities.Auxiliary.TileEntityPipePump;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntitySteamLine
extends TileEntityLine
implements PumpablePipe,
SteamTile,
PressureTile {
    private int steam;
    private WorkingFluid fluid = WorkingFluid.EMPTY;
    private Proportionality<ReactorType> source = new Proportionality();

    @Override
    public int getIndex() {
        return ReactorTiles.STEAMLINE.ordinal();
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        this.drawFromBoiler(world, x, y, z);
        this.getPipeSteam(world, x, y, z);
        if (this.steam <= 0) {
            this.fluid = WorkingFluid.EMPTY;
            this.source.clear();
        } else if (this.getPressure() > this.getMaxPressure()) {
            this.delete();
            world.func_72876_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 2.0f, true);
        }
    }

    @Override
    protected boolean canConnectToMachine(Block id, int meta, ForgeDirection dir, TileEntity te) {
        if (id == ReactorTiles.BOILER.getBlock() && meta == ReactorTiles.BOILER.getBlockMetadata() && dir == ForgeDirection.DOWN) {
            return true;
        }
        if (id == ReactorTiles.GRATE.getBlock() && meta == ReactorTiles.GRATE.getBlockMetadata()) {
            return true;
        }
        if (id == ReactorTiles.BIGTURBINE.getBlock() && meta == ReactorTiles.BIGTURBINE.getBlockMetadata()) {
            return true;
        }
        if (id == ReactorTiles.DIFFUSER.getBlock() && meta == ReactorTiles.DIFFUSER.getBlockMetadata()) {
            return ((TileEntitySteamDiffuser)this.getAdjacentTileEntity(dir)).getFacing().getOpposite() == dir;
        }
        if (id == MachineRegistry.PIPEPUMP.getBlock() && meta == MachineRegistry.PIPEPUMP.getBlockMetadata()) {
            return ((TileEntityPipePump)this.getAdjacentTileEntity(dir)).canConnectToPipeOnSide(dir);
        }
        return false;
    }

    private void drawFromBoiler(World world, int x, int y, int z) {
        TileEntityReactorBoiler te;
        ReactorTiles r = ReactorTiles.getTE((IBlockAccess)world, x, y - 1, z);
        if (r == ReactorTiles.BOILER && (te = (TileEntityReactorBoiler)world.func_147438_o(x, y - 1, z)).getTileEntityAge() > 5L && this.canTakeInWorkingFluid(te.getWorkingFluid())) {
            this.fluid = te.getWorkingFluid();
            int s = te.removeSteam();
            this.steam += s;
            for (ReactorType rt : te.getReactorTypeSet()) {
                if (rt == null) continue;
                double f = te.getReactorTypeFraction(rt);
                this.source.addValue((Object)rt, (double)s * f);
            }
        }
    }

    private boolean canTakeInWorkingFluid(WorkingFluid f) {
        if (f == WorkingFluid.EMPTY) {
            return false;
        }
        if (this.fluid == WorkingFluid.EMPTY) {
            return true;
        }
        return this.fluid == f;
    }

    private void getPipeSteam(World world, int x, int y, int z) {
        for (int i = 0; i < 6; ++i) {
            WorldRift wr;
            TileEntity tile;
            TileEntity te = this.getAdjacentTileEntity(this.dirs[i]);
            if (te instanceof TileEntitySteamLine) {
                TileEntitySteamLine tile2 = (TileEntitySteamLine)te;
                if (!this.canTakeInWorkingFluid(tile2.fluid)) continue;
                this.readPipe(tile2);
                continue;
            }
            if (!(te instanceof WorldRift) || world.field_72995_K || !((tile = (wr = (WorldRift)te).getTileEntityFrom(this.dirs[i])) instanceof TileEntitySteamLine)) continue;
            TileEntitySteamLine ts = (TileEntitySteamLine)tile;
            if (!this.canTakeInWorkingFluid(ts.fluid)) continue;
            this.readPipe(ts);
        }
    }

    private void readPipe(TileEntitySteamLine te) {
        int dS = te.steam - this.steam;
        if (dS > 0) {
            int amt = dS / 2 + 1;
            float frac = (float)amt / (float)te.steam;
            this.steam += amt;
            te.steam -= amt;
            this.fluid = te.fluid;
            this.addSources(te, frac);
        }
    }

    @Override
    public int getSteam() {
        return this.steam;
    }

    public void removeSteam(int amt) {
        this.steam -= amt;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.steam = NBT.func_74762_e("energy");
        this.fluid = WorkingFluid.getFromNBT(NBT);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("energy", this.steam);
        this.fluid.saveToNBT(NBT);
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.source.readFromNBT(NBT.func_74775_l("sources"), ReikaNBTHelper.getEnumConverter(ReactorType.class));
        if (this.source.removeValue(null) > 0.0) {
            ReactorCraft.logger.logError((Object)(this + " loaded null-containing steam type map from NBT: " + NBT));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        NBTTagCompound tag = new NBTTagCompound();
        this.source.writeToNBT(tag, ReikaNBTHelper.getEnumConverter(ReactorType.class));
        NBT.func_74782_a("sources", (NBTBase)tag);
    }

    public WorkingFluid getWorkingFluid() {
        return this.fluid;
    }

    public boolean canTransferTo(PumpablePipe p, ForgeDirection dir) {
        if (p instanceof TileEntitySteamLine) {
            WorkingFluid f = ((TileEntitySteamLine)p).fluid;
            return f != WorkingFluid.EMPTY ? f == this.fluid : true;
        }
        return false;
    }

    public int getFluidLevel() {
        return this.getSteam();
    }

    public void transferFrom(PumpablePipe from, int amt) {
        float frac = (float)amt / (float)((TileEntitySteamLine)from).steam;
        ((TileEntitySteamLine)from).steam -= amt;
        this.fluid = ((TileEntitySteamLine)from).fluid;
        this.steam += amt;
        this.addSources((TileEntitySteamLine)from, frac);
    }

    private void addSources(TileEntitySteamLine from, float frac) {
        for (ReactorType r : new ArrayList(from.source.getElements())) {
            double val;
            if (r == null || Double.isNaN(val = from.source.getValue((Object)r) * (double)frac) || Double.isInfinite(val)) continue;
            this.source.addValue((Object)r, val);
            from.source.addValue((Object)r, -val);
        }
    }

    public Proportionality<ReactorType> getSourceReactorType() {
        return this.source.copy();
    }

    @Override
    public IIcon getTexture() {
        return Blocks.field_150325_L.func_149691_a(0, this.isInWorld() ? 15 : 7);
    }

    public int getPressure() {
        return this.steam;
    }

    public int getMaxPressure() {
        return ReactorOptions.STEAMLINECAP.getValue();
    }
}

