/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities.Processing;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import Reika.ReactorCraft.Auxiliary.ReactorCoreTE;
import Reika.ReactorCraft.Base.TileEntityReactorBase;
import Reika.ReactorCraft.Entities.EntityNeutron;
import Reika.ReactorCraft.ReactorCraft;
import Reika.ReactorCraft.Registry.ReactorAchievements;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeConnector;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Registry.MachineRegistry;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityTritizer
extends TileEntityReactorBase
implements ReactorCoreTE,
PipeConnector,
IFluidHandler {
    public static final int CAPACITY = 1000;
    private final HybridTank input = new HybridTank("tritizerin", 1000);
    private final HybridTank output = new HybridTank("tritizerout", 1000);

    @Override
    public int getIndex() {
        return ReactorTiles.TRITIZER.ordinal();
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (DragonAPICore.debugtest) {
            this.input.addLiquid(100, ReactorCraft.H2);
            if (this.output.getLevel() > 500) {
                this.output.empty();
            }
        }
        if (!world.field_72995_K) {
            this.feed();
        }
        this.thermalTicker.update();
        if (this.thermalTicker.checkCap()) {
            this.updateTemperature(world, x, y, z);
        }
    }

    private void feed() {
        World world = this.field_145850_b;
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        TileEntity tile = this.getAdjacentTileEntity(ForgeDirection.DOWN);
        if (tile instanceof TileEntityTritizer) {
            int amt = ((TileEntityTritizer)tile).feedIn(this.input.getFluid(), false);
            if (amt > 0) {
                this.input.removeLiquid(amt);
            }
            if ((amt = ((TileEntityTritizer)tile).feedIn(this.output.getFluid(), true)) > 0) {
                this.output.removeLiquid(amt);
            }
        }
    }

    private int feedIn(FluidStack is, boolean out) {
        if (is == null) {
            return 0;
        }
        HybridTank tank = out ? this.output : this.input;
        Fluid f = is.getFluid();
        if (!out && Reactions.getReactionFrom(f) == null) {
            return 0;
        }
        if (tank.getActualFluid() != null && tank.getActualFluid() != f) {
            return 0;
        }
        int add = Math.min(tank.getRemainingSpace(), is.amount);
        tank.addLiquid(add, f);
        return add;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        this.input.writeToNBT(NBT);
        this.output.writeToNBT(NBT);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.input.readFromNBT(NBT);
        this.output.readFromNBT(NBT);
    }

    @Override
    public boolean onNeutron(EntityNeutron e, World world, int x, int y, int z) {
        if (this.input.isEmpty()) {
            return false;
        }
        EntityNeutron.NeutronType type = e.getType();
        if (type.canIrradiateLiquids()) {
            Reactions r = Reactions.getReactionFrom(this.input.getActualFluid());
            if (!world.field_72995_K && this.canMake(r) && ReikaRandomHelper.doWithChance((double)r.chance)) {
                this.make(r);
                return true;
            }
        }
        return false;
    }

    private void make(Reactions r) {
        int amt = r.amount;
        this.input.removeLiquid(amt);
        this.output.addLiquid(amt, r.output);
    }

    private boolean canMake(Reactions r) {
        int amt = r.amount;
        return this.input.getLevel() >= amt && this.output.canTakeIn(amt) && this.input.getActualFluid().equals(r.input);
    }

    public static void addRecipe(String name, Fluid in, Fluid out, int chance, int amt) {
        Class[] types = new Class[]{Fluid.class, Fluid.class, Integer.TYPE, Integer.TYPE};
        Object[] args = new Object[]{in, out, chance, amt};
        Reactions c = (Reactions)EnumHelper.addEnum(Reactions.class, (String)name.toUpperCase(), (Class[])types, (Object[])args);
        Reactions.access$002(Reactions.values());
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.canDrain(from, resource.getFluid()) ? this.output.drain(resource.amount, doDrain) : null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (!this.canDrain(from, null)) {
            return null;
        }
        return this.output.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return from == ForgeDirection.UP && Reactions.getReactionFrom(fluid) != null;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return from == ForgeDirection.DOWN && ReikaFluidHelper.isFluidDrainableFromTank((Fluid)fluid, (HybridTank)this.output);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.input.getInfo(), this.output.getInfo()};
    }

    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe();
    }

    public boolean canConnectToPipeOnSide(MachineRegistry p, ForgeDirection side) {
        return this.canConnectToPipe(p) && side.offsetY != 0;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!this.canFill(from, resource.getFluid())) {
            return 0;
        }
        return this.input.fill(resource, doFill);
    }

    public TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        if (side == ForgeDirection.UP) {
            return TileEntityPiping.Flow.INPUT;
        }
        if (side == ForgeDirection.DOWN) {
            return TileEntityPiping.Flow.OUTPUT;
        }
        return TileEntityPiping.Flow.NONE;
    }

    @Override
    public final int getTextureState(ForgeDirection side) {
        if (side.offsetY != 0) {
            return 4;
        }
        World world = this.field_145850_b;
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        ReactorTiles src = this.getMachine();
        ReactorTiles r = ReactorTiles.getTE((IBlockAccess)world, x, y - 1, z);
        ReactorTiles r2 = ReactorTiles.getTE((IBlockAccess)world, x, y + 1, z);
        if (r2 == src && r == src) {
            return 2;
        }
        if (r2 == src) {
            return 1;
        }
        if (r == src) {
            return 3;
        }
        return 0;
    }

    public static enum Reactions {
        TRITIUM("rc deuterium", "rc tritium", 75, 25),
        D20("water", "rc heavy water", 25, 100);

        public final Fluid input;
        public final Fluid output;
        public final int chance;
        public final int amount;
        private static Reactions[] reactionList;

        private Reactions(String in, String out, int chance, int amt) {
            this(FluidRegistry.getFluid((String)in), FluidRegistry.getFluid((String)out), chance, amt);
        }

        private Reactions(Fluid in, Fluid out, int chance, int amt) {
            this.chance = chance;
            this.amount = amt;
            this.input = in;
            this.output = out;
        }

        private void onPerform(TileEntityTritizer te) {
            switch (this) {
                case D20: {
                    ReactorAchievements.HEAVYWATER.triggerAchievement(te.getPlacer());
                    break;
                }
            }
        }

        public static Reactions getReactionFrom(Fluid in) {
            for (int i = 0; i < reactionList.length; ++i) {
                Reactions r = reactionList[i];
                if (!r.input.equals(in)) continue;
                return r;
            }
            return null;
        }

        static /* synthetic */ Reactions[] access$002(Reactions[] x0) {
            reactionList = x0;
            return x0;
        }

        static {
            reactionList = Reactions.values();
        }
    }
}

