/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities;

import Reika.ChromatiCraft.API.Interfaces.WorldRift;
import Reika.DragonAPI.Instantiable.Data.Proportionality;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.ReactorCraft.Auxiliary.ReactorTyped;
import Reika.ReactorCraft.Base.TileEntityLine;
import Reika.ReactorCraft.Base.TileEntityNuclearBoiler;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.ReactorCraft.Registry.ReactorType;
import Reika.RotaryCraft.Auxiliary.Interfaces.HeatConduction;
import Reika.RotaryCraft.RotaryCraft;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityHeatPipe
extends TileEntityLine {
    private static final double HEAT_CAPACITY = 3010.8;
    private double heatEnergy;
    private Proportionality<ReactorType> reactorTypes = new Proportionality();
    private float renderBrightness;
    private float lastBrightness;
    private float brightnessDeltaSinceUpdate;
    private int lastUpdateTime;

    @Override
    public IIcon getTexture() {
        return Blocks.field_150433_aE.func_149691_a(0, 0);
    }

    @Override
    public int getIndex() {
        return ReactorTiles.HEATPIPE.ordinal();
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (!world.field_72995_K) {
            this.balanceHeat(world, x, y, z);
            if (this.getTicksExisted() % 32 == 0) {
                // empty if block
            }
        }
    }

    private void ventHeat(World world, int x, int y, int z) {
        int Tamb;
        double temp = TileEntityHeatPipe.getTemperatureForPipe(this, false);
        if (temp >= (double)(Tamb = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z))) {
            temp -= (temp - (double)Tamb) / 96.0;
            this.heatEnergy = 3010.8 * temp;
        }
        this.temperature = (int)temp;
    }

    public double getNetHeatEnergy() {
        return this.heatEnergy - (double)ReikaWorldHelper.getAmbientTemperatureAt((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e) * 3010.8;
    }

    public static double getNetTemperature(HeatConduction hc) {
        return hc.getTemperature() - hc.getAmbientTemperature();
    }

    public static double getNetHeat(HeatConduction hc) {
        return hc.heatEnergyPerDegree() * TileEntityHeatPipe.getNetTemperature(hc);
    }

    public static int getTemperatureForHeat(double heat, HeatConduction hc) {
        return (int)Math.max(1.0, heat / hc.heatEnergyPerDegree());
    }

    public static double getTemperatureForPipe(TileEntityHeatPipe tp, boolean net) {
        return net ? tp.getNetHeatEnergy() / 3010.8 : tp.heatEnergy / 3010.8;
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        this.heatEnergy = (double)ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z) * 3010.8;
    }

    private void balanceHeat(World world, int x, int y, int z) {
        for (int i = 0; i < 6; ++i) {
            boolean valid;
            boolean intake;
            TileEntity te = this.getAdjacentTileEntity(this.dirs[i]);
            if (te instanceof TileEntityHeatPipe) {
                TileEntityHeatPipe tile = (TileEntityHeatPipe)te;
                this.balanceWith(tile);
                continue;
            }
            if (te instanceof WorldRift) {
                WorldRift wr = (WorldRift)te;
                TileEntity tile = wr.getTileEntityFrom(this.dirs[i]);
                if (!(tile instanceof TileEntityHeatPipe)) continue;
                TileEntityHeatPipe ts = (TileEntityHeatPipe)tile;
                this.balanceWith(ts);
                continue;
            }
            if (te == null || !this.canConnectToMachine(te.func_145838_q(), te.func_145832_p(), this.dirs[i], te)) continue;
            HeatConduction hc = (HeatConduction)te;
            double theirheat = TileEntityHeatPipe.getNetHeat(hc);
            double ourheat = this.getNetHeatEnergy();
            double theirtemp = TileEntityHeatPipe.getNetTemperature(hc);
            double ourtemp = TileEntityHeatPipe.getTemperatureForPipe(this, true);
            boolean bl = intake = theirheat > ourheat;
            boolean bl2 = intake ? hc.allowHeatExtraction() && ourtemp < theirtemp : (valid = hc.allowExternalHeating() && ourtemp > theirtemp);
            if (!valid) continue;
            double diff = ourheat - theirheat;
            int put = TileEntityHeatPipe.getTemperatureForHeat(diff /= 4.0, hc);
            hc.setTemperature(put + hc.getAmbientTemperature());
            this.heatEnergy -= diff;
            if (diff < 0.0) {
                ReactorType type = null;
                if (te instanceof ReactorTyped) {
                    ReactorTyped tb = (ReactorTyped)te;
                    type = tb.getReactorType();
                }
                if (type == null) continue;
                this.reactorTypes.addValue((Object)type, diff);
                continue;
            }
            if (!(diff > 0.0) || !(te instanceof TileEntityNuclearBoiler)) continue;
            TileEntityNuclearBoiler tb = (TileEntityNuclearBoiler)te;
            tb.setReactorTypes(this.reactorTypes);
        }
    }

    private void balanceWith(TileEntityHeatPipe ts) {
        if (ts.getTicksExisted() < 2) {
            return;
        }
        double diff = ts.heatEnergy - this.heatEnergy;
        if (diff <= 0.0) {
            return;
        }
        ts.heatEnergy -= (diff /= 2.0);
        this.heatEnergy += diff;
        this.reactorTypes = ts.reactorTypes;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.heatEnergy = NBT.func_74769_h("heat");
        this.updateBrightness();
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74780_a("heat", this.heatEnergy);
    }

    private void updateBrightness() {
        float f = this.computeBrightness();
        this.brightnessDeltaSinceUpdate += Math.abs(f - this.lastBrightness);
        this.renderBrightness = f;
        if (this.field_145850_b != null && ((double)this.brightnessDeltaSinceUpdate >= 0.2 || this.getTicksExisted() - this.lastUpdateTime > 40)) {
            this.triggerBlockUpdate();
            this.brightnessDeltaSinceUpdate = 0.0f;
            this.lastUpdateTime = this.getTicksExisted();
        }
    }

    @Override
    protected boolean canConnectToMachine(Block id, int meta, ForgeDirection dir, TileEntity te) {
        if (!(te instanceof HeatConduction)) {
            return false;
        }
        HeatConduction h = (HeatConduction)te;
        return h.allowExternalHeating() || h.allowHeatExtraction();
    }

    @Override
    public void onEntityCollided(Entity e) {
        if (this.temperature >= 100) {
            RotaryCraft.heatDamage.lastMachine = this;
            e.func_70097_a((DamageSource)RotaryCraft.heatDamage, (float)(this.temperature / 100));
        }
    }

    public int getRenderColor() {
        int base = 16754253;
        float f = this.getBrightness();
        return f <= 0.0f ? base : ReikaColorAPI.mixColors((int)0xFF3030, (int)base, (float)f);
    }

    private float computeBrightness() {
        if (this.temperature < 250) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.temperature - 250) / 1500.0f);
    }

    public float getBrightness() {
        return this.renderBrightness;
    }
}

