/*
 * Decompiled with CFR 0.152.
 */
package Reika.LegacyCraft.ASM;

import Reika.DragonAPI.Exception.ASMException;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Libraries.Java.ReikaASMHelper;
import Reika.LegacyCraft.ASM.MobTransformer;
import cpw.mods.fml.relauncher.FMLInjectionData;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ListIterator;
import java.util.Map;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.classloading.FMLForgePlugin;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

@IFMLLoadingPlugin.SortingIndex(value=0x7FFFFFFE)
@IFMLLoadingPlugin.MCVersion(value="1.7.10")
public class LegacyASMHandler
implements IFMLLoadingPlugin {
    public String[] getASMTransformerClass() {
        return new String[]{LegacyTransformer.class.getName(), MobTransformer.class.getName()};
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
    }

    public String getAccessTransformerClass() {
        return null;
    }

    static void redirectInstanceFunctionCall(ClassNode cn, MethodInsnNode min, String name) {
        min.owner = "Reika/LegacyCraft/ASM/LegacyASMHooks";
        ReikaASMHelper.addLeadingArgument((MethodInsnNode)min, (String)ReikaASMHelper.convertClassName((ClassNode)cn, (boolean)true));
        min.setOpcode(184);
    }

    static void redirectInstanceFunction(ClassNode cn, MethodNode m, String name) {
        MethodInsnNode call = ReikaASMHelper.rerouteMethod((ClassNode)cn, (MethodNode)m, (String)"Reika/LegacyCraft/ASM/LegacyASMHooks", (String)name);
        ReikaASMHelper.log((Object)("Constructed redirect in " + ReikaASMHelper.clearString((MethodNode)m) + " to " + ReikaASMHelper.clearString((AbstractInsnNode)call).replace("\n", "") + "."));
    }

    static void redirectInstanceFunctionWithReturnHook(ClassNode cn, MethodNode m, String name) {
        InsnList calls = new InsnList();
        ArrayList li = ReikaASMHelper.parseMethodSignature((MethodNode)m);
        if ((m.access & 8) == 0) {
            li.add(0, ReikaASMHelper.convertClassName((ClassNode)cn, (boolean)true));
            calls.add((AbstractInsnNode)new VarInsnNode(25, 0));
        }
        for (int i = 1; i < li.size() - 1; ++i) {
            String arg = (String)li.get(i);
            ReikaASMHelper.PrimitiveType p = ReikaASMHelper.PrimitiveType.getFromSig((String)arg);
            calls.add((AbstractInsnNode)new VarInsnNode(p.loadCode, i));
        }
        li.add(0, li.get(li.size() - 1));
        String sig = ReikaASMHelper.compileSignature((ArrayList)li);
        MethodInsnNode call = new MethodInsnNode(184, "Reika/LegacyCraft/ASM/LegacyASMHooks", name, sig, false);
        calls.add((AbstractInsnNode)call);
        for (int i = m.instructions.size() - 1; i >= 0; --i) {
            AbstractInsnNode ain = m.instructions.get(i);
            if (!ReikaASMHelper.isReturn((AbstractInsnNode)ain)) continue;
            m.instructions.insertBefore(ain, ReikaASMHelper.copyInsnList((InsnList)calls, (LabelNode[])new LabelNode[0]));
        }
        ReikaASMHelper.log((Object)("Constructed return-preserving redirect in " + ReikaASMHelper.clearString((MethodNode)m) + " to " + ReikaASMHelper.clearString((AbstractInsnNode)call).replace("\n", "") + "."));
    }

    static MethodNode getOrCreateMethod(ClassNode cn, String obf, String deobf, String desc) {
        return LegacyASMHandler.getOrCreateMethod(cn, obf, deobf, desc, true);
    }

    static MethodNode getOrCreateMethod(ClassNode cn, String obf, String deobf, String desc, boolean clear) {
        MethodNode m = null;
        try {
            m = ReikaASMHelper.getMethodByName((ClassNode)cn, (String)obf, (String)deobf, (String)desc);
        }
        catch (ASMException.NoSuchASMMethodException e) {
            m = ReikaASMHelper.addMethod((ClassNode)cn, (InsnList)new InsnList(), (String)(FMLForgePlugin.RUNTIME_DEOBF ? obf : deobf), (String)desc, (int)1);
        }
        if (clear) {
            m.instructions.clear();
        }
        return m;
    }

    private static void patchPathCalc(ClassNode cn, String obf, String deobf, String sig) {
        MethodNode m = ReikaASMHelper.getMethodByName((ClassNode)cn, (String)obf, (String)deobf, (String)sig);
        LegacyASMHandler.redirectInstanceFunction(cn, m, deobf);
    }

    public static class LegacyTransformer
    implements IClassTransformer {
        private static final MultiMap<String, ClassPatch> classes = new MultiMap().setNullEmpty();
        private static final Configuration config = new Configuration(new File((File)FMLInjectionData.data()[6], "config/Reika/LegacyCraft.cfg"));

        private static boolean getConfig(String sg, boolean def) {
            Property prop = config.get("control setup", sg, def);
            return prop.getBoolean(def);
        }

        public byte[] transform(String className, String className2, byte[] opcodes) {
            Collection c;
            if (!classes.isEmpty() && (c = classes.get((Object)className)) != null) {
                ReikaASMHelper.activeMod = "LegacyCraft";
                ReikaASMHelper.log((Object)("Patching class " + ((ClassPatch)((Object)c.iterator().next())).deobfName));
                for (ClassPatch p : c) {
                    opcodes = p.apply(opcodes);
                }
                classes.remove((Object)className);
                ReikaASMHelper.activeMod = null;
            }
            return opcodes;
        }

        static {
            for (int i = 0; i < ClassPatch.list.length; ++i) {
                ClassPatch p = ClassPatch.list[i];
                String s = !FMLForgePlugin.RUNTIME_DEOBF ? p.deobfName : p.obfName;
                classes.addValue((Object)s, (Object)p);
            }
        }

        private static enum ClassPatch {
            SUGARCANE("net.minecraft.block.BlockReed", "ane"),
            NETHERLAVA("net.minecraft.world.gen.ChunkProviderHell", "aqv"),
            ENDERPORT("net.minecraft.entity.monster.EntityEnderman", "ya"),
            FOLIAGE("net.minecraft.world.ColorizerFoliage", "agx"),
            ANIMALSPAWN("net.minecraft.world.WorldServer", "mt"),
            PORTAL1("net.minecraft.block.BlockPortal", "amp"),
            PORTAL2("net.minecraft.block.BlockEndPortal", "akt"),
            ICEBLOCK("net.minecraft.block.BlockIce", "alp"),
            WATERPATCH("net.minecraft.block.Block", "aji"),
            LAVAHISS("net.minecraft.block.BlockLiquid", "alw"),
            FLINTSOUND("net.minecraft.item.ItemFlintAndSteel", "acw"),
            CREEPERFALL("net.minecraft.entity.monster.EntityCreeper", "xz"),
            EQUIPDMG("net.minecraft.entity.EntityLiving", "sw"),
            ZOMBIEHOOKS("net.minecraft.entity.monster.EntityZombie", "yq"),
            ZOMBIETOOLS("net.minecraft.entity.monster.EntityZombie", "yq"),
            MOBARMOR("net.minecraft.entity.monster.EntityMob", "yg"),
            ZOMBIEFIRE("net.minecraft.entity.monster.EntityZombie", "yq"),
            SKELLYRATE("net.minecraft.entity.monster.EntitySkeleton", "yl"),
            SKELLYFIRE("net.minecraft.entity.monster.EntitySkeleton", "yl"),
            SILENTVILLAGERS("net.minecraft.entity.passive.EntityVillager", "yv"),
            ENDERSOUNDS("net.minecraft.entity.monster.EntityEnderman", "ya"),
            DUMBPATH("net.minecraft.world.World", "ahb");

            private final String obfName;
            private final String deobfName;
            private static final ClassPatch[] list;

            private ClassPatch(String deobf, String obf) {
                this.obfName = obf;
                this.deobfName = deobf;
            }

            private byte[] apply(byte[] data) {
                ClassNode cn = new ClassNode();
                ClassReader classReader = new ClassReader(data);
                classReader.accept((ClassVisitor)cn, 0);
                int flags = 1;
                block0 : switch (this) {
                    case SUGARCANE: {
                        if (FMLLaunchHandler.side() != Side.CLIENT) break;
                        if (!LegacyTransformer.getConfig("Disable Biome Colors on Sugarcane", true)) {
                            ReikaASMHelper.log((Object)("Not applying " + (Object)((Object)this) + " ASM handler; disabled in config."));
                            return data;
                        }
                        MethodNode m = ReikaASMHelper.getMethodByName((ClassNode)cn, (String)"func_149720_d", (String)"colorMultiplier", (String)"(Lnet/minecraft/world/IBlockAccess;III)I");
                        m.instructions.clear();
                        m.instructions.add((AbstractInsnNode)new LdcInsnNode((Object)0xFFFFFF));
                        m.instructions.add((AbstractInsnNode)new InsnNode(172));
                        ReikaASMHelper.log((Object)("Successfully applied " + (Object)((Object)this) + " ASM handler!"));
                        break;
                    }
                    case NETHERLAVA: {
                        String gen;
                        if (!LegacyTransformer.getConfig("Disable Nether Hidden Lava Pockets", true)) {
                            ReikaASMHelper.log((Object)("Not applying " + (Object)((Object)this) + " ASM handler; disabled in config."));
                            return data;
                        }
                        MethodNode m = ReikaASMHelper.getMethodByName((ClassNode)cn, (String)"func_73153_a", (String)"populate", (String)"(Lnet/minecraft/world/chunk/IChunkProvider;II)V");
                        ListIterator it = m.instructions.iterator();
                        String string = gen = FMLForgePlugin.RUNTIME_DEOBF ? "ars" : "net/minecraft/world/gen/feature/WorldGenHellLava";
                        while (it.hasNext()) {
                            TypeInsnNode tp;
                            AbstractInsnNode ain = (AbstractInsnNode)it.next();
                            if (ain.getOpcode() == 187) {
                                tp = (TypeInsnNode)ain;
                                if (!tp.desc.equals(gen)) continue;
                                tp.desc = "Reika/LegacyCraft/Overrides/WorldGenCustomNetherLava";
                                continue;
                            }
                            if (ain.getOpcode() == 183) {
                                tp = (MethodInsnNode)ain;
                                if (!tp.owner.equals(gen)) continue;
                                tp.owner = "Reika/LegacyCraft/Overrides/WorldGenCustomNetherLava";
                                continue;
                            }
                            if (ain.getOpcode() != 182) continue;
                            tp = (MethodInsnNode)ain;
                            if (!tp.owner.equals(gen)) continue;
                            tp.owner = "Reika/LegacyCraft/Overrides/WorldGenCustomNetherLava";
                        }
                        ReikaASMHelper.log((Object)("Successfully applied " + (Object)((Object)this) + " ASM handler!"));
                        break;
                    }
                    case ENDERPORT: {
                        if (!LegacyTransformer.getConfig("Disable Random Enderman Teleporting in Daylight", true)) {
                            ReikaASMHelper.log((Object)("Not applying " + (Object)((Object)this) + " ASM handler; disabled in config."));
                            return data;
                        }
                        MethodNode m = ReikaASMHelper.getMethodByName((ClassNode)cn, (String)"func_70636_d", (String)"onLivingUpdate", (String)"()V");
                        boolean prep = false;
                        for (int i = 0; i < m.instructions.size(); ++i) {
                            AbstractInsnNode ain = m.instructions.get(i);
                            if (ain.getOpcode() == 182) {
                                String func;
                                MethodInsnNode min = (MethodInsnNode)ain;
                                String string = func = FMLForgePlugin.RUNTIME_DEOBF ? "func_70013_c" : "getBrightness";
                                if (!func.equals(min.name)) continue;
                                prep = true;
                                continue;
                            }
                            if (!prep || ain.getOpcode() != 18) continue;
                            LdcInsnNode ldc = (LdcInsnNode)ain;
                            ldc.cst = Float.valueOf(Float.MAX_VALUE);
                            ReikaASMHelper.log((Object)("Successfully applied " + (Object)((Object)this) + " ASM handler!"));
                            break block0;
                        }
                        break;
                    }
                    case FOLIAGE: {
                        AbstractInsnNode ain;
                        int i;
                        if (!LegacyTransformer.getConfig("Alpha Grass and Leaf Color", false)) {
                            ReikaASMHelper.log((Object)("Not applying " + (Object)((Object)this) + " ASM handler; disabled in config."));
                            return data;
                        }
                        MethodNode m = ReikaASMHelper.getMethodByName((ClassNode)cn, (String)"func_77469_b", (String)"getFoliageColorBirch", (String)"()I");
                        AbstractInsnNode loc = null;
                        for (i = 0; i < m.instructions.size(); ++i) {
                            ain = m.instructions.get(i);
                            if (ain.getOpcode() != 18) continue;
                            loc = ain;
                            break;
                        }
                        m.instructions.insert(loc, (AbstractInsnNode)new LdcInsnNode((Object)0xFFFFFF));
                        m.instructions.remove(loc);
                        m = ReikaASMHelper.getMethodByName((ClassNode)cn, (String)"func_77466_a", (String)"getFoliageColorPine", (String)"()I");
                        loc = null;
                        for (i = 0; i < m.instructions.size(); ++i) {
                            ain = m.instructions.get(i);
                            if (ain.getOpcode() != 18) continue;
                            loc = ain;
                            break;
                        }
                        m.instructions.insert(loc, (AbstractInsnNode)new LdcInsnNode((Object)0xFFFFFF));
                        m.instructions.remove(loc);
                        m = ReikaASMHelper.getMethodByName((ClassNode)cn, (String)"func_77468_c", (String)"getFoliageColorBasic", (String)"()I");
                        loc = null;
                        for (i = 0; i < m.instructions.size(); ++i) {
                            ain = m.instructions.get(i);
                            if (ain.getOpcode() == 18) {
                                loc = ain;
                                break;
                            }
                            m.instructions.insert(loc, (AbstractInsnNode)new LdcInsnNode((Object)0xFFFFFF));
                            m.instructions.remove(loc);
                        }
                        ReikaASMHelper.log((Object)("Successfully applied " + (Object)((Object)this) + " ASM handler!"));
                        break;
                    }
                    case ANIMALSPAWN: {
                        if (!LegacyTransformer.getConfig("Pre Adventure Update Animal Spawning", false)) {
                            ReikaASMHelper.log((Object)("Not applying " + (Object)((Object)this) + " ASM handler; disabled in config."));
                            return data;
                        }
                        MethodNode m = ReikaASMHelper.getMethodByName((ClassNode)cn, (String)"func_72835_b", (String)"tick", (String)"()V");
                        AbstractInsnNode loc = null;
                        for (int i = 0; i < m.instructions.size(); ++i) {
                            AbstractInsnNode ain = m.instructions.get(i);
                            if (ain.getOpcode() != 18) continue;
                            LdcInsnNode ldc = (LdcInsnNode)ain;
                            if (!(ldc.cst instanceof Integer) || (Integer)ldc.cst != 400) continue;
                            loc = ain;
                            break;
                        }
                        m.instructions.insert(loc, (AbstractInsnNode)new LdcInsnNode((Object)40));
                        m.instructions.remove(loc);
                        ReikaASMHelper.log((Object)("Successfully applied " + (Object)((Object)this) + " ASM handler!"));
                        break;
                    }
                    case PORTAL1: {
                        if (!LegacyTransformer.getConfig("Disable Entities Travelling Through Portals", false)) {
                            ReikaASMHelper.log((Object)("Not applying " + (Object)((Object)this) + " ASM handler; disabled in config."));
                            return data;
                        }
                        MethodNode m = ReikaASMHelper.getMethodByName((ClassNode)cn, (String)"func_149670_a", (String)"onEntityCollidedWithBlock", (String)"(Lnet/minecraft/world/World;IIILnet/minecraft/entity/Entity;)V");
                        LabelNode l1 = new LabelNode();
                        LabelNode l2 = new LabelNode();
                        InsnList insert = new InsnList();
                        insert.add((AbstractInsnNode)new VarInsnNode(25, 5));
                        insert.add((AbstractInsnNode)new TypeInsnNode(193, "net/minecraft/entity/player/EntityPlayer"));
                        insert.add((AbstractInsnNode)new JumpInsnNode(154, l1));
                        insert.add((AbstractInsnNode)l2);
                        insert.add((AbstractInsnNode)new InsnNode(177));
                        insert.add((AbstractInsnNode)l1);
                        m.instructions.insert(insert);
                        ReikaASMHelper.log((Object)("Successfully applied " + (Object)((Object)this) + " ASM handler!"));
                        break;
                    }
                    case PORTAL2: {
                        if (!LegacyTransformer.getConfig("Disable Entities Travelling Through Portals", false)) {
                            ReikaASMHelper.log((Object)("Not applying " + (Object)((Object)this) + " ASM handler; disabled in config."));
                            return data;
                        }
                        MethodNode m = ReikaASMHelper.getMethodByName((ClassNode)cn, (String)"func_149670_a", (String)"onEntityCollidedWithBlock", (String)"(Lnet/minecraft/world/World;IIILnet/minecraft/entity/Entity;)V");
                        LabelNode l1 = new LabelNode();
                        LabelNode l2 = new LabelNode();
                        InsnList insert = new InsnList();
                        insert.add((AbstractInsnNode)new VarInsnNode(25, 5));
                        insert.add((AbstractInsnNode)new TypeInsnNode(193, "net/minecraft/entity/player/EntityPlayer"));
                        insert.add((AbstractInsnNode)new JumpInsnNode(154, l1));
                        insert.add((AbstractInsnNode)l2);
                        insert.add((AbstractInsnNode)new InsnNode(177));
                        insert.add((AbstractInsnNode)l1);
                        m.instructions.insert(insert);
                        ReikaASMHelper.log((Object)("Successfully applied " + (Object)((Object)this) + " ASM handler!"));
                        break;
                    }
                    case ICEBLOCK: {
                        AbstractInsnNode next;
                        boolean last;
                        FieldInsnNode fin;
                        AbstractInsnNode ain;
                        int i;
                        if (!LegacyTransformer.getConfig("Enable Ice to Water in Nether", true)) {
                            ReikaASMHelper.log((Object)("Not applying " + (Object)((Object)this) + " ASM handler; disabled in config."));
                            return data;
                        }
                        String hell = FMLForgePlugin.RUNTIME_DEOBF ? "field_76575_d" : "isHellWorld";
                        MethodNode m = ReikaASMHelper.getMethodByName((ClassNode)cn, (String)"func_149636_a", (String)"harvestBlock", (String)"(Lnet/minecraft/world/World;Lnet/minecraft/entity/player/EntityPlayer;IIII)V");
                        for (i = 0; i < m.instructions.size(); ++i) {
                            ain = m.instructions.get(i);
                            if (ain.getOpcode() != 180) continue;
                            fin = (FieldInsnNode)ain;
                            if (!fin.name.equals(hell)) continue;
                            last = false;
                            while (!last) {
                                next = fin.getNext();
                                last = next.getOpcode() == 177;
                                m.instructions.remove(next);
                            }
                            m.instructions.insert((AbstractInsnNode)fin, (AbstractInsnNode)new InsnNode(87));
                            ReikaASMHelper.log((Object)("Successfully applied " + (Object)((Object)this) + " ASM handler 1!"));
                            break;
                        }
                        m = ReikaASMHelper.getMethodByName((ClassNode)cn, (String)"func_149674_a", (String)"updateTick", (String)"(Lnet/minecraft/world/World;IIILjava/util/Random;)V");
                        for (i = 0; i < m.instructions.size(); ++i) {
                            ain = m.instructions.get(i);
                            if (ain.getOpcode() != 180) continue;
                            fin = (FieldInsnNode)ain;
                            if (!fin.name.equals(hell)) continue;
                            last = false;
                            while (!last) {
                                next = fin.getNext();
                                last = next.getOpcode() == 177;
                                m.instructions.remove(next);
                            }
                            m.instructions.insert((AbstractInsnNode)fin, (AbstractInsnNode)new InsnNode(87));
                            ReikaASMHelper.log((Object)("Successfully applied " + (Object)((Object)this) + " ASM handler 2!"));
                            break block0;
                        }
                        break;
                    }
                    case WATERPATCH: {
                        if (!LegacyTransformer.getConfig("Enable Ice to Water in Nether", false)) {
                            ReikaASMHelper.log((Object)("Not applying " + (Object)((Object)this) + " ASM handler; disabled in config."));
                            return data;
                        }
                        MethodNode m = ReikaASMHelper.getMethodByName((ClassNode)cn, (String)"func_149671_p", (String)"registerBlocks", (String)"()V");
                        AbstractInsnNode loc = ReikaASMHelper.getFirstInsnAfter((InsnList)m.instructions, (int)0, (int)16, (Object[])new Object[]{8});
                        loc = ReikaASMHelper.getFirstOpcodeAfter((InsnList)m.instructions, (int)m.instructions.indexOf(loc), (int)187);
                        TypeInsnNode type = (TypeInsnNode)loc;
                        int idx = m.instructions.indexOf((AbstractInsnNode)type);
                        type.desc = "net/minecraft/block/BlockDynamicLiquid";
                        MethodInsnNode min = (MethodInsnNode)ReikaASMHelper.getFirstOpcodeAfter((InsnList)m.instructions, (int)idx, (int)183);
                        min.owner = type.desc;
                        type = (TypeInsnNode)ReikaASMHelper.getFirstOpcodeAfter((InsnList)m.instructions, (int)(idx + 1), (int)187);
                        idx = m.instructions.indexOf((AbstractInsnNode)type);
                        type.desc = "net/minecraft/block/BlockStaticLiquid";
                        min = (MethodInsnNode)ReikaASMHelper.getFirstOpcodeAfter((InsnList)m.instructions, (int)idx, (int)183);
                        min.owner = type.desc;
                        ReikaASMHelper.log((Object)("Successfully applied " + (Object)((Object)this) + " ASM handler!"));
                        break;
                    }
                    case LAVAHISS: {
                        if (LegacyTransformer.getConfig("Lava Movement Hiss", true)) {
                            ReikaASMHelper.log((Object)("Not applying " + (Object)((Object)this) + " ASM handler; disabled in config."));
                            return data;
                        }
                        MethodNode m = ReikaASMHelper.getMethodByName((ClassNode)cn, (String)"func_149799_m", (String)"func_149799_m", (String)"(Lnet/minecraft/world/World;III)V");
                        m.instructions.clear();
                        m.instructions.add((AbstractInsnNode)new InsnNode(177));
                        ReikaASMHelper.log((Object)("Successfully applied " + (Object)((Object)this) + " ASM handler!"));
                        break;
                    }
                    case FLINTSOUND: {
                        MethodNode m = ReikaASMHelper.getMethodByName((ClassNode)cn, (String)"func_77648_a", (String)"onItemUse", (String)"(Lnet/minecraft/item/ItemStack;Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/world/World;IIIIFFF)Z");
                        for (int i = 0; i < m.instructions.size(); ++i) {
                            AbstractInsnNode ain = m.instructions.get(i);
                            if (ain.getOpcode() != 18) continue;
                            LdcInsnNode ldc = (LdcInsnNode)ain;
                            if (!"fire.ignite".equals(ldc.cst)) continue;
                            ReikaASMHelper.replaceInstruction((InsnList)m.instructions, (AbstractInsnNode)ain, (AbstractInsnNode)new MethodInsnNode(184, "Reika/LegacyCraft/ASM/LegacyASMHooks", "getFlintAndSteelSound", "()Ljava/lang/String;", false));
                        }
                        ReikaASMHelper.log((Object)("Successfully applied " + (Object)((Object)this) + " ASM handler!"));
                        break;
                    }
                    case CREEPERFALL: {
                        if (LegacyTransformer.getConfig("Creepers Explode on Fall", false)) {
                            ReikaASMHelper.log((Object)("Not applying " + (Object)((Object)this) + " ASM handler; disabled in config."));
                            return data;
                        }
                        if (ReikaASMHelper.removeMethod((ClassNode)cn, (String)(FMLForgePlugin.RUNTIME_DEOBF ? "func_70069_a" : "fall"), (String)"(F)V") == null) {
                            throw new ASMException.NoSuchASMMethodException(cn, "fall", "(F)V");
                        }
                        ReikaASMHelper.log((Object)("Successfully applied " + (Object)((Object)this) + " ASM handler!"));
                        break;
                    }
                    case EQUIPDMG: {
                        if (LegacyTransformer.getConfig("Damaged Mob Weapon Drops", false)) {
                            ReikaASMHelper.log((Object)("Not applying " + (Object)((Object)this) + " ASM handler; disabled in config."));
                            return data;
                        }
                        MethodNode m = ReikaASMHelper.getMethodByName((ClassNode)cn, (String)"func_82160_b", (String)"dropEquipment", (String)"(ZI)V");
                        String func = FMLForgePlugin.RUNTIME_DEOBF ? "func_77964_b" : "setItemDamage";
                        for (int i = 0; i < m.instructions.size(); ++i) {
                            AbstractInsnNode ain = m.instructions.get(i);
                            if (ain.getOpcode() != 182) continue;
                            MethodInsnNode min = (MethodInsnNode)ain;
                            if (!func.equals(min.name)) continue;
                            m.instructions.insertBefore((AbstractInsnNode)min, (AbstractInsnNode)new InsnNode(87));
                            m.instructions.insertBefore((AbstractInsnNode)min, (AbstractInsnNode)new InsnNode(3));
                            i += 3;
                        }
                        ReikaASMHelper.log((Object)("Successfully applied " + (Object)((Object)this) + " ASM handler!"));
                        break;
                    }
                    case ZOMBIEHOOKS: {
                        MethodNode m = ReikaASMHelper.getMethodByName((ClassNode)cn, (String)"func_110161_a", (String)"onSpawnWithEgg", (String)"(Lnet/minecraft/entity/IEntityLivingData;)Lnet/minecraft/entity/IEntityLivingData;");
                        FieldInsnNode fin = ReikaASMHelper.getFirstFieldCallByName((ClassNode)cn, (MethodNode)m, (String)"field_142046_b");
                        int var = ((VarInsnNode)fin.getPrevious()).var;
                        VarInsnNode vin = (VarInsnNode)ReikaASMHelper.getLastInsnBefore((InsnList)m.instructions, (int)m.instructions.indexOf((AbstractInsnNode)fin), (int)58, (Object[])new Object[]{var});
                        m.instructions.insertBefore((AbstractInsnNode)vin, (AbstractInsnNode)new VarInsnNode(25, 0));
                        m.instructions.insertBefore((AbstractInsnNode)vin, (AbstractInsnNode)new MethodInsnNode(184, "Reika/LegacyCraft/ASM/LegacyASMHooks", "interceptZombieData", "(Lnet/minecraft/entity/monster/EntityZombie$GroupData;Lnet/minecraft/entity/monster/EntityZombie;)Lnet/minecraft/entity/monster/EntityZombie$GroupData;", false));
                        ReikaASMHelper.log((Object)("Successfully applied " + (Object)((Object)this) + " ASM handler!"));
                        break;
                    }
                    case ZOMBIETOOLS: {
                        if (LegacyTransformer.getConfig("Zombies Can Spawn With Tools", false)) {
                            ReikaASMHelper.log((Object)("Not applying " + (Object)((Object)this) + " ASM handler; disabled in config."));
                            return data;
                        }
                        if (ReikaASMHelper.removeMethod((ClassNode)cn, (String)(FMLForgePlugin.RUNTIME_DEOBF ? "func_82164_bB" : "addRandomArmor"), (String)"()V") == null) {
                            throw new ASMException.NoSuchASMMethodException(cn, "addRandomArmor", "()V");
                        }
                        ReikaASMHelper.log((Object)("Successfully applied " + (Object)((Object)this) + " ASM handler!"));
                        break;
                    }
                    case MOBARMOR: {
                        if (LegacyTransformer.getConfig("Mobs Can Spawn With Armor", false)) {
                            ReikaASMHelper.log((Object)("Not applying " + (Object)((Object)this) + " ASM handler; disabled in config."));
                            return data;
                        }
                        MethodNode m = LegacyASMHandler.getOrCreateMethod(cn, "func_82164_bB", "addRandomArmor", "()V");
                        m.instructions.add((AbstractInsnNode)new InsnNode(177));
                        ReikaASMHelper.log((Object)("Successfully applied " + (Object)((Object)this) + " ASM handler!"));
                        break;
                    }
                    case ZOMBIEFIRE: {
                        if (LegacyTransformer.getConfig("Zombies Attack with Fire", false)) {
                            ReikaASMHelper.log((Object)("Not applying " + (Object)((Object)this) + " ASM handler; disabled in config."));
                            return data;
                        }
                        MethodNode m = ReikaASMHelper.getMethodByName((ClassNode)cn, (String)"func_70652_k", (String)"attackEntityAsMob", (String)"(Lnet/minecraft/entity/Entity;)Z");
                        MethodInsnNode min = ReikaASMHelper.getFirstMethodCallByName((ClassNode)cn, (MethodNode)m, (String)(FMLForgePlugin.RUNTIME_DEOBF ? "func_70027_ad" : "isBurning"));
                        AbstractInsnNode prev = min.getPrevious();
                        ReikaASMHelper.replaceInstruction((InsnList)m.instructions, (AbstractInsnNode)min, (AbstractInsnNode)new InsnNode(3));
                        m.instructions.remove(prev);
                        ReikaASMHelper.log((Object)("Successfully applied " + (Object)((Object)this) + " ASM handler!"));
                        break;
                    }
                    case SKELLYRATE: {
                        if (!LegacyTransformer.getConfig("Old Skeleton Fire Rate", true)) {
                            ReikaASMHelper.log((Object)("Not applying " + (Object)((Object)this) + " ASM handler; disabled in config."));
                            return data;
                        }
                        MethodNode m = ReikaASMHelper.getMethodByName((ClassNode)cn, (String)"<init>", (String)"(Lnet/minecraft/world/World;)V");
                        IntInsnNode iin = (IntInsnNode)ReikaASMHelper.getFirstInsnAfter((InsnList)m.instructions, (int)0, (int)16, (Object[])new Object[]{60});
                        iin.setOpcode(17);
                        iin.operand = 300;
                        ReikaASMHelper.replaceInstruction((InsnList)m.instructions, (AbstractInsnNode)iin.getPrevious(), (AbstractInsnNode)new InsnNode(3));
                        ReikaASMHelper.log((Object)("Successfully applied " + (Object)((Object)this) + " ASM handler!"));
                        break;
                    }
                    case SKELLYFIRE: {
                        if (LegacyTransformer.getConfig("Allow Skeleton Flaming Arrows", false)) {
                            ReikaASMHelper.log((Object)("Not applying " + (Object)((Object)this) + " ASM handler; disabled in config."));
                            return data;
                        }
                        MethodNode m = ReikaASMHelper.getMethodByName((ClassNode)cn, (String)"func_82196_d", (String)"attackEntityWithRangedAttack", (String)"(Lnet/minecraft/entity/EntityLivingBase;F)V");
                        FieldInsnNode fin = ReikaASMHelper.getFirstFieldCallByName((ClassNode)cn, (MethodNode)m, (String)(FMLForgePlugin.RUNTIME_DEOBF ? "field_77343_v" : "flame"));
                        JumpInsnNode jin = (JumpInsnNode)ReikaASMHelper.getFirstOpcodeAfter((InsnList)m.instructions, (int)m.instructions.indexOf((AbstractInsnNode)fin), (int)157);
                        jin.setOpcode(163);
                        m.instructions.insertBefore((AbstractInsnNode)jin, (AbstractInsnNode)new IntInsnNode(16, 100));
                        ReikaASMHelper.log((Object)("Successfully applied " + (Object)((Object)this) + " ASM handler!"));
                        break;
                    }
                    case SILENTVILLAGERS: {
                        MethodNode m = ReikaASMHelper.getMethodByName((ClassNode)cn, (String)"func_70639_aQ", (String)"getLivingSound", (String)"()Ljava/lang/String;");
                        LegacyASMHandler.redirectInstanceFunctionWithReturnHook(cn, m, "getVillagerSound");
                        m = ReikaASMHelper.getMethodByName((ClassNode)cn, (String)"func_70621_aR", (String)"getHurtSound", (String)"()Ljava/lang/String;");
                        LegacyASMHandler.redirectInstanceFunctionWithReturnHook(cn, m, "getVillagerSound");
                        m = ReikaASMHelper.getMethodByName((ClassNode)cn, (String)"func_70673_aS", (String)"getDeathSound", (String)"()Ljava/lang/String;");
                        LegacyASMHandler.redirectInstanceFunctionWithReturnHook(cn, m, "getVillagerSound");
                        ReikaASMHelper.log((Object)("Successfully applied " + (Object)((Object)this) + " ASM handler!"));
                        break;
                    }
                    case ENDERSOUNDS: {
                        if (LegacyTransformer.getConfig("New Angry Enderman Sounds", true)) {
                            ReikaASMHelper.log((Object)("Not applying " + (Object)((Object)this) + " ASM handler; disabled in config."));
                            return data;
                        }
                        MethodNode m = ReikaASMHelper.getMethodByName((ClassNode)cn, (String)"func_70823_r", (String)"isScreaming", (String)"()Z");
                        m.instructions.clear();
                        m.instructions.add((AbstractInsnNode)new InsnNode(3));
                        m.instructions.add((AbstractInsnNode)new InsnNode(172));
                        m = ReikaASMHelper.getMethodByName((ClassNode)cn, (String)"func_70782_k", (String)"findPlayerToAttack", (String)"()Lnet/minecraft/entity/Entity;");
                        LdcInsnNode ldc = (LdcInsnNode)ReikaASMHelper.getFirstInsnAfter((InsnList)m.instructions, (int)0, (int)18, (Object[])new Object[]{"mob.endermen.stare"});
                        ReikaASMHelper.replaceInstruction((InsnList)m.instructions, (AbstractInsnNode)ldc.getNext(), (AbstractInsnNode)new InsnNode(11));
                        ReikaASMHelper.log((Object)("Successfully applied " + (Object)((Object)this) + " ASM handler!"));
                        break;
                    }
                    case DUMBPATH: {
                        LegacyASMHandler.patchPathCalc(cn, "func_72865_a", "getPathEntityToEntity", "(Lnet/minecraft/entity/Entity;Lnet/minecraft/entity/Entity;FZZZZ)Lnet/minecraft/pathfinding/PathEntity;");
                        LegacyASMHandler.patchPathCalc(cn, "func_72844_a", "getEntityPathToXYZ", "(Lnet/minecraft/entity/Entity;IIIFZZZZ)Lnet/minecraft/pathfinding/PathEntity;");
                        ReikaASMHelper.log((Object)("Successfully applied " + (Object)((Object)this) + " ASM handler!"));
                    }
                }
                ClassWriter writer = new ClassWriter(flags);
                cn.accept((ClassVisitor)writer);
                return writer.toByteArray();
            }

            static {
                list = ClassPatch.values();
            }
        }
    }
}

