/*
 * Decompiled with CFR 0.152.
 */
package Reika.LegacyCraft.ASM;

import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Interfaces.Entity.TameHostile;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.LegacyCraft.LegacyCraft;
import Reika.LegacyCraft.LegacyOptions;
import Reika.Satisforestry.API.Spitter;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class LegacyASMHooks {
    public static String getVillagerSound(String orig, EntityVillager e) {
        return LegacyOptions.SILENTVILLAGERS.getState() ? null : orig;
    }

    public static String getFlintAndSteelSound() {
        return LegacyOptions.FLINTSOUND.getState() ? LegacyCraft.getOldFlintAndSteelSound() : "fire.ignite";
    }

    public static float getNonAIMoveSpeed() {
        return 0.2f;
    }

    public static float getAIMoveSpeed(float base) {
        return LegacyOptions.NEWAI.getState() ? base : LegacyASMHooks.getNonAIMoveSpeed();
    }

    public static EntityZombie.GroupData interceptZombieData(EntityZombie.GroupData data, EntityZombie e) {
        if (LegacyOptions.BABYZOMBIES.getState()) {
            data.field_142048_a = false;
        }
        if (!LegacyOptions.ZOMBIEVILLAGER.getState()) {
            data.field_142046_b = false;
        }
        return data;
    }

    public static IEntityLivingData onEntitySpawn(EntityLiving e, IEntityLivingData el) {
        if (e instanceof EntitySpider && !LegacyOptions.SPIDERPOTIONS.getState()) {
            e.func_70674_bp();
        }
        if (e instanceof EntityZombie) {
            EntityZombie ez = (EntityZombie)e;
            if (LegacyOptions.OLDZOMBIES.getState()) {
                LegacyASMHooks.removeModifierByName(e, SharedMonsterAttributes.field_111266_c, "Random spawn bonus");
                LegacyASMHooks.removeModifierByName(e, SharedMonsterAttributes.field_111265_b, "Random zombie-spawn bonus");
                LegacyASMHooks.removeModifierByName(e, EntityZombie.field_110186_bp, "Leader zombie bonus");
                LegacyASMHooks.removeModifierByName(e, SharedMonsterAttributes.field_111267_a, "Leader zombie bonus");
            }
            if (!LegacyOptions.ZOMBIEVILLAGER.getState()) {
                ez.func_82229_g(false);
            }
            if (LegacyOptions.BABYZOMBIES.getState()) {
                ez.func_82227_f(false);
            }
            if (ez.field_70154_o != null) {
                ez.func_70078_a(null);
            }
            if (!LegacyOptions.ZOMBIEDOOR.getState()) {
                ez.func_146070_a(false);
                ez.func_70661_as().func_75498_b(false);
            }
        }
        if (e instanceof EntitySkeleton) {
            LegacyASMHooks.correctSkeletonType((EntitySkeleton)e);
        }
        if (!LegacyOptions.MOBPICKUP.getState()) {
            e.func_98053_h(false);
        }
        return el;
    }

    public static void applyEntityAttributes(EntityLiving e) {
        if (e instanceof EntityZombie) {
            if (LegacyOptions.OLDRANGE.getState()) {
                e.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
            }
            if (LegacyOptions.BACKUP.getState()) {
                e.func_110148_a(EntityZombie.field_110186_bp).func_111128_a(0.0);
            }
        }
    }

    private static void removeModifierByName(EntityLiving e, IAttribute ia, String n) {
        IAttributeInstance iai = e.func_110148_a(ia);
        Collection c = ReikaEntityHelper.getAttributeByName((IAttributeInstance)iai, (String)n);
        if (c != null) {
            for (AttributeModifier mod : c) {
                iai.func_111124_b(mod);
            }
        }
    }

    public static void correctSkeletonType(EntitySkeleton es) {
        boolean hell = es.field_70170_p.field_73011_w.field_76575_d;
        if (es.func_82202_m() == 1 != hell) {
            es.func_82201_a(hell ? 1 : 0);
            es.func_70062_b(0, new ItemStack((Item)(hell ? Items.field_151052_q : Items.field_151031_f)));
            es.func_85036_m();
        }
    }

    public static PathEntity getPathEntityToEntity(World world, Entity src, Entity tgt, float dist, boolean useOpenDoors, boolean useClosedDoors, boolean avoidWater, boolean canSwim) {
        int x0 = MathHelper.func_76128_c((double)src.field_70165_t);
        int y0 = MathHelper.func_76128_c((double)(src.field_70163_u + 1.0));
        int z0 = MathHelper.func_76128_c((double)src.field_70161_v);
        if (!LegacyOptions.NEWAI.getState() && src instanceof EntityMob && !(src instanceof TameHostile) && !(src instanceof Spitter)) {
            return LegacyASMHooks.getDumbPath(world, src, MathHelper.func_76128_c((double)tgt.field_70165_t), MathHelper.func_76128_c((double)tgt.field_70163_u), MathHelper.func_76128_c((double)tgt.field_70161_v), dist);
        }
        world.field_72984_F.func_76320_a("pathfind");
        int sr = (int)(dist + 16.0f);
        int x1 = x0 - sr;
        int y1 = y0 - sr;
        int z1 = z0 - sr;
        int x2 = x0 + sr;
        int y2 = y0 + sr;
        int z2 = z0 + sr;
        ChunkCache chunkcache = new ChunkCache(world, x1, y1, z1, x2, y2, z2, 0);
        PathEntity pathentity = new PathFinder((IBlockAccess)chunkcache, useOpenDoors, useClosedDoors, avoidWater, canSwim).func_75856_a(src, tgt, dist);
        world.field_72984_F.func_76319_b();
        return pathentity;
    }

    public static PathEntity getEntityPathToXYZ(World world, Entity src, int x, int y, int z, float dist, boolean useOpenDoors, boolean useClosedDoors, boolean avoidWater, boolean canSwim) {
        if (!LegacyOptions.NEWAI.getState() && src instanceof EntityMob && !(src instanceof TameHostile) && !(src instanceof Spitter)) {
            return LegacyASMHooks.getDumbPath(world, src, x, y, z, dist);
        }
        world.field_72984_F.func_76320_a("pathfind");
        int x0 = MathHelper.func_76128_c((double)src.field_70165_t);
        int y0 = MathHelper.func_76128_c((double)src.field_70163_u);
        int z0 = MathHelper.func_76128_c((double)src.field_70161_v);
        int sr = (int)(dist + 8.0f);
        int x1 = x0 - sr;
        int y1 = y0 - sr;
        int z1 = z0 - sr;
        int x2 = x0 + sr;
        int y2 = y0 + sr;
        int z2 = z0 + sr;
        ChunkCache chunkcache = new ChunkCache(world, x1, y1, z1, x2, y2, z2, 0);
        PathEntity pathentity = new PathFinder((IBlockAccess)chunkcache, useOpenDoors, useClosedDoors, avoidWater, canSwim).func_75859_a(src, x, y, z, dist);
        world.field_72984_F.func_76319_b();
        return pathentity;
    }

    private static PathEntity getDumbPath(World world, Entity src, int x0, int y0, int z0, double dist) {
        double dx = (double)x0 + 0.5 - src.field_70165_t;
        double dy = (double)y0 - src.field_70163_u;
        double dz = (double)z0 + 0.5 - src.field_70161_v;
        double dd = ReikaMathLibrary.py3d((double)dx, (double)dy, (double)dz);
        if (dd > dist) {
            return null;
        }
        double dl = 0.25 / dd;
        ArrayList<PathPoint> li = new ArrayList<PathPoint>();
        ArrayList<Coordinate> li2 = new ArrayList<Coordinate>();
        Path p = new Path();
        Coordinate cur = null;
        for (double d = 0.0; d <= 1.0; d += dl) {
            double x = (double)x0 + dx * d;
            double y = (double)y0 + dy * d;
            double z = (double)z0 + dz * d;
            Coordinate c2 = new Coordinate(x, y, z);
            while (c2.yCoord > 0 && c2.offset(0, -1, 0).softBlock((IBlockAccess)world)) {
                c2 = c2.offset(0, -1, 0);
            }
            while (!c2.softBlock((IBlockAccess)world)) {
                c2 = c2.offset(0, 1, 0);
            }
            if (c2.equals(cur)) continue;
            cur = c2;
            PathPoint pp = new PathPoint(c2.xCoord, c2.yCoord, c2.zCoord);
            li.add(pp);
            li2.add(c2);
            p.func_75849_a(pp);
        }
        if (src instanceof EntityLivingBase && src.field_70122_E && src.field_70163_u < (double)y0 - 0.5 && world.field_73012_v.nextInt(3) == 0) {
            ReikaObfuscationHelper.invoke((String)"jump", (Object)src, (Object[])new Object[0]);
            float spd = ((EntityLivingBase)src).func_70689_ay();
            src.field_70159_w = (double)spd * dx / dd;
            src.field_70179_y = (double)spd * dz / dd;
        }
        return new PathEntity(li.toArray(new PathPoint[li.size()]));
    }
}

