/*
 * Decompiled with CFR 0.152.
 */
package Reika.LegacyCraft.ASM;

import Reika.DragonAPI.Libraries.Java.ReikaASMHelper;
import Reika.LegacyCraft.ASM.LegacyASMHandler;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class MobTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] data) {
        ReikaASMHelper.activeMod = "LegacyCraft";
        for (Patches p : Patches.list) {
            try {
                data = this.write(p, data);
            }
            catch (Throwable e) {
                ClassNode cn = new ClassNode();
                ClassReader classReader = new ClassReader(data);
                classReader.accept((ClassVisitor)cn, 0);
                p.apply(cn, 1);
                ReikaASMHelper.logError((Object)("Unable to patch mob class '" + cn.name + "' ^ '" + cn.superName + "': " + e.toString()));
                ReikaASMHelper.writeClassFile((ClassNode)cn, (String)"LgCASMOutput");
                e.printStackTrace();
            }
        }
        ReikaASMHelper.activeMod = null;
        return data;
    }

    private byte[] write(Patches p, byte[] data) {
        ClassNode cn = new ClassNode();
        ClassReader classReader = new ClassReader(data);
        classReader.accept((ClassVisitor)cn, 0);
        if (!p.appliesTo(cn)) {
            return data;
        }
        ReikaASMHelper.log((Object)("Applying " + (Object)((Object)p) + " ASM handler to " + cn.name));
        int flags = 1;
        flags = p.apply(cn, flags);
        ClassWriter writer = new ClassWriter(flags);
        cn.accept((ClassVisitor)writer);
        ReikaASMHelper.log((Object)("Successfully applied " + (Object)((Object)p) + " ASM handler to " + cn.name + "!"));
        return writer.toByteArray();
    }

    @Deprecated
    private static void patchAI(ClassNode cn) {
        MethodNode m = LegacyASMHandler.getOrCreateMethod(cn, "func_70650_aV", "isAIEnabled", "()Z");
        m.instructions.add((AbstractInsnNode)new FieldInsnNode(178, "Reika/LegacyCraft/LegacyOptions", "NEWAI", "LReika/LegacyCraft/LegacyOptions;"));
        m.instructions.add((AbstractInsnNode)new MethodInsnNode(182, "Reika/LegacyCraft/LegacyOptions", "getState", "()Z", false));
        m.instructions.add((AbstractInsnNode)new InsnNode(172));
    }

    @Deprecated
    private static void patchMoveSpeed(ClassNode cn) {
        MethodNode m = LegacyASMHandler.getOrCreateMethod(cn, "func_70689_ay", "getAIMoveSpeed", "()F");
        m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        m.instructions.add((AbstractInsnNode)new MethodInsnNode(183, cn.superName, "getAIMoveSpeed", "()F", false));
        m.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "Reika/LegacyCraft/ASM/LegacyASMHooks", "getAIMoveSpeed", "(F)F", false));
        m.instructions.add((AbstractInsnNode)new InsnNode(174));
    }

    private static void addEggSpawnHook(ClassNode cn) {
        MethodNode m = LegacyASMHandler.getOrCreateMethod(cn, "func_110161_a", "onSpawnWithEgg", "(Lnet/minecraft/entity/IEntityLivingData;)Lnet/minecraft/entity/IEntityLivingData;", false);
        InsnList li = new InsnList();
        li.add((AbstractInsnNode)new VarInsnNode(25, 0));
        li.add((AbstractInsnNode)new VarInsnNode(25, 1));
        li.add((AbstractInsnNode)new MethodInsnNode(184, "Reika/LegacyCraft/ASM/LegacyASMHooks", "onEntitySpawn", "(Lnet/minecraft/entity/EntityLiving;Lnet/minecraft/entity/IEntityLivingData;)Lnet/minecraft/entity/IEntityLivingData;", false));
        if (m.instructions.size() == 0) {
            m.instructions.add(li);
            m.instructions.add((AbstractInsnNode)new InsnNode(176));
        } else {
            for (int i = m.instructions.size() - 1; i >= 0; --i) {
                AbstractInsnNode ain = m.instructions.get(i);
                if (ain.getOpcode() != 176) continue;
                m.instructions.insertBefore(ain, ReikaASMHelper.copyInsnList((InsnList)li, (LabelNode[])new LabelNode[0]));
            }
        }
    }

    private static void patchEntityAttr(ClassNode cn) {
        MethodNode m = LegacyASMHandler.getOrCreateMethod(cn, "func_110147_ax", "applyEntityAttributes", "()V", false);
        InsnList li = new InsnList();
        li.add((AbstractInsnNode)new VarInsnNode(25, 0));
        li.add((AbstractInsnNode)new MethodInsnNode(184, "Reika/LegacyCraft/ASM/LegacyASMHooks", "applyEntityAttributes", "(Lnet/minecraft/entity/EntityLiving;)V", false));
        if (m.instructions.size() == 0) {
            m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            m.instructions.add((AbstractInsnNode)new MethodInsnNode(183, cn.superName, m.name, m.desc, false));
            m.instructions.add(li);
            m.instructions.add((AbstractInsnNode)new InsnNode(177));
        } else {
            for (int i = m.instructions.size() - 1; i >= 0; --i) {
                AbstractInsnNode ain = m.instructions.get(i);
                if (ain.getOpcode() != 177) continue;
                m.instructions.insertBefore(ain, ReikaASMHelper.copyInsnList((InsnList)li, (LabelNode[])new LabelNode[0]));
            }
        }
    }

    private static void patchToolEnchant(ClassNode cn) {
        MethodNode m = LegacyASMHandler.getOrCreateMethod(cn, "func_82162_bC", "enchantEquipment", "()V");
        LabelNode lb = new LabelNode();
        m.instructions.add((AbstractInsnNode)new FieldInsnNode(178, "Reika/LegacyCraft/LegacyOptions", "HELDENCHANT", "LReika/LegacyCraft/LegacyOptions;"));
        m.instructions.add((AbstractInsnNode)new MethodInsnNode(182, "Reika/LegacyCraft/LegacyOptions", "getState", "()Z", false));
        m.instructions.add((AbstractInsnNode)new JumpInsnNode(153, lb));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        m.instructions.add((AbstractInsnNode)new MethodInsnNode(183, cn.superName, m.name, m.desc, false));
        m.instructions.add((AbstractInsnNode)lb);
        m.instructions.add((AbstractInsnNode)new InsnNode(177));
    }

    private static boolean extendsMob(ClassNode cn) {
        return cn.superName != null && (cn.superName.equals("net/minecraft/entity/monster/EntityMob") || cn.superName.equals("yg"));
    }

    private static enum Patches {
        SPAWN,
        ATTR,
        ENCHANT;

        private static final Patches[] list;

        private int apply(ClassNode cn, int flags) {
            switch (this) {
                case ATTR: {
                    MobTransformer.patchEntityAttr(cn);
                    break;
                }
                case ENCHANT: {
                    MobTransformer.patchToolEnchant(cn);
                    flags |= 2;
                    break;
                }
                case SPAWN: {
                    MobTransformer.addEggSpawnHook(cn);
                }
            }
            return flags;
        }

        public boolean appliesTo(ClassNode cn) {
            switch (this) {
                default: 
            }
            return MobTransformer.extendsMob(cn) && !cn.name.contains("Satisforestry");
        }

        static {
            list = Patches.values();
        }
    }
}

