/*
 * Decompiled with CFR 0.152.
 */
package Reika.LegacyCraft;

import Reika.DragonAPI.Auxiliary.Trackers.PlayerHandler;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.DragonOptions;
import Reika.DragonAPI.Instantiable.IO.ModLogger;
import Reika.DragonAPI.Instantiable.IO.SingleSound;
import Reika.DragonAPI.Instantiable.IO.SoundLoader;
import Reika.DragonAPI.Interfaces.Configuration.ConfigList;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.LegacyCraft.ASM.LegacyASMHandler;
import Reika.LegacyCraft.LegacyConfig;
import Reika.LegacyCraft.LegacyEventHandler;
import Reika.LegacyCraft.LegacyOptions;
import Reika.LegacyCraft.LegacyPlayerTracker;
import Reika.LegacyCraft.Overrides.LegacyPotionHealth;
import Reika.LegacyCraft.Overrides.LegacyPotionRegen;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.net.URL;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMultiTexture;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenHills;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="LegacyCraft", name="LegacyCraft", version="v31a", certificateFingerprint="32:F5:F4:E8:44:C0:EA:C8:6F:46:8A:8E:F3:05:05:7B:6F:90:0F:78", dependencies="required-after:DragonAPI")
public class LegacyCraft
extends DragonAPIMod {
    @Mod.Instance(value="LegacyCraft")
    public static LegacyCraft instance = new LegacyCraft();
    public static final LegacyConfig config = new LegacyConfig(instance, (ConfigList[])LegacyOptions.optionList, null);
    public static ModLogger logger;
    static final Random rand;
    private static SingleSound flintAndSteel;
    private static SoundLoader sounds;

    @Mod.EventHandler
    public void preload(FMLPreInitializationEvent evt) {
        this.startTiming(DragonAPIMod.LoadProfiler.LoadPhase.PRELOAD);
        this.verifyInstallation();
        config.loadSubfolderedConfigFile(evt);
        config.initProps(evt);
        logger = new ModLogger((DragonAPIMod)instance, false);
        if (DragonOptions.FILELOG.getState()) {
            logger.setOutput("**_Loading_Log.log");
        }
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)LegacyEventHandler.instance);
        MinecraftForge.EVENT_BUS.register((Object)LegacyEventHandler.instance);
        if (LegacyOptions.NETHERICE.getState() && (Blocks.field_150355_j.getClass() != BlockStaticLiquid.class || Blocks.field_150358_i.getClass() != BlockDynamicLiquid.class)) {
            logger.logError((Object)("Water block overridden with " + Blocks.field_150355_j.getClass() + ", " + Blocks.field_150358_i.getClass() + ", Ice in Nether behavior may not function. This is a serious mistake in " + ReikaItemHelper.getRegistrantMod((ItemStack)new ItemStack(Blocks.field_150355_j))));
        }
        this.basicSetup(evt);
        this.finishTiming();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        this.startTiming(DragonAPIMod.LoadProfiler.LoadPhase.LOAD);
        PlayerHandler.instance.registerTracker((PlayerHandler.PlayerTracker)new LegacyPlayerTracker());
        flintAndSteel = new SingleSound("flintsteel", "Reika/LegacyCraft/flintsteel.ogg");
        sounds = new SoundLoader(new SoundEnum[]{flintAndSteel});
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            flintAndSteel.setSoundCategory(SoundCategory.BLOCKS);
            sounds.register();
        }
        if (LegacyOptions.OLDPOTIONS.getState()) {
            LegacyPotionHealth health = new LegacyPotionHealth();
            LegacyPotionRegen legacyPotionRegen = new LegacyPotionRegen();
        }
        if (LegacyOptions.ENDERBLOCKS.getState()) {
            EntityEnderman.setCarriable((Block)Blocks.field_150348_b, (boolean)true);
            EntityEnderman.setCarriable((Block)Blocks.field_150344_f, (boolean)true);
            EntityEnderman.setCarriable((Block)Blocks.field_150347_e, (boolean)true);
            EntityEnderman.setCarriable((Block)Blocks.field_150417_aV, (boolean)true);
        }
        if (LegacyOptions.SILVERFISH.getState() && BiomeGenBase.field_76770_e instanceof BiomeGenHills) {
            BiomeGenHills ex = (BiomeGenHills)BiomeGenBase.field_76770_e;
            BiomeGenHills ex2 = (BiomeGenHills)BiomeGenBase.field_76783_v;
            BiomeGenHills ex3 = (BiomeGenHills)BiomeGenBase.field_76773_a[BiomeGenBase.field_76770_e.field_76756_M + 128];
            BiomeGenHills ex4 = (BiomeGenHills)BiomeGenBase.field_150580_W;
            BiomeGenHills ex5 = (BiomeGenHills)BiomeGenBase.field_76773_a[BiomeGenBase.field_150580_W.field_76756_M + 128];
            WorldGenMinable dummy = new WorldGenMinable(Blocks.field_150348_b, 0);
            ex.field_82915_S = dummy;
            ex2.field_82915_S = dummy;
            ex3.field_82915_S = dummy;
            ex4.field_82915_S = dummy;
            ex5.field_82915_S = dummy;
        }
        if (LegacyOptions.OLDBOOK.getState()) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(Items.field_151122_aG), (Object[])new Object[]{"P", "P", "P", Character.valueOf('P'), Items.field_151121_aF});
        }
        if (LegacyOptions.OLDMELON.getState()) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.field_151060_bw), (Object[])new Object[]{Items.field_151127_ba, Items.field_151074_bl});
        }
        if (LegacyOptions.ROSES.getState()) {
            ItemMultiTexture item = (ItemMultiTexture)Item.func_150898_a((Block)Blocks.field_150328_O);
            item.field_150942_c[0] = "rose";
            BlockFlower.field_149859_a[0] = "rose";
            BlockFlower.field_149860_M[1][0] = "rose";
        }
        if (LegacyOptions.PIGPORTALS.getState()) {
            Blocks.field_150427_aO.func_149675_a(false);
        }
        this.finishTiming();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void setIcons(TextureStitchEvent evt) {
        if (evt.map.func_130086_a() == 0) {
            if (LegacyOptions.ROSES.getState()) {
                Blocks.field_150328_O.field_149861_N[0] = evt.map.func_94245_a("legacycraft:rose");
            }
            if (LegacyOptions.ALPHAGRASS.getState()) {
                String s;
                String alpha;
                int i;
                int m;
                Blocks.field_150349_c.field_149994_N = evt.map.func_94245_a("legacycraft:alpha/grass_side");
                Blocks.field_150349_c.field_149761_L = evt.map.func_94245_a("legacycraft:alpha/grass_side");
                Blocks.field_150349_c.field_149991_b = evt.map.func_94245_a("legacycraft:alpha/grass_top");
                for (m = 0; m <= 3; ++m) {
                    for (i = 0; i <= 1; ++i) {
                        alpha = i == 0 ? "trans" : "opq";
                        s = "legacycraft:alpha/leaf_0_" + alpha;
                        Blocks.field_150362_t.field_150129_M[i][m] = evt.map.func_94245_a(s);
                    }
                }
                for (m = 0; m <= 1; ++m) {
                    for (i = 0; i <= 1; ++i) {
                        alpha = i == 0 ? "trans" : "opq";
                        s = "legacycraft:alpha/leaf_0_" + alpha;
                        Blocks.field_150361_u.field_150129_M[i][m] = evt.map.func_94245_a(s);
                    }
                }
                for (int i2 = 1; i2 <= 2; ++i2) {
                    Blocks.field_150329_H.field_149870_b[i2] = evt.map.func_94245_a("legacycraft:alpha/" + BlockTallGrass.field_149871_a[i2]);
                }
                BlockSapling.field_149881_b[0] = evt.map.func_94245_a("legacycraft:alpha/sapling");
                Blocks.field_150395_bd.field_149761_L = evt.map.func_94245_a("legacycraft:alpha/vine");
                int[] data = ReikaArrayHelper.getArrayOf((int)0xFFFFFF, (int)65536);
                ColorizerGrass.func_77479_a((int[])data);
                ColorizerFoliage.func_77467_a((int[])data);
                SimpleReloadableResourceManager mgr = (SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L();
                Iterator it = mgr.field_110546_b.iterator();
                while (it.hasNext()) {
                    IResourceManagerReloadListener rl = (IResourceManagerReloadListener)it.next();
                    if (!rl.getClass().getSimpleName().contains("ColorReloadListener")) continue;
                    it.remove();
                }
            }
        }
    }

    @Mod.EventHandler
    public void postload(FMLPostInitializationEvent evt) {
        this.startTiming(DragonAPIMod.LoadProfiler.LoadPhase.POSTLOAD);
        if (LegacyOptions.OLDFIRE.getState()) {
            for (Object o : Block.field_149771_c.func_148742_b()) {
                String name = (String)o;
                Block b = Block.func_149684_b((String)name);
                if (b == Blocks.field_150350_a) continue;
                int spread = Blocks.field_150480_ab.getEncouragement(b);
                int flamm = Blocks.field_150480_ab.getFlammability(b);
                Blocks.field_150480_ab.setFireInfo(b, spread * 3, flamm * 3);
            }
        }
        this.finishTiming();
    }

    public String getDisplayName() {
        return "LegacyCraft";
    }

    public String getModAuthorName() {
        return "Reika";
    }

    public URL getDocumentationSite() {
        return DragonAPICore.getReikaForumPage();
    }

    public URL getBugSite() {
        return DragonAPICore.getReikaGithubPage();
    }

    public String getWiki() {
        return null;
    }

    public String getUpdateCheckURL() {
        return "http://server.techjargaming.com/Reika/versions";
    }

    public ModLogger getModLogger() {
        return logger;
    }

    public File getConfigFolder() {
        return config.getConfigFolder();
    }

    protected Class<? extends IClassTransformer> getASMClass() {
        return LegacyASMHandler.LegacyTransformer.class;
    }

    public static String getOldFlintAndSteelSound() {
        ResourceLocation s = sounds != null ? sounds.getResource((SoundEnum)flintAndSteel) : null;
        return s != null ? s.toString() : "";
    }

    static {
        rand = new Random();
    }
}

